/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.hr.hbp.common.encryptapi.HrEncryptApiRequest;
import kd.hr.hbp.common.encryptapi.HrEncryptApiResponse;
import kd.hr.hbp.common.encryptapi.HrEncryptMServiceUtils;
import kd.hr.hrcs.common.model.OrgInfo;
import kd.hr.hrcs.mservice.api.IHRCSEncryptApiService;

public class HRCSEncryptApiService
implements IHRCSEncryptApiService {
    private static final Log log = LogFactory.getLog(HRCSEncryptApiService.class);
    private static final String BOS_DEVPORTAL_BIZCLOUD = "bos_devportal_bizcloud";
    private static final String BOS_DEVPORTAL_BIZAPP = "bos_devportal_bizapp";
    private static final String HRCS_ENCAPIREGISTER = "hrcs_encapiregister";

    public DynamicObject getBizCloudDyByNumber(String cloudId) {
        cloudId = cloudId == null ? "" : cloudId;
        QFilter bizCloudFilter = new QFilter("number", "=", (Object)cloudId.toUpperCase());
        return QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_BIZCLOUD, (String)"id", (QFilter[])new QFilter[]{bizCloudFilter});
    }

    public DynamicObject getBizAppDyByNumber(String appId) {
        QFilter bizAppFilter = new QFilter("number", "=", (Object)appId);
        return QueryServiceHelper.queryOne((String)BOS_DEVPORTAL_BIZAPP, (String)"id", (QFilter[])new QFilter[]{bizAppFilter});
    }

    public DynamicObject getEncryptApiRegister(String bizCloudId, String bizAppId, String serviceName, String methodName) {
        QFilter filter = new QFilter("bizcloud", "=", (Object)bizCloudId);
        filter.and(new QFilter("bizapp", "=", (Object)bizAppId));
        filter.and(new QFilter("servicename", "=", (Object)serviceName));
        filter.and(new QFilter("methodname", "=", (Object)methodName));
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return QueryServiceHelper.queryOne((String)HRCS_ENCAPIREGISTER, (String)"encryptscheme", (QFilter[])new QFilter[]{filter});
    }

    public HrEncryptApiResponse<Map<String, Object>> encryptApiMethodTool(Object params) {
        HrEncryptApiRequest request = new HrEncryptApiRequest("hrmp", "hrcs", "IHRCSEncryptApiService", "encryptApiMethodUnitTest");
        request.setEncryptData(params);
        return (HrEncryptApiResponse)HrEncryptMServiceUtils.invokeEncryptService((HrEncryptApiRequest)request);
    }

    public HrEncryptApiResponse<Map<String, Object>> encryptApiMethodUnitTest(HrEncryptApiRequest request) {
        String requestStr = request.toString();
        log.info("HRCSEncryptApiService encryptApiMethodTest HrEncryptApiRequest :" + requestStr);
        Object decryptData = request.getDecryptData();
        log.info("HRCSEncryptApiService encryptApiMethodTest HrEncryptApiRequest getDecryptData :" + decryptData);
        Map<String, Object> resultMap = this.getResultMap();
        HrEncryptApiResponse hrEncryptAPIResponse = new HrEncryptApiResponse(request);
        hrEncryptAPIResponse.setEncryptData(resultMap);
        String responseStr = hrEncryptAPIResponse.toString();
        Boolean encrypt = request.getEncrypt();
        if (encrypt.booleanValue()) {
            resultMap.put("HrEncryptApiRequest", requestStr);
            resultMap.put("HrEncryptApiDecryptRequest", request.getDecryptData());
            resultMap.put("HrEncryptApiResponse", responseStr);
            resultMap.put("HrEncryptApiDecryptResponse", hrEncryptAPIResponse.getDecryptData());
        }
        hrEncryptAPIResponse.setEncryptData(resultMap);
        log.info("HRCSEncryptApiService encryptApiMethodTest HrEncryptApiResponse :" + responseStr);
        return hrEncryptAPIResponse;
    }

    private Map<String, Object> getResultMap() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("url", "url_test");
        resultMap.put("message", "message_test");
        resultMap.put("detailMessage", "detailMessage_test");
        OrgInfo orgInfo = new OrgInfo(Long.valueOf(1010L), Long.valueOf(1000L), Long.valueOf(1010L), "longNumberOneTest");
        Date date = new Date();
        orgInfo.setBsedTime(date);
        orgInfo.setBsledTime(date);
        Object orgInfoObj = JSON.toJSON((Object)orgInfo);
        resultMap.put("entitykey", orgInfoObj);
        OrgInfo orgInfoTwo = new OrgInfo(Long.valueOf(1020L), Long.valueOf(2000L), Long.valueOf(1020L), "longNumberTwoTest");
        orgInfoTwo.setBsedTime(date);
        orgInfoTwo.setBsledTime(date);
        Object orgInfoTwoObj = JSON.toJSON((Object)orgInfoTwo);
        HashMap<String, Object> entityKeyTwoMap = new HashMap<String, Object>(16);
        entityKeyTwoMap.put("entityKeyTwoChildKey", orgInfoTwoObj);
        entityKeyTwoMap.put("entityKeyTwoChildOtherKey", "10102020");
        resultMap.put("entityKeyTwoMap", entityKeyTwoMap);
        return resultMap;
    }
}

