/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.label.BaseLabelResult;
import kd.hr.hbp.common.model.label.LabelSceneInfo;
import kd.hr.hrcs.bussiness.service.label.APILabelServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelSceneServiceHelper;
import kd.hr.hrcs.bussiness.service.label.LabelTaskStorageService;
import kd.hr.hrcs.bussiness.servicehelper.label.LabelServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.label.LblHelperConstants;
import kd.hr.hrcs.mservice.api.IHRCSLabelService;

public class HRCSLabelService
implements IHRCSLabelService {
    private static final String CURREN_MODULE = "hrmp-hrcs-mservice";
    private static final int QUERY_PAGE_SIZE = 1000;
    private static String[] BATCH_GET_LABEL_SELECT_FIELDS = new String[]{"labelObjectId", "policyId", "taskNumber", "labels.labelId", "createTime", "id", "topBizId", "labels.labelValueId", "labels.labelValueName", "labels.labelBizValue", "labels.from"};

    public Map<String, Object> getLabelResultInfo(Long policyId, Long sceneId, String policyTaskNo) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("policyId", policyId);
        resultMap.put("sceneId", sceneId == null ? Long.valueOf(1L) : sceneId);
        resultMap.put("total", 500L);
        resultMap.put("policyTaskNo", policyTaskNo == null ? "202212011111001" : policyTaskNo);
        return resultMap;
    }

    public List<Map<String, Object>> getData(Long policyId, String policyTaskNo, int start, int limit) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
        for (int idx = start; idx < limit + start; ++idx) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("id", idx);
            resultMap.put("policyId", policyId);
            resultMap.put("sceneId", 1L);
            resultMap.put("policyTaskNo", 1L);
            resultMap.put("labelObjectId", 1L);
            resultMap.put("labelDimensionId", 1L);
            resultMap.put("labelId", 1L);
            resultMap.put("labelValueId", 1L);
            resultMap.put("lavelValueString", "Label Value " + idx);
            resultMap.put("labelObjId", idx);
            resultList.add(resultMap);
        }
        return resultList;
    }

    public Map<String, Object> getLabelPolicyConfig(Long policyId) {
        if (null == policyId) {
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRCSLabelService_0", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)policyId)};
        return this.getSuccessPolicies(filters);
    }

    public Map<String, Object> getLabelSceneConfig(Long sceneId) {
        if (null == sceneId) {
            HashMap<String, Object> result = new HashMap<String, Object>(16);
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRCSLabelService_0", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        QFilter[] filters = new QFilter[]{new QFilter("labelscene.fbasedataid.id", "=", (Object)sceneId)};
        return this.getSuccessPolicies(filters);
    }

    public Map<String, Object> listPoliciesByScene(Map<String, Object> params) {
        Map<String, Object> result = this.validateListPoliciesBySceneParam(params);
        if (!result.isEmpty()) {
            return result;
        }
        result.put("responseCode", "200");
        result.put("responseDesc", "success");
        String sceneNumber = (String)params.get("sceneNumber");
        String bizApp = (String)params.get("bizApp");
        QFilter sceneFilter = new QFilter("number", "=", (Object)sceneNumber);
        DynamicObject[] sceneDys = LblHelperConstants.lblSceneServiceHelper.query("bizappid", new QFilter[]{sceneFilter});
        if (sceneDys == null || sceneDys.length == 0) {
            result.put("policies", new ArrayList());
            return result;
        }
        DynamicObject sceneDy = sceneDys[0];
        String appNumber = sceneDy.getString("bizappid.number");
        if (!bizApp.equals(appNumber)) {
            result.put("policies", new ArrayList());
            return result;
        }
        QFilter[] filters = new QFilter[1];
        QFilter policySceneFilter = new QFilter("labelscene.fbasedataid.id", "=", sceneDy.getPkValue());
        List policyIds = (List)params.get("policyIds");
        if (!CollectionUtils.isEmpty((Collection)policyIds)) {
            policySceneFilter.and(new QFilter("id", "in", (Object)policyIds));
        }
        filters[0] = policySceneFilter;
        return this.getSuccessPolicies(filters);
    }

    private Map<String, Object> getSuccessPolicies(QFilter[] filters) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("responseCode", "200");
        result.put("responseDesc", "success");
        HRBaseServiceHelper policyServiceHelper = LblHelperConstants.lblPolicyServiceHelper;
        DynamicObject[] policyDys = policyServiceHelper.query("id,number,startdate,enddate,publishtype,lblstrategyorg", filters);
        if (policyDys == null || policyDys.length == 0) {
            result.put("policies", new ArrayList());
        } else {
            int size = policyDys.length;
            ArrayList policies = new ArrayList(size);
            for (DynamicObject dy : policyDys) {
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("policyId", dy.getLong("id"));
                map.put("policyNumber", dy.getString("number"));
                map.put("startTime", dy.getDate("startdate"));
                map.put("endTime", dy.getDate("enddate"));
                String publishType = dy.getString("publishtype");
                map.put("publishType", publishType);
                MulBasedataDynamicObjectCollection publicOrgs = (MulBasedataDynamicObjectCollection)dy.get("lblstrategyorg");
                if (publicOrgs != null && publicOrgs.size() > 0) {
                    List orgIds = publicOrgs.stream().map(item -> item.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                    map.put("publishOrgs", orgIds);
                } else {
                    map.put("publishOrgs", new ArrayList());
                }
                policies.add(map);
            }
            result.put("policies", policies);
        }
        return result;
    }

    private Map<String, Object> validateListPoliciesBySceneParam(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (params == null || params.size() == 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRCSLabelService_0", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        Object bizApp = params.get("bizApp");
        Object sceneNumber = params.get("sceneNumber");
        Object policyIds = params.get("policyIds");
        if (bizApp == null || sceneNumber == null) {
            String errMsg = ResManager.loadKDString((String)"\u5e94\u7528\u6807\u8bc6\u53ca\u573a\u666f\u7f16\u7801\uff0c\u4e3a\u5fc5\u8f93\u9879", (String)"HRCSLabelService_1", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        if (!(bizApp instanceof String)) {
            String errMsg = ResManager.loadKDString((String)"\u5e94\u7528\u6807\u8bc6\u7c7b\u578b\u9519\u8bef\uff0c\u5e94\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b\u3002", (String)"HRCSLabelService_2", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        String bizAppStr = (String)bizApp;
        if (!(sceneNumber instanceof String)) {
            String errMsg = ResManager.loadKDString((String)"\u573a\u666f\u7f16\u7801\u7c7b\u578b\u9519\u8bef\uff0c\u5e94\u4e3a\u5b57\u7b26\u4e32\u7c7b\u578b\u3002", (String)"HRCSLabelService_3", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        String sceneNumberStr = (String)sceneNumber;
        if (StringUtils.isEmpty((String)bizAppStr) || StringUtils.isEmpty((String)sceneNumberStr)) {
            String errMsg = ResManager.loadKDString((String)"\u5e94\u7528\u6807\u8bc6\u53ca\u573a\u666f\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u4e32", (String)"HRCSLabelService_4", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        if (bizAppStr.length() > 50 || sceneNumberStr.length() > 50) {
            String errMsg = ResManager.loadKDString((String)"\u7f16\u7801\u957f\u5ea6\u6700\u957f\u4e3a50\u4f4d", (String)"HRCSLabelService_5", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        if (policyIds != null) {
            Object policyId;
            if (!(policyIds instanceof List)) {
                String errMsg = ResManager.loadKDString((String)"\u7b56\u7565ID\u96c6\u5408\u5e94\u4e3a\u5217\u8868\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRCSLabelService_6", (String)CURREN_MODULE, (Object[])new Object[0]);
                this.fillErrorResult(result, errMsg);
                return result;
            }
            List policyIdList = (List)policyIds;
            if (!CollectionUtils.isEmpty((Collection)policyIdList) && !((policyId = policyIdList.get(0)) instanceof Long)) {
                String errMsg = ResManager.loadKDString((String)"\u5355\u4e2a\u7b56\u7565ID\u5e94\u4e3a\u957f\u6574\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRCSLabelService_7", (String)CURREN_MODULE, (Object[])new Object[0]);
                this.fillErrorResult(result, errMsg);
                return result;
            }
        }
        return result;
    }

    private void fillErrorResult(Map<String, Object> result, String errMsg) {
        result.put("responseCode", "417");
        result.put("responseDesc", errMsg);
    }

    public Map<String, Object> batchGetLabel(Map<String, Object> paramMap) {
        Map<String, Object> result = this.validateBatchGetLabelParam(paramMap);
        if (!result.isEmpty()) {
            return result;
        }
        Long policyId = Long.parseLong(paramMap.get("policyId").toString());
        String taskNumber = paramMap.get("taskNumber").toString();
        int start = Integer.parseInt(paramMap.get("start").toString());
        int limit = Integer.parseInt(paramMap.get("limit").toString());
        LabelTaskStorageService taskStorageService = new LabelTaskStorageService(policyId, taskNumber);
        ArrayList qFilters = new ArrayList();
        List resultList = taskStorageService.getResultList(BATCH_GET_LABEL_SELECT_FIELDS, qFilters, start, limit);
        result.put("responseCode", "200");
        result.put("responseDesc", "success");
        result.put("resultList", resultList);
        return result;
    }

    public Map<String, Object> getLabelBySceneIdAndBizObjId(Map<String, Object> paramMap) {
        Map<String, Object> result = this.validateGetLabelBySceneIdAndBizObjId(paramMap);
        if (!result.isEmpty()) {
            return result;
        }
        return this.queryResults(paramMap);
    }

    public Map<String, Object> queryResults(Map<String, Object> paramMap) {
        return APILabelServiceHelper.queryResults(paramMap);
    }

    private Map<String, Object> validateBatchGetLabelParam(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (params == null || params.size() == 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRCSLabelService_0", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        Object policyId = params.get("policyId");
        Object taskNumber = params.get("taskNumber");
        Object start = params.get("start");
        Object limit = params.get("limit");
        if (policyId == null || taskNumber == null || start == null || limit == null) {
            String errMsg = ResManager.loadKDString((String)"policyId,taskNumber,start,limit\u4e3a\u5fc5\u586b\u9879", (String)"HRCSLabelService_11", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        return result;
    }

    private Map<String, Object> validateGetLabelBySceneIdAndBizObjId(Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (params == null || params.size() == 0) {
            String errMsg = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"HRCSLabelService_0", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        Object sceneId = params.get("sceneId");
        Object bizObjId = params.get("id");
        if (sceneId == null || bizObjId == null) {
            String errMsg = ResManager.loadKDString((String)"\u573a\u666fid\u548c\u4e3b\u4e1a\u52a1\u5bf9\u8c61id\u5747\u4e3a\u5fc5\u586b\u9879", (String)"HRCSLabelService_12", (String)CURREN_MODULE, (Object[])new Object[0]);
            this.fillErrorResult(result, errMsg);
            return result;
        }
        return result;
    }

    public LabelSceneInfo getLabelSceneInfo(String sceneNumber) {
        return LabelSceneServiceHelper.getLabelSceneInfo((String)sceneNumber);
    }

    public Map<String, Object> batchSaveLabels(String sceneNumber, Long creator, List<BaseLabelResult> labelResultList, boolean isReplace) {
        return APILabelServiceHelper.batchSaveLabels((String)sceneNumber, (Long)creator, labelResultList, (boolean)isReplace);
    }

    public Map<String, Object> deleteResults(Map<String, Object> paramMap) {
        return APILabelServiceHelper.deleteResults(paramMap);
    }

    public Map<String, Object> queryLabelObjectsByEntityNumber(String mainEntityNumber) {
        return APILabelServiceHelper.queryLabelObjectsByEntityNumber((String)mainEntityNumber);
    }

    public int getLabelsCount(String enable, String status, Map<String, Object> filters) {
        LabelServiceHelper labelServiceHelper = new LabelServiceHelper();
        return labelServiceHelper.getLabelsCount(enable, status, filters);
    }

    public Map<String, Object> getLabels(String enable, String status, Map<String, Object> filters, int start, int pageSize) {
        return APILabelServiceHelper.getLabels((String)enable, (String)status, filters, (int)start, (int)pageSize);
    }

    public int getLabelResultCount(Long labelObjectId, Long labelId, Map<String, Object> filters) {
        return APILabelServiceHelper.getLabelResultCount((Long)labelObjectId, (Long)labelId, filters);
    }

    public Map<String, Object> getLabelResult(Long labelObjectId, Long labelId, Map<String, Object> filters, int start, int pageSize) {
        return APILabelServiceHelper.getLabelResult((Long)labelObjectId, (Long)labelId, filters, (int)start, (int)pageSize);
    }

    public Map<String, Object> getLabelResult(Long labelObjectId, Long labelId, Map<String, Object> filters, int start, int pageSize, Object[] objSortValues) {
        return APILabelServiceHelper.getLabelResult((Long)labelObjectId, (Long)labelId, filters, (int)start, (int)pageSize, (Object[])objSortValues);
    }
}

