/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.mservice;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.common.api.EnumResponseCode;
import kd.hr.hbp.common.api.HrApiResponse;
import kd.hr.hbp.common.model.perm.UserBucaPermDataParam;
import kd.hr.hbp.common.model.perm.UserRoleBatchAssignBean;
import kd.hr.hrcs.bussiness.service.perm.UserRoleService;
import kd.hr.hrcs.bussiness.service.perm.check.UserAdminOrgService;
import kd.hr.hrcs.bussiness.service.perm.check.cache.DimServiceWithCache;
import kd.hr.hrcs.bussiness.servicehelper.perm.dimension.EntityCtrlServiceHelper;
import kd.hr.hrcs.mservice.api.IHRCSPermManageService;
import org.apache.commons.lang3.tuple.Triple;

public class HRCSPermManageService
implements IHRCSPermManageService {
    private static final Log LOGGER = LogFactory.getLog(HRCSPermManageService.class);

    public HrApiResponse batchDeleteUserRole(List<Triple<Long, String, Long>> userRoleList) {
        return new UserRoleService().batchDeleteUserRole(userRoleList);
    }

    public HrApiResponse batchUserAssignRole(List<UserRoleBatchAssignBean> permList) {
        return new UserRoleService().batchUserAssignRole(permList);
    }

    public HrApiResponse userAssignRole(Long userId, String roleNumber, Date validStart, Date validEnd, boolean isCustomData, Map<Long, UserBucaPermDataParam> bucaPermData, Long creatorId) {
        return new UserRoleService().userAssignRole(userId, roleNumber, validStart, validEnd, isCustomData, bucaPermData, creatorId);
    }

    public HrApiResponse deleteUserRole(long userId, String roleNumber) {
        return new UserRoleService().deleteUserRole(userId, roleNumber);
    }

    public Map<String, String> getEntityProps(String entityNumber) {
        return UserRoleService.getEntityProps((String)entityNumber);
    }

    public List<String> getPermConfigFields(String entityNum) {
        return UserRoleService.getPermConfigFields((String)entityNum);
    }

    public HrApiResponse syncPermFiles(List<Long> laborrelStatusIds) {
        return UserRoleService.syncPermFiles(laborrelStatusIds);
    }

    public Map<String, Object> copyUserRole(long fromUserId, long fromOrgId, long toUserId, long toOrgId, Date startDate, Date endDate) {
        return UserRoleService.copyUserRole((long)fromUserId, (long)fromOrgId, (long)toUserId, (long)toOrgId, (Date)startDate, (Date)endDate);
    }

    public Map<String, Object> getRoleDims(String roleNumber, String appId, String entityNumber) {
        LOGGER.info("HRCSPermManageService getRoleDims entry parameter, roleNumber:{},appId:{},entityNumber:{}", new Object[]{roleNumber, appId, entityNumber});
        try {
            HashMap resultData = Maps.newHashMapWithExpectedSize((int)2);
            appId = PermCommonUtil.getAppIdFromSuspectedAppNum((String)appId);
            Long funcId = DimServiceWithCache.getCheckFuncIdWithCache((String)appId, (String)entityNumber);
            DynamicObject sysRoleDyn = UserAdminOrgService.getSysRoleDyna((String)roleNumber);
            if (sysRoleDyn == null) {
                String msg = String.format("role number:%s not exist in bos or disabled.", roleNumber);
                resultData.put("code", EnumResponseCode.FAIL.getCode());
                resultData.put("msg", msg);
                return resultData;
            }
            String roleId = sysRoleDyn.getString("id");
            DynamicObject hmpRoleDyn = UserAdminOrgService.getHmpRoleDyna((String)roleId);
            if (hmpRoleDyn == null) {
                String msg = String.format("role number:%s not exist in hmp.", roleNumber);
                resultData.put("code", EnumResponseCode.FAIL.getCode());
                resultData.put("msg", msg);
                return resultData;
            }
            List roleDim = UserRoleService.getRoleDim((Long)funcId, (String)roleId);
            resultData.put("code", EnumResponseCode.SUCCESS.getCode());
            resultData.put("roleDim", roleDim);
            LOGGER.info("HRCSPermManageService getRoleDims result data:{}", (Object)roleDim);
            return resultData;
        }
        catch (Exception ex) {
            LOGGER.error("HRCSPermManageService microService getRoleDims error.", (Throwable)ex);
            HashMap resultData = Maps.newHashMapWithExpectedSize((int)2);
            resultData.put("code", EnumResponseCode.FAIL.getCode());
            resultData.put("msg", ex.getMessage());
            return resultData;
        }
    }

    public List<Map<String, Object>> getCtrlDimensionByEntity(String entityNumber, String propKey) {
        LOGGER.info("HRCSPermManageService.getCtrlDimensionByEntity entry,entityNumber:{},propKey:{}", (Object)entityNumber, (Object)propKey);
        List result = EntityCtrlServiceHelper.getCtrlDimensionByEntity((String)entityNumber, (String)propKey);
        LOGGER.info("HRCSPermManageService.getCtrlDimensionByEntity result:{} ", (Object)result);
        return result;
    }

    public Map<String, Map<String, Object>> getPropDimensionMappingByEntity(String entityNumber) {
        LOGGER.info("HRCSPermManageService.getPropDimensionMappingByEntity entry,entityNumber:{}", (Object)entityNumber);
        Map result = EntityCtrlServiceHelper.getPropDimensionMappingByEntity((String)entityNumber);
        LOGGER.info("HRCSPermManageService.getPropDimensionMappingByEntity result:{} ", (Object)result);
        return result;
    }
}

