/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.webapi.econtract;

import java.net.URLDecoder;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ContractSubjectService;
import kd.hr.hrcs.bussiness.service.econtract.EContNotifyLogService;
import kd.hr.hrcs.bussiness.util.AesCryptUtil;
import kd.hr.hrcs.webapi.econtract.EContApiResult;

public abstract class AbstractContractApiPlugin
implements IBillWebApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractContractApiPlugin.class);
    private static final int CODE_ERROR = 101;
    private static final int CODE_DECRYPT_ERROR = 107;
    private static final int CODE_NONCE_ERROR = 110;
    private static final int CODE_PARAM_ERROR = 114;
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"HRMPEContractOpenApiThreadPool", (int)2);

    protected boolean mapIsEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    protected boolean strIsEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public ApiResult doCustomService(Map<String, Object> params) {
        LOGGER.info("kd-contract-api time:{}, params:{}", (Object)System.currentTimeMillis(), (Object)SerializationUtils.toJsonString(params));
        if (this.mapIsEmpty(params)) {
            return this.fail(114, ResManager.loadKDString((String)"\u5f02\u6b65\u901a\u77e5\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"AbstractContractApiPlugin_0", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
        }
        try {
            Map queryBody;
            String nonce;
            String kdappid = ((String)params.get("kdAppId")).trim();
            String uuid = ContractSubjectService.queryKeyByKdAppid((String)kdappid);
            if (StringUtils.isEmpty((String)uuid)) {
                LOGGER.error("kd-contract-api kdappid{} not match--accountId:{}", (Object)kdappid, (Object)RequestContext.get().getAccountId());
                return this.fail(114, String.format(ResManager.loadKDString((String)"\u5408\u540c\u4e3b\u4f53KDAppID\u4e0d\u5339\u914d%s\u3002", (String)"AbstractContractApiPlugin_1", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]), kdappid));
            }
            String sign = (String)params.get("sign");
            String decryptSign = null;
            try {
                decryptSign = AesCryptUtil.decrypt((String)uuid, (String)sign);
            }
            catch (Exception e) {
                LOGGER.error("kd-contract-api decrypt fail{}", (Object)e.getMessage());
            }
            if (StringUtils.isEmpty((String)decryptSign)) {
                decryptSign = AesCryptUtil.decrypt((String)uuid, (String)URLDecoder.decode(sign, "utf-8"));
            }
            LOGGER.info("decryptSign--->{},uuid-->{},sign--->{}", new Object[]{decryptSign, uuid, sign});
            if (StringUtils.isEmpty((String)decryptSign)) {
                return this.fail(107, ResManager.loadKDString((String)"\u7b7e\u540d\u65e0\u6cd5\u89e3\u5bc6", (String)"AbstractContractApiPlugin_2", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
            }
            String queryNonce = (String)params.get("nonce");
            if (!HRStringUtils.equals((String)queryNonce, (String)(nonce = (String)(queryBody = (Map)SerializationUtils.fromJsonString((String)decryptSign, Map.class)).get("nonce")))) {
                return this.fail(110, ResManager.loadKDString((String)"nonce\u4e0d\u5339\u914d", (String)"AbstractContractApiPlugin_3", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
            }
            Map data = (Map)queryBody.get("data");
            if (data == null) {
                return this.fail(110, ResManager.loadKDString((String)"data\u4e3a\u7a7a", (String)"AbstractContractApiPlugin_5", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
            }
            return this.doBusinessAsync(data);
        }
        catch (Exception e) {
            LOGGER.error("kd-contract-api error{}", (Object)e.getMessage(), (Object)e);
            return this.fail(101, ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38", (String)"AbstractContractApiPlugin_4", (String)"hrmp-hrcs-mservice", (Object[])new Object[0]));
        }
    }

    abstract String interfaceName();

    abstract String uniqueKey(Map<String, Object> var1);

    private ApiResult doBusinessAsync(Map<String, Object> data) {
        LOGGER.info("data-->{}", data);
        String uniqueKey = this.uniqueKey(data);
        EContNotifyLogService.recordNotifyLog((String)this.interfaceName(), (String)uniqueKey, (String)SerializationUtils.toJsonString(data));
        threadPool.execute(() -> {
            try {
                ApiResult apiResult = this.doBusiness(data);
                if (apiResult.getHttpStatus() == 200) {
                    EContNotifyLogService.notifySuccess((String)this.interfaceName(), (String)uniqueKey);
                } else {
                    LOGGER.warn("EContract OpenApi async business fail:{}->{}", (Object)uniqueKey, (Object)apiResult.getErrorCode());
                    EContNotifyLogService.notifyFail((String)this.interfaceName(), (String)uniqueKey);
                }
            }
            catch (Exception exc) {
                LOGGER.error("EContract OpenApi async business exception:{}->{}", (Object)uniqueKey, (Object)exc.getMessage());
                LOGGER.error((Throwable)exc);
                EContNotifyLogService.notifyFail((String)this.interfaceName(), (String)uniqueKey);
            }
        });
        ApiResult apiResult = ApiResult.success(null);
        apiResult.setHttpStatus(Integer.valueOf(200));
        return apiResult;
    }

    protected abstract ApiResult doBusiness(Map<String, Object> var1);

    protected EContApiResult fail(int errorCode, String errorMsg) {
        EContApiResult apiResult = EContApiResult.fail(errorCode, errorMsg);
        apiResult.setHttpStatus(400);
        LOGGER.info("kd-contract-api return fail{}", (Object)errorMsg);
        return apiResult;
    }
}

