/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.webapi.econtract;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ContractSubjectService;
import kd.hr.hrcs.bussiness.service.econtract.ECPersonAuthRecordService;
import kd.hr.hrcs.bussiness.service.econtract.EContNotifyService;
import kd.hr.hrcs.bussiness.service.econtract.EContemplateService;
import kd.hr.hrcs.bussiness.service.econtract.EContractService;
import kd.hr.hrcs.bussiness.service.econtract.EContractSignApiService;
import kd.hr.hrcs.webapi.econtract.AbstractContractApiPlugin;
import kd.hr.hrcs.webapi.econtract.EContApiResult;

public class HandSignNotifyApiPlugin
extends AbstractContractApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(HandSignNotifyApiPlugin.class);
    private static final String PERSON_SIGN_NOTIFY = "signNotify";
    private static final String COMPANY_SIGN_NOTIFY = "companySignNotify";
    private static final String COMPANY_SIGN_FAIL_NOTIFY = "companySignFailNotify";
    private static final String SIGN_FAIL_NOTIFY = "signFailNotify";

    @Override
    String interfaceName() {
        return "hrHandsignNotify";
    }

    @Override
    String uniqueKey(Map<String, Object> data) {
        String contractNo = (String)data.get("contractNo");
        String userId = (String)data.get("userId");
        if (this.strIsEmpty(userId)) {
            return contractNo;
        }
        return contractNo + "&" + userId;
    }

    @Override
    protected ApiResult doBusiness(Map<String, Object> data) {
        LOGGER.info("kd-contract-api-handsignnotify params{}", data);
        String contractNo = (String)data.get("contractNo");
        String userId = (String)data.get("userId");
        Long timeStamp = (Long)data.get("createTime");
        Date date = new Date(timeStamp);
        String resultCode = (String)data.get("resultCode");
        String resultDesc = (String)data.get("resultDesc");
        LOGGER.info("kd-contract-api-handsignnotify userid:{} createTime:{} resultCode\uff1a{},resultDesc:{}", new Object[]{userId, date, resultCode, resultDesc});
        if ("1".equals(resultCode)) {
            EContractService eContractService = new EContractService();
            DynamicObject contractInfo = eContractService.queryContractInfo(contractNo);
            if (this.strIsEmpty(userId)) {
                this.doCompanySignSucess(contractNo, date, eContractService, contractInfo);
            } else {
                String dbUserId = contractInfo.getString("userid");
                boolean isCompanySign = false;
                if (!dbUserId.equals(userId) && !ECPersonAuthRecordService.userIdExists((String)userId)) {
                    isCompanySign = true;
                    this.doCompanySignSucess(contractNo, date, eContractService, contractInfo);
                }
                if (!isCompanySign) {
                    this.doUserSignSuccess(contractNo, date, eContractService, contractInfo);
                }
            }
            return EContApiResult.success(data);
        }
        EContractService eContractService = new EContractService();
        DynamicObject contractInfo = eContractService.queryContractInfo(contractNo);
        if (this.strIsEmpty(userId)) {
            this.failNotifyBiz(contractInfo, data, COMPANY_SIGN_FAIL_NOTIFY);
        } else {
            String dbUserId = contractInfo.getString("userid");
            boolean isCompanySign = false;
            if (!dbUserId.equals(userId) && !ECPersonAuthRecordService.userIdExists((String)userId)) {
                isCompanySign = true;
                this.failNotifyBiz(contractInfo, data, COMPANY_SIGN_FAIL_NOTIFY);
            }
            if (!isCompanySign) {
                this.failNotifyBiz(contractInfo, data, SIGN_FAIL_NOTIFY);
            }
        }
        LOGGER.info("sign result={}", (Object)JSON.toJSONString(data));
        return EContApiResult.fail((String)resultDesc, (String)resultCode);
    }

    private void doCompanySignSucess(String contractNo, Date signDate, EContractService eContractService, DynamicObject contractInfo) {
        LOGGER.info("kd-contract-api-handsignnotify updateCompanySignDate");
        long tempId = contractInfo.getLong("econtemplateid.id");
        DynamicObject contTplInfo = EContemplateService.queryEContplInfo((Long)tempId);
        String signtype = contTplInfo.getString("signtype");
        eContractService.updateCompanySignDate(contractInfo, signDate, signtype);
        this.notifyBiz(contractInfo, contractNo, COMPANY_SIGN_NOTIFY);
    }

    private void doUserSignSuccess(String contractNo, Date date, EContractService eContractService, DynamicObject contractInfo) {
        LOGGER.info("kd-contract-api-handsignnotify doUserSignSuccess");
        eContractService.recordPersonSign(contractInfo, date);
        this.notifyBiz(contractInfo, contractNo, PERSON_SIGN_NOTIFY);
        int signflag = contractInfo.getInt("signflag");
        long contSubjectId = contractInfo.getLong("kdappid.id");
        Long fiorg = ContractSubjectService.queryFiorg((Long)contSubjectId);
        long tempId = contractInfo.getLong("econtemplateid.id");
        if (eContractService.isAutoCompanyLast(signflag)) {
            LOGGER.info("kd-contract-api-handsignnotify to company sign contractno:{}, signflag:{}", (Object)contractNo, (Object)signflag);
            this.sign(fiorg, contractNo, tempId);
        }
    }

    private void notifyBiz(DynamicObject contractInfo, String contractNo, String methodName) {
        String cloud = contractInfo.getString("cloud");
        String appNum = contractInfo.getString("appnum");
        if (this.strIsEmpty(cloud) || this.strIsEmpty(appNum)) {
            return;
        }
        String servName = EContNotifyService.querySignNotifyServName((String)cloud, (String)appNum);
        if (this.strIsEmpty(servName)) {
            return;
        }
        LOGGER.info("kd-contract-api-handsignnotify to notify biz cloud:{}, appNum:{}, servName{},methodName{}, contractNo{}", new Object[]{cloud, appNum, servName, methodName, contractNo});
        try {
            HRMServiceHelper.invokeBizService((String)cloud, (String)appNum, (String)servName, (String)methodName, (Object[])new Object[]{contractNo});
        }
        catch (Exception e) {
            LOGGER.info("kd-contract-api-handsignnotify to notify biz err {}", (Object)e.getMessage());
        }
    }

    private void failNotifyBiz(DynamicObject contractInfo, Map<String, Object> data, String methodName) {
        String cloud = contractInfo.getString("cloud");
        String appNum = contractInfo.getString("appnum");
        if (this.strIsEmpty(cloud) || this.strIsEmpty(appNum)) {
            return;
        }
        String servName = EContNotifyService.querySignNotifyServName((String)cloud, (String)appNum);
        if (this.strIsEmpty(servName)) {
            return;
        }
        LOGGER.info("kd-contract-api-handsignnotify to notify biz cloud:{}, appNum:{}, servName{},methodName{}, data{}", new Object[]{cloud, appNum, servName, methodName, JSON.toJSONString(data)});
        try {
            HRMServiceHelper.invokeBizService((String)cloud, (String)appNum, (String)servName, (String)methodName, (Object[])new Object[]{data});
        }
        catch (Exception e) {
            LOGGER.info("kd-contract-api-handsignnotify to notify biz err {}", (Object)e.getMessage());
        }
    }

    private void sign(Long fiorg, String contractNo, Long tempId) {
        EContractSignApiService signService = new EContractSignApiService(fiorg);
        signService.companySign(fiorg, contractNo, tempId, null);
    }
}

