/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;
import kd.hrmp.hric.bussiness.service.loop.LoopChecker;
import kd.hrmp.hric.bussiness.service.loop.Node;
import kd.hrmp.hric.common.util.QFilterUtils;

public class FrontImplLoopSaveOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        if (this.isOperate("save") || this.isEnableOperate()) {
            this.checkFrontImplLoop(this.getDataEntities());
        }
    }

    private boolean isOperate(String key) {
        return HRStringUtils.equals((String)this.getOperateKey(), (String)key);
    }

    private boolean isEnableOperate() {
        return this.isOperate("enable");
    }

    private void checkFrontImplLoop(ExtendedDataEntity[] dataEntities) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        List<Long> idList = Stream.of(dataEntities).map(it -> it.getDataEntity()).map(it -> it.getLong("id")).filter(it -> it > 0L).collect(Collectors.toList());
        QFilter frontFilter = this.getFrontFilter(idList);
        this.addDataEntitiesToNodeList(dataEntities, nodeList);
        this.addFrontNodeFromDB(frontFilter, nodeList, idList);
        LoopChecker loopChecker = new LoopChecker();
        if (loopChecker.checkLoop(nodeList)) {
            Set idSet = loopChecker.getLoopNodeSet().stream().map(it -> it.getId()).collect(Collectors.toSet());
            for (ExtendedDataEntity dataEntity : dataEntities) {
                if (!idSet.contains(dataEntity.getDataEntity().getString("number"))) continue;
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u6b64\u8d44\u6599\u6570\u636e\uff0c\u56e0\u4e3a\u5b83\u88ab\u5f15\u7528\u3002\u8bf7\u5148\u5220\u9664\u5f15\u7528\u6b64\u8d44\u6599\u6570\u636e\u7684\u201c\u524d\u7f6e\u5b9e\u65bd\u9879\u201d\u3002", (String)"BizsubareaSaveOpValidator_2", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        }
    }

    private void addFrontNodeFromDB(QFilter frontFilter, List<Node> nodeList, List<Long> idList) {
        Map objMap = ImplItemListDaoHelper.getAllFrontImplItem((QFilter[])frontFilter.toArray());
        objMap.entrySet().forEach(entry -> {
            DynamicObject dy = (DynamicObject)entry.getValue();
            DynamicObjectCollection mulCollection = dy.getDynamicObjectCollection("mulfrontimpl");
            nodeList.addAll(mulCollection.stream().map(it -> new Node(dy.getString("number"), (String)Optional.ofNullable(it.getDynamicObject("fbasedataid")).filter(dy2 -> this.isCheck((DynamicObject)dy2, idList)).map(dy2 -> dy2.getString("number")).orElse(null))).collect(Collectors.toList()));
        });
    }

    private QFilter getFrontFilter(List<Long> idList) {
        QFilter frontFilter = QFilterUtils.getEnableQFilter();
        if (!CollectionUtils.isEmpty(idList)) {
            if (this.isEnableOperate()) {
                frontFilter.or(new QFilter("id", "in", idList));
            } else {
                frontFilter.and(new QFilter("id", "not in", idList));
            }
        }
        return frontFilter;
    }

    private boolean isCheck(DynamicObject dy2, List<Long> idList) {
        if (this.isEnableOperate() && idList.contains(dy2.getLong("id"))) {
            return true;
        }
        return dy2.getBoolean("enable");
    }

    private void addDataEntitiesToNodeList(ExtendedDataEntity[] dataEntities, List<Node> nodeList) {
        if (!this.isOperate("save")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            if (!dy.getBoolean("enable")) continue;
            DynamicObjectCollection mulCollection = dy.getDynamicObjectCollection("mulfrontimpl");
            nodeList.addAll(mulCollection.stream().map(it -> new Node(dy.getString("number"), (String)Optional.ofNullable(it.getDynamicObject("fbasedataid")).map(dy2 -> dy2.getString("number")).orElse(null))).collect(Collectors.toList()));
        }
    }
}

