/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IImplItemDomainService;
import kd.hrmp.hric.common.constants.AppConstants;

public class ImplItemEnableOpValidator
extends HRDataBaseValidator {
    private IImplItemDomainService iImplItemDomainService = (IImplItemDomainService)ServiceFactory.getService(IImplItemDomainService.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntitys = this.getDataEntities();
        List<ExtendedDataEntity> dataEntityList = Arrays.stream(dataEntitys).filter(dataEntity -> !HRStringUtils.equals((String)dataEntity.getDataEntity().getString("initfordatasource"), (String)"C")).collect(Collectors.toList());
        dataEntitys = dataEntityList.toArray(new ExtendedDataEntity[dataEntityList.size()]);
        List<DynamicObject> relatedImplItemList = this.getDisabledBaseImplItemList(dataEntitys);
        Set<String> repeatEntitySet = this.getSelectedRepeatEntitySet(relatedImplItemList);
        Set repeatEnableImplEntitySet = this.iImplItemDomainService.getEnabledImplItemRelEntitySet(relatedImplItemList);
        repeatEntitySet.addAll(repeatEnableImplEntitySet);
        if (!CollectionUtils.isEmpty(repeatEntitySet)) {
            for (ExtendedDataEntity dataEntity2 : dataEntitys) {
                DynamicObject implItem = dataEntity2.getDataEntity();
                this.validateEntityRepeat(repeatEntitySet, dataEntity2, implItem);
            }
        }
    }

    private Set<String> getSelectedRepeatEntitySet(List<DynamicObject> relatedImplItemList) {
        Map<String, Long> disabledImplMap = relatedImplItemList.stream().collect(Collectors.groupingBy(dyn -> dyn.getDynamicObject("entityobjscope").getString("number"), Collectors.counting()));
        return disabledImplMap.entrySet().stream().filter(entry -> (Long)entry.getValue() > AppConstants.LONG_ONE).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    private List<DynamicObject> getDisabledBaseImplItemList(ExtendedDataEntity[] dataEntitys) {
        ArrayList relatedImplItemList = Lists.newArrayListWithCapacity((int)16);
        List disabledImplItemList = Arrays.stream(dataEntitys).map(dataEntity -> dataEntity.getDataEntity()).filter(dyn -> !dyn.getBoolean("enable")).collect(Collectors.toList());
        relatedImplItemList.addAll(disabledImplItemList);
        for (DynamicObject implItem : disabledImplItemList) {
            if (!HRStringUtils.equals((String)implItem.getString("category"), (String)"1")) continue;
            relatedImplItemList.remove(implItem);
        }
        return relatedImplItemList;
    }

    private void validateEntityRepeat(Set<String> repeatEnableImplEntitySet, ExtendedDataEntity dataEntity, DynamicObject implItem) {
        if (!implItem.getBoolean("enable")) {
            DynamicObject entityObj;
            if (HRStringUtils.equals((String)implItem.getString("category"), (String)"1")) {
                DynamicObjectCollection entryCol = implItem.getDynamicObjectCollection("baseimplentry");
                HashSet entityNameSet = Sets.newHashSetWithExpectedSize((int)16);
                entryCol.stream().map(entryDyn -> entryDyn.getDynamicObject("implitem")).filter(dyn -> repeatEnableImplEntitySet.contains(dyn.getDynamicObject("entityobjscope").getString("id"))).forEach(dyn -> {
                    String entityName = dyn.getDynamicObject("entityobjscope").getString("name");
                    entityNameSet.add(entityName);
                });
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\u5df2\u7ecf\u6709\u53ef\u7528\u7684\u5b9e\u65bd\u9879\u9009\u62e9\uff0c\u4e0d\u80fd\u542f\u7528", (String)"ImplItemListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), implItem.getString("name"), entityNameSet.stream().collect(Collectors.joining(","))));
            } else if (HRStringUtils.equals((String)implItem.getString("category"), (String)"0") && repeatEnableImplEntitySet.contains((entityObj = implItem.getDynamicObject("entityobjscope")).getString("id"))) {
                this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff0c%2$s\u5df2\u7ecf\u6709\u53ef\u7528\u7684\u5b9e\u65bd\u9879\u9009\u62e9\uff0c\u4e0d\u80fd\u542f\u7528", (String)"ImplItemListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), implItem.getString("name"), entityObj.getString("name")));
            }
        }
    }

    public Set<String> preparePropertys() {
        return Sets.newHashSet((Object[])new String[]{"id", "number", "category", "entityobjscope", "initfordatasource", "enable", "baseimplentry.implitem"});
    }
}

