/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;
import kd.hrmp.hric.common.util.ConvertUtils;

public class ImplItemSaveOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"delete")) {
            this.checkReference(this.getDataEntities());
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"save")) {
            this.checkInitInfo(this.getDataEntities()[0]);
        }
    }

    private void checkReference(ExtendedDataEntity[] dataEntities) {
        List delIdList = Stream.of(dataEntities).map(ExtendedDataEntity::getDataEntity).map(it -> it.getLong("id")).collect(Collectors.toList());
        QFilter[] qFilters = ConvertUtils.getQFilter((QFilter[])new QFilter[]{new QFilter("mulfrontimpl.fbasedataid", "in", delIdList)});
        DynamicObject[] refDynamicObjects = new HRBaseServiceHelper("hric_implitem").query("number,mulfrontimpl", qFilters);
        HashSet idSet = new HashSet();
        for (DynamicObject dynamicObject : refDynamicObjects) {
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("mulfrontimpl");
            idSet.addAll(collection.stream().map(it -> it.getLong("fbasedataid_id")).collect(Collectors.toSet()));
        }
        for (DynamicObject dynamicObject : dataEntities) {
            if (!idSet.contains(dynamicObject.getDataEntity().getLong("id"))) continue;
            this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u6b64\u8d44\u6599\u6570\u636e\uff0c\u56e0\u4e3a\u5b83\u88ab\u5f15\u7528\u3002\u8bf7\u5148\u5220\u9664\u5f15\u7528\u6b64\u8d44\u6599\u6570\u636e\u7684\u201c\u524d\u7f6e\u5b9e\u65bd\u9879\u201d\u3002", (String)"BizsubareaSaveOpValidator_2", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }

    private void checkInitInfo(ExtendedDataEntity dataEntity) {
        if (!HRStringUtils.equals((String)dataEntity.getDataEntity().getString("initfordatasource"), (String)"C")) {
            this.checkEntityObj(dataEntity);
        }
    }

    private void checkEntityObj(ExtendedDataEntity dataEntity) {
        ArrayList<Long> ids = new ArrayList<Long>();
        DynamicObject dataEntityDyn = dataEntity.getDataEntity();
        Long pk = dataEntityDyn.getLong("id");
        ids.add(pk);
        if (HRStringUtils.equals((String)dataEntityDyn.getString("category"), (String)"0")) {
            ArrayList<String> entityNumberList = new ArrayList<String>();
            entityNumberList.add(dataEntity.getDataEntity().getDynamicObject("entityobjscope").getString("number"));
            DynamicObject[] implItemList = ImplItemListDaoHelper.getImplByEntityNumber(entityNumberList, ids);
            if (!CollectionUtils.isEmpty(Arrays.asList(implItemList))) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u7ecf\u6709\u53ef\u7528\u7684\u5b9e\u65bd\u9879\u9009\u62e9\uff0c\u4e0d\u80fd\u91cd\u590d\u9009\u62e9\u3002", (String)"ImplItemSaveOpValidator_0", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), dataEntity.getDataEntity().getDynamicObject("entityobjscope").getString("name")));
            }
        }
    }
}

