/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;

public class InitPlanSaveOpValidator
extends HRDataBaseValidator {
    private static Log LOG = LogFactory.getLog(InitPlanSaveOpValidator.class);

    public void validate() {
        super.validate();
        long beginTime = System.currentTimeMillis();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            Map allNameMap = InitPlanServiceHelper.getAllMasterPlanName();
            List allNumberList = InitPlanServiceHelper.getAllPlanNumber();
            for (Object data : dataEntities) {
                this.checkEntryNum((ExtendedDataEntity)data);
                this.checkRepeatNumber((ExtendedDataEntity)data, allNumberList);
                this.checkMasterPlanRepeatName((ExtendedDataEntity)data, allNameMap);
                this.checkRepeatName((ExtendedDataEntity)data);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info("[HRIC] Init plan save verify take up time\uff1a{}ms", (Object)(endTime - beginTime));
    }

    private void checkRepeatNumber(ExtendedDataEntity data, List<HashMap<String, String>> allNumberList) {
        DynamicObject dyc = data.getDataEntity();
        long id = dyc.getLong("id");
        final String number = dyc.getString("number");
        List<String> numbers = allNumberList.stream().map(it -> (String)it.get("number")).collect(Collectors.toList());
        if (AppConstants.CONFIG_MODE_LIST.contains(dyc.getString("configmode"))) {
            ArrayList<String> numberList = new ArrayList<String>(){
                {
                    this.add(number);
                }
            };
            this.removeModifyNumbers(allNumberList, id, number, (List<String>)numberList);
            this.removeModifyNumberWithIdExist((List<String>)numberList, numbers, number);
            this.getShowMsg(data, (List<String>)numberList, "number");
            return;
        }
        DynamicObjectCollection docs = data.getDataEntity().getDynamicObjectCollection("entryentity");
        List numberList = Optional.ofNullable(docs.stream().map(doc -> doc.getString("entrynumber")).collect(Collectors.toList())).orElseGet(() -> Lists.newArrayList());
        this.checkCurPageRepeateCode(data, numberList);
        if (numberList.contains(number)) {
            this.getShowMsg(data, (List<String>)new ArrayList<String>(){
                {
                    this.add(number);
                }
            }, "number");
            return;
        }
        numberList.add(number);
        if (id != 0L) {
            this.removeModifyNumbers(allNumberList, id, number, numberList);
            this.removeModifyNumberWithIdExist(numberList, numbers, number);
            docs.forEach(doc -> {
                Long subPlanId = doc.getLong("id");
                String subPlanNum = doc.getString("entrynumber");
                if (subPlanId == 0L) {
                    this.removeModifyNumberWithIdExist(numberList, numbers, subPlanNum);
                } else {
                    this.removeModifyNumbers(allNumberList, subPlanId, subPlanNum, numberList);
                    this.removeModifyNumberWithIdExist(numberList, numbers, subPlanNum);
                }
            });
            this.getShowMsg(data, numberList, "number");
        } else {
            this.getShowMsg(data, numberList.stream().filter(num -> numbers.contains(num)).collect(Collectors.toList()), "number");
        }
    }

    private void removeModifyNumberWithIdExist(List<String> numberList, List<String> numbers, String subPlanNum) {
        if (!numbers.contains(subPlanNum)) {
            numberList.remove(subPlanNum);
        }
    }

    private void checkCurPageRepeateCode(ExtendedDataEntity data, List<String> numberList) {
        if (CollectionUtils.isEmpty(numberList)) {
            return;
        }
        HashMap nameMap = new HashMap();
        numberList.forEach(name -> {
            int i = 1;
            if (nameMap.get(name) != null) {
                i = (Integer)nameMap.get(name) + 1;
            }
            nameMap.put(name, i);
        });
        List<String> repeateCodeList = nameMap.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(entry -> (String)entry.getKey()).collect(Collectors.toList());
        this.getShowMsg(data, repeateCodeList, "number");
    }

    private void removeModifyNumbers(List<HashMap<String, String>> allNumberList, long id, String number, List<String> numberList) {
        List ids = allNumberList.stream().filter(it -> HRStringUtils.equals((String)((String)it.get("id")), (String)(id + ""))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(ids)) {
            String planId = (String)((HashMap)ids.get(0)).get("id");
            String planNumber = (String)((HashMap)ids.get(0)).get("number");
            if (HRStringUtils.equals((String)planId, (String)(id + "")) && HRStringUtils.equals((String)planNumber, (String)number)) {
                numberList.remove(planNumber);
            }
        }
    }

    private void checkMasterPlanRepeatName(ExtendedDataEntity data, Map<Long, String> allNameMap) {
        DynamicObject dyc = data.getDataEntity();
        DynamicObject parentDyc = dyc.getDynamicObject("parent");
        if (!ObjectUtils.isEmpty((Object)parentDyc)) {
            return;
        }
        String currPlanName = dyc.getString("name");
        Map<Long, String> nameMap = allNameMap;
        nameMap.remove(dyc.getLong("id"));
        if (nameMap.values().contains(currPlanName)) {
            this.addFatalErrorMessage(data, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8ba1\u5212\u540d\u79f0%s\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InitPlanSaveOpValidator_4", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), currPlanName));
            return;
        }
    }

    private void checkEntryNum(ExtendedDataEntity data) {
        DynamicObjectCollection dys = data.getDataEntity().getDynamicObjectCollection("entryentity");
        if (dys.size() > 20) {
            this.addFatalErrorMessage(data, ResManager.loadKDString((String)"\u5b50\u8ba1\u5212\u6700\u5927\u652f\u6301\u62c6\u520620\u4e2a\u3002\u8bf7\u81ea\u884c\u5220\u51cf\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"InitPlanSaveOpValidator_3", (String)"hrmp-hric-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void checkRepeatName(ExtendedDataEntity data) {
        DynamicObject dyc = data.getDataEntity();
        if (AppConstants.CONFIG_MODE_LIST.contains(dyc.getString("configmode"))) {
            return;
        }
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("entryentity");
        this.getShowMsg(data, this.getRepeatNameInCurrEntry(docs, dyc.getString("name")), "name");
    }

    private List<String> getRepeatNameInCurrEntry(DynamicObjectCollection docs, String parentPlanName) {
        List<String> nameList = docs.stream().map(doc -> doc.getString("entryname")).collect(Collectors.toList());
        if (HRStringUtils.isNotEmpty((String)parentPlanName)) {
            nameList.add(parentPlanName);
        }
        HashMap nameMap = new HashMap();
        nameList.forEach(name -> {
            int i = 1;
            if (nameMap.get(name) != null) {
                i = (Integer)nameMap.get(name) + 1;
            }
            nameMap.put(name, i);
        });
        nameList.clear();
        nameMap.keySet().forEach(name -> {
            if ((Integer)nameMap.get(name) > 1) {
                nameList.add((String)name);
            }
        });
        return nameList;
    }

    private void getShowMsg(ExtendedDataEntity data, List<String> nameList, String flag) {
        String tip = "";
        tip = HRStringUtils.equals((String)flag, (String)"number") ? ResManager.loadKDString((String)"\u8ba1\u5212\u7f16\u53f7", (String)"InitPlanSaveOpValidator_5", (String)"hrmp-hric-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5b50\u8ba1\u5212\u540d\u79f0", (String)"InitPlanSaveOpValidator_1", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
        StringBuilder msg = new StringBuilder();
        if (!CollectionUtils.isEmpty(nameList)) {
            msg.append(tip).append(Joiner.on((String)"\u3001").join(nameList));
        }
        if (HRStringUtils.isNotEmpty((String)msg.toString())) {
            this.addFatalErrorMessage(data, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InitPlanSaveOpValidator_2", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), msg));
            return;
        }
    }
}

