/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.ICooperativeDomainService;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;

public class InitPlanStartUpOpValidator
extends HRDataBaseValidator {
    private static Log LOG = LogFactory.getLog(InitPlanStartUpOpValidator.class);
    ICooperativeDomainService iSystemParamDomainService = (ICooperativeDomainService)ServiceFactory.getService(ICooperativeDomainService.class);

    public void validate() {
        super.validate();
        long beginTime = System.currentTimeMillis();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"startup")) {
            for (Object data : dataEntities) {
                DynamicObject dyc = data.getDataEntity();
                this.checkPlanPersonIsWrite((ExtendedDataEntity)data, dyc, "planperson", "name");
                if (HRStringUtils.equals((String)dyc.getString("configmode"), (String)"A")) {
                    this.checkPersonIsWrite((ExtendedDataEntity)data);
                    this.checkSonPlanIsCover((ExtendedDataEntity)data);
                    continue;
                }
                this.checkImplItemPlanPersonIsWrite((ExtendedDataEntity)data);
                this.checkVerifyPersonIsWrite((ExtendedDataEntity)data);
            }
        }
        long endTime = System.currentTimeMillis();
        LOG.info("[HRIC] Init plan start verify take up time\uff1a{}ms", (Object)(endTime - beginTime));
    }

    private void checkImplItemPlanPersonIsWrite(ExtendedDataEntity data) {
        DynamicObject dyc = data.getDataEntity();
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("itementryentity");
        if (CollectionUtils.isEmpty((Collection)docs)) {
            return;
        }
        docs.forEach(doc -> {
            boolean isSkip = doc.getBoolean("isskip");
            DynamicObject executePerson = doc.getDynamicObject("executeperson");
            if (!isSkip && executePerson == null) {
                this.addFatalErrorMessage(data, String.format(this.getEmptyTip(), doc.getString("itemname"), doc.getDynamicObjectType().getProperty("executeperson").getDisplayName().getLocaleValue()));
                return;
            }
        });
    }

    private void checkSonPlanIsCover(ExtendedDataEntity data) {
        DynamicObject dyc = data.getDataEntity();
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("bizsubarea");
        List<String> subAreas = docs.stream().map(doc -> doc.get(1)).map(doc -> ((DynamicObject)doc).getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
        DynamicObjectCollection dys = dyc.getDynamicObjectCollection("entryentity");
        ArrayList entrySubAreas = new ArrayList();
        dys.forEach(it -> {
            List currRowSubAreas = it.getDynamicObjectCollection("entrybizsubarea").stream().map(doc -> doc.get(1)).map(doc -> ((DynamicObject)doc).getLocaleString("name").getLocaleValue()).collect(Collectors.toList());
            entrySubAreas.addAll(currRowSubAreas);
        });
        subAreas.forEach(sub -> {
            if (!entrySubAreas.contains(sub)) {
                this.addFatalErrorMessage(data, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u65e0\u6cd5\u542f\u52a8\uff0c\u4e1a\u52a1\u5b50\u9886\u57df%s\u7f3a\u5c11\u5b50\u8ba1\u5212\u914d\u7f6e\u3002", (String)"InitPlanStartUpOpValidator_2", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), sub));
                return;
            }
        });
    }

    private void checkVerifyPersonIsWrite(ExtendedDataEntity data) {
        if (!this.iSystemParamDomainService.getParameterBoolean()) {
            return;
        }
        DynamicObject dyc = data.getDataEntity();
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("itementryentity");
        if (CollectionUtils.isEmpty((Collection)docs)) {
            return;
        }
        docs.forEach(doc -> {
            boolean isDataVerify = doc.getBoolean("isdataverify");
            DynamicObject verifyPerson = doc.getDynamicObject("verifyperson");
            if (isDataVerify && verifyPerson == null) {
                this.addFatalErrorMessage(data, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201d%s\u201c\u5df2\u5f00\u542f\u6570\u636e\u9a8c\u8bc1\uff0c\u8bf7\u586b\u5199\u9a8c\u8bc1\u8d1f\u8d23\u4eba\u3002", (String)"InitPlanStartUpOpValidator_1", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), doc.getString("itemname")));
                return;
            }
        });
    }

    private void checkPersonIsWrite(ExtendedDataEntity data) {
        DynamicObject dyc = data.getDataEntity();
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)docs)) {
            return;
        }
        docs.forEach(doc -> this.checkPlanPersonIsWrite(data, (DynamicObject)doc, "entryplanperson", "entryname"));
    }

    private void checkPlanPersonIsWrite(ExtendedDataEntity data, DynamicObject dyc, String fieldPlanperson, String fieldName) {
        if (dyc.getDynamicObject(fieldPlanperson) == null) {
            if (HRStringUtils.equals((String)fieldPlanperson, (String)"planperson")) {
                this.execParentPlanPersonIsEmpty(data, dyc, fieldPlanperson, fieldName);
            } else {
                this.addFatalErrorMessage(data, String.format(this.getEmptyTip(), dyc.getString(fieldName), dyc.getDynamicObjectType().getProperty(fieldPlanperson).getDisplayName().getLocaleValue()));
            }
        }
    }

    private void execParentPlanPersonIsEmpty(ExtendedDataEntity data, DynamicObject dyc, String fieldPlanperson, String fieldName) {
        if (null == dyc.getString("structnumber")) {
            this.addFatalErrorMessage(data, String.format(this.getEmptyTip(), dyc.getString(fieldName), dyc.getDynamicObjectType().getProperty(fieldPlanperson).getDisplayName().getLocaleValue()));
            return;
        }
        DynamicObject[] allParentPlans = InitPlanServiceHelper.getAllParentPlans((String)dyc.getString("structnumber"));
        boolean isEmptyForPerson = Arrays.asList(allParentPlans).stream().anyMatch(it -> it.get("planperson") == null && allParentPlans.length > 1);
        if (isEmptyForPerson) {
            this.addFatalErrorMessage(data, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d%2$s\u4e3a\u7a7a\uff0c\u8bf7\u5230\u201c%3$s\u201d\u7684\u5b50\u8ba1\u5212\u4fe1\u606f\u9762\u677f\u4e2d\u91cd\u65b0\u5206\u914d\u8d1f\u8d23\u4eba", (String)"InitPlanStartUpOpValidator_4", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), dyc.getString(fieldName), dyc.getDynamicObjectType().getProperty(fieldPlanperson).getDisplayName().getLocaleValue(), Arrays.asList(allParentPlans).stream().filter(it -> it.get("parent") == null).findFirst().get().getString("name")));
        } else {
            this.addFatalErrorMessage(data, String.format(this.getEmptyTip(), dyc.getString(fieldName), dyc.getDynamicObjectType().getProperty(fieldPlanperson).getDisplayName().getLocaleValue()));
        }
    }

    private String getEmptyTip() {
        return ResManager.loadKDString((String)"\u201d%1$s\u201c%2$s\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"InitPlanStartUpOpValidator_0", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    }
}

