/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;

public class InitTemplateSaveOpValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        if (HRStringUtils.equals((String)this.getOperateKey(), (String)"save") || HRStringUtils.equals((String)this.getOperateKey(), (String)"submit")) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            this.checkMediateTable(dataEntities[0]);
            this.checkUniqueString(dataEntities[0]);
            this.checkDataRange(dataEntities[0]);
        }
    }

    private void checkDataRange(ExtendedDataEntity dataEntity) {
        DynamicObject dyn = dataEntity.getDataEntity();
        DynamicObjectCollection templateEntryCol = dyn.getDynamicObjectCollection("treeentryentity");
        DynamicObject dynamicObject = dyn.getDynamicObject("entityobjscope");
        String number = dynamicObject.getString(((BasedataEntityType)dynamicObject.getDataEntityType()).getNumberProperty());
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        ArrayList<MainEntityType> entityTypes = new ArrayList<MainEntityType>();
        HashMap dateMap = Maps.newHashMap();
        if (mainType instanceof QueryEntityType) {
            QueryEntityType queryType = (QueryEntityType)mainType;
            entityTypes.add(queryType.getMainEntityType());
            entityTypes.addAll(queryType.getAllJoinEntityType());
        } else {
            entityTypes.add(mainType);
        }
        for (MainEntityType mainEntityType : entityTypes) {
            this.buildDateRange(mainEntityType, dateMap);
        }
        Map<String, Boolean> resultMap = templateEntryCol.stream().filter(entryDyn -> dateMap.containsKey(entryDyn.getString("entitynumber")) && entryDyn.getBoolean("isimport")).collect(Collectors.toMap(entryDyn -> entryDyn.getString("entitynumber"), it -> true));
        templateEntryCol.stream().filter(entryDyn -> dateMap.containsKey(entryDyn.getString("entitynumber")) && !entryDyn.getBoolean("isimport")).filter(entryDyn -> resultMap.containsKey(dateMap.get(entryDyn.getString("entitynumber")))).forEach(entryDyn -> this.addFatalErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\"%1$s\"\u548c\"%2$s\", \"\u662f\u5426\u5bfc\u5165\"\u8bf7\u4fdd\u6301\u4e00\u81f4\u3002", (String)"InitTemplateSaveOpValidator_3", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), dateMap.get(entryDyn.getString("entitynumber")), entryDyn.getString("entitynumber"))));
    }

    private void buildDateRange(MainEntityType mainType, Map<String, String> dateMap) {
        List newItems = InitTemplateServiceHelper.filterEntityItems((MainEntityType)mainType);
        for (EntityItem entityItem : newItems) {
            if (entityItem instanceof DateRangeField) {
                dateMap.put(((DateRangeField)entityItem).getStartDateFieldKey(), ((DateRangeField)entityItem).getEndDateFieldKey());
                dateMap.put(((DateRangeField)entityItem).getEndDateFieldKey(), ((DateRangeField)entityItem).getStartDateFieldKey());
            }
            if (!(entityItem instanceof TimeRangeField)) continue;
            dateMap.put(((TimeRangeField)entityItem).getStartDateFieldKey(), ((TimeRangeField)entityItem).getEndDateFieldKey());
            dateMap.put(((TimeRangeField)entityItem).getEndDateFieldKey(), ((TimeRangeField)entityItem).getStartDateFieldKey());
        }
    }

    private void checkUniqueString(ExtendedDataEntity dataEntity) {
        DynamicObject dyn = dataEntity.getDataEntity();
        HashMap parentMap = Maps.newHashMap();
        Map<Long, List<String>> fieldsMap = this.getFieldsMap(dyn, parentMap);
        String uniqueString = (String)dyn.get("uniquestring");
        List uniqueList = Arrays.stream(uniqueString.split(",")).filter(s -> HRStringUtils.isNotEmpty((String)s)).collect(Collectors.toList());
        StringBuilder msgBuilder = new StringBuilder();
        for (Map.Entry<Long, List<String>> entryFields : fieldsMap.entrySet()) {
            String headName;
            boolean isMatch;
            if (CollectionUtils.isEmpty((Collection)entryFields.getValue()) || (isMatch = entryFields.getValue().stream().anyMatch(field -> uniqueList.contains(field)))) continue;
            InitTemplateServiceHelper templateHelper = new InitTemplateServiceHelper();
            String string = headName = HRStringUtils.equals((String)"billhead", (String)((String)parentMap.get(entryFields.getKey()))) ? templateHelper.getBillHeadResName() : templateHelper.getBillBodyResName();
            if (HRStringUtils.equals((String)"billhead", (String)((String)parentMap.get(entryFields.getKey())))) {
                msgBuilder.append(ResManager.loadKDString((String)"\u5355\u636e\u5934\u5b58\u5728\u201c\u662f\u5426\u5bfc\u5165\u201d\u4e3a\u662f\u7684\u5b57\u6bb5\uff0c\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5bfc\u5165\u5b57\u6bb5\u4f5c\u4e3a\u6570\u636e\u66ff\u6362\u552f\u4e00\u503c\u3002", (String)"InitTemplateSaveOpValidator_1", (String)"hrmp-hric-formplugin", (Object[])new Object[]{parentMap.get(entryFields.getKey()), headName})).append("\n");
                continue;
            }
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5bfc\u5165\u5b57\u6bb5\u4f5c\u4e3a\u6570\u636e\u66ff\u6362\u552f\u4e00\u503c\uff0c\u7f16\u7801\u4e3a{0}\u7684{1}\u5b58\u5728\u201c\u662f\u5426\u5bfc\u5165\u201d\u4e3a\u201c\u662f\u201d\u7684\u5b57\u6bb5\u3002", (String)"InitTemplateSaveOpValidator_2", (String)"hrmp-hric-formplugin", (Object[])new Object[]{parentMap.get(entryFields.getKey()), headName})).append("\n");
        }
        if (msgBuilder.length() > 0) {
            this.addFatalErrorMessage(this.dataEntities[0], msgBuilder.toString());
        }
    }

    private void checkMediateTable(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        Long pkId = (Long)dy.getPkValue();
        String tableName = dy.getString("intermediatetable");
        if (InitTemplateServiceHelper.isInDb((String)"intermediatetable", (String)tableName, (Long)pkId, null)) {
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u3010%s\u3011\uff1a\u7f13\u5b58\u8868\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"InitTemplateSaveOpValidator_0", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), tableName));
        }
    }

    private Map<Long, List<String>> getFieldsMap(DynamicObject dyn, Map<Long, String> parentMap) {
        HashMap fieldMap = Maps.newHashMap();
        DynamicObjectCollection templateEntryCol = dyn.getDynamicObjectCollection("treeentryentity");
        List<String> fieldList = null;
        for (DynamicObject entryDyn : templateEntryCol) {
            if (entryDyn == null || entryDyn.getLong("pid") == 0L || !entryDyn.getBoolean("istablehead") || fieldMap.get(entryDyn.getLong("id")) != null) continue;
            fieldList = new ArrayList();
            fieldMap.put(entryDyn.getLong("id"), fieldList);
            parentMap.put(entryDyn.getLong("id"), entryDyn.getString("entitynumber"));
        }
        for (DynamicObject entryDyn : templateEntryCol) {
            if (entryDyn == null || entryDyn.getLong("pid") == 0L || entryDyn.getBoolean("istablehead") || fieldList == null || entryDyn == null || !entryDyn.getBoolean("isimport")) continue;
            fieldList = (List)fieldMap.get(entryDyn.getLong("pid"));
            fieldList.add(entryDyn.getString("numberalias"));
        }
        return fieldMap;
    }

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add("treeentryentity.pid");
        set.add("treeentryentity.istablehead");
        set.add("treeentryentity.entityname");
        set.add("treeentryentity.entitynumber");
        set.add("treeentryentity.numberalias");
        set.add("treeentryentity.isimport");
        set.add("treeentryentity.isfield");
        set.add("treeentryentity.ismustinput");
        set.add("treeentryentity.isbasedata");
        set.add("treeentryentity.isvalidateexist");
        return set;
    }
}

