/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hrmp.hric.bussiness.service.MicConfigServiceHelper;
import kd.hrmp.hric.common.util.HricObjectUtils;

public class MicConfigCommonOpValidator
extends HRDataBaseValidator {
    protected void checkAppScope() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<String, DynamicObject> entityMicConfigMap = this.getEntityToMicConfigMap(dataEntities);
        Map<String, DynamicObject> appMicConfigMap = this.getAppToMicConfigMap(dataEntities);
        Arrays.stream(this.getDataEntities()).forEach(dataEntity -> {
            String entityName;
            DynamicObject dy = dataEntity.getDataEntity();
            DynamicObject appScope = dy.getDynamicObject("appscope");
            String appName = dy.getDynamicObject("apprel").getString("name");
            String string = entityName = HricObjectUtils.isEmpty((Object)appScope) ? "" : appScope.getString("name");
            if (appScope == null && !HricObjectUtils.isEmpty(appMicConfigMap.get(dy.getDynamicObject("apprel").getString("id")))) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s:\u5173\u8054\u5e94\u7528\u5df2\u5b58\u5728\u53ef\u7528\u7684\u6570\u636e\uff0c\u8bf7\u4fee\u6539\uff1b", (String)"MicConfigSaveOpValidator_0", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), appName));
            } else if (appScope != null && !HricObjectUtils.isEmpty(entityMicConfigMap.get(appScope.getString("id")))) {
                this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, String.format(ResManager.loadKDString((String)"%1$s-%2$s\uff1a\u5173\u8054\u5e94\u7528-\u5173\u8054\u5b9e\u4f53\u5bf9\u8c61\u5df2\u5b58\u5728\u53ef\u7528\u6570\u636e\uff0c\u8bf7\u4fee\u6539\u3002", (String)"MicConfigSaveOpValidator_1", (String)"hrmp-hric-opplugin", (Object[])new Object[0]), appName, entityName));
            }
        });
    }

    private Map<String, DynamicObject> getEntityToMicConfigMap(ExtendedDataEntity[] dataEntities) {
        List entityNumber = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity()).filter(dyn -> dyn.getDynamicObject("appscope") != null).map(dyn -> dyn.getDynamicObject("appscope").getString("id")).collect(Collectors.toList());
        List<Long> idList = this.getIdList(dataEntities);
        DynamicObject[] micConfigDyns = MicConfigServiceHelper.getMicConfigsByEntityNumber((String)"appscope", entityNumber, idList);
        return Arrays.stream(micConfigDyns).collect(Collectors.toMap(dyn -> dyn.getDynamicObject("appscope").getString("id"), dyn -> dyn, (before, after) -> before));
    }

    private Map<String, DynamicObject> getAppToMicConfigMap(ExtendedDataEntity[] dataEntities) {
        List relAppIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity()).filter(dyn -> dyn.getDynamicObject("appscope") == null && dyn.getDynamicObject("apprel") != null).map(dyn -> dyn.getDynamicObject("apprel").getString("id")).collect(Collectors.toList());
        List<Long> idList = this.getIdList(dataEntities);
        DynamicObject[] micConfigDyns = MicConfigServiceHelper.getMicConfigsByAppId((String)"apprel", relAppIds, idList);
        return Arrays.stream(micConfigDyns).collect(Collectors.toMap(dyn -> dyn.getDynamicObject("apprel").getString("id"), dyn -> dyn, (before, after) -> before));
    }

    private List<Long> getIdList(ExtendedDataEntity[] dataEntities) {
        return Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity()).filter(dyn -> dyn.getLong("id") > 0L).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
    }
}

