/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.web;

import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IAttachmentDataService;
import kd.hrmp.hric.bussiness.service.AttachmentDataServiceHelper;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.AttachmentUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class ImplItemAttachmentSaveOpPlugin
extends HRDataBaseOp {
    private static Log LOG = LogFactory.getLog(ImplItemAttachmentSaveOpPlugin.class);
    private IAttachmentDataService iAttachmentDataService = (IAttachmentDataService)ServiceFactory.getService(IAttachmentDataService.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Object[] dys = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return;
        }
        if (HRStringUtils.equals((String)e.getOperationKey(), (String)"save")) {
            this.saveAttachment((DynamicObject)dys[0]);
        }
    }

    private void saveAttachment(DynamicObject dyc) {
        long pkId = dyc.getLong("id");
        String attachJsonData = HricDynamicObjectUtils.getBigText((DynamicObject)dyc, (String)"attachmentjsondata");
        if (HRStringUtils.isEmpty((String)attachJsonData) && !this.iAttachmentDataService.isExistAttachment(Long.valueOf(pkId))) {
            return;
        }
        attachJsonData = HRStringUtils.isEmpty((String)attachJsonData) ? "[]" : attachJsonData;
        List<DynamicObject> attachmentDys = this.getAttachmentList(pkId, attachJsonData);
        AttachmentDataServiceHelper.dealAttachmentData((Long)pkId, (DynamicObject[])attachmentDys.toArray(new DynamicObject[attachmentDys.size()]));
    }

    private List<DynamicObject> getAttachmentList(long pkId, String attachJsonData) {
        List attachmentDataList;
        try {
            attachmentDataList = (List)HRJSONUtils.cast((String)attachJsonData, List.class);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDHricException((Throwable)e, HRICErrorEnum.JSON_PARSE_ERROR, new Object[0]);
        }
        ArrayList attachmentDys = Lists.newArrayListWithCapacity((int)attachmentDataList.size());
        attachmentDataList.forEach(urlInfo -> {
            DynamicObject attachmentData = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_attachmentdata"));
            attachmentData.set("relentity", (Object)pkId);
            attachmentData.set("creator", (Object)RequestContext.get().getCurrUserId());
            attachmentData.set("createdate", (Object)new Date());
            attachmentData.set("description", urlInfo.get("description"));
            attachmentData.set("sort", urlInfo.get("sort"));
            attachmentData.set("name", urlInfo.get("name"));
            attachmentData.set("type", urlInfo.get("type"));
            attachmentData.set("size", urlInfo.get("size"));
            attachmentData.set("url", urlInfo.get("url"));
            this.downloadFromCache(urlInfo.get("url").toString(), attachmentData);
            attachmentDys.add(attachmentData);
        });
        return attachmentDys;
    }

    private void downloadFromCache(String url, DynamicObject attachmentData) {
        InputStream is = AttachmentUtils.getInputStream((String)url);
        try {
            attachmentData.set("filedata", (Object)Base64.getEncoder().encodeToString(ByteStreams.toByteArray((InputStream)is)));
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
            throw new KDHricException((Throwable)ex, HRICErrorEnum.IO_STREAM_OPERATE_ERROR, new Object[0]);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

