/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.opplugin.validator.InitPlanSaveOpValidator;

public class InitPlanSaveOpPlugin
extends HRDataBaseOp {
    private static Log LOG = LogFactory.getLog(InitPlanSaveOpPlugin.class);
    private static HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hric_initplan");

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InitPlanSaveOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long beginTime = System.currentTimeMillis();
        Object[] dys = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return;
        }
        if (HRStringUtils.equals((String)e.getOperationKey(), (String)"save")) {
            this.saveInitPlan((DynamicObject[])dys);
        }
        long endTime = System.currentTimeMillis();
        LOG.info("[HRIC] Init plan save take up time\uff1a{}ms", (Object)(endTime - beginTime));
    }

    private void saveInitPlan(DynamicObject[] dys) {
        ArrayList saveEntitys = new ArrayList();
        ArrayList needDelEntitys = new ArrayList();
        ArrayList<Long> needDelIds = new ArrayList<Long>();
        DynamicObject[] subPlans = InitPlanServiceHelper.getSubInitPlansByParentIds(this.getIds(dys));
        Arrays.stream(dys).forEach(dyc -> {
            if (HRStringUtils.isEmpty((String)dyc.getString("structnumber"))) {
                dyc.set("structnumber", (Object)ORM.create().genStringId(dyc.getDataEntityType()));
            }
            if (AppConstants.CONFIG_MODE_LIST.contains(dyc.getString("configmode"))) {
                needDelIds.add((Long)dyc.get("id"));
                return;
            }
            dyc.set("itementryentity", null);
            Map<Long, DynamicObject> subPlanMap = this.getSubPlans(subPlans, dyc.getLong("id"));
            Set<Long> subPlanIds = subPlanMap.keySet();
            DynamicObjectCollection docs = dyc.getDynamicObjectCollection("entryentity");
            docs.forEach(doc -> {
                Long currId = doc.getLong("id");
                if (subPlanIds.contains(currId)) {
                    DynamicObject sub = (DynamicObject)subPlanMap.remove(currId);
                    this.fieldSetter((DynamicObject)doc, sub);
                    saveEntitys.add(sub);
                } else if (currId == 0L) {
                    DynamicObject sonDyc = new DynamicObject(dyc.getDynamicObjectType());
                    this.structSonDyc((DynamicObject)doc, sonDyc, (DynamicObject)dyc);
                    saveEntitys.add(sonDyc);
                }
            });
            needDelEntitys.addAll(CollectionUtils.isEmpty(subPlanMap) ? new ArrayList() : subPlanMap.values());
        });
        List<Long> delIds = needDelEntitys.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        InitPlanServiceHelper.delInitPlans((Long[])delIds.toArray(new Long[delIds.size()]));
        serviceHelper.save(saveEntitys.toArray(new DynamicObject[saveEntitys.size()]));
        this.delSonPlans(needDelIds);
    }

    private void delSonPlans(List<Long> needDelIds) {
        if (CollectionUtils.isEmpty(needDelIds)) {
            return;
        }
        InitPlanServiceHelper.delSonPlans((Long[])((Long[])needDelIds.stream().toArray(Long[]::new)));
    }

    private Map<Long, DynamicObject> getSubPlans(DynamicObject[] dys, Long parentId) {
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return new HashMap<Long, DynamicObject>();
        }
        return Arrays.stream(dys).filter(dyc -> dyc.getLong("parent.id") == parentId.longValue()).collect(Collectors.toMap(dyc -> dyc.getLong("id"), dyc -> dyc, (k1, k2) -> k1));
    }

    private List<Long> getIds(DynamicObject[] dys) {
        return Arrays.stream(dys).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
    }

    private void structSonDyc(DynamicObject doc, DynamicObject sonDyc, DynamicObject dyc) {
        DynamicObject industry;
        ORM orm = ORM.create();
        sonDyc.set("entryentity", null);
        long id = orm.genLongId(sonDyc.getDataEntityType());
        sonDyc.set("id", (Object)id);
        sonDyc.set("masterid", (Object)id);
        sonDyc.set("structnumber", (Object)(dyc.getString("structnumber") + "!" + orm.genStringId(sonDyc.getDataEntityType())));
        sonDyc.set("layer", (Object)(dyc.getInt("layer") + 1));
        sonDyc.set("parent", (Object)dyc);
        sonDyc.set("planstatus", (Object)"E");
        sonDyc.set("plantype", (Object)dyc.getString("plantype"));
        this.fieldSetter(doc, sonDyc);
        sonDyc.set("status", (Object)"A");
        sonDyc.set("enable", (Object)"1");
        DynamicObject sourceSystem = dyc.getDynamicObject("sourcesystem");
        if (sourceSystem != null) {
            sonDyc.set("sourcesystem", (Object)sourceSystem.getLong("id"));
        }
        if ((industry = dyc.getDynamicObject("industrytype")) != null) {
            sonDyc.set("industrytype", (Object)industry.getLong("id"));
        }
    }

    private void fieldSetter(DynamicObject doc, DynamicObject sonDyc) {
        if (doc.getLong("id") != 0L) {
            sonDyc.set("modifier", (Object)RequestContext.get().getCurrUserId());
            sonDyc.set("modifytime", (Object)new Date());
            sonDyc.set("number", (Object)doc.getString("entrynumber"));
            sonDyc.set("group", (Object)doc.getDynamicObjectCollection("entrygroup"));
            sonDyc.set("bizsubarea", (Object)doc.getDynamicObjectCollection("entrybizsubarea"));
        } else {
            sonDyc.set("number", (Object)this.hasCodeRule(doc, sonDyc));
            sonDyc.set("creator", (Object)RequestContext.get().getCurrUserId());
            sonDyc.set("createtime", (Object)new Date());
            sonDyc.set("group", (Object)this.handleMulBasedata(doc, "entrygroup"));
            sonDyc.set("bizsubarea", (Object)this.handleMulBasedata(doc, "entrybizsubarea"));
        }
        sonDyc.set("name", (Object)doc.getLocaleString("entryname"));
        sonDyc.set("startdate", (Object)doc.getDate("entrystartdate"));
        sonDyc.set("enddate", (Object)doc.getDate("entryenddate"));
        sonDyc.set("planperson", (Object)doc.getDynamicObject("entryplanperson"));
        sonDyc.set("datarange", (Object)doc.getLocaleString("entrydatarange"));
    }

    private DynamicObjectCollection handleMulBasedata(DynamicObject doc, String mulBasedataField) {
        DynamicObjectType type = ((DynamicObject)doc.getDynamicObjectCollection(mulBasedataField).get(0)).getDynamicObjectType();
        MulBasedataDynamicObjectCollection dys = new MulBasedataDynamicObjectCollection();
        doc.getDynamicObjectCollection(mulBasedataField).forEach(dyc -> {
            DynamicObject dynamicObject = new DynamicObject(type);
            dynamicObject.set("fbasedataid", dyc.get(1));
            dys.add(dynamicObject);
        });
        return dys;
    }

    private String hasCodeRule(DynamicObject doc, DynamicObject sonDyc) {
        boolean isExist = CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)sonDyc, null);
        boolean isAddView = CodeRuleServiceHelper.isAddView((String)"hric_initplan", (DynamicObject)sonDyc, null);
        if (isExist && !isAddView) {
            return CodeRuleServiceHelper.getNumber((String)"hric_initplan", (DynamicObject)sonDyc, null);
        }
        return doc.getString("entrynumber");
    }
}

