/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.opplugin.web;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.ICooperativeDomainService;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.constants.msg.PlanMsgEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.opplugin.validator.InitPlanStartUpOpValidator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;

public class InitPlanStartUpOpPlugin
extends HRDataBaseOp {
    private static Log LOG = LogFactory.getLog(InitPlanStartUpOpPlugin.class);
    private String PLAN_CONFIG = ResManager.loadKDString((String)"\u8ba1\u5212\u914d\u7f6e", (String)"InitPlanStartUpOpPlugin_0", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String EXECUTE = ResManager.loadKDString((String)"\u6267\u884c", (String)"InitPlanStartUpOpPlugin_1", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String VERIFICATION = ResManager.loadKDString((String)"\u9a8c\u8bc1", (String)"InitPlanStartUpOpPlugin_2", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String MESSAGE_TITLE = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f85\u529e\u4efb\u52a1\u901a\u77e5\u3002", (String)"InitPlanStartUpOpPlugin_3", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_ONE = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u8ba1\u5212\u914d\u7f6e\u4efb\u52a1%2$s", (String)"InitPlanStartUpOpPlugin_4", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_TWO = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1%2$s", (String)"InitPlanStartUpOpPlugin_5", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_THREE = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u6570\u636e\u9a8c\u8bc1\u4efb\u52a1%2$s", (String)"InitPlanStartUpOpPlugin_6", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String MESSAGE_TAG = ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitPlanStartUpOpPlugin_7", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String TOBEGENERATE_TIP = ResManager.loadKDString((String)"\uff08\u5f85\u751f\u6210\uff09", (String)"InitPlanStartUpOpPlugin_8", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String EXCEPTION_TIP1 = ResManager.loadKDString((String)"%1$s[%2$s]\u4efb\u52a1\u6ca1\u6709\u5173\u8054\u5b9e\u65bd\u9879\uff0c\u8bf7\u4fee\u590d\u6570\u636e\u540e\u91cd\u65b0\u542f\u52a8\u3002", (String)"InitPlanStartUpOpPlugin_9", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private String EXCEPTION_TIP2 = ResManager.loadKDString((String)"\u8bf7\u4fee\u590d\u6570\u636e\u540e\u91cd\u65b0\u542f\u52a8\uff0c\u5f85\u751f\u6210\u4efb\u52a1\u201c%1$s\u201d\u7f3a\u5c11\u5173\u8054\u5b9e\u65bd\u9879\u3002", (String)"InitPlanStartUpOpPlugin_10", (String)"hrmp-hric-opplugin", (Object[])new Object[0]);
    private static final String QUERY_FIELDS = "id,planstatus,startuptime";
    private DynamicObject[] implItemInitTasks;
    private DynamicObject[] implItemPlanDys;
    private Set<Long> masterPlanStartedBizSubAreaIds = new HashSet<Long>();
    private Set<Long> curPlanBizsubareaIdSet = new HashSet<Long>();
    private List<DynamicObject> currInitTasks = new ArrayList<DynamicObject>();
    private Map<Long, DynamicObject> toBeGenerateInitTasks = new HashMap<Long, DynamicObject>();
    private List<DynamicObject> curMasterPlanToBeGenTaskList = new ArrayList<DynamicObject>();
    private List<String> taskNumbers = new ArrayList<String>();
    private List<Long> parentPlanIds = new ArrayList<Long>();
    private List<Long> needDelToBeGenTaskIds = new ArrayList<Long>();
    private List<Long> needDelPreTaskIds = new ArrayList<Long>();
    private List<DynamicObject> needUpdateTasks = new ArrayList<DynamicObject>();
    private DynamicObject firstPlan;
    private Set<Long> masterPlanBizSubAreaIds = new HashSet<Long>();
    private String masterPlanStructNumber;
    private Date curDate = new Date();
    private long curUserId = RequestContext.get().getCurrUserId();
    private Queue<Long> idQueue = new LinkedList<Long>();
    ICooperativeDomainService iSystemParamDomainService = (ICooperativeDomainService)ServiceFactory.getService(ICooperativeDomainService.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new InitPlanStartUpOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        long beginTime = System.currentTimeMillis();
        Object[] dys = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dys)) {
            return;
        }
        if (HRStringUtils.equals((String)e.getOperationKey(), (String)"startup")) {
            this.generateTask((DynamicObject)dys[0]);
        }
        long endTime = System.currentTimeMillis();
        LOG.info("[HRIC] Init plan start take up time\uff1a{}ms", (Object)(endTime - beginTime));
    }

    private void generateTask(DynamicObject dyc) {
        this.masterPlanStructNumber = (String)Splitter.on((String)"!").trimResults().splitToList((CharSequence)dyc.getString("structnumber")).get(0);
        this.firstPlan = InitPlanServiceHelper.getMasterPlanByStructNumber((String)this.masterPlanStructNumber);
        this.recordMasterPlanBizSubAreaIds();
        ArrayList<InitMessageInfo> messageInfos = new ArrayList<InitMessageInfo>();
        if (HRStringUtils.equals((String)dyc.getString("configmode"), (String)"A")) {
            this.generatePlanConfigTask(dyc, messageInfos);
        } else {
            this.generateItemExecuteTask(dyc);
            this.changeSubPanSplitTaskStatus(dyc);
            this.preInitTaskInit();
        }
        if (ObjectUtils.isEmpty(this.currInitTasks)) {
            return;
        }
        this.updatePlanStatus();
        InitTaskServiceHelper.batchDelTask(this.needDelToBeGenTaskIds);
        InitTaskServiceHelper.saveInitTasks((DynamicObject[])this.currInitTasks.toArray(new DynamicObject[this.currInitTasks.size()]));
        InitTaskServiceHelper.saveInitTasks((DynamicObject[])this.toBeGenerateInitTasks.values().toArray(new DynamicObject[this.toBeGenerateInitTasks.size()]));
        InitTaskServiceHelper.updateTaskInfo((DynamicObject[])this.needUpdateTasks.toArray(new DynamicObject[this.needUpdateTasks.size()]));
        this.buildMessageInfo(messageInfos);
        MessageSendServiceHelper.saveMessage(messageInfos);
        AsyncTaskServiceHelper.startJob();
    }

    private void buildMessageInfo(List<InitMessageInfo> messageInfos) {
        List ids = this.currInitTasks.stream().filter(task -> task.getDynamicObject("parent") == null).map(it -> it.getLong("id")).collect(Collectors.toList());
        DynamicObject[] taskList = InitTaskServiceHelper.getTaskList(ids);
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)this.currInitTasks.get(0).getLong("belongplan"));
        Arrays.stream(taskList).forEach(task -> {
            if (!HRStringUtils.equals((String)task.getString("tasktype"), (String)"A")) {
                ArrayList<Long> receivers = new ArrayList<Long>();
                receivers.add(task.getDynamicObject("taskleader").getLong("id"));
                DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
                InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_inittaskform").buildEntityId(Long.valueOf(task.getLong("id"))).buildContent(this.buildContent((DynamicObject)task, plan)).buildTitle(this.MESSAGE_TITLE).buildTag(this.MESSAGE_TAG).build();
                messageInfos.add(info);
            }
        });
    }

    private String buildContent(DynamicObject task, DynamicObject plan) {
        if (HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")) {
            return String.format(Locale.ROOT, this.MESSAGE_CONTENT_TWO, plan.getDynamicObject("planperson").getString("name"), task.getString("name"));
        }
        return String.format(Locale.ROOT, this.MESSAGE_CONTENT_THREE, plan.getDynamicObject("planperson").getString("name"), task.getString("name"));
    }

    private void changeSubPanSplitTaskStatus(DynamicObject dyc) {
        String number = dyc.getString("number");
        DynamicObject planTask = InitTaskServiceHelper.getPlanTaskByPlanNumber((String)number);
        if (ObjectUtils.isEmpty((Object)planTask)) {
            return;
        }
        planTask.set("taskstatus", (Object)"C");
        planTask.set("taskendtime", (Object)new Date());
        InitTaskServiceHelper.updateTaskInfo((DynamicObject[])new DynamicObject[]{planTask});
    }

    private void preInitTaskInit() {
        ArrayList taskTriple = new ArrayList();
        Map<Long, DynamicObject> initTastMap = this.currInitTasks.stream().filter(task -> HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")).filter(task -> task.getDynamicObject("parent") == null).collect(Collectors.toMap(task -> task.getLong("id"), task -> task, (k1, k2) -> k1));
        initTastMap.entrySet().stream().forEach(entry -> {
            DynamicObject implItem = ((DynamicObject)entry.getValue()).getDynamicObject("implitemrel");
            long implItemId = implItem.getLong("id");
            DynamicObjectCollection preImplItem = implItem.getDynamicObjectCollection("mulfrontimpl");
            if (!CollectionUtils.isEmpty((Collection)preImplItem)) {
                List preImplItemIds = preImplItem.stream().map(pre -> pre.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(pre -> pre.getLong("id")).collect(Collectors.toList());
                taskTriple.add(ImmutableTriple.of(entry.getKey(), (Object)implItemId, preImplItemIds));
            }
        });
        taskTriple.forEach(it -> {
            ArrayList<Long> preTaskIds = new ArrayList<Long>();
            ((List)it.getRight()).forEach(pre -> initTastMap.entrySet().stream().forEach(entry -> {
                Long currTaskId = (Long)entry.getKey();
                long currTaskImplItemId = ((DynamicObject)entry.getValue()).getDynamicObject("implitemrel").getLong("id");
                String taskType = ((DynamicObject)entry.getValue()).getString("tasktype");
                if (pre == currTaskImplItemId && HRStringUtils.equals((String)taskType, (String)"B")) {
                    preTaskIds.add(currTaskId);
                }
            }));
            if (!CollectionUtils.isEmpty(preTaskIds)) {
                DynamicObject dyc = (DynamicObject)initTastMap.get(it.getLeft());
                dyc.set("pretask", (Object)this.structPreTask(dyc, preTaskIds));
                dyc.set("taskstatus", (Object)"A");
                dyc.set("taskbegintime", null);
            }
        });
    }

    private DynamicObjectCollection structPreTask(DynamicObject initTask, List<Long> preTaskIds) {
        DynamicObjectCollection docs = initTask.getDynamicObjectCollection("pretask");
        preTaskIds.forEach(pre -> {
            DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
            dy.set("fbasedataid", pre);
            docs.add((Object)dy);
        });
        return docs;
    }

    private void updatePlanStatus() {
        Object[] dys = InitPlanServiceHelper.getPlanFields((String)QUERY_FIELDS, (String)"id", this.parentPlanIds);
        Arrays.stream(dys).forEach(dyc -> {
            dyc.set("planstatus", (Object)"B");
            dyc.set("startuptime", (Object)new Date());
        });
        Object[] docs = InitPlanServiceHelper.getPlanFields((String)QUERY_FIELDS, (String)"parent", this.parentPlanIds);
        Arrays.stream(docs).forEach(doc -> doc.set("planstatus", (Object)"A"));
        InitPlanServiceHelper.updateDynamicObjects((DynamicObject[])((DynamicObject[])ArrayUtils.addAll((Object[])dys, (Object[])docs)));
    }

    private void generateItemExecuteTask(DynamicObject dyc) {
        long curPlanId = dyc.getLong("id");
        this.parentPlanIds.add(curPlanId);
        this.taskNumbers = this.getCurStartPlanAllTaskNumbers(dyc);
        this.implItemInitTasks = this.getImplItemInitTasks();
        this.curMasterPlanToBeGenTaskList = InitTaskServiceHelper.getToBeGenerateInitTasks((Long)this.firstPlan.getLong("id"));
        this.getCurPlanBizsubareaIds(dyc);
        DynamicObjectCollection docs = dyc.getDynamicObjectCollection("itementryentity");
        long[] ids = ORM.create().genLongIds("hric_inittask", docs.size() * 3);
        Arrays.stream(ids).forEach(id -> this.idQueue.offer(id));
        boolean collaborationMode = this.iSystemParamDomainService.getParameterBoolean();
        docs.stream().filter(it -> !it.getBoolean("isskip")).forEach(doc -> {
            DynamicObjectCollection mulFrontImpls = doc.getDynamicObjectCollection("mulfrontimpl");
            DynamicObjectCollection preTasks = this.handlePreImplItem(mulFrontImpls, docs);
            DynamicObject execTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask"));
            execTask.set("id", (Object)this.getTaskId((DynamicObject)doc));
            this.structInitTask(dyc, (DynamicObject)doc, false, preTasks, execTask);
            this.handleSonTask(curPlanId, (DynamicObject)doc, execTask);
            this.currInitTasks.add(execTask);
            if (!collaborationMode) {
                return;
            }
            if (doc.getBoolean("isdataverify")) {
                DynamicObject verifyTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask"));
                verifyTask.set("id", (Object)this.idQueue.poll());
                this.structInitTask(dyc, (DynamicObject)doc, true, execTask, verifyTask);
                this.currInitTasks.add(verifyTask);
            }
        });
        this.judgeCurPlanIsContainsToBeGenTask();
        this.getNeedUpdateTask();
    }

    private void handleSonTask(Long planId, DynamicObject doc, DynamicObject parentTask) {
        String parentTaskNumber = parentTask.getString("number");
        DynamicObject implItem = doc.getDynamicObject("implitem");
        if (implItem == null) {
            LOG.info("[HRIC] The task:{} relation implItem is empty", (Object)parentTaskNumber);
            return;
        }
        String category = implItem.getString("category");
        if (HRStringUtils.equals((String)category, (String)"1")) {
            DynamicObjectCollection baseImplEntry = implItem.getDynamicObjectCollection("baseimplentry");
            Long taskleader = doc.getDynamicObject("executeperson").getLong("id");
            parentTask.set("haschildren", (Object)1);
            baseImplEntry.stream().forEach(baseImplItem -> {
                DynamicObject sonImplItem = baseImplItem.getDynamicObject("implitem");
                if (sonImplItem == null) {
                    LOG.info("[HRIC] The task:{} has sonTask relation implItem is empty", (Object)parentTaskNumber);
                    return;
                }
                DynamicObject sonTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask"));
                sonTask.set("number", (Object)(parentTaskNumber + "-" + (baseImplEntry.indexOf(baseImplItem) + 1)));
                sonTask.set("taskleader", (Object)taskleader);
                sonTask.set("belongplan", (Object)planId);
                sonTask.set("parent", (Object)parentTask);
                this.sonTaskValSetter(sonTask, sonImplItem);
                this.currInitTasks.add(sonTask);
            });
        }
    }

    private void sonTaskValSetter(DynamicObject sonTask, DynamicObject sonImplItem) {
        sonTask.set("id", (Object)this.idQueue.poll());
        sonTask.set("name", (Object)(sonImplItem.getLocaleString("name").getLocaleValue() + PlanMsgEnum.EXECUTE.get()));
        sonTask.set("taskaccepttime", (Object)this.curDate);
        sonTask.set("creator", (Object)this.curUserId);
        sonTask.set("createtime", (Object)this.curDate);
        sonTask.set("implitemrel", (Object)sonImplItem);
        sonTask.set("taskstatus", (Object)"B");
        sonTask.set("tasktype", (Object)"B");
    }

    private DynamicObject[] getImplItemInitTasks() {
        ArrayList implItemPlanIds = new ArrayList();
        this.implItemPlanDys = InitPlanServiceHelper.getImplItemPlanByStructNumber((String)this.masterPlanStructNumber);
        Arrays.stream(this.implItemPlanDys).forEach(dyc -> {
            implItemPlanIds.add(dyc.getLong("id"));
            DynamicObjectCollection docs = dyc.getDynamicObjectCollection("bizsubarea");
            docs.forEach(doc -> {
                DynamicObject bizSubArea = doc.getDynamicObject("fbasedataid");
                this.masterPlanStartedBizSubAreaIds.add(bizSubArea.getLong("id"));
            });
        });
        return InitTaskServiceHelper.getInitTaskByBelongPlanIds(implItemPlanIds);
    }

    private void judgeCurPlanIsContainsToBeGenTask() {
        if (CollectionUtils.isEmpty(this.curMasterPlanToBeGenTaskList)) {
            return;
        }
        this.curMasterPlanToBeGenTaskList.removeIf(task -> {
            DynamicObject implItemRel = task.getDynamicObject("implitemrel");
            if (ObjectUtils.isEmpty((Object)implItemRel)) {
                throw new KDHricException(String.format(Locale.ROOT, this.EXCEPTION_TIP2, task.getLocaleString("name").getLocaleValue()));
            }
            long bizSubAreaId = implItemRel.getDynamicObject("bizsubarea").getLong("id");
            if (this.curPlanBizsubareaIdSet.contains(bizSubAreaId)) {
                long toBeGenTaskId = task.getLong("id");
                this.needDelToBeGenTaskIds.add(toBeGenTaskId);
                this.needDelPreTaskIds.add(toBeGenTaskId);
                return true;
            }
            return false;
        });
    }

    private void getNeedUpdateTask() {
        Arrays.stream(this.implItemInitTasks).filter(task -> HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")).filter(task -> HRStringUtils.equals((String)task.getString("taskstatus"), (String)"A")).forEach(task -> {
            DynamicObjectCollection preTasks = task.getDynamicObjectCollection("pretask");
            Iterator iterator = preTasks.iterator();
            while (iterator.hasNext()) {
                DynamicObject preTask = ((DynamicObject)iterator.next()).getDynamicObject("fbasedataid");
                long preTaskId = preTask.getLong("id");
                if (!this.needDelPreTaskIds.contains(preTaskId)) continue;
                iterator.remove();
                this.needUpdateTasks.add((DynamicObject)task);
            }
            if (CollectionUtils.isEmpty((Collection)preTasks)) {
                task.set("taskstatus", (Object)"B");
                task.set("taskbegintime", (Object)this.curDate);
            }
        });
    }

    private Long getTaskId(DynamicObject doc) {
        long implItemId = doc.getDynamicObject("implitem").getLong("id");
        Iterator<DynamicObject> iterator = this.curMasterPlanToBeGenTaskList.iterator();
        while (iterator.hasNext()) {
            DynamicObject task = iterator.next();
            DynamicObject implItemRel = task.getDynamicObject("implitemrel");
            if (ObjectUtils.isEmpty((Object)implItemRel)) {
                throw new KDHricException(String.format(Locale.ROOT, this.EXCEPTION_TIP2, task.getLocaleString("name").getLocaleValue()));
            }
            if (implItemId != implItemRel.getLong("id")) continue;
            long taskId = task.getLong("id");
            this.needDelToBeGenTaskIds.add(taskId);
            iterator.remove();
            return taskId;
        }
        return this.idQueue.poll();
    }

    private List<String> getCurStartPlanAllTaskNumbers(DynamicObject dyc) {
        String parentNum = dyc.getString("number");
        DynamicObject[] dys = InitTaskServiceHelper.getTaskNumbersWithCurrPlan((String)parentNum);
        return Arrays.stream(dys).map(it -> it.getString("number")).collect(Collectors.toList());
    }

    private void getCurPlanBizsubareaIds(DynamicObject dyc) {
        DynamicObjectCollection dys = dyc.getDynamicObjectCollection("bizsubarea");
        dys.stream().map(it -> it.getDynamicObject("fbasedataid")).forEach(it -> this.curPlanBizsubareaIdSet.add(it.getLong("id")));
    }

    private DynamicObjectCollection handlePreImplItem(DynamicObjectCollection mulFrontImpls, DynamicObjectCollection docs) {
        if (CollectionUtils.isEmpty((Collection)mulFrontImpls)) {
            return new DynamicObjectCollection();
        }
        Map<Long, DynamicObject> mulFrontImplMap = mulFrontImpls.stream().map(it -> it.getDynamicObject("fbasedataid")).collect(Collectors.toMap(it -> it.getLong("id"), it -> it, (o1, o2) -> o1));
        Set curEntryImplItemIdSet = docs.stream().filter(it -> !it.getBoolean("isskip")).map(doc -> doc.getDynamicObject("implitem").getLong("id")).collect(Collectors.toSet());
        Map<Long, DynamicObject> implItemInitTaskIdMap = this.getImplItemInitTaskIdMap();
        Map<Long, DynamicObject> toBeGenTaskImplItemMap = this.getToBeGenTaskImplItemMap();
        DynamicObjectCollection preTasks = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask")).getDynamicObjectCollection("pretask");
        Set<Long> implItemIds = this.getOtherSonPlanEntityImplItemId();
        mulFrontImpls.stream().forEach(it -> {
            DynamicObject implItemDyc = it.getDynamicObject("fbasedataid");
            long implItemId = implItemDyc.getLong("id");
            long bizSubAreaId = implItemDyc.getDynamicObject("bizsubarea").getLong("id");
            if (curEntryImplItemIdSet.contains(implItemId)) {
                return;
            }
            DynamicObject preTask = new DynamicObject(preTasks.getDynamicObjectType());
            if (implItemInitTaskIdMap.containsKey(implItemId)) {
                preTask.set("fbasedataid", implItemInitTaskIdMap.get(implItemId));
                preTasks.add((Object)preTask);
                return;
            }
            if (toBeGenTaskImplItemMap.containsKey(implItemId)) {
                preTask.set("fbasedataid", toBeGenTaskImplItemMap.get(implItemId));
                preTasks.add((Object)preTask);
                return;
            }
            if (this.curPlanBizsubareaIdSet.contains(bizSubAreaId) && !curEntryImplItemIdSet.contains(implItemId)) {
                return;
            }
            if (this.masterPlanBizSubAreaIds.contains(bizSubAreaId) && this.masterPlanStartedBizSubAreaIds.contains(bizSubAreaId) && !implItemIds.contains(implItemId)) {
                return;
            }
            if (this.toBeGenerateInitTasks.containsKey(implItemId)) {
                preTask.set("fbasedataid", (Object)this.toBeGenerateInitTasks.get(implItemId));
                preTasks.add((Object)preTask);
                return;
            }
            DynamicObject initTask = this.toBeGenerateInitTask((DynamicObject)mulFrontImplMap.get(implItemId));
            this.toBeGenerateInitTasks.put(implItemId, initTask);
            preTask.set("fbasedataid", (Object)initTask);
            preTasks.add((Object)preTask);
        });
        return preTasks;
    }

    private void recordMasterPlanBizSubAreaIds() {
        DynamicObjectCollection dys = this.firstPlan.getDynamicObjectCollection("bizsubarea");
        dys.forEach(dyc -> this.masterPlanBizSubAreaIds.add(dyc.getDynamicObject("fbasedataid").getLong("id")));
    }

    private Set<Long> getOtherSonPlanEntityImplItemId() {
        if (ObjectUtils.isEmpty((Object[])this.implItemPlanDys)) {
            return new HashSet<Long>();
        }
        HashSet<Long> implItemIds = new HashSet<Long>();
        Arrays.stream(this.implItemPlanDys).forEach(it -> {
            DynamicObjectCollection docs = it.getDynamicObjectCollection("itementryentity");
            docs.stream().filter(doc -> !doc.getBoolean("isskip")).forEach(doc -> {
                long implItemId = doc.getDynamicObject("implitem").getLong("id");
                implItemIds.add(implItemId);
            });
        });
        return implItemIds;
    }

    private Map<Long, DynamicObject> getImplItemInitTaskIdMap() {
        return Arrays.stream(this.implItemInitTasks).filter(task -> HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")).collect(Collectors.toMap(it -> {
            DynamicObject dyc = it.getDynamicObject("implitemrel");
            if (dyc == null) {
                throw new KDHricException(String.format(Locale.ROOT, this.EXCEPTION_TIP1, it.getLocaleString("name").getLocaleValue(), it.getString("number")));
            }
            return dyc.getLong("id");
        }, it -> it));
    }

    private Map<Long, DynamicObject> getToBeGenTaskImplItemMap() {
        if (CollectionUtils.isEmpty(this.curMasterPlanToBeGenTaskList)) {
            return new HashMap<Long, DynamicObject>();
        }
        return this.curMasterPlanToBeGenTaskList.stream().collect(Collectors.toMap(it -> {
            DynamicObject dyc = it.getDynamicObject("implitemrel");
            if (dyc == null) {
                throw new KDHricException(String.format(Locale.ROOT, this.EXCEPTION_TIP2, it.getLocaleString("name").getLocaleValue(), it.getString("number")));
            }
            return dyc.getLong("id");
        }, it -> it));
    }

    private DynamicObject toBeGenerateInitTask(DynamicObject currImplItem) {
        DynamicObject initTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask"));
        long taskId = ORM.create().genLongId("hric_inittask");
        initTask.set("id", (Object)taskId);
        initTask.set("number", (Object)(taskId + ""));
        initTask.set("name", (Object)(currImplItem.getLocaleString("name").getLocaleValue() + this.TOBEGENERATE_TIP));
        initTask.set("belongplan", (Object)this.firstPlan.getLong("id"));
        initTask.set("implitemrel", (Object)currImplItem);
        initTask.set("taskstatus", (Object)"Z");
        return initTask;
    }

    private void structInitTask(DynamicObject dyc, DynamicObject doc, boolean isDataVerify, Object execOrPreTask, DynamicObject initTask) {
        initTask.set("belongplan", (Object)dyc.getLong("id"));
        initTask.set("taskaccepttime", (Object)this.curDate);
        initTask.set("creator", (Object)this.curUserId);
        initTask.set("createtime", (Object)this.curDate);
        initTask.set("implitemrel", (Object)doc.getDynamicObject("implitem"));
        initTask.set("listseq", (Object)doc.getDynamicObject("implitem").getInt("listseq"));
        String parentNum = dyc.getString("number");
        if (isDataVerify) {
            initTask.set("number", (Object)this.getTaskNumber(parentNum + "-Y"));
            initTask.set("tasktype", (Object)"C");
            initTask.set("name", (Object)(doc.getLocaleString("itemname").getLocaleValue() + this.VERIFICATION));
            initTask.set("taskleader", (Object)doc.getDynamicObject("verifyperson").getLong("id"));
            initTask.set("taskstatus", (Object)"A");
            this.structPreTask((DynamicObject)execOrPreTask, initTask);
            return;
        }
        initTask.set("number", (Object)this.getTaskNumber(parentNum + "-Z"));
        initTask.set("tasktype", (Object)"B");
        initTask.set("name", (Object)(doc.getLocaleString("itemname").getLocaleValue() + this.EXECUTE));
        initTask.set("taskleader", (Object)doc.getDynamicObject("executeperson").getLong("id"));
        if (CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)execOrPreTask))) {
            this.taskLableAssignment(initTask, "B", this.curDate, null);
        } else {
            this.structPreTaskWithPreImplItemIsNotNull((DynamicObjectCollection)execOrPreTask, initTask);
        }
    }

    private void structPreTaskWithPreImplItemIsNotNull(DynamicObjectCollection dys, DynamicObject initTask) {
        long notFinishTaskCount = dys.stream().map(dyc -> dyc.getDynamicObject("fbasedataid")).map(dyc -> dyc.getString("taskstatus")).filter(taskStatus -> HRStringUtils.equals((String)taskStatus, (String)"Z") || !HRStringUtils.equals((String)taskStatus, (String)"C")).count();
        if (notFinishTaskCount > 0L) {
            this.taskLableAssignment(initTask, "A", null, dys);
        } else {
            this.taskLableAssignment(initTask, "B", this.curDate, dys);
        }
    }

    private void structPreTask(DynamicObject executeTask, DynamicObject initTask) {
        DynamicObjectCollection docs = initTask.getDynamicObjectCollection("pretask");
        DynamicObject dy = new DynamicObject(docs.getDynamicObjectType());
        dy.set("fbasedataid", (Object)executeTask);
        docs.add((Object)dy);
        initTask.set("pretask", (Object)docs);
    }

    private void taskLableAssignment(DynamicObject initTask, String status, Date curData, DynamicObjectCollection dys) {
        initTask.set("taskstatus", (Object)status);
        initTask.set("taskbegintime", (Object)curData);
        initTask.set("pretask", (Object)dys);
    }

    private String getTaskNumber(String taskNumberPrefix) {
        long numSize = this.taskNumbers.stream().filter(num -> num.startsWith(taskNumberPrefix)).count();
        String taskNumber = numSize == 0L ? taskNumberPrefix + "0001" : taskNumberPrefix + String.format(Locale.ROOT, "%04d", numSize + 1L);
        this.taskNumbers.add(taskNumber);
        return taskNumber;
    }

    private void generatePlanConfigTask(DynamicObject dyc, List<InitMessageInfo> messageInfos) {
        long pkId = dyc.getLong("id");
        this.checkCurrPlanIsExist(pkId);
        this.parentPlanIds.add(pkId);
        DynamicObject[] subPlans = InitPlanServiceHelper.getInitPlansById((Long)pkId);
        ORM orm = ORM.create();
        Arrays.stream(subPlans).forEach(doc -> {
            DynamicObject initTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_inittask"));
            initTask.set("id", (Object)orm.genLongId("hric_inittask"));
            initTask.set("number", (Object)doc.getString("number"));
            initTask.set("name", (Object)(doc.getLocaleString("name").getLocaleValue() + this.PLAN_CONFIG));
            initTask.set("tasktype", (Object)"A");
            initTask.set("taskstatus", (Object)"B");
            initTask.set("belongplan", (Object)doc.getLong("id"));
            initTask.set("taskaccepttime", (Object)this.curDate);
            initTask.set("taskbegintime", (Object)this.curDate);
            initTask.set("taskleader", (Object)doc.getDynamicObject("planperson").getLong("id"));
            initTask.set("creator", (Object)this.curUserId);
            initTask.set("createtime", (Object)this.curDate);
            initTask.set("listseq", (Object)-1);
            this.currInitTasks.add(initTask);
            messageInfos.add(this.assembleInitMessageInfo(dyc, (DynamicObject)doc, initTask));
        });
    }

    private InitMessageInfo assembleInitMessageInfo(DynamicObject dyc, DynamicObject doc, DynamicObject initTask) {
        ArrayList<Long> receivers = new ArrayList<Long>();
        ArrayList<String> phone = new ArrayList<String>();
        receivers.add(initTask.getLong("taskleader"));
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
        phone.add(UserServiceHelper.getCurrentUser((String)"phone").getString("phone"));
        InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_initplan").buildEntityId(Long.valueOf(doc.getLong("id"))).buildContent(String.format(Locale.ROOT, this.MESSAGE_CONTENT_ONE, dyc.getDynamicObject("planperson").getString("name"), initTask.getString("name"))).buildTitle(this.MESSAGE_TITLE).buildTag(this.MESSAGE_TAG).buildPhone(phone).build();
        return info;
    }

    private void checkCurrPlanIsExist(long pkId) {
        Object[] subPlanTasks = InitTaskServiceHelper.getSubPlanTask((long)pkId);
        if (ObjectUtils.isEmpty((Object[])subPlanTasks)) {
            return;
        }
        Arrays.stream(subPlanTasks).forEach(doc -> {
            doc.set("taskstatus", (Object)"C");
            doc.set("taskendtime", (Object)this.curDate);
        });
        InitTaskServiceHelper.updateTaskInfo((DynamicObject[])subPlanTasks);
    }
}

