/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.BizSubAreaServiceHelper;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;
import kd.hrmp.hric.bussiness.service.InitDataStatisticsServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.common.ColorEnum;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.formplugin.web.ChartCommonEditPlugin;

public class AppHomeBizAreaTabPlugin
extends ChartCommonEditPlugin
implements BeforeF7SelectListener {
    private Map<String, String> INITLONG_MAP = new HashMap<String, String>(){
        {
            this.put("A", ResManager.loadKDString((String)"\u65e0\u521d\u59cb\u5316\u8bb0\u5f55", (String)"AppHomeBizAreaTabPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("B", ResManager.loadKDString((String)"\u6709\u521d\u59cb\u5316\u8bb0\u5f55", (String)"AppHomeBizAreaTabPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
    };

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnbizarea"});
        BasedataEdit bizAreaEdit = (BasedataEdit)this.getView().getControl("bizarea");
        bizAreaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizSubAreaEdit = (BasedataEdit)this.getView().getControl("bizsubarea");
        bizSubAreaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Tab tab = (Tab)this.getView().getControl("tabap1");
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)"btnbizarea") && CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)this.getModel().getValue("bizsubarea"))) && !HRStringUtils.equals((String)tab.getCurrentTab(), (String)"tabbizarea")) {
            this.setBizSubAreaIds();
        }
    }

    private void setBizSubAreaIds() {
        DynamicObject[] bizSubAreas = BizSubAreaServiceHelper.getAppScope();
        List bizSubAreaIdList = Arrays.stream(bizSubAreas).map(it -> it.getLong("id")).collect(Collectors.toList());
        List bizAreaIdList = Arrays.stream(bizSubAreas).filter(it -> null != it.getDynamicObject("group")).map(it -> it.getDynamicObject("group").getLong("id")).distinct().collect(Collectors.toList());
        this.getModel().setValue("bizsubarea", (Object)bizSubAreaIdList.toArray());
        this.getModel().setValue("bizarea", (Object)bizAreaIdList.toArray());
    }

    private void setDataLabel(Set<Long> idSet) {
        Object[] implDynArray = ImplItemListDaoHelper.getAvailableAndDisableImplByBizSubArea(idSet);
        long availableCount = Arrays.asList(implDynArray).stream().filter(it -> HRStringUtils.equals((String)it.getString("enable"), (String)"1")).count();
        long disableCount = Arrays.asList(implDynArray).stream().filter(it -> HRStringUtils.equals((String)it.getString("enable"), (String)"0")).count();
        ((Label)this.getView().getControl("enableimpl")).setText(ConvertUtils.toString((Object)availableCount));
        ((Label)this.getView().getControl("disableimpl")).setText(ConvertUtils.toString((Object)disableCount));
        Object[] plans = InitPlanServiceHelper.getPlanByBizArea((String)Joiner.on((String)",").join(idSet));
        Date nowDate = new Date();
        long beyondCount = Arrays.stream(plans).filter(it -> HRStringUtils.equals((String)it.getString("planstatus"), (String)"B") && null != it.getDate("enddate") && nowDate.compareTo(it.getDate("enddate")) >= 0).count();
        ((Label)this.getView().getControl("beyondplan")).setText(ConvertUtils.toString((Object)beyondCount));
        ((Label)this.getView().getControl("bizpiecharlabel1")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u8ba1\u5212\u5171%1$s\u4e2a", (String)"AppHomeBizAreaTabPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), Arrays.stream(plans).filter(it -> !HRStringUtils.equals((String)it.getString("planstatus"), (String)"E")).count()));
        Object[] tasks = InitTaskServiceHelper.getTaskCountByImplItems(Arrays.asList(implDynArray).stream().map(it -> it.getLong("id")).collect(Collectors.toList()));
        List<DynamicObject> parentTaskList = Arrays.asList(tasks).stream().filter(it -> it.get("parent") == null).collect(Collectors.toList());
        long taskCount = Arrays.asList(tasks).stream().filter(it -> !HRStringUtils.equals((String)it.getString("taskstatus"), (String)"C") && it.get("parent") == null).count();
        ((Label)this.getView().getControl("todotask")).setText(ConvertUtils.toString((Object)taskCount));
        ((Label)this.getView().getControl("bizpiecharlabel2")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1\u5171%1$s\u4e2a", (String)"AppHomeBizAreaTabPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), parentTaskList.size()));
        if (!HRArrayUtils.isEmpty((Object[])plans)) {
            this.setPieCHart("bizpiechar1", ResManager.loadKDString((String)"\u5173\u8054\u8ba1\u5212\u7edf\u8ba1", (String)"AppHomeBizAreaTabPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getSeriesData((DynamicObject[])plans, this.PLAN_STATUS_MAP, "planstatus"));
        }
        if (!HRArrayUtils.isEmpty((Object[])tasks)) {
            this.setPieCHart("bizpiechar2", ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1\u7edf\u8ba1", (String)"AppHomeBizAreaTabPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getSeriesData(parentTaskList.toArray(new DynamicObject[0]), this.TASK_STATUS_MAP, "taskstatus"));
        }
        if (!HRArrayUtils.isEmpty((Object[])implDynArray)) {
            ItemValue[] item = this.getSeriesData((DynamicObject[])implDynArray, this.INITLONG_MAP, "isinitlog");
            this.setPieCHart("bizpiechar3", ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8986\u76d6\u7387", (String)"AppHomeBizAreaTabPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), item);
            ((Label)this.getView().getControl("bizpiecharlabel3")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8986\u76d6\u7387%1$s", (String)"AppHomeBizAreaTabPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getImplItemData(item)));
        }
        this.setCustomChartForTaskCost((DynamicObject[])tasks);
        this.getView().updateView("entitycustomchart");
        this.getView().updateView("flexpanelap31");
    }

    private void setCustomChartForTaskCost(DynamicObject[] tasks) {
        DynamicObject[] taskCosts = InitDataStatisticsServiceHelper.getByTaskIds(Arrays.stream(tasks).map(it -> it.getLong("id")).collect(Collectors.toList()));
        LinkedHashMap<String, Map<String, Object>> entityMap = new LinkedHashMap<String, Map<String, Object>>();
        Arrays.asList(taskCosts).stream().filter(it -> null != it.getDynamicObject("entityobjscope")).forEach(it -> {
            if (entityMap.containsKey(it.getDynamicObject("entityobjscope").getString("number"))) {
                Map data = (Map)entityMap.get(it.getDynamicObject("entityobjscope").getString("number"));
                data.put("amount", (Long)data.get("amount") + it.getLong("amount"));
                data.put("businesschecktime", it.getBigDecimal("businesschecktime").add((BigDecimal)data.get("businesschecktime")).divide(BigDecimal.ONE, 2, 4));
                data.put("synchronizedatatime", it.getBigDecimal("synchronizedatatime").add((BigDecimal)data.get("synchronizedatatime")).divide(BigDecimal.ONE, 2, 4));
                data.put("unitdatatime", (Long)data.get("amount") == 0L ? new BigDecimal(0L) : ((BigDecimal)data.get("synchronizedatatime")).add((BigDecimal)data.get("businesschecktime")).divide(new BigDecimal((Long)data.get("amount")), 4, 4).multiply(new BigDecimal(10000)));
            } else {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("amount", it.getLong("amount"));
                data.put("businesschecktime", it.getBigDecimal("businesschecktime").divide(BigDecimal.ONE, 2, 4));
                data.put("synchronizedatatime", it.getBigDecimal("synchronizedatatime").divide(BigDecimal.ONE, 2, 4));
                data.put("unitdatatime", it.getLong("amount") == 0L ? new BigDecimal(0L) : it.getBigDecimal("synchronizedatatime").add(it.getBigDecimal("businesschecktime")).divide(new BigDecimal(it.getLong("amount")), 4, 4).multiply(new BigDecimal(10000)));
                data.put("name", it.getDynamicObject("entityobjscope").getString("name"));
                entityMap.put(it.getDynamicObject("entityobjscope").getString("number"), data);
            }
        });
        this.setCustomChartForTaskCost("entitycustomchart", entityMap);
    }

    private String getImplItemData(ItemValue[] item) {
        long initCount = ConvertUtils.toLong((Object)Arrays.asList(item).stream().filter(it -> HRStringUtils.equals((String)it.getColor(), (String)ColorEnum.IN_EXECUTION.getColor())).findFirst().get().getValue());
        long noInitCount = ConvertUtils.toLong((Object)Arrays.asList(item).stream().filter(it -> HRStringUtils.equals((String)it.getColor(), (String)ColorEnum.TO_BE_CONFIGURED.getColor())).findFirst().get().getValue());
        DecimalFormat format = new DecimalFormat("0.00%");
        if (initCount + noInitCount == 0L) {
            return "0.00%";
        }
        return format.format(new BigDecimal(initCount).divide(new BigDecimal(initCount + noInitCount), 4, 4));
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"bizsubarea")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection dyc = (DynamicObjectCollection)this.getModel().getValue("bizarea");
            HashSet ids = new HashSet();
            dyc.stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).forEach(gro -> ids.add((Long)gro.get("id")));
            showParameter.getListFilterParameter().setFilter(new QFilter("group", "in", ids));
        } else if (HRStringUtils.equals((String)sourceName, (String)"bizarea")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bizarea"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"bizarea") && null != (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) {
            this.getModel().setValue("bizsubarea", null);
            this.getModel().setValue("bizarea", (Object)returnData.stream().map(it -> it.getPrimaryKeyValue()).collect(Collectors.toList()).toArray());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName;
        switch (changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElseGet(() -> "")) {
            case "bizsubarea": {
                DynamicObjectCollection dyc = (DynamicObjectCollection)this.getModel().getValue("bizsubarea");
                HashSet<Long> ids = new HashSet<Long>();
                if (!CollectionUtils.isEmpty((Collection)dyc)) {
                    dyc.stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).forEach(gro -> ids.add((Long)gro.get("id")));
                    this.setDataLabel(ids);
                    break;
                }
                this.resetBizAreaShow();
                break;
            }
            case "bizarea": {
                DynamicObjectCollection bizSubList = (DynamicObjectCollection)this.getModel().getValue("bizarea");
                if (!CollectionUtils.isEmpty((Collection)bizSubList)) break;
                this.getModel().setValue("bizsubarea", null);
            }
        }
    }

    private void resetBizAreaShow() {
        ((Label)this.getView().getControl("enableimpl")).setText("0");
        ((Label)this.getView().getControl("disableimpl")).setText("0");
        ((Label)this.getView().getControl("beyondplan")).setText("0");
        ((Label)this.getView().getControl("todotask")).setText("0");
        ((Label)this.getView().getControl("bizpiecharlabel1")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u8ba1\u5212\u5171%1$s\u4e2a", (String)"AppHomeBizAreaTabPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), "0"));
        ((Label)this.getView().getControl("bizpiecharlabel2")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5173\u8054\u4efb\u52a1\u5171%1$s\u4e2a", (String)"AppHomeBizAreaTabPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), "0"));
        ((Label)this.getView().getControl("bizpiecharlabel3")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8986\u76d6\u7387%1$s", (String)"AppHomeBizAreaTabPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), "0"));
        this.getView().updateView("tabbizarea");
    }
}

