/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitDataStatisticsServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskCountServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.common.ColorEnum;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.DateUtils;
import kd.hrmp.hric.formplugin.web.ChartCommonEditPlugin;

public class AppHomePlanTabPlugin
extends ChartCommonEditPlugin
implements BeforeF7SelectListener {
    private String TITLE_ONE = ResManager.loadKDString((String)"\u5bfc\u5165\u6b21\u6570", (String)"AppHomePlanTabPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_TWO = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\u6b21\u6570\uff08\u5168\u90e8\u6210\u529f\uff09", (String)"AppHomePlanTabPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_THREE = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c\u6b21\u6570\uff08\u5b58\u5728\u5931\u8d25\uff09", (String)"AppHomePlanTabPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_FOUR = ResManager.loadKDString((String)"\u4e1a\u52a1\u6821\u9a8c\u5168\u90e8\u6210\u529f", (String)"AppHomePlanTabPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_FIVE = ResManager.loadKDString((String)"\u4e1a\u52a1\u6821\u9a8c\u6b21\u6570(\u6709\u5931\u8d25)", (String)"AppHomePlanTabPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_SIX = ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5168\u90e8\u6210\u529f", (String)"AppHomePlanTabPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_SEVEN = ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u6b21\u6570(\u6709\u5931\u8d25)", (String)"AppHomePlanTabPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TITLE_EIGHT = ResManager.loadKDString((String)"\u56de\u6eda\u6b21\u6570", (String)"AppHomePlanTabPlugin_11", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String UNIT = ResManager.loadKDString((String)"\u6b21", (String)"AppHomePlanTabPlugin_15", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btninitplan"});
        BasedataEdit initPlan = (BasedataEdit)this.getView().getControl("initplan");
        initPlan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)"btninitplan") && null == this.getModel().getValue("initplan")) {
            this.showPlanF7();
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"predictdayslabel", "costlabel"});
        }
    }

    private void showPlanF7() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hric_initplan");
        showParameter.setFormId(FormMetadataCache.getListFormConfig((String)"hric_initplan").getF7ListFormId());
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        css.setWidth("900px");
        css.setHeight("600px");
        style.setInlineStyleCss(css);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btninitplan"));
        showParameter.setOpenStyle(style);
        showParameter.setShowTitle(false);
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(false);
        showParameter.setAppId("hric");
        showParameter.setHasRight(true);
        showParameter.setF7ClickByFilter(true);
        showParameter.setShowUsed(false);
        showParameter.setCustomParam("filterplanstatus", (Object)"A");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"btninitplan")) {
            if (closedCallBackEvent.getReturnData() == null) {
                this.resetPlanShow();
                return;
            }
            ListSelectedRow userRow = ((ListSelectedRowCollection)closedCallBackEvent.getReturnData()).get(0);
            this.getModel().setValue("initplan", userRow.getPrimaryKeyValue());
            this.getView().updateView("initplan");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElseGet(() -> "");
        if (HRStringUtils.equals((String)changeFieldName, (String)"initplan")) {
            Object dyc = this.getModel().getValue("initplan");
            if (!HRObjectUtils.isEmpty((Object)dyc)) {
                this.setDataLabel(((DynamicObject)dyc).getLong("id"));
            } else {
                this.resetPlanShow();
            }
        }
    }

    private void setDataLabel(Long planId) {
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)planId);
        long bizAreaCount = InitPlanServiceHelper.getBizAreaCountByPlanId((Long)planId);
        ((Label)this.getView().getControl("bizarealabel")).setText(ConvertUtils.toString((Object)bizAreaCount));
        long bizSubCount = InitPlanServiceHelper.getBizSubAreaCountByPlanId((Long)planId);
        ((Label)this.getView().getControl("bizsubarealabel")).setText(ConvertUtils.toString((Object)bizSubCount));
        if (null == plan.getDate("startdate") || null == plan.getDate("enddate")) {
            ((Label)this.getView().getControl("predictdayslabel")).setText("-");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"predictdayslabel2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"predictdayslabel"});
        } else {
            long subDay = DateUtils.getSubDay((Date)plan.getDate("startdate"), (Date)plan.getDate("enddate"));
            ((Label)this.getView().getControl("predictdayslabel")).setText(ConvertUtils.toString((Object)(subDay + 1L)));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"predictdayslabel2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"predictdayslabel"});
        }
        if (null == plan.getDate("actualenddate") || null == plan.getDate("startuptime")) {
            ((Label)this.getView().getControl("costlabel")).setText("-");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"costlabel2"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costlabel"});
        } else {
            BigDecimal subHours = new BigDecimal(plan.getDate("actualenddate").getTime() - plan.getDate("startuptime").getTime()).divide(new BigDecimal(3600000), 0, 4);
            ((Label)this.getView().getControl("costlabel")).setText(ConvertUtils.toString((Object)subHours));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costlabel2"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"costlabel"});
        }
        DynamicObject[] plans = InitPlanServiceHelper.getInitPlansByStructNumber((String)plan.getString("structnumber"));
        DynamicObject[] tasks = InitTaskServiceHelper.getExecAndVerifyTaskByPlanIds((String)"taskstatus,tasktype,implitemrel,parent", Arrays.stream(plans).map(it -> it.getLong("id")).collect(Collectors.toList()));
        List execTasks = Arrays.stream(tasks).filter(it -> !HRObjectUtils.isEmpty((Object)it.getDynamicObject("implitemrel"))).filter(it -> HRStringUtils.equals((String)it.getString("tasktype"), (String)"B")).collect(Collectors.toList());
        List<DynamicObject> parentExecTaskList = execTasks.stream().filter(it -> it.get("parent") == null).collect(Collectors.toList());
        List<DynamicObject> parentTaskList = Arrays.asList(tasks).stream().filter(it -> it.get("parent") == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(parentExecTaskList)) {
            this.setPieCHart("implpiechart", ResManager.loadKDString((String)"\u201c\u5b9e\u65bd\u9879\u7edf\u8ba1\u201d\u73b0\u5df2\u5173\u8054\u3002", (String)"AppHomePlanTabPlugin_12", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getSeriesDataForImpl(parentExecTaskList));
        }
        ((Label)this.getView().getControl("labelimplchart")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b9e\u65bd\u9879\u5171%1$s\u4e2a", (String)"AppHomePlanTabPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), parentExecTaskList.size()));
        if (CollectionUtils.isNotEmpty(parentTaskList)) {
            this.setPieCHart("taskpiechart", ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u7edf\u8ba1\u6570\u636e\u3002", (String)"AppHomePlanTabPlugin_13", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getSeriesData(parentTaskList.toArray(new DynamicObject[parentTaskList.size()]), this.TASK_STATUS_MAP, "taskstatus"));
        }
        ((Label)this.getView().getControl("labeltaskchart")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u5171%1$s\u4e2a", (String)"AppHomePlanTabPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), parentTaskList.size()));
        this.getView().updateView("flexpanelap3");
        List<DynamicObject> initTasks = execTasks.stream().filter(it -> HRStringUtils.equals((String)it.getDynamicObject("implitemrel").getString("initfordatasource"), (String)"A")).collect(Collectors.toList());
        this.setCustomChartForTaskCost(initTasks);
        this.getView().updateView("taskcustomchartap");
        this.setCustomChartForTaskCount(initTasks);
        this.getView().updateView("taskcountchart");
    }

    private void setCustomChartForTaskCount(List<DynamicObject> tasks) {
        DynamicObject[] taskOpCounts = InitTaskCountServiceHelper.getByTaskIds(tasks.stream().map(it -> it.getLong("id")).collect(Collectors.toList()));
        CustomChart customChart = (CustomChart)this.getView().getControl("taskcountchart");
        ArrayList<Number> introduce = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> initCheckSucc = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> initCheckFail = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> bizChechSucc = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> bizChechFail = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> syncCheckSucc = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> syncCheckFail = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> rollBack = new ArrayList<Number>(AppConstants.LIST_SIZE);
        Arrays.stream(taskOpCounts).forEach(it -> {
            introduce.add(it.getLong("introductioncount"));
            initCheckSucc.add(it.getLong("initchecksucccount"));
            initCheckFail.add(it.getLong("initcheckfailcount"));
            bizChechSucc.add(it.getLong("bizchecksucccount"));
            bizChechFail.add(it.getLong("bizcheckfailcount"));
            syncCheckSucc.add(it.getLong("syncdatasucccount"));
            syncCheckFail.add(it.getLong("syncdatafailcount"));
            rollBack.add(it.getLong("rollbackcount"));
        });
        Axis a1x = customChart.createXAxis("", AxisType.category);
        a1x.setCategorys(Arrays.asList(taskOpCounts).stream().map(it -> it.getDynamicObject("inittaskid").getString("name")).collect(Collectors.toList()));
        HashMap<String, String> axisPointerX = new HashMap<String, String>();
        axisPointerX.put("type", "shadow");
        a1x.setPropValue("axisPointer", axisPointerX);
        Axis countAxis = customChart.createYAxis(ResManager.loadKDString((String)"\u6b21\u6570", (String)"AppHomePlanTabPlugin_14", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), AxisType.value);
        countAxis.setPosition(Position.left);
        countAxis.setPropValue("alignTicks", (Object)true);
        countAxis.setPropValue("axisLine", this.getAxisLineMap("#40A9FF"));
        countAxis.setPropValue("yAxisIndex", (Object)0);
        this.setYData(this.TITLE_ONE, introduce, customChart, "1", "#40A9FF", 0);
        this.setYData(this.TITLE_TWO, initCheckSucc, customChart, "2", "#45DAD1", 0);
        this.setYData(this.TITLE_THREE, initCheckFail, customChart, "2", "#F57582", 0);
        this.setYData(this.TITLE_FOUR, bizChechSucc, customChart, "3", "#73D13D", 0);
        this.setYData(this.TITLE_FIVE, bizChechFail, customChart, "3", "#F273B5", 0);
        this.setYData(this.TITLE_SIX, syncCheckSucc, customChart, "4", "#FBC53D", 0);
        this.setYData(this.TITLE_SEVEN, syncCheckFail, customChart, "4", "#F9752A", 0);
        this.setYData(this.TITLE_EIGHT, rollBack, customChart, "5", "#6682F5", 0);
        this.setCustomStyle(customChart);
        ArrayList titleList = Lists.newArrayList((Object[])new String[]{this.TITLE_ONE, this.TITLE_TWO, this.TITLE_THREE, this.TITLE_FOUR, this.TITLE_FIVE, this.TITLE_SIX, this.TITLE_SEVEN, this.TITLE_EIGHT});
        ArrayList colorList = Lists.newArrayList((Object[])new String[]{"#40A9FF", "#45DAD1", "#F57582", "#73D13D", "#F273B5", "#FBC53D", "#F9752A", "#6682F5"});
        customChart.addTooltip("formatter", (Object)this.getFormatter(titleList, colorList, null, this.UNIT));
    }

    private void setCustomChartForTaskCost(List<DynamicObject> tasks) {
        DynamicObject[] taskCosts = InitDataStatisticsServiceHelper.getByTaskIds(tasks.stream().map(it -> it.getLong("id")).collect(Collectors.toList()));
        LinkedHashMap<String, Map<String, Object>> entityMap = new LinkedHashMap<String, Map<String, Object>>();
        Arrays.asList(taskCosts).forEach(it -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("name", it.getDynamicObject("inittaskid").getString("name"));
            data.put("amount", it.getLong("amount"));
            data.put("businesschecktime", it.getBigDecimal("businesschecktime").divide(BigDecimal.ONE, 2, 4));
            data.put("synchronizedatatime", it.getBigDecimal("synchronizedatatime").divide(BigDecimal.ONE, 2, 4));
            data.put("unitdatatime", it.getLong("amount") == 0L ? new BigDecimal(0L) : it.getBigDecimal("synchronizedatatime").add(it.getBigDecimal("businesschecktime")).divide(new BigDecimal(it.getLong("amount")), 4, 4).multiply(new BigDecimal(10000)));
            entityMap.put(ConvertUtils.toString((Object)it.getDynamicObject("inittaskid").getLong("id")), data);
        });
        this.setCustomChartForTaskCost("taskcustomchartap", entityMap);
    }

    private ItemValue[] getSeriesDataForImpl(List<DynamicObject> execTasks) {
        long initCount = execTasks.stream().filter(it -> HRStringUtils.equals((String)it.getDynamicObject("implitemrel").getString("initfordatasource"), (String)"A")).count();
        long handCount = execTasks.stream().filter(it -> HRStringUtils.equals((String)it.getDynamicObject("implitemrel").getString("initfordatasource"), (String)"C")).count();
        ArrayList<ItemValue> itemLists = new ArrayList<ItemValue>();
        itemLists.add(new ItemValue(ResManager.loadKDString((String)"\u4ece\u7f13\u5b58\u8868\u5bfc\u5165", (String)"AppHomePlanTabPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), (Number)initCount, ColorEnum.IN_EXECUTION.getColor()));
        itemLists.add(new ItemValue(ResManager.loadKDString((String)"\u624b\u5de5\u5f55\u5165", (String)"AppHomePlanTabPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), (Number)handCount, ColorEnum.COMPLETED.getColor()));
        return itemLists.toArray(new ItemValue[0]);
    }

    private void resetPlanShow() {
        ((Label)this.getView().getControl("bizarealabel")).setText("0");
        ((Label)this.getView().getControl("bizsubarealabel")).setText("0");
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"predictdayslabel", "costlabel"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"predictdayslabel2", "costlabel2"});
        ((Label)this.getView().getControl("predictdayslabel")).setText("-");
        ((Label)this.getView().getControl("costlabel")).setText("-");
        ((Label)this.getView().getControl("labelimplchart")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b9e\u65bd\u9879\u5171%1$s\u4e2a", (String)"AppHomePlanTabPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), "0"));
        ((Label)this.getView().getControl("labeltaskchart")).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u5171%1$s\u4e2a", (String)"AppHomePlanTabPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), "0"));
        this.getView().updateView("tabinitplan");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"initplan")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setF7ClickByFilter(true);
            showParameter.setCustomParam("filterplanstatus", (Object)"A");
            showParameter.setShowUsed(false);
        }
    }
}

