/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hric.bussiness.service.BizSubAreaServiceHelper;

public class BizSubAreaTreeServiceHelper {
    public TreeNode loadAllTreeNodes() {
        String rootID = "01010";
        TreeNode root = new TreeNode("", rootID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"BizSubAreaTreeServiceHelper_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        root.setIsOpened(Boolean.TRUE.booleanValue());
        Object[] hrbusinessfieldDyns = BizSubAreaServiceHelper.getHrBusinessField();
        if (!HRArrayUtils.isEmpty((Object[])hrbusinessfieldDyns)) {
            this.initTree(rootID, root, (DynamicObject[])hrbusinessfieldDyns);
        }
        return root;
    }

    private void initTree(String rootID, TreeNode root, DynamicObject[] hrbusinessfieldDyns) {
        Map<Long, List<DynamicObject>> subAreaMap = this.getBizSubAreaMap();
        HashMap<String, TreeNode> treeMaps = new HashMap<String, TreeNode>();
        treeMaps.put(rootID, root);
        StringBuilder parentIdBuilder = new StringBuilder();
        for (DynamicObject hrbusinessfieldDyn : hrbusinessfieldDyns) {
            this.reBuildTree(treeMaps, rootID, "1", hrbusinessfieldDyn);
            parentIdBuilder.append(rootID).append("#").append("1").append(hrbusinessfieldDyn.getLong("id"));
            List<DynamicObject> bizSubAreaList = subAreaMap.get(hrbusinessfieldDyn.getLong("id"));
            if (!CollectionUtils.isEmpty(bizSubAreaList)) {
                for (DynamicObject bizSubAreaDyn : bizSubAreaList) {
                    this.reBuildTree(treeMaps, parentIdBuilder.toString(), "2", bizSubAreaDyn);
                }
            }
            parentIdBuilder.setLength(0);
        }
    }

    private void initTree(String rootID, TreeNode root, DynamicObject[] hrbusinessfieldDyns, DynamicObject[] bizSubAreaDyns) {
        Map<Long, List<DynamicObject>> subAreaMap = this.getBizSubAreaMap(bizSubAreaDyns);
        HashMap<String, TreeNode> treeMaps = new HashMap<String, TreeNode>();
        treeMaps.put(rootID, root);
        StringBuilder parentIdBuilder = new StringBuilder();
        for (DynamicObject hrbusinessfieldDyn : hrbusinessfieldDyns) {
            this.reBuildTree(treeMaps, rootID, "1", hrbusinessfieldDyn);
            parentIdBuilder.append(rootID).append("#").append("1").append(hrbusinessfieldDyn.getLong("id"));
            List<DynamicObject> bizSubAreaList = subAreaMap.get(hrbusinessfieldDyn.getLong("id"));
            if (!CollectionUtils.isEmpty(bizSubAreaList)) {
                for (DynamicObject bizSubAreaDyn : bizSubAreaList) {
                    this.reBuildTree(treeMaps, parentIdBuilder.toString(), "2", bizSubAreaDyn);
                }
            }
            parentIdBuilder.setLength(0);
        }
    }

    private Map<Long, List<DynamicObject>> getBizSubAreaMap() {
        DynamicObject[] bizSubAreaDyns = BizSubAreaServiceHelper.getSubBizAreaCol();
        return this.getBizSubAreaMap(bizSubAreaDyns);
    }

    private Map<Long, List<DynamicObject>> getBizSubAreaMap(DynamicObject[] bizSubAreaDyns) {
        return Arrays.stream(bizSubAreaDyns).collect(Collectors.groupingBy(dyn -> dyn.getLong("group.id")));
    }

    private void reBuildTree(HashMap<String, TreeNode> treeMaps, String parentId, String sign, DynamicObject dy) {
        String id = parentId + "#" + sign + dy.getLong("id");
        TreeNode treeNode = treeMaps.computeIfAbsent(id, k -> new TreeNode(parentId, id, dy.getString("name")));
        TreeNode parentNode = treeMaps.get(parentId);
        if (!HRObjectUtils.isEmpty((Object)parentNode)) {
            parentNode.addChild(treeNode);
        }
    }
}

