/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.CustomChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.common.ColorEnum;
import kd.hrmp.hric.common.constants.AppConstants;

public class ChartCommonEditPlugin
extends HRDataBaseEdit {
    Map<String, String> PLAN_STATUS_MAP = new HashMap<String, String>(){
        {
            this.put("A", ResManager.loadKDString((String)"\u5f85\u914d\u7f6e", (String)"ChartCommonEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("B", ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"ChartCommonEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("C", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ChartCommonEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
    };
    Map<String, String> TASK_STATUS_MAP = new HashMap<String, String>(){
        {
            this.put("A", ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d", (String)"ChartCommonEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("B", ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"ChartCommonEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("C", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"ChartCommonEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("E", ResManager.loadKDString((String)"\u56de\u6eda\u7b49\u5f85\u4e2d", (String)"ChartCommonEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("F", ResManager.loadKDString((String)"\u56de\u6eda\u5904\u7406\u4e2d", (String)"ChartCommonEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
    };
    private String AMOUNT = ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u91cf", (String)"ChartCommonEditPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String SYNCCOST = ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u8017\u65f6", (String)"ChartCommonEditPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String BIZCOST = ResManager.loadKDString((String)"\u4e1a\u52a1\u6821\u9a8c\u8017\u65f6", (String)"ChartCommonEditPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String UNITCOST = ResManager.loadKDString((String)"\u6bcf\u4e07\u6761\u6570\u636e\u8017\u65f6", (String)"ChartCommonEditPlugin_11", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String COST = ResManager.loadKDString((String)"\u8017\u65f6", (String)"ChartCommonEditPlugin_12", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final String UNIT = "(S)";
    private String UNIT_TWO = ResManager.loadKDString((String)"\u6761", (String)"ChartCommonEditPlugin_14", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final String UNIT_THREE = "s";

    ItemValue[] getSeriesData(DynamicObject[] dys, Map<String, String> statusMap, String status) {
        ArrayList itemLists = new ArrayList();
        List docs = Arrays.stream(dys).filter(dyc -> statusMap.containsKey(dyc.getString(status))).collect(Collectors.toList());
        Map<String, Long> statusSumMap = docs.stream().collect(Collectors.groupingBy(dyc -> dyc.getString(status), Collectors.counting()));
        Set<String> keys = statusSumMap.keySet();
        statusMap.keySet().forEach(key -> {
            if (!keys.contains(key)) {
                statusSumMap.put((String)key, (Long)null);
            }
        });
        statusSumMap.entrySet().forEach(entry -> itemLists.add(new ItemValue((String)statusMap.get(entry.getKey()), (Number)entry.getValue(), ColorEnum.getColorByStatus((String)((String)entry.getKey())))));
        return itemLists.toArray(new ItemValue[0]);
    }

    protected void setCharStyle(PieChart pieChart, String titleChart, boolean isShowTitle) {
        pieChart.setShowTitle(isShowTitle);
        pieChart.setShowLegend(true);
        pieChart.setLegendVertical(true);
        pieChart.setShowTooltip(true);
        pieChart.setLegendPropValue("right", (Object)"1%");
        pieChart.setLegendPropValue("top", (Object)10);
        pieChart.setLegendPropValue("itemWidth", (Object)10);
        pieChart.setLegendPropValue("itemHeight", (Object)10);
        pieChart.setLegendPropValue("icon", (Object)"circle");
        pieChart.setTitlePropValue("x", (Object)0);
        pieChart.setTitlePropValue("y", (Object)0);
        HashMap<String, Object> textMap = new HashMap<String, Object>();
        textMap.put("color", "#404040");
        textMap.put("fontSize", 14);
        textMap.put("fontWeight", "bold");
        textMap.put("left", 20);
        pieChart.setTitlePropValue("text", (Object)titleChart);
        pieChart.setTitlePropValue("textStyle", textMap);
    }

    protected void setPieCHart(String pieChartName, String titleName, ItemValue[] seriesData) {
        PieChart pieChart = (PieChart)this.getView().getControl(pieChartName);
        this.setCharStyle(pieChart, "", false);
        PieSeries series = pieChart.createPieSeries(titleName);
        series.setRadius("40%", "70%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
        series.setPropValue("labelLine", (Object)new HashMap(){
            {
                this.put("show", Boolean.TRUE);
            }
        });
        series.setData(seriesData);
    }

    public Map<String, Object> getAxisLineMap(String color) {
        HashMap<String, Object> axisLine = new HashMap<String, Object>();
        axisLine.put("show", true);
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("color", color);
        axisLine.put("lineStyle", lineStyle);
        return axisLine;
    }

    public void setCustomChartForTaskCost(String control, Map<String, Map<String, Object>> entityMap) {
        CustomChart customChart = (CustomChart)this.getView().getControl(control);
        ArrayList<String> category = new ArrayList<String>(AppConstants.LIST_SIZE);
        ArrayList<Number> taskData = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> synCost = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<Number> bizCost = new ArrayList<Number>(AppConstants.LIST_SIZE);
        ArrayList<BigDecimal> unitCost = new ArrayList<BigDecimal>(AppConstants.LIST_SIZE);
        for (Map.Entry<String, Map<String, Object>> entry : entityMap.entrySet()) {
            Map<String, Object> map = entry.getValue();
            category.add((String)map.get("name"));
            taskData.add((Long)map.get("amount"));
            synCost.add((BigDecimal)map.get("synchronizedatatime"));
            bizCost.add((BigDecimal)map.get("businesschecktime"));
            unitCost.add((BigDecimal)map.get("unitdatatime"));
        }
        this.setXYAxis(customChart, category);
        this.setYData(this.AMOUNT, taskData, customChart, "", "#40A9FF", 0);
        this.setYData(this.SYNCCOST, synCost, customChart, "1", "#73D13D", 1);
        this.setYData(this.BIZCOST, bizCost, customChart, "1", "#6682F5", 1);
        LineSeries costTimeSeries = customChart.createLineSeries(this.UNITCOST);
        costTimeSeries.setData(unitCost.toArray(new Number[0]));
        costTimeSeries.setType(ChartType.line);
        costTimeSeries.setYAxisIndex(2);
        costTimeSeries.setLineColor("#FF991C");
        costTimeSeries.setItemColor("#FF991C");
        this.setCustomStyle(customChart);
        ArrayList titleList = Lists.newArrayList((Object[])new String[]{this.AMOUNT, this.SYNCCOST, this.BIZCOST, this.UNITCOST});
        ArrayList colorList = Lists.newArrayList((Object[])new String[]{"#40A9FF", "#73D13D", "#6682F5", "#FF991C"});
        ArrayList unitList = Lists.newArrayList((Object[])new String[]{this.UNIT_TWO, UNIT_THREE, UNIT_THREE, UNIT_THREE});
        customChart.addTooltip("formatter", (Object)this.getFormatter(titleList, colorList, unitList, null));
    }

    protected String getFormatter(List<String> titleList, List<String> colorList, List<String> unitList, String unit) {
        StringBuilder formatter = new StringBuilder();
        for (int index = 0; index < titleList.size(); ++index) {
            formatter.append("<span style=\"display: inline-block; margin-right: 4px; border-radius: 10px; width: 10px; height: 10px;background-color: ").append(colorList.get(index)).append(";\"></span> ");
            formatter.append(titleList.get(index)).append(": <strong>{c").append(index).append("}</strong>").append(HRStringUtils.isEmpty((String)unit) ? unitList.get(index) : unit);
            if (index == titleList.size() - 1) continue;
            formatter.append("<br />");
        }
        return formatter.toString();
    }

    protected void setYData(String title, List<Number> data, CustomChart customChart, String stack, String color, int yAxisIndex) {
        BarSeries costSeries = customChart.createBarSeries(title);
        costSeries.setData(data.toArray(new Number[0]));
        costSeries.setType(ChartType.bar);
        costSeries.setBarWidth("20");
        costSeries.setPropValue("yAxisIndex", (Object)yAxisIndex);
        if (HRStringUtils.isNotEmpty((String)stack)) {
            costSeries.setStack(stack);
        }
        costSeries.getLabel().setShow(false);
        costSeries.setItemColor(color);
    }

    protected void setXYAxis(CustomChart customChart, List<String> category) {
        Axis a1x = customChart.createXAxis("", AxisType.category);
        a1x.setCategorys(category);
        HashMap<String, String> axisPointerX = new HashMap<String, String>();
        axisPointerX.put("type", "shadow");
        a1x.setPropValue("axisPointer", axisPointerX);
        Axis countAxis = customChart.createYAxis(ResManager.loadKDString((String)"\u6570\u636e\u989d", (String)"ChartCommonEditPlugin_13", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), AxisType.value);
        countAxis.setPosition(Position.left);
        countAxis.setPropValue("alignTicks", (Object)true);
        countAxis.setPropValue("axisLine", this.getAxisLineMap("#40A9FF"));
        countAxis.setPropValue("yAxisIndex", (Object)0);
        Axis costAxis = customChart.createYAxis(this.COST + UNIT, AxisType.value);
        costAxis.setPosition(Position.right);
        costAxis.setPropValue("alignTicks", (Object)true);
        costAxis.setPropValue("axisLine", this.getAxisLineMap("#6682F5"));
        costAxis.setPropValue("yAxisIndex", (Object)1);
        Axis costTimeAxis = customChart.createYAxis(this.UNITCOST + UNIT, AxisType.value);
        costTimeAxis.setPosition(Position.right);
        costTimeAxis.setPropValue("alignTicks", (Object)true);
        costTimeAxis.setPropValue("offset", (Object)80);
        costTimeAxis.setPropValue("axisLine", this.getAxisLineMap("#FF991C"));
        costTimeAxis.setPropValue("yAxisIndex", (Object)2);
    }

    protected void setCustomStyle(CustomChart customChart) {
        customChart.addTooltip("trigger", (Object)"axis");
        HashMap<String, Object> axisPointer = new HashMap<String, Object>();
        axisPointer.put("type", "cross");
        HashMap<String, String> crossStyle = new HashMap<String, String>();
        crossStyle.put("color", "'#999");
        axisPointer.put("crossStyle", crossStyle);
        customChart.addTooltip("axisPointer", axisPointer);
        customChart.setShowTooltip(true);
        customChart.setMargin(Position.bottom, "15%");
        customChart.setMargin(Position.right, "5%");
        HashMap<String, Comparable<Boolean>> dataZoom = new HashMap<String, Comparable<Boolean>>();
        dataZoom.put("show", Boolean.valueOf(true));
        dataZoom.put("start", Integer.valueOf(0));
        dataZoom.put("end", Integer.valueOf(100));
        customChart.addProperty("dataZoom", dataZoom);
        customChart.setShowTitle(false);
        customChart.setShowLegend(true);
        customChart.setLegendPropValue("right", (Object)"13%");
    }
}

