/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitExecTaskCallbackServiceHelper;
import kd.hrmp.hric.bussiness.service.InitFinishServiceHelper;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.AsyncTaskSceneConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;

public class FinishProgressEditPlugin
extends HRDataBaseEdit
implements ProgresssListener {
    private static final String CACHEKEY_ISSTART = "isstart";
    private static final String CURR_TASK_IS_FINISH = "currTaskIsFinish";
    private static final String CACHEKEY_ISFINISHED = "isfinished";
    private static final String CUSTPARAM_TASKID = "hric_taskId";
    private static Log LOG = LogFactory.getLog(FinishProgressEditPlugin.class);
    private int total;
    private long stopCount;
    private long finishCount;
    private List<DynamicObject> handleTaskList;

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
        Button backRun = (Button)this.getControl("backrun");
        backRun.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)"backrun", (CharSequence)source.getKey())) {
            this.closeForm();
            this.doTranBackground();
        }
    }

    public void afterBindData(EventObject e) {
        super.beforeBindData(e);
        this.queryTaskExecSituation();
        if ((long)this.total == this.finishCount) {
            this.setCurrTaskIsFinish();
            this.showSuccessPanel();
            this.recordLog();
            this.sendSysMsg();
            return;
        }
        if ((long)this.total == this.finishCount + this.stopCount) {
            this.setCurrTaskIsFinish();
            this.showFailedPanel();
            this.sendSysMsg();
            return;
        }
        this.startBar();
        this.setLabelProgress(0);
        this.getView().setVisible(Boolean.FALSE, new String[]{"successpanel", "failedpanel", "btncancel"});
        this.initTaskLabel();
        String taskId = this.getTaskId();
        if (HRStringUtils.isNotEmpty((String)taskId)) {
            this.setBackrunBtnEnable(Boolean.TRUE);
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.setPercent(progress);
            this.setLabelProgress(progress);
        } else {
            this.setBackrunBtnEnable(Boolean.FALSE);
        }
    }

    private String getCustomParam(String key) {
        return ConvertUtils.toString((Object)this.getView().getFormShowParameter().getCustomParam(key));
    }

    private void setBackrunBtnEnable(Boolean isEnable) {
        this.getView().setEnable(isEnable, new String[]{"backrun"});
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && HRStringUtils.isEmpty((String)taskId)) {
            this.dispatchTask();
            this.setBackrunBtnEnable(Boolean.TRUE);
            return;
        }
        if (HRStringUtils.isEmpty((String)taskId)) {
            return;
        }
        this.queryTaskExecSituation();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (taskInfo.isTaskEnd()) {
            this.complete(taskInfo, evt);
            this.setCurrTaskIsFinish();
        } else {
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            this.initTaskLabel();
            evt.setProgress(progress);
            this.setLabelProgress(progress);
        }
    }

    private void setCurrTaskIsFinish() {
        this.getView().getPageCache().put(CURR_TASK_IS_FINISH, "true");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        TaskInfo taskInfo;
        super.beforeClosed(e);
        String taskId = this.getTaskId();
        String currTaskIsFinish = this.getView().getPageCache().get(CURR_TASK_IS_FINISH);
        if (HRStringUtils.equals((String)currTaskIsFinish, (String)"true")) {
            this.refreshPlanInfoPage();
            return;
        }
        if (HRStringUtils.isEmpty((String)currTaskIsFinish) && HRStringUtils.isEmpty((String)taskId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7b49\u5f85\u540e\u53f0\u4efb\u52a1\u751f\u6210\u540e\uff0c\u518d\u70b9\u51fb\u201c\u5173\u95ed\u201d\u3002", (String)"FinishProgressEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        if ((taskInfo = ScheduleServiceHelper.queryTask((String)taskId)).isTaskEnd()) {
            this.refreshPlanInfoPage();
        } else {
            this.doTranBackground();
        }
    }

    private void sendSysMsg() {
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>(AppConstants.LIST_SIZE);
        String opType = this.getCustomParam("opType");
        String title = HRStringUtils.equals((String)opType, (String)"plan") ? ResManager.loadKDString((String)"\u8ba1\u5212\u521d\u59cb\u5316\u5b8c\u6210\u63d0\u9192", (String)"FinishProgressEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4efb\u52a1\u521d\u59cb\u5316\u5b8c\u6210\u63d0\u9192", (String)"FinishProgressEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
        String masterPlanId = this.getCustomParam("masterPlanId");
        String phone = ConvertUtils.toString(((Map)UserServiceHelper.get((List)new ArrayList<Long>(){
            {
                this.add(RequestContext.get().getCurrUserId());
            }
        }).get(0)).get("phone"));
        if (HRStringUtils.isEmpty((String)phone)) {
            return;
        }
        InitMessageInfo msgInfo = new InitMessageInfoBuilder().buildReceivers((List)new ArrayList<Long>(){
            {
                this.add(RequestContext.get().getCurrUserId());
            }
        }).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName("hric_initplandetail").buildEntityId(Long.valueOf(HRStringUtils.isEmpty((String)masterPlanId) ? 0L : Long.parseLong(masterPlanId))).buildContent(this.assemblyMsgContent(opType)).buildTitle(title).buildTag(ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"FinishProgressEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0])).buildPhone((List)ImmutableList.of((Object)phone)).buildMessageChannelList("mcenter").build();
        infoList.add(msgInfo);
        DynamicObject dynamicObject = AsyncTaskServiceHelper.createTaskAndSave((Map)ImmutableMap.of((Object)"messageParams", (Object)JSON.toJSONString(infoList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect})), (String)ID.genStringId(), (String)"", (Long)AsyncTaskSceneConstants.SCENE_MESSAGE_NOTICE);
        AsyncTaskServiceHelper.startJob((long)dynamicObject.getLong("id"));
    }

    private String assemblyMsgContent(String opType) {
        String logStr = this.getCustomParam("logStr");
        logStr = logStr == null ? "" : logStr.substring(0, logStr.length() - 1);
        String result = HRStringUtils.equals((String)opType, (String)"plan") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u64cd\u4f5c\u7684%1$s\u8ba1\u5212\u521d\u59cb\u5316\u5df2\u5b8c\u6210\u6267\u884c\u3002", (String)"FinishProgressEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), logStr) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u60a8\u64cd\u4f5c\u7684%1$s\u4efb\u52a1\u5df2\u5b8c\u6210\u521d\u59cb\u5316\u3002", (String)"FinishProgressEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), logStr);
        return result;
    }

    private void refreshPlanInfoPage() {
        String parentPageId = this.getCustomParam("planInfoPageId");
        IFormView view = SessionManager.getCurrent().getView(parentPageId);
        if (view == null) {
            return;
        }
        view.invokeOperation("refresh");
        this.getView().sendFormAction(view);
    }

    private void setLabelProgress(int progress) {
        ((Label)this.getView().getControl("percent")).setText(progress + "%");
    }

    private void complete(TaskInfo taskInfo, ProgressEvent evt) {
        boolean isFinished = this.isFinished();
        this.setFinished(true);
        if (HRStringUtils.equals((String)"FAILED", (String)taskInfo.getStatus())) {
            if (FinishProgressEditPlugin.isShowStackTrace()) {
                this.getView().showErrMessage(taskInfo.getFailureReason(), "");
            } else {
                String errMsg = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u51fa\u9519\uff0c\u8be6\u60c5\u8bf7\u67e5\u9605\u65e5\u5fd7", (String)"TaskProgressFormEdit_2", (String)"bos-schedule-form", (Object[])new Object[0]);
                this.getView().showErrorNotification(errMsg);
            }
            this.stopBar();
            return;
        }
        if (!isFinished) {
            evt.setProgress(99);
            this.setLabelProgress(99);
            this.sendSysMsg();
            return;
        }
        evt.setProgress(100);
        this.setLabelProgress(100);
        this.stopBar();
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        if ((long)this.total == this.finishCount) {
            this.showSuccessPanel();
            this.recordLog();
            return;
        }
        if ((long)this.total == this.finishCount + this.stopCount) {
            this.showFailedPanel();
            return;
        }
    }

    private void closeForm() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
    }

    private void setFinished(boolean finished) {
        this.getPageCache().put(CACHEKEY_ISFINISHED, String.valueOf(finished));
    }

    private boolean isFinished() {
        String finished = this.getPageCache().get(CACHEKEY_ISFINISHED);
        if (HRStringUtils.isEmpty((String)finished)) {
            return false;
        }
        return Boolean.parseBoolean(finished);
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        if (HRStringUtils.isEmpty((String)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setTaskId(taskId);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put(CUSTPARAM_TASKID, taskId);
    }

    private void setStart(boolean start) {
        this.getPageCache().put(CACHEKEY_ISSTART, String.valueOf(start));
    }

    private boolean isStart() {
        String start = this.getPageCache().get(CACHEKEY_ISSTART);
        if (HRStringUtils.isEmpty((String)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private JobFormInfo getJobFormInfo() {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("hric_planortaskfinish");
        if (HRStringUtils.isEmpty((String)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey(CUSTPARAM_TASKID)) {
            return (String)this.getView().getFormShowParameter().getCustomParam(CUSTPARAM_TASKID);
        }
        return this.getPageCache().get(CUSTPARAM_TASKID);
    }

    private void doTranBackground() {
        String taskId = this.getTaskId();
        if (HRStringUtils.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
            ThreadPools.executeOnce((String)"task-background-monitor", (Runnable)subscriber);
        }
    }

    private void startBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.start();
    }

    private void recordLog() {
        String totalStr = this.getPageCache().get("currTotal");
        String finishCountStr = this.getPageCache().get("currFinishCount");
        if (HRStringUtils.isEmpty((String)totalStr) || HRStringUtils.isEmpty((String)finishCountStr)) {
            return;
        }
        if (HRStringUtils.equals((String)totalStr, (String)finishCountStr)) {
            DynamicObject serviceLog = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_initservicelog"));
            serviceLog.set("planid", (Object)this.getCustomParam("masterPlanId"));
            serviceLog.set("operationdate", (Object)new Date());
            if (HRStringUtils.equals((String)this.getCustomParam("opType"), (String)"plan")) {
                serviceLog.set("operationtype", (Object)"B");
            } else {
                serviceLog.set("operationtype", (Object)"A");
            }
            HricDynamicObjectUtils.setBigText((DynamicObject)serviceLog, (String)"operationobj", (String)this.getCustomParam("logStr"));
            serviceLog.set("operationperson", (Object)UserServiceHelper.getCurrentUserId());
            InitFinishServiceHelper.saveVerifyLog((DynamicObject)serviceLog);
        }
    }

    private void queryTaskExecSituation() {
        String manualEntryTaskCountStr = this.getCustomParam("manualEntryTaskCount");
        String nonManualEntryTaskCountStr = this.getCustomParam("nonManualEntryTask");
        int manualEntryTaskCount = Integer.parseInt(manualEntryTaskCountStr == null ? "0" : manualEntryTaskCountStr);
        int nonManualEntryTaskCount = Integer.parseInt(nonManualEntryTaskCountStr == null ? "0" : nonManualEntryTaskCountStr);
        DynamicObject[] dys = InitExecTaskCallbackServiceHelper.queryBasicInfoByOperateKey((String)this.getCustomParam("currBatchNumber"));
        this.total = dys.length < nonManualEntryTaskCount ? manualEntryTaskCount + nonManualEntryTaskCount : dys.length + manualEntryTaskCount;
        this.finishCount = Arrays.stream(dys).filter(dyc -> HRStringUtils.equals((String)"3", (String)dyc.getString("status"))).count() + (long)manualEntryTaskCount;
        this.stopCount = Arrays.stream(dys).filter(dyc -> HRStringUtils.equals((String)"5", (String)dyc.getString("status"))).count();
        this.handleTaskList = Arrays.stream(dys).filter(dyc -> HRStringUtils.equals((String)"1", (String)dyc.getString("status"))).collect(Collectors.toList());
        this.getPageCache().put("currTotal", this.total + "");
        this.getPageCache().put("currFinishCount", this.finishCount + "");
        this.getPageCache().put("currStopCount", this.stopCount + "");
    }

    private void showFailedPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"syncpanel", "successpanel", "backrun"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"failedpanel", "btncancel"});
        ((Label)this.getView().getControl("success")).setText(this.finishCount + "");
        ((Label)this.getView().getControl("fail")).setText(this.stopCount + "");
    }

    private void showSuccessPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"syncpanel", "failedpanel", "backrun"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"successpanel", "btncancel"});
        ((Label)this.getView().getControl("successall")).setText(this.total + "");
    }

    private void initTaskLabel() {
        for (int i = 0; i < 3; ++i) {
            ((Label)this.getView().getControl("task" + i)).setText("");
        }
        if (CollectionUtils.isEmpty(this.handleTaskList)) {
            return;
        }
        int loop = this.handleTaskList.size() < 3 ? this.handleTaskList.size() : 3;
        for (int i = 0; i < loop; ++i) {
            DynamicObject dyc = this.handleTaskList.get(i);
            String paramStr = dyc.getString("param");
            if (!HRStringUtils.isNotEmpty((String)paramStr)) continue;
            try {
                Map paramMap = (Map)HRJSONUtils.cast((String)paramStr, Map.class);
                ((Label)this.getView().getControl("task" + i)).setText((String)paramMap.get("taskName"));
                continue;
            }
            catch (IOException e) {
                LOG.info("[HRIC] method:initTaskLabel(),Task name is empty,case{}", (Object)e);
            }
        }
    }

    private static boolean isShowStackTrace() {
        Object isShowStackTrace;
        String showStackTrace = System.getProperty("exception_showstacktrace");
        if (showStackTrace != null && HRStringUtils.equals((String)"true", (String)showStackTrace)) {
            return true;
        }
        Map cache = SystemParamServiceHelper.loadPublicParametersFromCache();
        if (cache != null && cache.size() > 0 && (isShowStackTrace = cache.get("showstacktrace")) != null) {
            return (Boolean)isShowStackTrace;
        }
        return false;
    }
}

