/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.util.HricCacheUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class HRICInitImportPlugin
extends BatchImportPlugin {
    private static final String TASK_ID = "hrictaskid";
    private static final Log log = LogFactory.getLog(HRICInitImportPlugin.class);
    private String batchNumber = null;
    private Long taskId = null;
    private String midTableNumber = null;

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        this.initParams(ctx);
        return super.setContext(rc, ctx, startArgs);
    }

    private void initParams(ImportContext ctx) {
        String url = (String)ctx.getAllUrls().iterator().next();
        if (HRStringUtils.isEmpty((String)url)) {
            return;
        }
        String md5Url = DigestUtils.md5Hex((String)url);
        log.info("HRICInitImportPlugin_md5Url: {}", (Object)md5Url);
        this.batchNumber = this.getInitParam(md5Url + "initbatchnumber", String.class);
        this.taskId = this.getInitParam(md5Url + TASK_ID, Long.class);
        this.midTableNumber = this.getInitParam(md5Url + "midTableNumber", String.class);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        long[] idArray = DBServiceHelper.genLongIds((String)this.midTableNumber, (int)rowdatas.size());
        for (int index = 0; index < rowdatas.size(); ++index) {
            ImportBillData row = rowdatas.get(index);
            row.getData().put("initbatchnumber", (Object)this.batchNumber);
            row.getData().put(TASK_ID, (Object)this.taskId);
            row.getData().put("initstatus", (Object)OperateEnum.INITIMPORTDATA.getSuccessStatus());
            row.getData().put("id", (Object)idArray[index]);
        }
        return super.save(rowdatas, logger);
    }

    private <T> T getInitParam(String key, Class<T> clazz) {
        Object value = HricCacheUtils.get((String)key, clazz);
        HricCacheUtils.remove((String)key);
        return (T)value;
    }
}

