/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Operations;
import kd.bos.entity.plugin.IImportDataPlugin;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.BeforeUploadEvent;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.ImportStartPlugin;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BillStatusField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.svc.util.FileHandlerUtil;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hrmp.hric.bussiness.service.InitTaskCountServiceHelper;
import kd.hrmp.hric.common.util.HricCacheUtils;
import org.apache.commons.codec.digest.DigestUtils;

public class HRICInitImportStartPlugin
extends ImportStartPlugin {
    private static final String FILEPANEL = "filepanel";
    private static final String CHECK_RIGHT_APP_ID = "CheckRightAppId";
    private static final String BILL_FORM_ID = "BillFormId";
    public static final String LIST_NAME = "ListName";
    private static final String KEYFIELDS = "keyfields";
    private static final String IMPORTTYPE = "importtype";
    private static final String IMPORT_PLUGIN = "ImportPlugin";
    private static final String FILEPATH = "filepath";
    private static final String INIT_BATCHNUMBER = "initbatchnumber";
    private static final Log log = LogFactory.getLog(HRICInitImportStartPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    private boolean isPropertyImport(List<EntityItem<?>> newItems, IDataEntityProperty prop) {
        for (EntityItem<?> item : newItems) {
            DateRangeField field;
            if (item instanceof DateRangeField && ((field = (DateRangeField)item).getStartDateFieldKey().equals(prop.getName()) || field.getEndDateFieldKey().equals(prop.getName()))) {
                return true;
            }
            if (!prop.getName().equals(item.getKey())) continue;
            return true;
        }
        return false;
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String appid = (String)showParam.getCustomParam("ServiceAppId");
        String checkrightappid = (String)showParam.getCustomParam(CHECK_RIGHT_APP_ID);
        String billFormId = (String)showParam.getCustomParam(BILL_FORM_ID);
        String listName = (String)showParam.getCustomParam(LIST_NAME);
        String pluginName = this.getImportPlugin(showParam);
        Label title = (Label)this.getControl("title");
        if (Lang.en_US == RequestContext.get().getLang()) {
            title.setText("&nbsp;&nbsp;" + listName);
        } else {
            title.setText(listName);
        }
        this.init(appid, checkrightappid, listName, billFormId, pluginName);
    }

    private void init(String appid, String checkRightAppId, String listName, String billFormId, String pluginName) {
        ComboEdit combo = (ComboEdit)this.getControl(KEYFIELDS);
        List<String> lockKeys = new ArrayList<String>(0);
        String importType = "new";
        String keyfields = null;
        ArrayList<Object> keyfieldItems = new ArrayList<ComboItem>(0);
        if (StringUtils.isNotBlank((CharSequence)pluginName)) {
            try {
                IImportDataPlugin plugin = (IImportDataPlugin)Class.forName(pluginName).newInstance();
                if (plugin instanceof BatchImportPlugin) {
                    ((BatchImportPlugin)plugin).setContext(RequestContext.get(), new ImportContext(this.getView(), null, appid, checkRightAppId, listName, billFormId, null, null), null);
                    lockKeys = ((BatchImportPlugin)plugin).getDefaultLockUIs();
                    String pluginImportType = ((BatchImportPlugin)plugin).getDefaultImportType();
                    importType = this.getImportType(pluginImportType, importType);
                    keyfields = ((BatchImportPlugin)plugin).getDefaultKeyFields();
                    keyfieldItems = new ArrayList(((BatchImportPlugin)plugin).getOverrideFieldsConfig());
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        if ("new".equals(importType) && !lockKeys.contains(KEYFIELDS)) {
            lockKeys.add(KEYFIELDS);
        }
        this.inintDetail(lockKeys, billFormId, keyfieldItems, combo);
        this.getModel().setValue(IMPORTTYPE, (Object)importType);
        this.getModel().setValue(KEYFIELDS, keyfields);
    }

    private String getImportType(String pluginImportType, String importType) {
        if (StringUtils.isNotBlank((CharSequence)pluginImportType)) {
            return pluginImportType;
        }
        return importType;
    }

    private void inintDetail(List<String> lockKeys, String billFormId, List<ComboItem> keyfieldItems, ComboEdit combo) {
        this.getView().setEnable(Boolean.valueOf(false), lockKeys.toArray(new String[0]));
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)billFormId);
        if (keyfieldItems.isEmpty()) {
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            List entityItems = entityMetadata.getItems();
            List<EntityItem<?>> newItems = entityItems.stream().filter(item -> {
                boolean valid = item instanceof Field;
                if (valid) {
                    Field field = (Field)item;
                    Predicate<Field> validJudge = this.getPredicate(param -> StringUtils.isNotBlank((CharSequence)param.getFieldName())).and(param -> param.getFeatures().isImportable()).and(this.getPredicate(param -> param instanceof BillStatusField).or(param -> param instanceof CheckBoxField).or(param -> param instanceof RadioField).or(param -> param instanceof RadioGroupField).or(param -> param instanceof ModifierField).or(param -> param instanceof PictureField).or(param -> param instanceof UserAvatarField).or(param -> param instanceof IconField).or(param -> param instanceof AttachmentCountField).or(param -> param instanceof AttachmentField).or(param -> param instanceof PrintCountField).negate());
                    valid = validJudge.test(field);
                }
                return valid;
            }).collect(Collectors.toList());
            for (IDataEntityProperty property : entityType.getProperties()) {
                if (!this.isPropertyImport(newItems, property)) continue;
                keyfieldItems.add(new ComboItem(property.getDisplayName(), property.getName()));
            }
        }
        keyfieldItems.add(0, new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"HRICInitImportStartPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0])), "hrmp-hric-formplugin"));
        if (!keyfieldItems.isEmpty()) {
            this.sortKeyfieldItems(keyfieldItems, entityType);
            combo.setComboItems(keyfieldItems);
        }
    }

    private Predicate<Field> getPredicate(Predicate<Field> pred) {
        return pred;
    }

    private void sortKeyfieldItems(List<ComboItem> keyfieldItems, MainEntityType entityType) {
        String orgKey = "";
        if (entityType != null && entityType.getMainOrg() != null) {
            orgKey = entityType.getMainOrg();
        }
        boolean hasOrg = false;
        int orgIndex = 0;
        boolean hasBillno = false;
        int billnoIndex = 0;
        for (int index = 0; index < keyfieldItems.size(); ++index) {
            ComboItem comboItem = keyfieldItems.get(index);
            if (StringUtils.isNotBlank((CharSequence)orgKey) && orgKey.equals(comboItem.getValue())) {
                orgIndex = index;
                hasOrg = true;
                continue;
            }
            if (!"billno".equals(comboItem.getValue())) continue;
            billnoIndex = index;
            hasBillno = true;
        }
        if (hasOrg) {
            keyfieldItems.add(1, keyfieldItems.get(orgIndex));
            keyfieldItems.remove(orgIndex + 1);
        }
        if (hasBillno) {
            keyfieldItems.add(hasOrg ? 2 : 1, keyfieldItems.get(billnoIndex));
            keyfieldItems.remove(billnoIndex + 1);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (IMPORTTYPE.equalsIgnoreCase(propertyName)) {
            this.getView().setEnable(Boolean.valueOf(!"new".equalsIgnoreCase((String)e.getChangeSet()[0].getNewValue())), new String[]{KEYFIELDS});
            String importtype = (String)this.getModel().getValue(propertyName);
            if (StringUtils.equals((CharSequence)"new", (CharSequence)importtype)) {
                this.getModel().setValue(KEYFIELDS, null);
            }
        }
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                FormShowParameter currShowParameter = this.getView().getFormShowParameter();
                String billFormId = (String)currShowParameter.getCustomParam(BILL_FORM_ID);
                String importPlugin = this.getImportPlugin(currShowParameter);
                if (StringUtils.isBlank((CharSequence)billFormId)) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7c7b\u578b", (String)"HRICInitImportStartPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("bos_downloadtemplate");
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam(BILL_FORM_ID, (Object)billFormId);
                showParameter.setCustomParam("BillTypeId", currShowParameter.getCustomParam("BillTypeId"));
                showParameter.setCustomParam(IMPORT_PLUGIN, (Object)importPlugin);
                showParameter.setCustomParam("TemplateType", (Object)"IMPT");
                this.getView().showForm(showParameter);
                break;
            }
            case "btnresetfile": {
                this.getModel().setValue("filename", (Object)"");
                this.getModel().setValue(FILEPATH, (Object)"");
                this.getView().setVisible(Boolean.FALSE, new String[]{FILEPANEL});
                this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
                break;
            }
        }
    }

    private void importData() {
        String url = (String)this.getModel().getValue(FILEPATH);
        if (StringUtils.isBlank((CharSequence)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"HRICInitImportStartPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"new".equals(this.getModel().getValue(IMPORTTYPE)) && StringUtils.isBlank((Object)this.getModel().getValue(KEYFIELDS))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"HRICInitImportStartPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        this.importData(url);
        this.saveTaskOpCount();
    }

    private void saveTaskOpCount() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("hrictaskid");
        DynamicObject taskOpCountObj = InitTaskCountServiceHelper.getByTaskId((long)taskId);
        if (HRObjectUtils.isEmpty((Object)taskOpCountObj)) {
            taskOpCountObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_taskopcount"));
            taskOpCountObj.set("inittaskid", (Object)taskId);
            taskOpCountObj.set("introductioncount", (Object)1);
        } else {
            taskOpCountObj.set("introductioncount", (Object)(taskOpCountObj.getInt("introductioncount") + 1));
        }
        InitTaskCountServiceHelper.saveOne((DynamicObject)taskOpCountObj);
    }

    private void importData(String url) {
        IFormView view = this.getView();
        FormShowParameter showParam = view.getFormShowParameter();
        String billFormId = (String)showParam.getCustomParam(BILL_FORM_ID);
        String listName = (String)showParam.getCustomParam(LIST_NAME);
        String serviceAppId = view.getFormShowParameter().getServiceAppId();
        String checkRightAppId = (String)showParam.getCustomParam(CHECK_RIGHT_APP_ID);
        Operations ops = EntityMetadataCache.getDataEntityOperations((String)FormMetadataCache.getFormConfig((String)billFormId).getEntityTypeId());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importing");
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        HashMap<String, Object> params = new HashMap<String, Object>();
        String importType = (String)this.getModel().getValue(IMPORTTYPE);
        params.put("Type", importType);
        if (!"new".equals(importType)) {
            params.put("KeyFields", (String)this.getModel().getValue(KEYFIELDS));
        }
        params.put("ServiceAppId", serviceAppId);
        params.put(CHECK_RIGHT_APP_ID, checkRightAppId);
        params.put(BILL_FORM_ID, billFormId);
        params.put(LIST_NAME, listName);
        params.put("OpSave", ops.getSave());
        params.put("Url", url);
        params.put(IMPORT_PLUGIN, this.getImportPlugin(showParam));
        params.put("OperateKey", showParam.getCustomParam("OperateKey"));
        params.put("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
        Long taskId = (Long)showParam.getCustomParam("hrictaskid");
        String initBatchNumber = this.createBatchNumber();
        String md5Url = DigestUtils.md5Hex((String)url);
        log.info("HRICInitImportStartPlugin_md5Url: {}", (Object)md5Url);
        HricCacheUtils.put((String)(md5Url + "hrictaskid"), (Object)taskId);
        HricCacheUtils.put((String)(md5Url + INIT_BATCHNUMBER), (Object)initBatchNumber);
        HricCacheUtils.put((String)(md5Url + "midTableNumber"), (Object)billFormId);
        showParameter.setCustomParams(params);
        showParameter.setCustomParam("RealPermissionEntityId", showParam.getCustomParam("RealPermissionEntityId"));
        showParameter.setParentPageId(view.getFormShowParameter().getParentPageId());
        showParameter.setCloseCallBack(view.getFormShowParameter().getCloseCallBack());
        view.showForm(showParameter);
    }

    private String getImportPlugin(FormShowParameter showParam) {
        String pluginName = (String)showParam.getCustomParam(IMPORT_PLUGIN);
        if (StringUtils.isBlank((CharSequence)pluginName)) {
            List plugins = (List)showParam.getCustomParam("plugins");
            pluginName = this.getImportPluginClassName(plugins, pluginName);
        }
        return pluginName;
    }

    private String getImportPluginClassName(List<Map<String, Object>> plugins, String pluginName) {
        if (plugins == null) {
            return pluginName;
        }
        for (Map<String, Object> tempMap : plugins) {
            if (!Boolean.TRUE.equals(tempMap.get("Enabled"))) continue;
            return (String)tempMap.get("ClassName");
        }
        return pluginName;
    }

    private String createBatchNumber() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        return dateFormat.format(new Date());
    }

    public void beforeUpload(BeforeUploadEvent evt) {
        log.info("\u4e0a\u4f20\u5f00\u59cb:");
        this.getView().getPageCache().put("UploadBeginTime", String.valueOf(System.currentTimeMillis()));
    }

    public void afterUpload(UploadEvent evt) {
        String beginDate = this.getView().getPageCache().get("UploadBeginTime");
        Long beginTime = Long.parseLong(beginDate);
        log.info(ResManager.loadKDString((String)"\u4e0a\u4f20\u5b8c\u6210\uff0c\u7528\u65f6: {}ms", (String)"MidTableGenerate_11", (String)"hrmp-hric-business", (Object[])new Object[0]), (Object)(System.currentTimeMillis() - beginTime));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String filePath = this.getModel().getValue(FILEPATH).toString();
        FileHandlerUtil.tryDelFile((String)filePath);
    }
}

