/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.formplugin.web.HRICTreeListPlugin;
import org.apache.commons.lang3.StringUtils;

public class HRICParentTreeListPlugin
extends HRICTreeListPlugin {
    @Override
    protected TreeNode loadRootNode() {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String structNumber = (String)parameter.getCustomParam("structnumber");
        return this.initTree(structNumber);
    }

    private TreeNode initTree(String structNumber) {
        TreeNode root = new TreeNode("", structNumber, ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212", (String)"HRICParentTreeListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        root.setIsOpened(true);
        HashMap nodeMap = Maps.newHashMap();
        nodeMap.put(structNumber, root);
        DynamicObject[] allPlans = InitPlanServiceHelper.getAllSonPlans((String)structNumber);
        Arrays.stream(allPlans).forEach(plan -> {
            String tempStructNumber = plan.getString("structnumber");
            if (StringUtils.isNotEmpty((CharSequence)tempStructNumber) && !StringUtils.equals((CharSequence)plan.getString("structnumber"), (CharSequence)structNumber)) {
                String parentNumber = tempStructNumber.substring(0, tempStructNumber.lastIndexOf(33));
                TreeNode node = new TreeNode(parentNumber, tempStructNumber, plan.getString("name"));
                nodeMap.put(plan.getString("structnumber"), node);
                ((TreeNode)nodeMap.get(parentNumber)).addChild(node);
            }
        });
        return root;
    }

    @Override
    protected QFilter buildLeftTreeFilter(String nodeId) {
        return new QFilter("structnumber", "like", (Object)(nodeId + "%"));
    }
}

