/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.EventObject;
import java.util.Objects;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;

public abstract class HRICTreeListPlugin
extends StandardTreeListPlugin {
    public void initializeTree(EventObject e) {
        TreeNode root = this.loadRootNode();
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addNode(root);
        treeView.focusNode(root);
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if (HRStringUtils.equals((String)this.getRootNodeId(), (String)nodeId)) {
            e.setChildNodes(this.loadRootNode().getChildren());
        } else {
            TreeNode evtTreeNode = this.getTreeModel().getRoot().getTreeNode(nodeId, 20);
            if (!Objects.isNull(evtTreeNode)) {
                e.setChildNodes(evtTreeNode.getChildren());
            }
        }
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        QFilter filter = null;
        String nodeId = (String)e.getNodeId();
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        filter = this.buildLeftTreeFilter(nodeId);
        if (filter != null) {
            e.addQFilter(filter);
        }
    }

    protected abstract TreeNode loadRootNode();

    protected abstract QFilter buildLeftTreeFilter(String var1);

    protected String getRootNodeId() {
        return null;
    }
}

