/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.service.AttachmentDataServiceHelper;
import kd.hrmp.hric.common.util.AttachmentUtils;

public class ImplItemAttachmentEditPlugin
extends HRDataBaseEdit
implements UploadListener {
    private static String SUCCESS = "success";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.loadDbAttachment();
    }

    private void loadDbAttachment() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isSysPreset = true;
        boolean isFromTask = this.getView().getFormShowParameter().getCustomParams().containsKey("hric_taskopguide");
        long implItemId = 0L;
        if (isFromTask) {
            isSysPreset = (Boolean)this.getView().getFormShowParameter().getCustomParam("issyspreset");
            implItemId = (Long)this.getView().getFormShowParameter().getCustomParam("hric_taskopguide");
        } else {
            isSysPreset = dataEntity.getBoolean("issyspreset");
            implItemId = dataEntity.getLong("id");
        }
        if (isSysPreset) {
            this.buildAttachmentPanelBindData(attachmentPanel, implItemId);
        } else {
            attachmentPanel.bindData(AttachmentServiceHelper.getAttachments((String)"hric_implitem", (Object)implItemId, (String)"attachmentpanelap"));
        }
    }

    private void buildAttachmentPanelBindData(AttachmentPanel attachmentPanel, Long implItemId) {
        DynamicObject[] dys = AttachmentDataServiceHelper.query((Long)implItemId);
        ArrayList attachmentDataList = new ArrayList();
        Arrays.stream(dys).forEach(dyc -> attachmentDataList.add(this.getAttachmentData((DynamicObject)dyc)));
        attachmentPanel.bindData(attachmentDataList);
    }

    private Map<String, Object> getAttachmentData(DynamicObject dyc) {
        HashMap<String, Object> attachmentData = new HashMap<String, Object>();
        String fileName = dyc.getString("name");
        String fileData = dyc.getString("filedata");
        String url = dyc.getString("url");
        if (!AttachmentUtils.checkUrlExist((String)url)) {
            ByteArrayInputStream ins = new ByteArrayInputStream(Base64.getDecoder().decode(fileData));
            url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)ins, 5000);
        }
        attachmentData.put("url", url);
        attachmentData.put("createdate", dyc.getDate("createdate"));
        attachmentData.put("sort", dyc.getInt("sort"));
        attachmentData.put("size", dyc.getInt("size"));
        attachmentData.put("description", dyc.getString("description"));
        attachmentData.put("name", fileName);
        attachmentData.put("status", SUCCESS);
        return attachmentData;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            this.setAttachmentJsonData();
        }
    }

    private void setAttachmentJsonData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachmentDataList = attachmentPanel.getAttachmentData();
        ArrayList attachmentDatas = new ArrayList();
        attachmentDataList.forEach(it -> {
            HashMap attachment = new HashMap();
            attachment.put("sort", it.get("sort"));
            String fileName = it.get("name").toString();
            attachment.put("name", fileName);
            attachment.put("type", fileName.substring(fileName.lastIndexOf(".") + 1));
            attachment.put("url", it.get("url"));
            attachment.put("size", it.get("size"));
            attachment.put("description", it.get("description"));
            attachmentDatas.add(attachment);
        });
        if (!CollectionUtils.isEmpty(attachmentDatas)) {
            this.getModel().setValue("attachmentjsondata", (Object)JSON.toJSONString(attachmentDatas));
        }
    }
}

