/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IImplItemEntityService;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricObjectUtils;
import kd.hrmp.hric.formplugin.web.ImplItemBaseEditPlugin;
import kd.hrmp.hric.formplugin.web.util.ImplItemFormUtils;

public class ImplItemComposeEditPlugin
extends ImplItemBaseEditPlugin {
    private static final Log LOG = LogFactory.getLog(ImplItemComposeEditPlugin.class);
    private IImplItemEntityService iImplItemEntityService = (IImplItemEntityService)ServiceFactory.getService(IImplItemEntityService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initComposeImplItem();
        this.loadComDIEntryData();
    }

    private void loadComDIEntryData() {
        DynamicObjectCollection implItemEntryCol = this.getModel().getEntryEntity("baseimplentry");
        if (!CollectionUtils.isEmpty((Collection)implItemEntryCol)) {
            List<Long> implItemIdList = implItemEntryCol.stream().map(entryDyn -> entryDyn.getDynamicObject("implitem").getLong("id")).collect(Collectors.toList());
            this.setComDIEntry(implItemIdList);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"addbaseentry")) {
            this.showImplItemF7("baseimplentry");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"baseimplentry") && closedCallBackEvent.getReturnData() != null) {
            ImplItemFormUtils.handleImplItemF7Callback(this.getView(), "baseimplentry", "implitem", closedCallBackEvent);
            this.setComDIEntry(this.getF7SelectedIdList(closedCallBackEvent));
        }
    }

    private void setComDIEntry(List<Long> implItemIdList) {
        DynamicObject[] implItemDyns = this.iImplItemEntityService.query("id,name,dientryentity.sourcesystem,dientryentity.integrationservicetype,dientryentity.discheme,dientryentity.diname", implItemIdList.toArray());
        DynamicObjectCollection allDIEntryCol = new DynamicObjectCollection();
        Arrays.stream(implItemDyns).forEach(implItemDyn -> {
            DynamicObjectCollection entryCol = implItemDyn.getDynamicObjectCollection("dientryentity");
            if (!CollectionUtils.isEmpty((Collection)entryCol)) {
                allDIEntryCol.addAll((Collection)entryCol);
            }
        });
        this.insertComDIEntryData(allDIEntryCol);
    }

    private void insertComDIEntryData(DynamicObjectCollection allDIEntryCol) {
        String comDIEntryEntity = "comdientryentity";
        if (!CollectionUtils.isEmpty((Collection)allDIEntryCol)) {
            int entryCount = this.getModel().getDataEntity(true).getDynamicObjectCollection(comDIEntryEntity).size();
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow(comDIEntryEntity, null, allDIEntryCol.size());
            this.getModel().endInit();
            for (int index = 0; index < allDIEntryCol.size(); ++index) {
                DynamicObject diEntryDyn = (DynamicObject)allDIEntryCol.get(index);
                this.getModel().setValue("comdi_implitem", (Object)((DynamicObject)diEntryDyn.getParent()).getLong("id"), entryCount + index);
                this.getModel().setValue("comdi_sourcesystem", diEntryDyn.get("sourcesystem"), entryCount + index);
                this.getModel().setValue("comdi_intservicetype", diEntryDyn.get("integrationservicetype"), entryCount + index);
                this.getModel().setValue("comdi_scheme", diEntryDyn.get("discheme"), entryCount + index);
                this.getModel().setValue("comdi_name", diEntryDyn.get("diname"), entryCount + index);
            }
            this.getView().updateView(comDIEntryEntity);
        }
    }

    @Override
    protected QFilter getImplItemF7QFilter(String entryEntity) {
        QFilter commonFilter = super.getImplItemF7QFilter(entryEntity);
        commonFilter.and(new QFilter("category", "=", (Object)"0"));
        commonFilter.and(new QFilter("initfordatasource", "=", (Object)ConvertUtils.toString((Object)this.getModel().getValue("initfordatasource"))));
        DynamicObject bizSubAreaDyn = (DynamicObject)this.getModel().getValue("bizsubarea");
        Long bizSubAreaId = Optional.ofNullable(bizSubAreaDyn).map(dyn -> dyn.getLong("id")).orElseGet(() -> 0L);
        if (bizSubAreaId > 0L) {
            commonFilter.and(new QFilter("bizsubarea.id", "=", (Object)bizSubAreaId));
        }
        return commonFilter;
    }

    private void initComposeImplItem() {
        if (HRStringUtils.equals((String)((String)this.getView().getFormShowParameter().getCustomParam("operate")), (String)"compose")) {
            String impItemIdStr = (String)this.getView().getFormShowParameter().getCustomParam("selectIdList");
            List implItemIdList = Arrays.stream(impItemIdStr.split(",")).map(Long::parseLong).collect(Collectors.toList());
            DynamicObject[] implItemDyns = this.iImplItemEntityService.queryImplItemsByIdList("group,bizsubarea,listseq,initfordatasource", implItemIdList);
            List implItemDynList = Arrays.stream(implItemDyns).sorted(Comparator.comparingInt(dyn -> dyn.getInt("listseq"))).collect(Collectors.toList());
            this.getModel().setValue("group", (Object)implItemDyns[0].getDynamicObject("group"));
            this.getModel().setValue("bizsubarea", (Object)implItemDyns[0].getDynamicObject("bizsubarea"));
            this.getModel().setValue("category", (Object)"1");
            if (HRStringUtils.equals((String)"A", (String)implItemDyns[0].getString("initfordatasource"))) {
                this.getModel().setValue("impltype", (Object)"A");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"i_enable"});
            } else {
                this.getModel().setValue("impltype", (Object)"B");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"i_category", "i_entity", "i_isinitlog", "i_mulfrontimpl", "comdipanel", "flexpanelap4", "flexpanelap7"});
            }
            this.getModel().setDataChanged(false);
            this.getModel().beginInit();
            if (implItemIdList.size() > 0) {
                this.getModel().batchCreateNewEntryRow("baseimplentry", null, implItemIdList.size());
            }
            for (int i = 0; i < implItemDynList.size(); ++i) {
                this.getModel().setValue("implitem", implItemDynList.get(i), i);
            }
            this.getModel().endInit();
            ComboEdit comboEdit = (ComboEdit)this.getControl("initfordatasource");
            comboEdit.setEnable("initfordatasource", false, 0);
        }
    }

    @Override
    public String getEntryImplItemField() {
        return "implitem";
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        EntryProp entryProp = e.getEntryProp();
        if (HRStringUtils.equals((String)entryProp.getName(), (String)"baseimplentry")) {
            DynamicObjectCollection baseImplEntryCol = this.getModel().getEntryEntity("baseimplentry");
            ArrayList delImplItemIdList = Lists.newArrayListWithCapacity((int)16);
            for (int rowIndex : e.getRowIndexs()) {
                DynamicObject entryDyn = (DynamicObject)baseImplEntryCol.get(rowIndex);
                DynamicObject implItemDyn = entryDyn.getDynamicObject("implitem");
                if (HricObjectUtils.isEmpty((Object)implItemDyn)) continue;
                delImplItemIdList.add(implItemDyn.getLong("id"));
            }
            this.deleteComDIEntry(delImplItemIdList);
        }
    }

    private void deleteComDIEntry(List<Long> delImplItemIdList) {
        if (CollectionUtils.isEmpty(delImplItemIdList)) {
            return;
        }
        ArrayList rowIndexList = Lists.newArrayListWithCapacity((int)16);
        DynamicObjectCollection comDIEntryCol = this.getModel().getEntryEntity("comdientryentity");
        for (int rowIndex = 0; rowIndex < comDIEntryCol.size(); ++rowIndex) {
            DynamicObject comDIEntryDyn = (DynamicObject)comDIEntryCol.get(rowIndex);
            Long comDiImplItemId = comDIEntryDyn.getDynamicObject("comdi_implitem").getLong("id");
            if (!delImplItemIdList.contains(comDiImplItemId)) continue;
            rowIndexList.add(rowIndex);
        }
        if (!CollectionUtils.isEmpty((Collection)rowIndexList)) {
            this.getModel().deleteEntryRows("comdientryentity", rowIndexList.stream().mapToInt(i -> i).toArray());
        }
    }
}

