/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class ImplItemDIEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("discheme");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourceSysEdit = (BasedataEdit)this.getView().getControl("sourcesystem");
        sourceSysEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElse("");
        if (HRStringUtils.equals((String)changeFieldName, (String)"sourcesystem")) {
            this.getModel().setValue("discheme", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"discheme")) {
            DynamicObject sourceSys = (DynamicObject)this.getModel().getValue("sourcesystem");
            if (sourceSys == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6765\u6e90\u7cfb\u7edf\u3002", (String)"ImplItemDIEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (HRStringUtils.equals((String)sourceSys.getString("number"), (String)"s-HR")) {
                this.handleQFilter(evt, true);
            } else {
                this.handleQFilter(evt, false);
            }
        } else if (HRStringUtils.equals((String)sourceName, (String)"sourcesystem")) {
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setOrderBy("index");
        }
    }

    private void handleQFilter(BeforeF7SelectEvent evt, boolean isAddQFilter) {
        ListShowParameter fp = (ListShowParameter)evt.getFormShowParameter();
        String diType = this.getModel().getValue("integrationservicetype").toString();
        if (HRStringUtils.equals((String)diType, (String)"isc_data_copy_trigger")) {
            fp.setBillFormId("isc_data_copy_trigger");
            this.addQFilter(fp, "data_copy.schema_category.longnumber", isAddQFilter);
        } else {
            fp.setBillFormId("isc_service_flow");
            this.addQFilter(fp, "classification.longnumber", isAddQFilter);
        }
    }

    private void addQFilter(ListShowParameter fp, final String field, boolean isAddQFilter) {
        if (!isAddQFilter) {
            return;
        }
        ListFilterParameter listFilterParameter = fp.getListFilterParameter();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(){
            {
                this.add(new QFilter(field, "like", (Object)"%KD_RC_sHR_XHHRIC_S%"));
            }
        };
        listFilterParameter.setQFilters((List)qFilters);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"confirm", (String)formOperate.getOperateKey())) {
            this.handleReturnDataToParent();
        }
    }

    private void handleReturnDataToParent() {
        HashMap<String, Object> pageInfoMap = new HashMap<String, Object>();
        pageInfoMap.put("sourcesystem", ((DynamicObject)this.getModel().getValue("sourcesystem")).getLong("id"));
        pageInfoMap.put("integrationservicetype", this.getModel().getValue("integrationservicetype").toString());
        pageInfoMap.put("discheme", this.getModel().getValue("discheme"));
        this.getView().returnDataToParent(pageInfoMap);
        this.getView().close();
    }
}

