/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.MulComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.ICooperativeDomainService;
import kd.hrmp.hric.bussiness.service.BizSubAreaServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.MicConfigServiceHelper;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.formplugin.web.ImplItemBaseEditPlugin;
import kd.hrmp.hric.formplugin.web.InitPermHelper;
import kd.hrmp.hric.formplugin.web.util.ImplItemFormUtils;

public class ImplItemEditPlugin
extends ImplItemBaseEditPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(ImplItemEditPlugin.class);
    private static final String BOS_ENTITYOBJECT = "bos_entityobject";
    ICooperativeDomainService iSystemParamDomainService = (ICooperativeDomainService)ServiceFactory.getService(ICooperativeDomainService.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        LOG.info("preOpenForm start");
        BaseShowParameter showParameter = Optional.ofNullable(e.getSource()).filter(BaseShowParameter.class::isInstance).map(it -> (BaseShowParameter)it).orElse(null);
        if (showParameter == null) {
            return;
        }
        showParameter.setListentimerElapsed(true);
        if (showParameter.getPkId() == null) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u5b9e\u65bd\u9879", (String)"ImplItemEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        } else {
            showParameter.setCaption(ResManager.loadKDString((String)"\u5b9e\u65bd\u9879\u8be6\u60c5", (String)"ImplItemEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)((String)showParameter.getCustomParam("operate")), (String)"compose")) {
            showParameter.setCaption(ResManager.loadKDString((String)"\u7ec4\u5408\u5b9e\u65bd\u9879", (String)"ImplItemEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
        LOG.info("preOpenForm start");
    }

    public void afterCreateNewData(EventObject e) {
        String currentNodeId = Optional.ofNullable(this.getView()).map(IFormView::getParentView).filter(IListView.class::isInstance).map(it -> (IListView)it).map(IListView::getTreeListView).map(ITreeListView::getTreeModel).map(ITreeModel::getCurrentNodeId).map(String::valueOf).orElse("");
        String[] ids = currentNodeId.split("\\#.{1}");
        if (ids.length > 1) {
            this.getModel().setValue("group", (Object)new HRBaseServiceHelper("hbss_hrbusinessfield").queryOne((Object)ids[1]));
        }
        if (ids.length > 2) {
            this.getModel().setValue("bizsubarea", (Object)new HRBaseServiceHelper("hric_bizsubarea").queryOne((Object)ids[2]));
        }
        this.setInitScene();
        this.settingAOrC();
        this.getModel().deleteEntryData("entryentity");
    }

    private void setEntryValue() {
        DynamicObjectCollection frontImpl = this.getModel().getDataEntity().getDynamicObjectCollection("mulfrontimpl");
        if (!CollectionUtils.isEmpty((Collection)frontImpl)) {
            List<Long> idList = frontImpl.stream().map(it -> it.getLong("fbasedataid_id")).collect(Collectors.toList());
            this.setEntryInfo("entryentity", "frontimplitem", idList);
        }
    }

    private void setInitScene() {
        MainEntityType mainType = this.getModel().getDataEntityType();
        MulComboProp comboProp = (MulComboProp)mainType.getProperties().get((Object)"usescene");
        List combodata = comboProp.getComboItems();
        StringBuilder value = new StringBuilder();
        for (int i = 0; i < combodata.size(); ++i) {
            value.append(((ValueMapItem)combodata.get(i)).getValue());
            if (i >= combodata.size() - 1) continue;
            value.append(",");
        }
        this.getModel().setValue("usescene", (Object)value.toString());
    }

    public void afterLoadData(EventObject e) {
        this.setEntryValue();
        DynamicObject dyc = this.getModel().getDataEntity().getDynamicObject("entityobjscope");
        if (dyc != null) {
            String entityNumber = Optional.ofNullable(dyc.getString("number")).orElse("");
            this.changeMicConfig(entityNumber);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"bizsubarea")) {
            Object id = Optional.ofNullable(this.getModel()).map(IDataModel::getDataEntity).map(it -> it.getDynamicObject("group")).map(it -> it.get("id")).orElse(null);
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("group", "=", id));
        } else if (HRStringUtils.equals((String)sourceName, (String)"entityobjscope")) {
            this.filterAppScope(evt);
        } else if (HRStringUtils.equals((String)sourceName, (String)"initimporttemplat")) {
            this.filterInitImportTemplate(evt);
        } else if (HRStringUtils.equals((String)sourceName, (String)"middletableconf")) {
            this.filterMiddleTable(evt);
        }
    }

    private void filterMiddleTable(BeforeF7SelectEvent evt) {
        DynamicObject dyc = (DynamicObject)this.getModel().getValue("entityobjscope");
        Set<Object> middleNumberSet = new HashSet();
        if (!ObjectUtils.isEmpty((Object)dyc)) {
            middleNumberSet = this.getTableSet(dyc.getString("number"));
        }
        FormShowParameter formShowParameter = evt.getFormShowParameter();
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7f13\u5b58\u8868", (String)"ImplItemEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        formShowParameter.setFormId("bos_listf7");
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("number", "in", (Object)middleNumberSet.toArray(new String[middleNumberSet.size()])));
    }

    private void filterAppScope(BeforeF7SelectEvent evt) {
        Object id = Optional.ofNullable(this.getModel()).map(IDataModel::getDataEntity).map(it -> it.getDynamicObject("bizsubarea")).map(it -> it.get("id")).orElse(null);
        HashSet appScopeSet = new HashSet();
        Object[] appScope = BizSubAreaServiceHelper.getAppScopeById(id);
        if (!HRArrayUtils.isEmpty((Object[])appScope)) {
            Arrays.stream(appScope).map(dyc -> dyc.getDynamicObjectCollection("appscope")).forEach(dyc -> dyc.forEach(dy -> appScopeSet.add(dy.getString("fbasedataid_id"))));
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        showParameter.setCustomParam("bizappids", (Object)SerializationUtils.toJsonString(appScopeSet));
    }

    private void filterInitImportTemplate(BeforeF7SelectEvent evt) {
        DynamicObject dyc = this.getModel().getDataEntity().getDynamicObject("entityobjscope");
        String number = "";
        if (!ObjectUtils.isEmpty((Object)dyc)) {
            number = Optional.ofNullable(dyc.getString("number")).orElse("");
        }
        ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("entityobjscope", "=", (Object)number));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("bizsubarea");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit_1 = (BasedataEdit)this.getView().getControl("entityobjscope");
        basedataEdit_1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid baseImplEntryGrid = (EntryGrid)this.getView().getControl("baseimplentry");
        baseImplEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid diEntryGrid = (EntryGrid)this.getView().getControl("dientryentity");
        diEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid comDiEntryGrid = (EntryGrid)this.getView().getControl("comdientryentity");
        comDiEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit basedataEdit_2 = (BasedataEdit)this.getView().getControl("initimporttemplat");
        basedataEdit_2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit_3 = (BasedataEdit)this.getView().getControl("middletableconf");
        basedataEdit_3.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName;
        switch (changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElse("")) {
            case "group": {
                this.getModel().setValue("bizsubarea", null);
                break;
            }
            case "bizsubarea": {
                this.getModel().setValue("entityobjscope", null);
            }
            case "entityobjscope": {
                this.setInfluencedValue();
                break;
            }
            case "impltype": {
                this.implTypePropertyChanged(this.getPropertyChangeNewValue(e));
                break;
            }
            case "initimporttemplat": {
                this.setMiddleTableVal();
                break;
            }
            case "middletableconf": {
                this.setImportTemplatVal();
                break;
            }
            case "initfordatasource": {
                this.initForDataSourcePropertyChanged(this.getPropertyChangeNewValue(e));
                break;
            }
            case "descforinput": {
                this.changeDescForCheckVal();
                break;
            }
        }
        this.getView().setVisible(Boolean.valueOf(this.iSystemParamDomainService.getParameterBoolean() && this.checkVerifyIsShow()), new String[]{"flexpanelap7"});
    }

    private void setMiddleTableVal() {
        DynamicObject dyc = this.getModel().getDataEntity().getDynamicObject("initimporttemplat");
        if (dyc == null) {
            this.getModel().setValue("middletableconf", null);
            return;
        }
        String midTableNumbr = dyc.getString("intermediatetable");
        DynamicObject midTable = new HRBaseServiceHelper(BOS_ENTITYOBJECT).queryOne(new QFilter[]{new QFilter("number", "=", (Object)midTableNumbr)});
        this.getModel().setValue("middletableconf", (Object)midTable);
    }

    private void setImportTemplatVal() {
        DynamicObject dyc = this.getModel().getDataEntity().getDynamicObject("middletableconf");
        if (dyc == null) {
            this.getModel().setValue("initimporttemplat", null);
            return;
        }
        this.getModel().setValue("initimporttemplat", (Object)InitTemplateServiceHelper.getInitTemplateByMidNumber((String)dyc.getString("number")));
    }

    private void changeDescForCheckVal() {
        String initForDataSource = this.getModel().getValue("initfordatasource").toString();
        String descForCheckVal = this.getModel().getValue("descforverification").toString();
        if (HRStringUtils.equals((String)initForDataSource, (String)"C") && HRStringUtils.isEmpty((String)descForCheckVal)) {
            this.getModel().setValue("descforverification", (Object)this.getModel().getValue("descforinput").toString());
        }
    }

    private void setInfluencedValue() {
        this.getModel().setValue("initimporttemplat", null);
        this.getModel().setValue("implclass", null);
        DynamicObject dyc = this.getModel().getDataEntity().getDynamicObject("entityobjscope");
        if (dyc == null) {
            return;
        }
        String number = Optional.ofNullable(dyc.getString("number")).orElse("");
        String dataSource = this.getModel().getDataEntity().getString("initfordatasource");
        if (HRStringUtils.equals((String)dataSource, (String)"A")) {
            this.changeInitImport(number);
            this.changeMiddleTable(number);
        }
        this.changeMicConfig(number);
    }

    private void setMiddleTable() {
        DynamicObject dyc;
        if (HRStringUtils.equals((String)this.getModel().getDataEntity().getString("initfordatasource"), (String)"A")) {
            this.getModel().setValue("middletableconf", null);
        }
        if ((dyc = this.getModel().getDataEntity().getDynamicObject("initimporttemplat")) != null) {
            this.setMiddleTableConf((Set<String>)new HashSet<String>(){
                {
                    this.add(dyc.getString("intermediatetable"));
                }
            });
        }
    }

    private String getPropertyChangeNewValue(PropertyChangedArgs e) {
        return Optional.ofNullable(e.getChangeSet()).filter(ArrayUtils::isNotEmpty).map(it -> it[0]).map(it -> it.getNewValue()).map(String::valueOf).orElse("");
    }

    private void initForDataSourcePropertyChanged(String newValue) {
        this.getModel().setValue("initformode", (Object)"");
        switch (newValue) {
            case "A": {
                this.settingInitForDataSourceA();
                break;
            }
            case "C": {
                this.settingInitForDataSourceC();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void settingInitForDataSourceC() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"initfordatasource", "flexpanelap4", "flexpanelap7"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entityobjscope", "initimporttemplat", "downloadicon", "downloadtemp", "middletableconf", "implclass"});
        ((BasedataEdit)this.getControl("entityobjscope")).setMustInput(false);
        ((BasedataEdit)this.getControl("initimporttemplat")).setMustInput(false);
        ((BasedataEdit)this.getControl("middletableconf")).setMustInput(false);
        ((TextEdit)this.getControl("descforinput")).setMustInput(true);
        this.setDefaultValue(Boolean.TRUE);
    }

    private void settingInitForDataSourceA() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"initfordatasource", "entityobjscope", "initimporttemplat", "downloadicon", "downloadtemp", "middletableconf", "implclass", "flexpanelap7"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        ((BasedataEdit)this.getControl("entityobjscope")).setMustInput(true);
        ((BasedataEdit)this.getControl("initimporttemplat")).setMustInput(true);
        ((BasedataEdit)this.getControl("middletableconf")).setMustInput(true);
        this.setDefaultValue(Boolean.FALSE);
    }

    private void implTypePropertyChanged(String newValue) {
        if (HRStringUtils.isEmpty((String)newValue)) {
            return;
        }
        this.getModel().setValue("implsubtype", (Object)(newValue + "01"));
        this.settingAdvconapShowAndHide(newValue);
    }

    private void settingAdvconapShowAndHide(String newValue) {
        this.getModel().setValue("initfordatasource", (Object)"");
        if (HRStringUtils.equals((String)newValue, (String)"A") || HRStringUtils.equals((String)newValue, (String)"C")) {
            this.settingAOrC();
        } else {
            this.settingB();
        }
    }

    private void settingAOrC() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"initfordatasource", "entityobjscope", "initimporttemplat", "downloadicon", "downloadtemp", "middletableconf", "implclass", "flexpanelap7"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
        ((TextEdit)this.getControl("descforinput")).setMustInput(false);
        ((BasedataEdit)this.getControl("entityobjscope")).setMustInput(true);
        ((BasedataEdit)this.getControl("initimporttemplat")).setMustInput(true);
        ((BasedataEdit)this.getControl("middletableconf")).setMustInput(true);
        this.setDefaultValue(Boolean.FALSE);
        this.getModel().setValue("initfordatasource", (Object)"A");
    }

    private void settingB() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"initfordatasource", "flexpanelap4", "flexpanelap7"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"entityobjscope", "initimporttemplat", "downloadicon", "downloadtemp", "middletableconf", "implclass"});
        ((BasedataEdit)this.getControl("entityobjscope")).setMustInput(false);
        ((BasedataEdit)this.getControl("middletableconf")).setMustInput(false);
        ((BasedataEdit)this.getControl("initimporttemplat")).setMustInput(false);
        ((TextEdit)this.getControl("descforinput")).setMustInput(true);
        this.setDefaultValue(Boolean.TRUE);
        this.getModel().setValue("initfordatasource", (Object)"C");
        this.lockDatasource(false);
    }

    private void lockDatasource(boolean isLock) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("initfordatasource");
        comboEdit.setEnable("initfordatasource", !isLock, 0);
    }

    private void setDefaultValue(boolean inutpageaddr) {
        ((TextEdit)this.getControl("inputpageaddr")).setMustInput(inutpageaddr);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (((Boolean)this.getModel().getValue("issyspreset")).booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save", "addentry", "delentry", "diaddentry", "didelentry", "checkvectorap", "inputvectorap", "labelap", "labelap4"});
        }
    }

    public void afterBindData(EventObject e) {
        boolean isPlanJump;
        super.afterBindData(e);
        DynamicObject dyc = this.getModel().getDataEntity();
        if (ObjectUtils.isEmpty((Object)dyc)) {
            return;
        }
        this.getView().setVisible(Boolean.valueOf(this.iSystemParamDomainService.getParameterBoolean() && this.checkVerifyIsShow()), new String[]{"flexpanelap7"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        boolean iscopy = this.getBoolParameter("iscopy");
        if (HRStringUtils.equals((String)status.name(), (String)OperationStatus.EDIT.name()) || HRStringUtils.equals((String)status.name(), (String)OperationStatus.VIEW.name())) {
            this.setPanelStatus(dyc);
        }
        if (iscopy) {
            this.setPanelStatus(dyc);
            this.afterLoadData(e);
        }
        if (isPlanJump = this.getBoolParameter("isPlanJump")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"addpageforinput", "addpageforcheck", "addentry", "delentry", "diaddentry", "didelentry"});
        }
    }

    private boolean checkVerifyIsShow() {
        return !HRStringUtils.equals((String)ConvertUtils.toString((Object)this.getModel().getValue("initfordatasource")), (String)"C") || !HRStringUtils.equals((String)ConvertUtils.toString((Object)this.getModel().getValue("category")), (String)"1");
    }

    private boolean getBoolParameter(String name) {
        return Optional.ofNullable((Boolean)this.getView().getFormShowParameter().getCustomParam(name)).orElse(false);
    }

    private void setPanelStatus(DynamicObject dyc) {
        this.setInitImplLogPanel(dyc);
        switch (dyc.getString("initfordatasource")) {
            case "A": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap4"});
                this.setMustInput(Boolean.TRUE, "entityobjscope", "initimporttemplat", "middletableconf");
                break;
            }
            case "C": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"entityobjscope", "initimporttemplat", "downloadicon", "downloadtemp", "middletableconf", "implclass"});
                this.setMustInput(Boolean.TRUE, "descforinput", "inputpageaddr");
                if (!HRStringUtils.equals((String)"1", (String)ConvertUtils.toString((Object)this.getModel().getValue("category")))) break;
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"i_category", "i_entity", "i_isinitlog", "i_mulfrontimpl", "comdipanel", "flexpanelap4", "flexpanelap7"});
                break;
            }
        }
    }

    private void setInitImplLogPanel(DynamicObject dyc) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("initimpllog");
        listShowParameter.setFormId("hric_innerlist");
        listShowParameter.setBillFormId("hric_initimpllog");
        listShowParameter.setCustomParam("id", (Object)dyc.getLong("id"));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        switch (operateKey = formOp.getOperateKey()) {
            case "save": {
                if (InitPermHelper.hasNotPermission("4715a0df000000ac", this.getView(), "hric_implitem")) {
                    args.setCancel(true);
                    return;
                }
                this.setFrontImplItem();
                if (this.getModel().getValue("middletableconf") != null) break;
                this.setMiddleTable();
                break;
            }
            case "downloadtemp": {
                this.downloadTemp();
                args.setCancel(true);
                break;
            }
            case "addentry": {
                this.showImplItemF7("entryentity");
                args.setCancel(true);
                break;
            }
            case "diaddentry": {
                args.setCancel(true);
                this.addDIService();
                break;
            }
        }
    }

    private void setFrontImplItem() {
        List pkIdList = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").stream().map(it -> it.getLong("frontimplitem_id")).collect(Collectors.toList());
        List mulFrontImplIdList = this.getModel().getDataEntity().getDynamicObjectCollection("mulfrontimpl").stream().map(it -> it.getLong("fbasedataid_id")).collect(Collectors.toList());
        if (!mulFrontImplIdList.equals(pkIdList)) {
            this.getModel().setValue("mulfrontimpl", (Object)pkIdList.toArray());
        }
    }

    private void addDIService() {
        Object bizSubArea = this.getModel().getValue("bizsubarea");
        if (ObjectUtils.isEmpty((Object)bizSubArea)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u5b50\u9886\u57df\u3002", (String)"ImplItemEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hric_implitemdi");
        showParameter.setCustomParam("bizsubareanumber", (Object)((DynamicObject)bizSubArea).getString("number"));
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        style.setInlineStyleCss(css);
        showParameter.setOpenStyle(style);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "diServiceAddCallback"));
        this.getView().showForm(showParameter);
    }

    private void downloadTemp() {
        DynamicObject implDy = this.getModel().getDataEntity().getDynamicObject("initimporttemplat");
        if (Objects.isNull(implDy)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5bfc\u5165\u6a21\u7248\u4e3a\u7a7a\u3002", (String)"ImplItemEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        String billFormId = implDy.getString("intermediatetable");
        if (Objects.isNull(billFormId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5bfc\u5165\u6a21\u7248\u6ca1\u6709\u5173\u8054\u5bf9\u5e94\u7684\u5143\u6570\u636e\u5b9e\u4f53\u3002", (String)"ImplItemEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        InitTemplateServiceHelper.downloadTempExcel((String)billFormId, (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"entryentity") && closedCallBackEvent.getReturnData() != null) {
            ImplItemFormUtils.handleImplItemF7Callback(this.getView(), "entryentity", "frontimplitem", closedCallBackEvent);
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"frontImplModifyCallback")) {
            this.refreshEntry();
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"diServiceAddCallback") && closedCallBackEvent.getReturnData() != null) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            this.addEntry(returnData);
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"baseImplItemModifyCallback")) {
            this.refreshEntry("baseimplentry", "implitem");
        }
    }

    private void addEntry(Map<String, Object> returnData) {
        Long sourceSys = (Long)returnData.get("sourcesystem");
        if (this.checkDiSchemeIsAdd(sourceSys)) {
            DynamicObject diScheme = (DynamicObject)returnData.get("discheme");
            TableValueSetter vs = this.getTableValueSetter();
            vs.addRow(new Object[]{sourceSys, returnData.get("integrationservicetype"), diScheme.getLong("id"), diScheme.getLocaleString("name").getLocaleValue()});
            this.getModel().beginInit();
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.batchCreateNewEntryRow("dientryentity", vs);
            this.getModel().endInit();
            this.getView().updateView("dientryentity");
        }
    }

    private boolean checkDiSchemeIsAdd(Long sourceSys) {
        DynamicObjectCollection diSchemes = this.getModel().getEntryEntity("dientryentity");
        for (DynamicObject dyc : diSchemes) {
            DynamicObject entitySourceSys = dyc.getDynamicObject("sourcesystem");
            if (sourceSys.longValue() != entitySourceSys.getLong("id")) continue;
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\uff1a\u5df2\u914d\u7f6e\u96c6\u6210\u670d\u52a1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ImplItemEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), entitySourceSys.getLocaleString("name")));
            return false;
        }
        return true;
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("sourcesystem", new Object[0]);
        vs.addField("integrationservicetype", new Object[0]);
        vs.addField("discheme", new Object[0]);
        vs.addField("diname", new Object[0]);
        return vs;
    }

    private void setMustInput(Boolean isMust, String ... args) {
        String[] values = args;
        Arrays.stream(values).forEach(value -> {
            if (this.getControl((String)value) instanceof FieldEdit) {
                ((FieldEdit)this.getControl((String)value)).setMustInput(isMust.booleanValue());
            }
        });
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if (HRStringUtils.equals((String)fieldName, (String)"f_name")) {
            this.frontImplItemHyperLink(evt);
        } else if (HRStringUtils.equals((String)fieldName, (String)"discheme")) {
            this.diServiceHyperLink(evt);
        } else if (HRStringUtils.equals((String)fieldName, (String)"comdi_scheme")) {
            this.comDiServiceHyperLink(evt);
        } else if (HRStringUtils.equals((String)fieldName, (String)"i_name")) {
            this.showImplItemForm(evt.getRowIndex(), "baseimplentry", "implitem", "baseImplItemModifyCallback");
        }
    }

    private void diServiceHyperLink(HyperLinkClickEvent evt) {
        this.showDiServicePage(evt, "dientryentity", "integrationservicetype", "discheme");
    }

    private void comDiServiceHyperLink(HyperLinkClickEvent evt) {
        this.showDiServicePage(evt, "comdientryentity", "comdi_intservicetype", "comdi_scheme");
    }

    private void showDiServicePage(HyperLinkClickEvent evt, String entryEntity, String diTypeField, String diSchemeField) {
        BillShowParameter showParameter;
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection dys = dataEntity.getDynamicObjectCollection(entryEntity);
        DynamicObject diScheme = (DynamicObject)dys.get(evt.getRowIndex());
        String diType = diScheme.getString(diTypeField);
        long pkId = diScheme.getDynamicObject(diSchemeField).getLong("id");
        String pageId = SessionManager.getCurrent().get(this.getView().getPageId() + pkId + "");
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new BillShowParameter();
            showParameter.setPkId((Object)pkId);
            if (HRStringUtils.equals((String)diType, (String)"isc_service_flow")) {
                showParameter.setFormId("isc_service_flow");
            } else if (HRStringUtils.equals((String)diType, (String)"isc_data_copy_trigger")) {
                showParameter.setFormId("isc_data_copy_trigger");
            }
            showParameter.setStatus(OperationStatus.VIEW);
            SessionManager.getCurrent().put(this.getView().getPageId() + pkId + "", showParameter.getPageId());
        } else {
            showParameter = (BillShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
        }
        showParameter.getOpenStyle().setClientShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void frontImplItemHyperLink(HyperLinkClickEvent evt) {
        this.showImplItemForm(evt.getRowIndex(), "entryentity", "frontimplitem", "frontImplModifyCallback");
    }

    private void showImplItemForm(int rowIndex, String entryEntity, String implItemField, String callBackActionId) {
        Optional<Long> idOp = Optional.ofNullable(this.getModel()).map(it -> it.getDataEntity(true)).map(it -> it.getDynamicObjectCollection(entryEntity)).map(it -> (DynamicObject)it.get(rowIndex)).map(it -> it.getDynamicObject(implItemField)).map(it -> it.getLong("id"));
        if (!idOp.isPresent()) {
            LOG.warn("no data exists, current row: {}, entry count: {}", (Object)rowIndex, (Object)this.getModel().getDataEntity().getDynamicObjectCollection(entryEntity).size());
            return;
        }
        ImplItemFormUtils.showImplItemForm(this.getView(), idOp.get(), OperationStatus.EDIT, new CloseCallBack((IFormPlugin)this, callBackActionId));
    }

    private void refreshEntry() {
        this.refreshEntry("entryentity", "frontimplitem");
    }

    private void refreshEntry(String entryEntity, String implItemField) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryEntity);
        List<Long> idList = collection.stream().map(it -> it.getDynamicObject(implItemField)).map(it -> it.getLong("id")).collect(Collectors.toList());
        this.getModel().deleteEntryData(entryEntity);
        this.setEntryInfo(entryEntity, implItemField, idList);
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setSkipNoField(true);
        IFormView formView = this.getView().getParentView();
        if (formView instanceof ListView) {
            formView.invokeOperation("refresh");
            this.getView().sendFormAction(formView);
        }
    }

    private void changeInitImport(String number) {
        this.getModel().setValue("initimporttemplat", null);
        Object[] dynamicObjects = InitTemplateServiceHelper.getTemplateListByAppScope((String)number);
        if (dynamicObjects.length > 1) {
            return;
        }
        if (!ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            this.getModel().setValue("initimporttemplat", dynamicObjects[0]);
        }
    }

    private void changeMicConfig(String entityNumber) {
        this.getModel().setValue("implclass", (Object)MicConfigServiceHelper.getImplementNameByAppScope((String)entityNumber));
    }

    private void changeMiddleTable(String number) {
        this.getModel().setValue("middletableconf", null);
        Set<String> middleNumberSet = this.getTableSet(number);
        Object[] entityObjects = new HRBaseServiceHelper(BOS_ENTITYOBJECT).query(new QFilter[]{new QFilter("number", "in", middleNumberSet)});
        if (entityObjects.length > 1) {
            return;
        }
        if (!ObjectUtils.isEmpty((Object[])entityObjects)) {
            this.getModel().setValue("middletableconf", entityObjects[0]);
        }
    }

    private void setMiddleTableConf(Set<String> middleNumberSet) {
        this.getModel().setValue("middletableconf", null);
        DynamicObject[] entityObjects = new HRBaseServiceHelper(BOS_ENTITYOBJECT).query(new QFilter[]{new QFilter("number", "in", middleNumberSet)});
        if (entityObjects.length == 1) {
            this.getModel().setValue("middletableconf", (Object)entityObjects[0]);
        }
    }

    private Set<String> getTableSet(String number) {
        HashSet<String> middleNumberSet = new HashSet<String>();
        HashSet resultSet = new HashSet();
        DynamicObject[] dataByAppScopeNumbers = InitTemplateServiceHelper.getDataByAppScopeNumber((String)number);
        Arrays.stream(dataByAppScopeNumbers).forEach(data -> {
            if (data.get("id").equals(this.getModel().getValue("initimporttemplat"))) {
                resultSet.add(data.getString("intermediatetable"));
            }
            middleNumberSet.add(data.getString("intermediatetable"));
        });
        return resultSet.size() == 0 ? middleNumberSet : resultSet;
    }

    @Override
    protected QFilter getImplItemF7QFilter(String entryEntity) {
        QFilter qFilter = QFilterUtils.getEnableQFilter();
        qFilter.and(super.getImplItemF7QFilter(entryEntity));
        return qFilter;
    }

    @Override
    public String getEntryImplItemField() {
        return "frontimplitem";
    }
}

