/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.formplugin.web.StructurePagePlugin;
import kd.hrmp.hric.formplugin.web.util.InitFormUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ImplItemLinkPageEditPlugin
extends StructurePagePlugin {
    private int tempCount = 1;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dyc = this.getModel().getDataEntity();
        if (ObjectUtils.isEmpty((Object)dyc)) {
            return;
        }
        if (dyc.getBoolean("issyspreset")) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        this.loadlinkPanel(dyc.getString("inputpageaddr"), "input");
        this.loadlinkPanel(dyc.getString("checkpageaddr"), "check");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (HRStringUtils.equals((String)status.name(), (String)OperationStatus.EDIT.name()) || HRStringUtils.equals((String)status.name(), (String)OperationStatus.VIEW.name())) {
            this.setLockField();
        }
    }

    private void setLockField() {
        DynamicObject subBizArea = (DynamicObject)this.getModel().getValue("bizsubarea");
        if (!InitPlanServiceHelper.isUpdateBaseField((long)subBizArea.getLong("id"))) {
            InitFormUtils.lockField(false, this.getControl("group"));
            InitFormUtils.lockField(false, this.getControl("bizsubarea"));
            InitFormUtils.lockField(false, this.getControl("entityobjscope"));
            InitFormUtils.lockField(false, this.getControl("initfordatasource"));
            InitFormUtils.lockField(false, this.getControl("impltype"));
        }
    }

    private void loadlinkPanel(String pageaddr, String type) {
        if (HRStringUtils.isEmpty((String)pageaddr)) {
            return;
        }
        this.getPageCache().put(type + "MenuPageCache", pageaddr);
        Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)pageaddr, Map.class);
        linkPageMaps.remove("maxcount");
        ArrayList<Pair<String, String>> menuList = new ArrayList<Pair<String, String>>();
        linkPageMaps.values().forEach(map -> menuList.add(Pair.of(map.get("key"), map.get("value"))));
        if (!CollectionUtils.isEmpty(menuList)) {
            this.addLinkPanel(menuList, type, Boolean.FALSE);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"inputvectorap", "checkvectorap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"save")) {
            DynamicObject dyc = this.getModel().getDataEntity();
            this.delOldValue(dyc);
        }
    }

    private void delOldValue(DynamicObject dyc) {
        switch (dyc.getString("initfordatasource")) {
            case "A": {
                this.setValue("descforinput", "inputpageaddr");
                break;
            }
            case "C": {
                this.setValue("entityobjscope", "initimporttemplat", "middletableconf", "implclass");
                break;
            }
            default: {
                return;
            }
        }
    }

    private void setValue(String ... args) {
        String[] values = args;
        Arrays.stream(values).forEach(value -> this.getModel().setValue(value, null));
    }

    public void click(EventObject e) {
        super.click(e);
        String opKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            opKey = ((Control)source).getKey();
        }
        String keyType = opKey.substring(0, 5);
        if (opKey.endsWith("vectorap")) {
            this.showF7(keyType);
        } else if (opKey.contains("iconap_del")) {
            this.removeQuickLaunchFromView(opKey, keyType, keyType + "linkpanel");
        } else if (opKey.contains("iconap")) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("pageResource", "implitem");
            params.put("pageLinkType", "");
            this.openPage(opKey, keyType, params);
        }
    }

    private void showF7(String keyType) {
        FormShowParameter fsp = new FormShowParameter();
        if (!HRStringUtils.isEmpty((String)this.getPageCache().get(keyType + "MenuPageCache"))) {
            fsp.setCustomParam("menuMap", (Object)SerializationUtils.toJsonString(this.getCurrConfigMap(keyType)));
        }
        fsp.setShowTitle(true);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setFormId("bos_quicklaunchconfig");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, keyType + "linkPageConfigCallBack"));
        this.getView().getFormShowParameter().setAppId(null);
        this.getView().showForm(fsp);
    }

    private void removeQuickLaunchFromView(String key, String type, String panel) {
        String num = key.substring(15);
        Container c = (Container)this.getView().getControl(panel);
        c.deleteControls(new String[]{type + "iflexpanel" + num});
        this.delCacheAndPageFieldData(num, type + "MenuPageCache", type + "pageaddr");
    }

    private void delCacheAndPageFieldData(String num, String cache, String addr) {
        String pageCache = this.getPageCache().get(cache);
        if (HRStringUtils.isNotEmpty((String)pageCache)) {
            Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)pageCache, Map.class);
            linkPageMaps.remove(num);
            linkPageMaps.remove("maxcount");
            if (!CollectionUtils.isEmpty((Map)linkPageMaps)) {
                final String max = linkPageMaps.keySet().stream().max(Comparator.naturalOrder()).orElse("");
                linkPageMaps.put("maxcount", new HashMap<String, String>(){
                    {
                        this.put("key", "maxcount");
                        this.put("value", max);
                    }
                });
            }
            String dataStr = SerializationUtils.toJsonString((Object)linkPageMaps);
            this.getPageCache().put(cache, HRStringUtils.equals((String)dataStr, (String)"{}") ? null : dataStr);
            this.getModel().setValue(addr, (Object)(HRStringUtils.equals((String)dataStr, (String)"{}") ? null : dataStr));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        this.getView().getFormShowParameter().setAppId("hric");
        super.closedCallBack(e);
        String actionId = e.getActionId();
        List retDatas = (List)e.getReturnData();
        if (CollectionUtils.isEmpty((Collection)retDatas)) {
            return;
        }
        ArrayList<Pair<String, String>> menuList = new ArrayList<Pair<String, String>>();
        retDatas.forEach(data -> {
            if (data.containsKey("cache_linkUrl")) {
                menuList.add(Pair.of(data.get("cache_linkTitle"), (Object)this.linkUrlInit((Map<String, String>)data)));
            } else {
                menuList.add(Pair.of(data.get("cache_sel_appId"), data.get("cache_sel_menuId")));
            }
        });
        if ("inputlinkPageConfigCallBack".equals(actionId)) {
            ArrayList<Pair<String, String>> menuListCopy = new ArrayList<Pair<String, String>>(menuList.size());
            menuListCopy.addAll(menuList);
            Set<Pair<String, String>> inputPageLinkSet = this.pageLinkCache2Set(this.getPageCache().get("inputMenuPageCache"));
            Set<Pair<String, String>> checkPageLinkSet = this.pageLinkCache2Set(this.getPageCache().get("checkMenuPageCache"));
            this.addLinkPanel(menuList, "input", Boolean.TRUE);
            if (checkPageLinkSet.size() == AppConstants.INT_FIVE.intValue()) {
                return;
            }
            this.autoFillCheckPageLink(menuListCopy, inputPageLinkSet, checkPageLinkSet);
        } else if ("checklinkPageConfigCallBack".equals(actionId)) {
            this.addLinkPanel(menuList, "check", Boolean.TRUE);
        }
    }

    private String linkUrlInit(Map<String, String> dataMap) {
        HashMap<String, String> extUrlMap = new HashMap<String, String>();
        String cacheLinkUrl = dataMap.get("cache_linkUrl");
        String cacheLinkIcon = dataMap.get("cache_linkIcon");
        if (HRStringUtils.isNotEmpty((String)cacheLinkUrl)) {
            extUrlMap.put("pageUrl", cacheLinkUrl.toUpperCase(Locale.ROOT));
        }
        if (HRStringUtils.isNotEmpty((String)cacheLinkIcon)) {
            extUrlMap.put("imgUrl", cacheLinkIcon);
        }
        return JSONObject.toJSONString(extUrlMap);
    }

    private void autoFillCheckPageLink(List<Pair<String, String>> menuListCopy, Set<Pair<String, String>> inputPageLinkSet, Set<Pair<String, String>> checkPageLinkSet) {
        if (!CollectionUtils.isEmpty(checkPageLinkSet)) {
            menuListCopy = this.removeDuplication(menuListCopy, inputPageLinkSet);
        }
        this.addLinkPanel(menuListCopy, "check", Boolean.TRUE);
    }

    Set<Pair<String, String>> pageLinkCache2Set(String cacheStr) {
        if (HRStringUtils.isNotEmpty((String)cacheStr)) {
            Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)cacheStr, Map.class);
            linkPageMaps.remove("maxcount");
            LinkedHashSet<Pair<String, String>> cacheLinkSet = new LinkedHashSet<Pair<String, String>>(linkPageMaps.size());
            for (Map.Entry entry : linkPageMaps.entrySet()) {
                cacheLinkSet.add((Pair<String, String>)Pair.of(((Map)entry.getValue()).get("key"), ((Map)entry.getValue()).get("value")));
            }
            return cacheLinkSet;
        }
        return new LinkedHashSet<Pair<String, String>>();
    }

    private List<Pair<String, String>> checkRetDatas(List<Pair<String, String>> menuList, String type, boolean isDb) {
        String cacheValue = this.getPageCache().get(type + "MenuPageCache");
        Map linkPageMaps = new HashMap();
        if (HRStringUtils.isNotEmpty((String)cacheValue)) {
            linkPageMaps = (Map)SerializationUtils.fromJsonString((String)cacheValue, Map.class);
        }
        if (!ObjectUtils.isEmpty(linkPageMaps)) {
            List<String> countList = linkPageMaps.keySet().stream().collect(Collectors.toList());
            countList.remove("maxcount");
            Container c = (Container)this.getView().getControl(type + "linkpanel");
            countList.forEach(count -> c.deleteControls(new String[]{type + "iflexpanel" + count}));
            this.getPageCache().remove(type + "MenuPageCache");
            if (isDb) {
                this.getModel().setValue(type + "pageaddr", null);
            }
            linkPageMaps.remove("maxcount");
            LinkedHashSet<Pair<String, String>> cacheLinkSet = new LinkedHashSet<Pair<String, String>>(linkPageMaps.size());
            for (Map.Entry entry : linkPageMaps.entrySet()) {
                cacheLinkSet.add((Pair<String, String>)Pair.of(((Map)entry.getValue()).get("key"), ((Map)entry.getValue()).get("value")));
            }
            menuList = this.removeDuplication(menuList, cacheLinkSet);
        }
        if (menuList.size() > 5) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u9875\u9762\u94fe\u63a5\u6700\u591a\u53ef\u914d\u7f6e5\u4e2a\u3002\u8d85\u51fa\u90e8\u5206\u5df2\u81ea\u52a8\u5ffd\u7565\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ImplItemLinkPageEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            return menuList.subList(0, 5);
        }
        return menuList;
    }

    private List<Pair<String, String>> removeDuplication(List<Pair<String, String>> menuList, Set<Pair<String, String>> cacheLinkSet) {
        LinkedHashSet<Pair<String, String>> menuLinkSet = new LinkedHashSet<Pair<String, String>>(menuList);
        Set cacheMenuIdSet = cacheLinkSet.stream().map(menu -> ((String)menu.getValue()).toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        Iterator it = menuLinkSet.iterator();
        while (it.hasNext()) {
            Pair link = (Pair)it.next();
            if (!cacheMenuIdSet.contains(((String)link.getValue()).toUpperCase(Locale.ROOT))) continue;
            it.remove();
        }
        cacheLinkSet.addAll(menuLinkSet);
        return new ArrayList<Pair<String, String>>(cacheLinkSet);
    }

    private void addLinkPanel(List<Pair<String, String>> menuList, String type, boolean isDb) {
        if (CollectionUtils.isEmpty(menuList)) {
            return;
        }
        ArrayList list = new ArrayList(menuList.size());
        HashMap<String, Map<String, String>> pageMap = new HashMap<String, Map<String, String>>();
        String pageaddr = this.getPageCache().get(type + "MenuPageCache");
        if (HRStringUtils.isNotEmpty((String)pageaddr)) {
            this.findMaxCount(pageaddr);
        }
        menuList = this.checkRetDatas(menuList, type, isDb);
        menuList.forEach(menuPair -> {
            FlexPanelAp flexAp;
            if (((String)menuPair.getValue()).contains("pageUrl")) {
                pageMap.put(this.tempCount + "", new HashMap<String, String>(){
                    {
                        this.put("key", menuPair.getKey());
                        this.put("value", menuPair.getValue());
                    }
                });
                flexAp = this.createFlexAp(type, menuPair, null, this.tempCount++, this.getView());
            } else {
                AppMenuInfo appMenuInfo = this.getAppMenuInfo((Pair<String, String>)menuPair);
                pageMap.put(this.tempCount + "", new HashMap<String, String>(){
                    {
                        this.put("key", menuPair.getKey());
                        this.put("value", menuPair.getValue());
                    }
                });
                flexAp = this.createFlexAp(type, null, appMenuInfo, this.tempCount++, this.getView());
            }
            list.add(flexAp.createControl());
        });
        Container c = (Container)this.getView().getControl(type + "linkpanel");
        c.addControls(list);
        this.createOrUpdateCacheAndDb(pageMap, type, isDb);
    }

    private AppMenuInfo getAppMenuInfo(Pair<String, String> menuPair) {
        AppMenuInfo appMenuInfo = AppMetadataCache.getAppMenuInfo((String)((String)menuPair.getKey()), (String)((String)menuPair.getValue()).toUpperCase(Locale.ROOT));
        if (appMenuInfo == null) {
            appMenuInfo = AppMetadataCache.getAppMenuInfo((String)((String)menuPair.getKey()), (String)((String)menuPair.getValue()).toLowerCase(Locale.ROOT));
        }
        if (appMenuInfo == null) {
            appMenuInfo = AppMetadataCache.getAppMenuInfo((String)((String)menuPair.getKey()), (String)((String)menuPair.getValue()));
        }
        return appMenuInfo;
    }

    private void findMaxCount(String pageaddr) {
        Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)pageaddr, Map.class);
        String s = (String)((Map)linkPageMaps.get("maxcount")).get("value");
        int count = "".equals(s) ? 1 : Integer.parseInt(s);
        this.tempCount = count + 1;
    }

    private void createOrUpdateCacheAndDb(Map<String, Map<String, String>> pageMap, String type, boolean isDb) {
        String s = this.getPageCache().get(type + "MenuPageCache");
        if (isDb && HRStringUtils.isNotEmpty((String)s)) {
            Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)s, Map.class);
            linkPageMaps.remove("maxcount");
            pageMap.putAll(linkPageMaps);
        }
        final Integer max = pageMap.keySet().stream().map(Integer::new).max(Comparator.naturalOrder()).orElse(0);
        pageMap.put("maxcount", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("key", "maxcount");
                this.put("value", String.valueOf(max));
            }
        });
        String dataStr = SerializationUtils.toJsonString(pageMap);
        this.getPageCache().put(type + "MenuPageCache", HRStringUtils.equals((String)dataStr, (String)"{}") ? null : dataStr);
        if (isDb) {
            this.getModel().setValue(type + "pageaddr", (Object)(HRStringUtils.equals((String)dataStr, (String)"{}") ? null : dataStr));
        }
    }

    private Map<String, String> getCurrConfigMap(String type) {
        String pageCache = this.getPageCache().get(type + "MenuPageCache");
        if (HRStringUtils.isEmpty((String)pageCache)) {
            return null;
        }
        HashMap<String, String> currConfigMap = new HashMap<String, String>();
        Map linkPageMaps = (Map)SerializationUtils.fromJsonString((String)pageCache, Map.class);
        linkPageMaps.values().forEach(linkPage -> {
            if (!((String)linkPage.get("value")).toLowerCase().contains("http") && !HRStringUtils.equals((String)((String)linkPage.get("key")), (String)"maxcount")) {
                currConfigMap.put(((String)linkPage.get("value")).toLowerCase(), (String)linkPage.get("key"));
            }
        });
        return currConfigMap;
    }
}

