/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IImplItemDomainService;

public class ImplItemListPlugin
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(ImplItemListPlugin.class);
    private String ERR_TIP = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"ImplItemListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ERR_TIP_DETAIL = ResManager.loadKDString((String)"%1$s\uff0c%2$s\u5df2\u7ecf\u6709\u53ef\u7528\u7684\u5b9e\u65bd\u9879\u9009\u62e9\uff0c\u4e0d\u80fd\u542f\u7528", (String)"ImplItemListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private final IImplItemDomainService iImplItemDomainService = (IImplItemDomainService)ServiceFactory.getService(IImplItemDomainService.class);

    public void setFilter(SetFilterEvent e) {
        e.setOrderBy("enable desc,listseq asc,number desc");
        super.setFilter(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (!"enable".equals(operateKey) && "compose".equals(operateKey)) {
            this.composeOperation(args);
        }
    }

    private void composeOperation(BeforeDoOperationEventArgs args) {
        List<Long> selectIdList = this.getSelectedIdList();
        String validateMsg = this.iImplItemDomainService.validateComposeOperation(selectIdList);
        if (HRStringUtils.isNotEmpty((String)validateMsg)) {
            this.getView().showTipNotification(validateMsg);
            args.setCancel(true);
            return;
        }
        this.openComposeImplItemPage(selectIdList);
    }

    private void openComposeImplItemPage(List<Long> selectIdList) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("hric_implitem");
        parameter.setCustomParam("operate", (Object)"compose");
        parameter.setCustomParam("selectIdList", (Object)selectIdList.stream().map(String::valueOf).collect(Collectors.joining(",")));
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private List<Long> getSelectedIdList() {
        return this.getSelectedRows().stream().map(it -> (Long)it.getPrimaryKeyValue()).filter(id -> id > 0L).collect(Collectors.toList());
    }
}

