/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Optional;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.service.BizSubAreaServiceHelper;
import kd.hrmp.hric.common.util.ConvertUtils;

public class InitBizParamsEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getParentView().getFormShowParameter().getCustomParams().containsKey("menulist")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"paramtype", "mulcombotext"});
        }
        this.setValueMustInput();
        this.analyzeComBoText();
        this.getModel().setDataChanged(false);
    }

    public void afterCreateNewData(EventObject e) {
        String s = Optional.ofNullable(this.getView()).map(IFormView::getParentView).filter(IListView.class::isInstance).map(it -> (IListView)it).map(IListView::getTreeListView).map(ITreeListView::getTreeModel).map(ITreeModel::getCurrentNodeId).map(String::valueOf).orElse("");
        String[] ids = s.split("\\#.{1}");
        if (ids.length > 1) {
            this.getModel().setValue("group", (Object)new HRBaseServiceHelper("hbss_hrbusinessfield").queryOne((Object)ids[1]));
        }
        if (ids.length > 2) {
            this.getModel().setValue("bizsubarea", (Object)new HRBaseServiceHelper("hric_bizsubarea").queryOne((Object)ids[2]));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit group = (BasedataEdit)this.getView().getControl("group");
        group.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit baseDataEdit = (BasedataEdit)this.getView().getControl("bizsubarea");
        baseDataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit baseDataEdit2 = (BasedataEdit)this.getView().getControl("entityobjscope");
        baseDataEdit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    private void setValueMustInput() {
        String paramType;
        switch (paramType = ConvertUtils.toString((Object)this.getModel().getValue("paramtype"))) {
            case "A": {
                ((FieldEdit)this.getView().getControl("checkboxfield")).setMustInput(true);
                break;
            }
            case "B": {
                ((FieldEdit)this.getView().getControl("mulcombofield")).setMustInput(true);
                ((FieldEdit)this.getView().getControl("mulcombotext")).setMustInput(true);
                break;
            }
            case "C": {
                ((FieldEdit)this.getView().getControl("textfield")).setMustInput(true);
            }
        }
    }

    private void analyzeComBoText() {
        String mulComBoText = ConvertUtils.toString((Object)this.getModel().getValue("mulcombotext"));
        if (HRStringUtils.isEmpty((String)mulComBoText)) {
            this.getModel().setValue("mulcombofield", (Object)"");
            return;
        }
        if ((mulComBoText = mulComBoText.trim()).indexOf(":") < 0 || mulComBoText.length() < 3) {
            this.getModel().setValue("mulcombofield", (Object)"");
            return;
        }
        String[] items = mulComBoText.split("\n");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(items.length);
        for (String item : items) {
            String[] elements = item.split(":");
            if (elements.length < 2) continue;
            ComboItem comboItem = new ComboItem(new LocaleString(elements[0]), elements[1]);
            comboItems.add(comboItem);
        }
        ((ComboEdit)this.getView().getControl("mulcombofield")).setComboItems(comboItems);
        this.getView().updateView("mulcombofield");
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElseGet(() -> "");
        if (HRStringUtils.equals((String)changeFieldName, (String)"paramtype")) {
            this.setValueMustInput();
        } else if (HRStringUtils.equals((String)changeFieldName, (String)"mulcombotext")) {
            this.analyzeComBoText();
        } else if (HRStringUtils.equals((String)changeFieldName, (String)"group")) {
            this.getModel().setValue("bizsubarea", null);
        } else if (HRStringUtils.equals((String)changeFieldName, (String)"bizsubarea")) {
            this.getModel().setValue("entityobjscope", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"bizsubarea")) {
            Object id = Optional.ofNullable(this.getModel()).map(IDataModel::getDataEntity).map(it -> it.getDynamicObject("group")).map(it -> it.get("id")).orElse(null);
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("group", "=", id));
        } else if (HRStringUtils.equals((String)sourceName, (String)"group")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "group"));
        } else if (HRStringUtils.equals((String)sourceName, (String)"entityobjscope")) {
            this.filterAppScope(evt);
        }
    }

    private void filterAppScope(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object id = Optional.ofNullable(this.getModel()).map(IDataModel::getDataEntity).map(it -> it.getDynamicObject("bizsubarea")).map(it -> it.get("id")).orElse(null);
        HashSet appScopeSet = new HashSet();
        Object[] appScope = BizSubAreaServiceHelper.getAppScopeById(id);
        if (!HRArrayUtils.isEmpty((Object[])appScope)) {
            Arrays.stream(appScope).map(dyc -> dyc.getDynamicObjectCollection("appscope")).forEach(dyc -> dyc.forEach(dy -> appScopeSet.add(dy.getString("fbasedataid_id"))));
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u5b9e\u4f53\u5bf9\u8c61", (String)"InitBizParamsEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        showParameter.setCustomParam("bizappids", (Object)SerializationUtils.toJsonString(appScopeSet));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"group") && null != (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) {
            this.getModel().setValue("bizsubarea", null);
            this.getModel().setValue("group", returnData.get(0).getPrimaryKeyValue());
        }
    }
}

