/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.param.AppParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hr.hbp.formplugin.web.HRExactMatchBasedataListDataProvider;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IDataClearDomainService;
import kd.hrmp.hric.bussiness.service.factory.ThreadPoolFactory;
import kd.hrmp.hric.common.util.ConvertUtils;
import org.apache.commons.lang3.StringUtils;

public class InitDataClearListPlugin
extends HRDataBaseList {
    private IDataClearDomainService iDataClearDomainService = (IDataClearDomainService)ServiceFactory.getService(IDataClearDomainService.class);
    private String CLEAR_MESSAGE = ResManager.loadKDString((String)"\u6e05\u7406\u9009\u4e2d\u7684\u5bf9\u8c61\uff1f", (String)"InitDataClearListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String CLEAR_MESSAGE_TWO = ResManager.loadKDString((String)"\u6570\u636e\u6e05\u7406\u5df2\u6267\u884c\uff0c\u8bf7\u67e5\u8be2\u6267\u884c\u65e5\u5fd7\u3002", (String)"InitDataClearListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final String METADATA_CLEAR_SCHEM_NUMBER = "CL_00001_S";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"manualexecution")) {
            this.getView().showConfirm(this.CLEAR_MESSAGE, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("manualexecution", (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)operateKey, (String)"viewexcutelog")) {
            this.showLogForm(args);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"manualexecution") && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.getView().showMessage(this.CLEAR_MESSAGE_TWO);
            List selectedIdList = ((ListView)this.getView()).getSelectedRows().stream().map(it -> ConvertUtils.toLong((Object)it.getPrimaryKeyValue())).collect(Collectors.toList());
            ThreadPoolFactory.getCommonExecutor().execute(() -> this.iDataClearDomainService.clear(selectedIdList));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"isclear", "clearstatus"});
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new DataClearListDataProvider());
    }

    private void showLogForm(AfterDoOperationEventArgs args) {
        long primaryKeyValue = ConvertUtils.toLong(args.getOperationResult().getSuccessPkIds().get(0));
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hric_dtclrlogform");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", (Object)primaryKeyValue);
        this.getView().showForm(parameter);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List columns = args.getListColumns();
        if (!this.getRecordChanged()) {
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                IListColumn column = (IListColumn)it.next();
                if (!StringUtils.equals((CharSequence)column.getListFieldKey(), (CharSequence)"viewexcutelog")) continue;
                it.remove();
            }
        }
    }

    private boolean getRecordChanged() {
        String isopen;
        ListShowParameter listShowParameter;
        Map params;
        Map<String, Object> systemParam = this.getConfigParams();
        boolean isRecordChange = false;
        if (!Objects.isNull(systemParam.get("changecheck"))) {
            isRecordChange = (Boolean)systemParam.get("changecheck");
        }
        if (!CollectionUtils.isEmpty((Map)(params = (Map)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"getParamByEntity", (Object[])new Object[]{(listShowParameter = (ListShowParameter)this.getView().getFormShowParameter()).getBillFormId()}))) && StringUtils.equals((CharSequence)(isopen = (String)params.get("isopen")), (CharSequence)"1")) {
            isRecordChange = (Boolean)params.get("changecheck");
        }
        return isRecordChange;
    }

    private Map<String, Object> getConfigParams() {
        long orgId = RequestContext.get().getOrgId() == 0L ? 100000L : RequestContext.get().getOrgId();
        AppParam appParam = new AppParam("XYRL3+A8Z+Z", Long.valueOf(orgId));
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
    }

    private class DataClearListDataProvider
    extends HRExactMatchBasedataListDataProvider {
        private DataClearListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection list = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)list)) {
                return list;
            }
            ((DynamicObject)list.get(0)).getDynamicObjectType().addProperty((DynamicProperty)new DynamicSimpleProperty("entryentity.clearstrategy", String.class, (Object)""));
            for (DynamicObject dynamicObject : list) {
                if (HRStringUtils.equals((String)dynamicObject.getString("number"), (String)InitDataClearListPlugin.METADATA_CLEAR_SCHEM_NUMBER)) {
                    dynamicObject.set("entryentity.clearstrategy", (Object)(dynamicObject.getBoolean("isclear") ? ResManager.loadKDString((String)"\u6e05\u7406", (String)"InitDataClearListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u6e05\u7406", (String)"InitDataClearListPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0])));
                    continue;
                }
                if (dynamicObject.getLong("entryentity.id") == 0L) continue;
                dynamicObject.set("entryentity.clearstrategy", (Object)InitDataClearListPlugin.this.iDataClearDomainService.getDataClearStrategy(Long.valueOf(dynamicObject.getLong("entryentity.id"))));
            }
            InitDataClearListPlugin.this.iDataClearDomainService.clearStrategyCache();
            return list;
        }
    }
}

