/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hric.bussiness.service.InitExecTaskService;
import kd.hrmp.hric.bussiness.service.common.FormService;
import kd.hrmp.hric.bussiness.service.impl.InitExecTaskServiceImpl;
import kd.hrmp.hric.common.constants.InitExecTaskConstants;
import kd.hrmp.hric.common.util.DateUtils;
import kd.hrmp.hric.formplugin.web.InitPermHelper;

public class InitExecTaskListPlugin
extends HRDataBaseList {
    private static Log LOG = LogFactory.getLog(InitExecTaskListPlugin.class);
    private static final Set<String> MODIFY_PERMISSION_BTN = ImmutableSet.of((Object)"retry", (Object)"discard");
    private Map<String, Consumer<AfterDoOperationEventArgs>> afterDoOperationMap = Maps.newHashMap();
    private InitExecTaskService initExecTaskService = new InitExecTaskServiceImpl();
    private static final String FORCE_DISCARD = "force_discard";
    private static final String FORCE_DISCARD_CONFIRM_CALLBACK = "force_discard_confirm_callback";

    public InitExecTaskListPlugin() {
        this.afterDoOperationMap.put("retry", event -> this.doRetryTask((AfterDoOperationEventArgs)event));
        this.afterDoOperationMap.put("discard", event -> this.doDiscardTask((AfterDoOperationEventArgs)event));
        this.afterDoOperationMap.put(FORCE_DISCARD, event -> this.doForceDiscardTask((AfterDoOperationEventArgs)event));
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        Long pid;
        super.setFilter(setFilterEvent);
        String pidStr = this.getPageCache().get("pid");
        if (HRStringUtils.isEmpty((String)pidStr)) {
            Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("batchnumber");
            String operateType = (String)this.getView().getFormShowParameter().getCustomParam("operatetype");
            QFilter taskIdFilter = new QFilter("batchnumber", "=", (Object)taskId);
            QFilter operateTypeFilter = new QFilter("operatetype", "=", (Object)operateType);
            pid = new InitExecTaskServiceImpl().getLastestTaskId(taskIdFilter.and(operateTypeFilter).toArray());
        } else {
            pid = Long.valueOf(pidStr);
        }
        if (pid != null && pid > 0L) {
            this.getPageCache().put("pid", pid.toString());
            setFilterEvent.addCustomQFilter(this.getPidAndIdFilter(pid));
        }
        setFilterEvent.setOrderBy("id asc");
    }

    private QFilter getPidAndIdFilter(Long pid) {
        QFilter idFilter = new QFilter("id", "=", (Object)pid);
        QFilter pidFilter = new QFilter("pid", "=", (Object)pid);
        return idFilter.or(pidFilter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        this.afterDoOperationMap.getOrDefault(eventArgs.getOperateKey(), event -> {}).accept(eventArgs);
    }

    private void doRetryTask(AfterDoOperationEventArgs event) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List taskIdList = null;
        ArrayList retryList = null;
        if (selectedRows != null && selectedRows.size() > 0) {
            taskIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(id -> (Long)id).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = this.initExecTaskService.queryExecTaskByIdList(taskIdList);
            retryList = this.getCanRetryTask(dynamicObjects);
            if (retryList.isEmpty()) {
                return;
            }
        } else {
            String pid = this.getPageCache().get("pid");
            Long batchNumber = (Long)this.getView().getFormShowParameter().getCustomParam("batchnumber");
            QFilter qFilter = this.getPidAndIdFilter(Long.valueOf(pid));
            QFilter statusFilter = new QFilter("taskstatus", "in", (Object)InitExecTaskConstants.RETRY_TASKSTATUS_LIST);
            Object[] dynamicObjects = this.initExecTaskService.queryExecTaskByIdList(qFilter.and(statusFilter));
            retryList = Lists.newArrayList((Object[])dynamicObjects);
        }
        if (retryList.isEmpty()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u91cd\u8bd5\u6570\u636e\u3002", (String)"InitExecTaskListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        if (this.hasRetryTimeError(retryList)) {
            return;
        }
        if (this.initExecTaskService.retry((List)retryList)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u8bd5\u6210\u529f", (String)"InitExecTaskListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
            return;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91cd\u8bd5\u5931\u8d25", (String)"InitExecTaskListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
    }

    private boolean hasRetryTimeError(List<DynamicObject> retryList) {
        boolean hasError = false;
        Date now = new Date();
        for (DynamicObject dy : retryList) {
            Date startDate = dy.getDate("lastretrytime");
            Long subMillisecond = DateUtils.getSubMilliSecond((Date)startDate, (Date)now);
            if (Objects.isNull(subMillisecond) || subMillisecond == 0L || subMillisecond >= (long)InitExecTaskConstants.RETRY_WAIT_MILLISECOND.intValue()) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u907f\u514d\u9891\u7e41\u64cd\u4f5c\uff0c\u6bcf\u6b21\u4e8b\u52a1\u91cd\u8bd5\u95f4\u969410\u79d2\u3002", (String)"InitExecTaskListPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return true;
        }
        return hasError;
    }

    private void doForceDiscardTask(AfterDoOperationEventArgs event) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List taskIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(id -> (Long)id).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.initExecTaskService.queryExecTaskByIdList(taskIdList);
        boolean hasNotProcessing = Stream.of(dynamicObjects).anyMatch(dy -> !"A".equals(dy.getString("taskstatus")));
        if (hasNotProcessing) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u4e8b\u52a1\u72b6\u6001\u4e3a\u7b49\u5f85\u4e2d\u3001\u5904\u7406\u4e2d\u7684\u624d\u80fd\u5f3a\u5236\u7ec8\u6b62\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InitExecTaskListPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        List preHandleList = Stream.of(dynamicObjects).filter(dy -> {
            Long subMinute;
            Date startTime = dy.getDate("taskstarttime");
            Date lastRetryTime = dy.getDate("lastretrytime");
            if (lastRetryTime != null) {
                startTime = HRDateTimeUtils.dateDiff((Date)startTime, (Date)lastRetryTime) > 0L ? startTime : lastRetryTime;
            }
            return (subMinute = DateUtils.getSubMinute((Date)startTime, (Date)new Date())) >= 10L;
        }).collect(Collectors.toList());
        if (dynamicObjects.length != preHandleList.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e8b\u52a1\u8fdb\u884c\u4e2d\uff0c\u8bf710\u5206\u949f\u540e\u518d\u8bd5\u3002", (String)"InitExecTaskListPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener forceDiscardConfirmCallbackListener = new ConfirmCallBackListener(FORCE_DISCARD_CONFIRM_CALLBACK, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4e8b\u52a1\u8fdb\u884c\u4e2d\uff0c\u5f3a\u5236\u7ec8\u6b62\u53ef\u80fd\u4f1a\u5bfc\u81f4\u521d\u59cb\u5316\u4e2d\u5fc3\u4e0e\u4e1a\u52a1\u6570\u636e\u72b6\u6001\u4e0d\u4e00\u81f4\uff0c\u662f\u5426\u5f3a\u5236\u7ec8\u6b62\u4e8b\u52a1\uff1f", (String)"InitExecTaskListPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, ConfirmTypes.Default, forceDiscardConfirmCallbackListener);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.openLargeMsgForm(args);
    }

    private void openLargeMsgForm(HyperLinkClickArgs args) {
        BillList source = (BillList)args.getHyperLinkClickEvent().getSource();
        FormService.getInstance().openLargeText(source.getEntityId(), "result", this.getView(), source.getFocusRowPkId());
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)FORCE_DISCARD_CONFIRM_CALLBACK) && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            try {
                List taskIdList = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).map(id -> (Long)id).collect(Collectors.toList());
                DynamicObject[] dynamicObjects = this.initExecTaskService.queryExecTaskByIdList(taskIdList);
                this.initExecTaskService.discardExecTask(Arrays.asList(dynamicObjects));
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"InitExecTaskListPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            }
            catch (KDBizException ex) {
                LOG.error((Throwable)ex);
                this.getView().showErrorNotification(ex.getMessage());
            }
        }
    }

    private void doDiscardTask(AfterDoOperationEventArgs event) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List taskIdList = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).map(id -> (Long)id).collect(Collectors.toList());
        DynamicObject[] dynamicObjects = this.initExecTaskService.queryExecTaskByIdList(taskIdList);
        List preHandleList = Stream.of(dynamicObjects).filter(dy -> HRStringUtils.equals((String)dy.getString("taskstatus"), (String)"G")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(preHandleList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u6709\u670d\u52a1\u5f02\u5e38\u7684\u6570\u636e\u53ef\u4ee5\u88ab\u7ec8\u6b62\u3002", (String)"InitExecTaskListPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        try {
            this.initExecTaskService.discardExecTask(preHandleList);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f", (String)"InitExecTaskListPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
        catch (KDBizException ex) {
            LOG.error((Throwable)ex);
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private List<DynamicObject> getCanRetryTask(DynamicObject[] dynamicObjects) {
        ArrayList retryTaskList = Lists.newArrayList();
        for (DynamicObject task : dynamicObjects) {
            if (InitExecTaskConstants.RETRY_TASKSTATUS_LIST.contains(task.getString("taskstatus"))) {
                retryTaskList.add(task);
                continue;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u72b6\u6001\u4e0d\u662f\u7b49\u5f85\u4e2d\u3001\u5904\u7406\u4e2d\u3001\u5df2\u53cd\u9988\u548c\u670d\u52a1\u5f02\u5e38\uff0c\u4e0d\u7528\u91cd\u8bd5\u3002", (String)"InitExecTaskListPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[]{task.getLong("id")}));
        }
        return retryTaskList;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String opreateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (!this.checkBosBtnPermission(opreateKey)) {
            args.setCancel(true);
            return;
        }
    }

    private boolean checkBosBtnPermission(String operateKey) {
        if (MODIFY_PERMISSION_BTN.contains(operateKey)) {
            return !InitPermHelper.hasNotPermission("4715a0df000000ac", this.getView(), "hric_inittask");
        }
        if ("refresh".equals(operateKey)) {
            return !InitPermHelper.hasNotPermission("47150e89000000ac", this.getView(), "hric_inittask");
        }
        return true;
    }
}

