/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.TelephoneField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.common.bean.InitMiddleField;
import kd.hrmp.hric.common.constants.InitMidTableModifyConstants;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.ControlUtils;
import kd.hrmp.hric.common.util.ConvertUtils;

public class InitMidBatchModifyEditPlugin
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(InitMidBatchModifyEditPlugin.class);

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String fieldName;
        if ("fieldnames".equals(propertyChangedArgs.getProperty().getName()) && !HRStringUtils.isEmpty((String)(fieldName = propertyChangedArgs.getChangeSet()[0].getNewValue().toString()))) {
            InitMiddleField fieldInfo;
            String showField;
            String fieldNameFieldTypeMapStr = this.getPageCache().get("fieldNumberFieldInfoMap");
            Map fieldNumberFieldInfoMap = Maps.newHashMapWithExpectedSize((int)16);
            try {
                fieldNumberFieldInfoMap = (Map)HRJSONUtils.cast((String)fieldNameFieldTypeMapStr, Map.class);
            }
            catch (Exception e) {
                LOG.error("InitMidBatchModifyEditPlugin  propertyChanged error{}", (Object)e.getMessage());
            }
            if (!CollectionUtils.isEmpty((Map)fieldNumberFieldInfoMap) && !HRStringUtils.isEmpty((String)(showField = (fieldInfo = (InitMiddleField)JSONObject.parseObject((String)JSONObject.toJSONString(fieldNumberFieldInfoMap.get(fieldName)), InitMiddleField.class)).getFieldType().toLowerCase()))) {
                String oldField;
                InitMiddleField hideFieldInfo;
                String hideFieldName;
                this.getModel().setValue("showfield", (Object)showField);
                this.getModel().setValue("textlength", (Object)fieldInfo.getLength());
                FieldEdit fieldEdit = (FieldEdit)this.getControl(showField);
                fieldEdit.setCaption(fieldInfo.getFieldName());
                if (ComboField.class.getSimpleName().equals(fieldInfo.getFieldType())) {
                    ArrayList itemList = Lists.newArrayListWithCapacity((int)fieldInfo.getItemList().size());
                    for (kd.bos.metadata.entity.commonfield.ComboItem cItem : fieldInfo.getItemList()) {
                        ComboItem comboItem = new ComboItem();
                        comboItem.setValue(cItem.getValue());
                        comboItem.setCaption(cItem.getCaption());
                        itemList.add(comboItem);
                    }
                    ((ComboEdit)fieldEdit).setComboItems((List)itemList);
                }
                if (propertyChangedArgs.getChangeSet()[0].getOldValue() != null && !HRStringUtils.isEmpty((String)propertyChangedArgs.getChangeSet()[0].getOldValue().toString()) && !HRStringUtils.isEmpty((String)(hideFieldName = (hideFieldInfo = (InitMiddleField)JSONObject.parseObject((String)JSONObject.toJSONString(fieldNumberFieldInfoMap.get(oldField = propertyChangedArgs.getChangeSet()[0].getOldValue().toString())), InitMiddleField.class)).getFieldType().toLowerCase()))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{hideFieldName});
                }
                this.getView().setVisible(Boolean.TRUE, new String[]{showField});
                this.getView().updateView();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if ("batch_save".equals(((DefaultEntityOperate)beforeDoOperationEventArgs.getSource()).getOperateKey())) {
            this.checkFieldLength(beforeDoOperationEventArgs);
            FormShowParameter showParameter = this.getView().getFormShowParameter();
            Object primaryKeys = showParameter.getCustomParam("primaryKeys");
            Object dataFormId = showParameter.getCustomParam("dataFormId");
            OperateOption option = ((DefaultEntityOperate)beforeDoOperationEventArgs.getSource()).getOption();
            option.setVariableValue("primaryKeys", primaryKeys.toString());
            option.setVariableValue("dataFormId", dataFormId.toString());
        }
    }

    private void checkFieldLength(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        String showField = ConvertUtils.toString((Object)this.getModel().getValue("showfield"));
        int textLen = ConvertUtils.toInteger((Object)this.getModel().getValue("textlength"));
        if (InitMidTableModifyConstants.TEXT_FIELD_LIST.contains(showField)) {
            String value = this.getModel().getValue(showField).toString();
            if (HRStringUtils.isEmpty((String)value)) {
                return;
            }
            try {
                boolean sign;
                int length = value.getBytes("UTF-8").length;
                boolean bl = sign = Integer.compare(textLen, length) < 0;
                if (this.getModel().getValue(showField) instanceof OrmLocaleValue) {
                    OrmLocaleValue ormLocaleValue = (OrmLocaleValue)this.getModel().getValue(showField);
                    sign = ormLocaleValue.entrySet().stream().anyMatch(it -> Integer.compare(textLen, ((String)it.getValue()).length()) < 0);
                }
                if (sign) {
                    this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8f93\u5165\u957f\u5ea6\u8d85\u957f\uff0c\u6700\u5927\u957f\u5ea6\uff1a%1$s\u3002", (String)"InitMidBatchModifyEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), textLen));
                    beforeDoOperationEventArgs.setCancel(true);
                }
            }
            catch (UnsupportedEncodingException e) {
                LOG.error("InitMidBatchModifyEditPlugin  checkFieldLength error{}", (Object)e.getMessage());
                throw new KDHricException(e.getMessage());
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult operationResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("batch_save") && HRStringUtils.isNotEmpty((String)(operationResult = afterDoOperationEventArgs.getOperationResult()).getMessage())) {
            this.getView().returnDataToParent((Object)operationResult.getMessage());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object dataFormId = showParameter.getCustomParam("dataFormId");
        this.getModel().setValue("data_formid", dataFormId);
    }

    public void createNewData(BizDataEventArgs e) {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object dataFormId = showParameter.getCustomParam("dataFormId");
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>();
        ComboEdit comboEdit = (ComboEdit)this.getControl("fieldnames");
        if (dataFormId != null) {
            List<EntityItem<?>> entityItemList = InitMidBatchModifyEditPlugin.getEntityItems(dataFormId.toString());
            HashMap fieldNumberFieldInfoMap = Maps.newHashMapWithExpectedSize((int)entityItemList.size());
            for (EntityItem<?> entityItem : entityItemList) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(entityItem.getName());
                comboItem.setValue(entityItem.getKey());
                itemList.add(comboItem);
                InitMiddleField fieldInfo = this.getFieldType(entityItem);
                fieldNumberFieldInfoMap.put(entityItem.getKey(), fieldInfo);
            }
            comboEdit.setComboItems(itemList);
            this.getPageCache().put("fieldNumberFieldInfoMap", JSONObject.toJSONString((Object)fieldNumberFieldInfoMap));
            this.getView().setVisible(Boolean.FALSE, InitMidTableModifyConstants.MIDDLE_BATCH_MODIFY_FIELD_LIST.toArray(new String[0]));
        }
    }

    private InitMiddleField getFieldType(EntityItem<?> entityItem) {
        InitMiddleField fieldInfo = new InitMiddleField();
        String fieldType = "";
        if (entityItem instanceof BigIntField) {
            fieldType = BigIntField.class.getSimpleName();
        } else if (entityItem instanceof IntegerField) {
            fieldType = IntegerField.class.getSimpleName();
        } else if (entityItem instanceof DecimalField) {
            fieldType = DecimalField.class.getSimpleName();
        } else if (entityItem instanceof LargeTextField) {
            fieldType = LargeTextField.class.getSimpleName();
            fieldInfo.setLength(Integer.valueOf(((LargeTextField)entityItem).getMaxLength()));
        } else if (entityItem instanceof DateField) {
            fieldType = DateField.class.getSimpleName();
        } else if (entityItem instanceof MuliLangTextField) {
            fieldType = MuliLangTextField.class.getSimpleName();
            fieldInfo.setLength(Integer.valueOf(((MuliLangTextField)entityItem).getMaxLength()));
        } else if (entityItem instanceof TimeField) {
            fieldType = TimeField.class.getSimpleName();
        } else if (entityItem instanceof CheckBoxField) {
            fieldType = CheckBoxField.class.getSimpleName();
        } else if (entityItem instanceof ComboField) {
            fieldType = ComboField.class.getSimpleName();
            fieldInfo.setItemList(((ComboField)entityItem).getItems());
        } else if (entityItem instanceof TextField) {
            fieldType = TextField.class.getSimpleName();
            fieldInfo.setLength(Integer.valueOf(((TextField)entityItem).getMaxLength()));
        } else if (entityItem instanceof DateTimeField) {
            fieldType = DateTimeField.class.getSimpleName();
        } else if (entityItem instanceof TelephoneField) {
            fieldType = TelephoneField.class.getSimpleName();
        }
        if ("hricsourcesys".equals(entityItem.getKey())) {
            fieldType = BasedataField.class.getSimpleName();
        }
        fieldInfo.setFieldType(fieldType);
        fieldInfo.setFieldName(entityItem.getName());
        return fieldInfo;
    }

    private static List<EntityItem<?>> getEntityItems(String number) {
        List newItemList = ControlUtils.getAllEntityItems((String)number);
        List<String> modifyCommonFieldList = Arrays.asList("initbatchnumber", "initstatus", "initerrormsg", "hrictaskid", "hricbizid", "hriccreater", "hriccreatedate", "hricmodifier", "hricmodifydate");
        return newItemList.stream().filter(dy -> !modifyCommonFieldList.contains(dy.getKey()) && !dy.getKey().equals(number)).collect(Collectors.toList());
    }
}

