/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hric.common.constants.msg.MidTableMsgEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InitMiddleTemplateExportListPlugin
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(InitMiddleTemplateExportListPlugin.class);
    private static int MAX_EXPORT_SIZE = 20000;
    private List<String> errorList = null;

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("exportlist".equals(formOperate.getOperateKey()) && this.getExportDataCount() > MAX_EXPORT_SIZE) {
            this.getView().showErrorNotification(MidTableMsgEnum.MAX_EXPORT_SIZE.getMsg());
            args.setCancel(true);
        }
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        String[] fieldArray = HRStringUtils.split((String)e.getSelectFields(), (String)",");
        Set fieldSet = Arrays.stream(fieldArray).collect(Collectors.toSet());
        fieldSet.add("initerrormsg");
        e.setSelectFields(fieldSet.stream().collect(Collectors.joining(",")));
    }

    public void setFilter(SetFilterEvent e) {
        if (this.isErrorDataExport()) {
            IListView listview = (IListView)this.getView();
            BillList billList = (BillList)listview.getControl("billlistap");
            String listDataCountPrefix = String.format("%s_%s", billList.getKey(), "bdc");
            String description = String.format("%s_%s", billList.getKey(), "dc");
            this.getView().getPageCache().remove(listDataCountPrefix);
            this.getView().getPageCache().remove(description);
            e.getQFilters().add(this.getErrorMsgFilter(this.getPageCache().get("errorStatus")));
        }
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        String midTableEntityName = e.getMainEntityType().getDisplayName().toString();
        int hricIndex = midTableEntityName.indexOf("hric_");
        if (hricIndex >= 0) {
            midTableEntityName = midTableEntityName.substring(0, hricIndex);
        }
        String fileName = midTableEntityName + "_" + e.getFileName();
        if (this.isErrorDataExport()) {
            fileName = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25_%s", (String)"InitMiddleTemplateExportListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), fileName);
        }
        e.setFileName(fileName);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        List exportQueryDataList = Arrays.stream(e.getQueryValues()).map(it -> it.getString("initerrormsg")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(this.errorList)) {
            this.errorList = exportQueryDataList;
        } else {
            this.errorList.addAll(exportQueryDataList);
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        XSSFWorkbook wb = null;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        if (file != null && !CollectionUtils.isEmpty(this.errorList)) {
            try {
                fis = new FileInputStream(file);
                wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                short columnNum = sheet.getRow(2).getLastCellNum();
                sheet.shiftColumns(0, columnNum - 1, 1);
                for (int i = 0; i < 3; ++i) {
                    sheet.getRow(i).createCell(0).setCellValue("");
                }
                sheet.getRow(3).createCell(0).setCellValue(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u9519\u8bef\u4fe1\u606f\u3002", (String)"InitMiddleTemplateExportListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                for (int index = 0; index < this.errorList.size(); ++index) {
                    sheet.getRow(index + 4).createCell(0).setCellValue(this.errorList.get(index));
                }
                fos = new FileOutputStream(file);
                wb.write((OutputStream)fos);
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                throw new KDHricException("export file exception");
            }
            finally {
                if (wb != null) {
                    try {
                        wb.close();
                    }
                    catch (IOException ex) {
                        LOG.error("wb close IOException:", (Object)ex.getMessage());
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ex) {
                        LOG.error("fis close IOException:", (Object)ex.getMessage());
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ex) {
                        LOG.error("fos close IOException:", (Object)ex.getMessage());
                    }
                }
            }
        }
    }

    private int getExportDataCount() {
        int exportDataCount = 0;
        int selectedRowCount = ((ListView)this.getView()).getSelectedRows().size();
        exportDataCount = selectedRowCount > 0 ? selectedRowCount : ((BillList)this.getView().getControl("billlistap")).queryBillDataCount();
        return exportDataCount;
    }

    private QFilter getErrorMsgFilter(String errorStatus) {
        Long startId = Long.parseLong(this.getPageCache().get("startId"));
        Long endId = Long.parseLong(this.getPageCache().get("endId"));
        QFilter qFilter = new QFilter("initstatus", "=", (Object)errorStatus);
        qFilter.and(new QFilter("id", ">=", (Object)startId));
        qFilter.and(new QFilter("id", "<=", (Object)endId));
        return qFilter;
    }

    private boolean isErrorDataExport() {
        String errorStatus = this.getPageCache().get("errorStatus");
        return HRStringUtils.isNotEmpty((String)errorStatus);
    }
}

