/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeExportFileEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.ConfigurationUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IBaseConfigDomainService;
import kd.hrmp.hric.bussiness.domain.init.IInitTaskDomainService;
import kd.hrmp.hric.bussiness.domain.init.IMidTableDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPromptboxDomainService;
import kd.hrmp.hric.bussiness.service.ImplItemListDaoHelper;
import kd.hrmp.hric.bussiness.service.InitMidTableServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskCountServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.bussiness.service.common.FormService;
import kd.hrmp.hric.bussiness.service.task.handle.BizValidatePageHandle;
import kd.hrmp.hric.bussiness.service.task.handle.InitValidatePageHandle;
import kd.hrmp.hric.bussiness.service.task.handle.MidTableHandleInfo;
import kd.hrmp.hric.bussiness.service.task.handle.RollbackInitDataHandle;
import kd.hrmp.hric.bussiness.service.task.handle.SyncBizTablePageHandle;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.bo.ExecTaskCallbackBo;
import kd.hrmp.hric.common.constants.InitMiddleTemplateConstants;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.common.util.InitOperationResultUtils;
import kd.hrmp.hric.formplugin.web.InitPermHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class InitMiddleTemplateListPlugin
extends HRDataBaseList {
    private Long taskId = 123456789123456789L;
    private boolean isDevMode = ConfigurationUtil.getBoolean((String)"hr.init.dev.mode", (Boolean)false);
    private static List<String> BTN_LIST_ONE = Lists.newArrayList((Object[])new String[]{"bizvalidation1", "initvalidate1", "syncbiz1"});
    private String MID_TOP_TIPS = ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u6210\u529f\u5e9f\u5f03%2$s\u6761\uff0c\u5931\u8d25\u5e9f\u5f03%3$s\u6761\u3002", (String)"InitMiddleTemplateListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MID_TOP_TIPS_THREE = ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\uff1a\u53ea\u80fd\u5e9f\u5f03\u540c\u6b65\u6210\u529f\u3001\u66f4\u65b0\u4e3a\u5df2\u9a8c\u8bc1\u6210\u529f\u3001\u66f4\u65b0\u4e3a\u5df2\u5b8c\u6210\u6210\u529f\u4ee5\u5916\u7684\u6570\u636e\u3002", (String)"InitMiddleTemplateListPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MID_TOP_TIPS_TWO = ResManager.loadKDString((String)"\u5e9f\u5f03\u5931\u8d25", (String)"InitMiddleTemplateListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MID_SUC_TIPS = ResManager.loadKDString((String)"\u5e9f\u5f03\u6210\u529f", (String)"InitMiddleTemplateListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String DESCRIPTION_TIP_TITLE = ResManager.loadKDString((String)"\u6a21\u677f\u63cf\u8ff0", (String)"InitMiddleTemplateListPlugin_11", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String DESCRIPTION_TIP_CONTENT = ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e", (String)"InitMiddleTemplateListPlugin_12", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String DI_TIPS = ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u96c6\u6210\u5931\u8d25\u3002", (String)"InitMiddleTemplateListPlugin_15", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final Set<String> ROLLBACK_PROCESSING_BTN_STATUS = ImmutableSet.of((Object)"retry", (Object)"rollback");
    private int rollbackCount = 0;
    private static final String IS_SHOW_DISCARDDETAILPAGE = "isShowDiscardDetailPage";
    private static final String START_PROGRESS = "startprogress";
    private IInitTaskDomainService iInitTaskDomainService = (IInitTaskDomainService)ServiceFactory.getService(IInitTaskDomainService.class);
    private IMidTableDomainService iMidTableDomainService = (IMidTableDomainService)ServiceFactory.getService(IMidTableDomainService.class);
    private final IPromptboxDomainService iPromptboxDomainService = (IPromptboxDomainService)ServiceFactory.getService(IPromptboxDomainService.class);

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        if (!this.isShowDiscardDetailPage()) {
            event.getQFilters().add(new QFilter("initstatus", "!=", (Object)OperateEnum.DISCARD.getSuccessStatus()));
            event.setOrderBy("initbatchnumber desc,id asc");
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.isDevMode) {
            return;
        }
        FormOperate formOperate = (FormOperate)args.getSource();
        if (!this.checkBosBtnPermission(formOperate.getOperateKey())) {
            args.setCancel(true);
            return;
        }
        if (!this.checkOperationAccess(formOperate.getOperateKey())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u65e0\u6cd5\u6267\u884c\u6b64\u64cd\u4f5c\u3002", (String)"InitMiddleTemplateListPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        IFormView formView = this.getView().getParentView();
        if (!this.checkPermission()) {
            args.setCancel(true);
            return;
        }
        String isStart = (String)HricCacheUtils.get((String)(this.getParentPageId() + RequestContext.get().getCurrUserId() + START_PROGRESS), String.class);
        if (HRStringUtils.isNotEmpty((String)isStart) && HRStringUtils.equals((String)isStart, (String)"true") & InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.contains(formOperate.getOperateKey())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u8010\u5fc3\u7b49\u5f85\u3002", (String)"InitMiddleTemplateListPlugin_22", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if ("discard".equals(formOperate.getOperateKey())) {
            this.updateDiscardForMiddleTable(formView);
            args.setCancel(true);
        }
        this.bizAgainConfirm(formOperate.getOperateKey(), args);
    }

    private void bizAgainConfirm(String operateKey, BeforeDoOperationEventArgs args) {
        if (HRStringUtils.equals((String)operateKey, (String)"bizvalidation") || HRStringUtils.equals((String)operateKey, (String)"bizvalidation1")) {
            this.checkConfirmBox(args, "B", "promptbox_b");
        } else if (HRStringUtils.equals((String)operateKey, (String)"syncbiz") || HRStringUtils.equals((String)operateKey, (String)"syncbiz1")) {
            this.checkConfirmBox(args, "C", "promptbox_c");
        } else if (HRStringUtils.equals((String)operateKey, (String)"rollback")) {
            this.checkConfirmBox(args, "A", "promptbox_a");
        }
    }

    private void checkConfirmBox(BeforeDoOperationEventArgs args, String op, String confirm) {
        DynamicObject task = InitTaskServiceHelper.getTask((String)"implitemrel", (long)this.getTaskId());
        String tip = this.iPromptboxDomainService.getTipByEntityAndOp(task.getDynamicObject("implitemrel").getDynamicObject("entityobjscope").getPkValue(), op);
        if (HRStringUtils.isEmpty((String)tip)) {
            return;
        }
        this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(confirm, (IFormPlugin)this));
        args.setCancel(true);
    }

    private boolean checkBosBtnPermission(String operateKey) {
        if (InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.contains(operateKey)) {
            return !InitPermHelper.hasNotPermission("4715a0df000000ac", this.getView(), "hric_inittask");
        }
        if (InitMiddleTemplateConstants.VIEW_PERMISSION_BTN_SET.contains(operateKey)) {
            return !InitPermHelper.hasNotPermission("47150e89000000ac", this.getView(), "hric_inittask");
        }
        return true;
    }

    private boolean checkOperationAccess(String operateKey) {
        if (!InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.contains(operateKey)) {
            return true;
        }
        if (InitTaskServiceHelper.existTask((long)this.getTaskId(), (String)"B")) {
            return true;
        }
        return ROLLBACK_PROCESSING_BTN_STATUS.contains(operateKey) && InitTaskServiceHelper.existTask((long)this.getTaskId(), (String)"F");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IFormView formView = this.getView().getParentView();
        try {
            switch (args.getOperateKey()) {
                case "downloadtemp": {
                    this.downloadExcelTemplate();
                    break;
                }
                case "initimportdatasingle": 
                case "initimportdata": {
                    this.openImportPage();
                    break;
                }
                case "initvalidate": 
                case "initvalidate1": {
                    this.doInitValidate();
                    this.parentViewSetParameter(args.getSource() instanceof Donothing ? ((Donothing)args.getSource()).getOperateName().getLocaleValue() : "");
                    this.invokeParentOperation(formView);
                    break;
                }
                case "bizvalidation": 
                case "bizvalidation1": {
                    this.doBizValidation();
                    this.parentViewSetParameter(args.getSource() instanceof Donothing ? ((Donothing)args.getSource()).getOperateName().getLocaleValue() : "");
                    this.invokeParentOperation(formView);
                    break;
                }
                case "syncbiz": 
                case "syncbiz1": {
                    this.doSyncBiz();
                    break;
                }
                case "rollback": {
                    this.doRollback();
                    break;
                }
                case "exportlist": {
                    break;
                }
                case "templatedescription": {
                    this.showTemplateDescription();
                    break;
                }
                case "sourcesystemdi": {
                    this.doDiService(args);
                    break;
                }
                case "discarddetail": {
                    this.openDiscardDetailPage();
                    break;
                }
                case "batch_modify": {
                    if (!this.checkSelectStatus()) break;
                    this.openBatchModify(this.getSelectedRows().getPrimaryKeyValues(), ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId());
                    break;
                }
            }
        }
        catch (KDHricException ex) {
            this.getView().showErrorNotification(ex.getMessage());
        }
    }

    private boolean checkSelectStatus() {
        String result = this.iMidTableDomainService.getMidTableDataStatusCheckResult(this.getMidTableNumber(), this.getSelectedRows().getPrimaryKeyValues());
        if (HRStringUtils.equals((String)result, (String)"true")) {
            return true;
        }
        this.getView().showErrorNotification(result);
        return false;
    }

    private void openBatchModify(Object[] primaryKeyValues, String dataFormId) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("hric_midbatchmodify");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("primaryKeys", (Object)primaryKeyValues);
        fsp.setCustomParam("dataFormId", (Object)dataFormId);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batch_modify_action_id"));
        fsp.setHasRight(true);
        this.getView().showForm(fsp);
    }

    private void openDiscardDetailPage() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hric_discarddetaillist");
        showParameter.setCaption(ResManager.loadKDString((String)"\u5e9f\u5f03\u6570\u636e\u660e\u7ec6", (String)"InitMiddleTemplateListPlugin_21", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        showParameter.setBillFormId(this.getMidTableNumber());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.getListFilterParameter().setFilter(new QFilter("hrictaskid", "=", (Object)this.getTaskId()));
        showParameter.setCustomParam(IS_SHOW_DISCARDDETAILPAGE, (Object)true);
        StyleCss styleCss = new StyleCss();
        styleCss.setWidth("900px");
        styleCss.setHeight("600px");
        showParameter.getOpenStyle().setInlineStyleCss(styleCss);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void doDiService(AfterDoOperationEventArgs args) {
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        String sourceSystem = (String)customParamsMap.get("sourcesystem");
        DynamicObject dyc = ImplItemListDaoHelper.getImplItemDiEntityById((long)ConvertUtils.toLong(customParamsMap.get("implItemID")));
        DynamicObjectCollection dys = dyc.getDynamicObjectCollection("dientryentity");
        Optional<DynamicObject> opDiScheme = dys.stream().filter(it -> {
            DynamicObject sourceSys = it.getDynamicObject("sourcesystem");
            return HRStringUtils.equals((String)sourceSys.getString("number"), (String)sourceSystem);
        }).findFirst();
        if (!opDiScheme.isPresent()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5339\u914d\u7684\u96c6\u6210\u670d\u52a1\u3002\u8bf7\u5148\u914d\u7f6e\u5173\u8054\u7684\u5b9e\u65bd\u9879\u57fa\u7840\u8d44\u6599\u3002", (String)"InitMiddleTemplateListPlugin_14", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject diScheme = opDiScheme.get();
        DynamicObject doc = diScheme.getDynamicObject("discheme");
        DynamicObject result = new HRBaseServiceHelper(diScheme.getString("integrationservicetype")).queryOne("enable", new QFilter("id", "=", (Object)doc.getLong("id")));
        if (!HRStringUtils.equals((String)result.getString("enable"), (String)"1")) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u5339\u914d\u7684\u96c6\u6210\u670d\u52a1\u201c%1$s\u201d\u72b6\u6001\u4e0d\u53ef\u7528\uff0c\u8bf7\u5148\u542f\u7528\u3002", (String)"InitMiddleTemplateListPlugin_13", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), result.getLocaleString("name").getLocaleValue()));
            return;
        }
        String number = result.getString("number");
        String taskId = customParamsMap.get("hrictaskid").toString();
        Long sourceSystemId = ConvertUtils.toLong(customParamsMap.get("hricsourcesystemid"));
        if (HRStringUtils.equals((String)diScheme.getString("integrationservicetype"), (String)"isc_data_copy_trigger")) {
            this.handleStartupScheme(taskId, number, args, sourceSystemId);
        } else if (HRStringUtils.equals((String)diScheme.getString("integrationservicetype"), (String)"isc_service_flow")) {
            this.handleServiceFlow(taskId, number, args, sourceSystemId);
        }
    }

    private void handleServiceFlow(final String taskId, String number, AfterDoOperationEventArgs args, final Long sourceSystemId) {
        Long start;
        try {
            start = (Long)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)"start", (Object[])new Object[]{number, new ArrayList<Object>(){
                {
                    this.add(InitMiddleTemplateListPlugin.this.handleDiParams(taskId, sourceSystemId));
                }
            }});
        }
        catch (Exception e) {
            this.getView().showMessage(this.DI_TIPS, e.toString(), MessageTypes.Default);
            return;
        }
        this.saveTaskOpCount(ConvertUtils.toLong((Object)taskId));
        this.parentViewSetParameter(args.getSource() instanceof Donothing ? ((Donothing)args.getSource()).getOperateName().getLocaleValue() : "");
        this.getView().getParentView().getFormShowParameter().setCustomParam("example_number", (Object)String.valueOf(start));
        this.invokeParentOperation(this.getView().getParentView());
    }

    private void handleStartupScheme(String taskId, String number, AfterDoOperationEventArgs args, Long sourceSystemId) {
        Map executeResult = (Map)HRMServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"ISCDataCopyService", (String)"execute", (Object[])new Object[]{number, this.handleDiParams(taskId, sourceSystemId), new HashMap()});
        if (!((Boolean)executeResult.get("success")).booleanValue()) {
            this.getView().showMessage(this.DI_TIPS, executeResult.get("msg").toString(), MessageTypes.Default);
            return;
        }
        this.saveTaskOpCount(ConvertUtils.toLong((Object)taskId));
        String executionNumber = executeResult.get("execution_number").toString();
        this.parentViewSetParameter(args.getSource() instanceof Donothing ? ((Donothing)args.getSource()).getOperateName().getLocaleValue() : "");
        this.getView().getParentView().getFormShowParameter().setCustomParam("execution_number", (Object)executionNumber);
        this.invokeParentOperation(this.getView().getParentView());
    }

    private Map<String, Object> handleDiParams(String taskId, Long sourceSystemId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("initstatus", "A");
        params.put("hrictaskid", taskId);
        String dateStr = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
        params.put("initbatchnumber", "DI" + dateStr.replace("-", "").replace(":", "").replace(" ", "").replace(".", ""));
        params.put("hricsourcesystemid", sourceSystemId);
        return params;
    }

    private void showTemplateDescription() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("hrictaskid");
        if (null != taskId) {
            boolean emptyDesc;
            DynamicObject task = InitTaskServiceHelper.getTask((long)taskId);
            DynamicObject tempLate = task.getDynamicObject("implitemrel").getDynamicObject("initimporttemplat");
            if (null == tempLate) {
                this.getView().showMessage(this.DESCRIPTION_TIP_TITLE, this.DESCRIPTION_TIP_CONTENT, MessageTypes.Default);
                return;
            }
            DynamicObject resultTempLate = InitTemplateServiceHelper.getInitTemplateByTemplateID((Long)tempLate.getLong("id"));
            if (null == resultTempLate) {
                this.getView().showMessage(this.DESCRIPTION_TIP_TITLE, this.DESCRIPTION_TIP_CONTENT, MessageTypes.Default);
                return;
            }
            ILocaleString description = resultTempLate.getLocaleString("description");
            boolean bl = emptyDesc = null == description || null != description && HRStringUtils.isEmpty((String)description.getLocaleValue());
            if (emptyDesc) {
                this.getView().showMessage(this.DESCRIPTION_TIP_TITLE, this.DESCRIPTION_TIP_CONTENT, MessageTypes.Default);
                return;
            }
            this.getView().showMessage(this.DESCRIPTION_TIP_TITLE, description.getLocaleValue(), MessageTypes.Default);
        }
    }

    private void updateDiscardForMiddleTable(IFormView formView) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List middleTableIds = selectedRows.stream().map(it -> (Long)it.getPrimaryKeyValue()).collect(Collectors.toList());
        String entityCode = formView.getPageCache().get("mid_table_entityname");
        DynamicObject[] midList = InitMidTableServiceHelper.queryPageCollection((String)entityCode, (QFilter[])new QFilter("id", "in", middleTableIds).toArray());
        ArrayList<DynamicObject> execMids = new ArrayList<DynamicObject>(midList.length);
        ArrayList<DynamicObject> errorMids = new ArrayList<DynamicObject>(midList.length);
        Arrays.asList(midList).forEach(mid -> {
            String status = mid.getString("initstatus");
            if (OperateEnum.DISCARD.getHandleStatusList().contains(status)) {
                errorMids.add((DynamicObject)mid);
            } else {
                mid.set("initstatus", (Object)OperateEnum.DISCARD.getSuccessStatus());
                execMids.add((DynamicObject)mid);
            }
        });
        if (!CollectionUtils.isEmpty(execMids)) {
            InitMidTableServiceHelper.updateMidForDisuse(execMids, (String)entityCode);
        }
        this.showConfirmMessage(selectedRows, errorMids, execMids);
    }

    private void showConfirmMessage(ListSelectedRowCollection selectedRows, List<DynamicObject> errorMids, List<DynamicObject> execMids) {
        IFormView formView = this.getView().getParentView();
        if (CollectionUtils.isEmpty(errorMids)) {
            formView.showTipNotification(this.MID_SUC_TIPS);
            this.getView().invokeOperation("refresh");
        } else if (!CollectionUtils.isEmpty(errorMids) && !CollectionUtils.isEmpty(execMids)) {
            formView.showTipNotification(String.format(Locale.ROOT, this.MID_TOP_TIPS, selectedRows.size(), selectedRows.size() - errorMids.size(), errorMids.size()) + "\n" + this.MID_TOP_TIPS_THREE);
            this.getView().invokeOperation("refresh");
        } else if (CollectionUtils.isEmpty(execMids)) {
            formView.showTipNotification(StringUtils.join((Object[])new String[]{this.MID_TOP_TIPS_TWO, this.MID_TOP_TIPS_THREE}, (String)"\n"));
        }
        this.getView().sendFormAction(formView);
    }

    private boolean checkPermission() {
        Long taskId = (Long)this.getView().getFormShowParameter().getCustomParam("hrictaskid");
        if (null != taskId) {
            DynamicObject task = InitTaskServiceHelper.getTask((long)taskId);
            long currId = UserServiceHelper.getCurrentUserId();
            if (task.getDynamicObject("taskleader").getLong("id") != currId) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u5f53\u524d\u4efb\u52a1\u8d1f\u8d23\u4eba, \u4e0d\u80fd\u8fdb\u884c\u6b64\u64cd\u4f5c", (String)"InitMiddleTemplateListPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void invokeParentOperation(IFormView formView) {
        if (this.isDevMode) {
            return;
        }
        formView.invokeOperation("parentsonrel");
        this.getView().sendFormAction(formView);
        this.getView().setEnable(Boolean.FALSE, InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.toArray(new String[0]));
    }

    public void afterBindData(EventObject event) {
        super.afterBindData(event);
        this.setBtnView();
        this.setBtnEnable();
        String isStart = (String)HricCacheUtils.get((String)(this.getParentPageId() + RequestContext.get().getCurrUserId() + START_PROGRESS), String.class);
        if (HRStringUtils.isNotEmpty((String)isStart) && HRStringUtils.equals((String)isStart, (String)"true")) {
            this.getView().setEnable(Boolean.FALSE, InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.toArray(new String[0]));
        }
    }

    private void setBtnEnable() {
        if (this.isDevMode) {
            return;
        }
        String mutex = Optional.ofNullable(this.getView().getFormShowParameter().getCustomParams().get("mutex")).orElse("");
        if (ObjectUtils.isNotEmpty((Object)mutex)) {
            this.getView().setEnable(Boolean.FALSE, InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.toArray(new String[0]));
            return;
        }
        Object obj = this.getView().getFormShowParameter().getCustomParams().get("taskleader");
        long taskLeader = 0L;
        if (obj instanceof Long) {
            taskLeader = (Long)obj;
        }
        if (obj instanceof Integer) {
            taskLeader = ((Integer)obj).longValue();
        }
        if (taskLeader != RequestContext.get().getCurrUserId()) {
            this.getView().setEnable(Boolean.FALSE, InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.toArray(new String[0]));
        }
    }

    private void setBtnView() {
        if (ConfigurationUtil.getBoolean((String)"hr.init.dev.mode", (Boolean)false).booleanValue()) {
            return;
        }
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isNotEmpty((Object)customParamsMap)) {
            String taskStatus = (String)customParamsMap.get("taskstatus");
            if (Objects.isNull(taskStatus)) {
                taskStatus = "";
            }
            Long taskId = (Long)customParamsMap.get("hrictaskid");
            String taskType = (String)customParamsMap.get("tasktype");
            this.setView(taskStatus, taskId, taskType);
            String sourceSystem = (String)customParamsMap.get("sourcesystem");
            if (HRStringUtils.isEmpty((String)sourceSystem)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"sourcesystemdi"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"initimportdatasingle"});
            }
        }
    }

    private void setView(String taskStatus, Long taskId, String taskType) {
        if (HRStringUtils.equals((String)taskType, (String)"C")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"downloadtemp", "initimportdatasingle", "initvalidate", "bizvalidation", "syncbiz", "retry", "rollback", "bizvalidation1", "initvalidate1", "syncbiz1", "discard", "sourcesystemdi", "batch_modify"});
            return;
        }
        switch (taskStatus) {
            case "A": 
            case "E": {
                String dataSource;
                this.getView().setVisible(Boolean.FALSE, new String[]{"initimportdatasingle", "initvalidate", "bizvalidation", "syncbiz", "retry", "rollback", "bizvalidation1", "initvalidate1", "syncbiz1", "discard", "sourcesystemdi", "batch_modify"});
                DynamicObject taskTmp = InitTaskServiceHelper.getTask((long)taskId);
                if (!ObjectUtils.isNotEmpty((Object)taskTmp) || !HRStringUtils.equals((String)"B", (String)(dataSource = taskTmp.getDynamicObject("implitemrel").getString("initfordatasource")))) break;
                this.getView().setVisible(Boolean.FALSE, new String[]{"downloadtemp"});
                break;
            }
            case "C": 
            case "D": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"downloadtemp", "initimportdatasingle", "initvalidate", "bizvalidation", "syncbiz", "retry", "rollback", "bizvalidation1", "initvalidate1", "syncbiz1", "discard", "sourcesystemdi", "batch_modify"});
                break;
            }
            case "B": {
                DynamicObject task = InitTaskServiceHelper.getTask((long)taskId);
                if (!ObjectUtils.isNotEmpty((Object)task)) break;
                this.getView().setVisible(Boolean.FALSE, BTN_LIST_ONE.toArray(new String[0]));
                break;
            }
            case "F": {
                this.getView().setVisible(Boolean.FALSE, new String[]{"downloadtemp", "initimportdatasingle", "initvalidate", "bizvalidation", "syncbiz", "bizvalidation1", "initvalidate1", "syncbiz1", "discard", "sourcesystemdi", "batch_modify"});
                break;
            }
        }
    }

    private void doSyncBiz() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u64cd\u4f5c\u5c06\u4f1a\u5c06\u521d\u59cb\u5316\u6821\u9a8c\u6210\u529f\u548c\u4e1a\u52a1\u6821\u9a8c\u6210\u529f\u7684\u6570\u636e\u5199\u5165\u4e1a\u52a1\u8868\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u540c\u6b65\u3002", (String)"InitMiddleTemplateListPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("doSyncBizConfirm", (IFormPlugin)this));
    }

    private void doRollback() {
        List<Long> selectedIdList = ((IListView)this.getView()).getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        IBaseConfigDomainService iBaseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.getService(IBaseConfigDomainService.class);
        boolean isCanRollbackSelect = iBaseConfigDomainService.isCanRollbackSelect(this.getTaskId());
        this.rollbackCount = this.getRollBackCount(selectedIdList, isCanRollbackSelect);
        if (this.rollbackCount <= 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u540c\u6b65\u6210\u529f\u548c\u66f4\u65b0\u4e3a\u5df2\u9a8c\u8bc1\u6210\u529f\u7684\u6570\u636e\u3002", (String)"InitMiddleTemplateListPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        } else if (isCanRollbackSelect && !CollectionUtils.isEmpty(selectedIdList)) {
            this.rollbackBySelect(selectedIdList);
        } else if (!isCanRollbackSelect && !CollectionUtils.isEmpty(selectedIdList)) {
            HashMap btnNameMaps = Maps.newHashMapWithExpectedSize((int)16);
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u5168\u90e8\u56de\u6eda", (String)"InitMiddleTemplateListPlugin_19", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u4efb\u52a1\u4e0d\u652f\u6301\u90e8\u5206\u6570\u636e\u56de\u6eda\uff0c\u53ea\u80fd\u8fdb\u884c\u5168\u90e8\u56de\u6eda\u3002\u662f\u5426\u786e\u8ba4\u5168\u90e8\u56de\u6eda\uff1f", (String)"InitMiddleTemplateListPlugin_20", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.rollbackCount), "", MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener("doRollbackConfirm", (IFormPlugin)this), (Map)btnNameMaps);
        } else {
            this.getView().showConfirm(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\u5220\u9664%1$s\u6761\u4e1a\u52a1\u8868\u4e2d\u672c\u6b21\u4efb\u52a1\u540c\u6b65\u7684\u6570\u636e\uff1f", (String)"InitMiddleTemplateListPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.rollbackCount), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("doRollbackConfirm", (IFormPlugin)this));
        }
    }

    private void rollbackBySelect(List<Long> selectedIdList) {
        if (selectedIdList.size() > 5000) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009\u62e95000\u6761\u6570\u636e\u8fdb\u884c\u56de\u6eda\u3002", (String)"InitMiddleTemplateListPlugin_16", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedIdList.size() > this.rollbackCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u56de\u6eda\u540c\u6b65\u6210\u529f\u3001\u66f4\u65b0\u4e3a\u5df2\u9a8c\u8bc1\u6210\u529f\u7684\u6570\u636e\u3002\u540c\u65f6\uff0c\u5c06\u9009\u4e2d\u7684\u8fd9\u4e24\u79cd\u72b6\u6001\u7684\u6570\u636e\u8fdb\u884c\u6570\u636e\u56de\u6eda\u64cd\u4f5c\u3002", (String)"InitMiddleTemplateListPlugin_17", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
        this.rollbackAll(this.getRollbackHandleInfo(selectedIdList));
    }

    private int getRollBackCount(List<Long> selectedIdList, boolean isCanRollbackSelect) {
        QFilter qFilter = this.getNormalQFilter();
        if (isCanRollbackSelect && !CollectionUtils.isEmpty(selectedIdList)) {
            qFilter.and(new QFilter("id", "in", selectedIdList));
        }
        return InitMidTableServiceHelper.queryCount((String)this.getMidTableNumber(), (QFilter[])qFilter.toArray());
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"doSyncBizConfirm") && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.doSyncBizConfirm();
        } else if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"doRollbackConfirm") && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.rollbackAll(this.getHandleInfo());
        } else if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"promptbox_b") && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.doBizValidation();
            this.parentViewSetParameter(ResManager.loadKDString((String)"\u4e1a\u52a1\u6821\u9a8c", (String)"InitTaskFormPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.invokeParentOperation(this.getView().getParentView());
        } else if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"promptbox_c") && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.doSyncBizConfirm();
        } else if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"promptbox_a") && MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            this.doRollback();
        }
    }

    private void doSyncBizConfirm() {
        this.parentViewSetParameter(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e", (String)"InitMiddleTemplateListPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        new SyncBizTablePageHandle(this.getHandleInfo()).handle();
        this.invokeParentOperation(this.getView().getParentView());
    }

    private void rollbackAll(MidTableHandleInfo handleInfo) {
        this.parentViewSetParameter(ResManager.loadKDString((String)"\u6570\u636e\u56de\u6eda", (String)"InitMiddleTemplateListPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        Map customParamsMap = this.getView().getFormShowParameter().getCustomParams();
        if (ConvertUtils.toBoolean(customParamsMap.get("parent"))) {
            Long parentId = ConvertUtils.toLong(customParamsMap.get("parentid"));
            handleInfo.setEntityTaskIdMapping(this.iInitTaskDomainService.getSonTaskEntityNumberMap(parentId));
        }
        new RollbackInitDataHandle(handleInfo).handle();
        this.invokeParentOperation(this.getView().getParentView());
    }

    private void parentViewSetParameter(String btnName) {
        this.getView().getParentView().getFormShowParameter().setCustomParam("btnname", (Object)btnName);
        this.getView().getParentView().getFormShowParameter().setCustomParam("current_operate_type", (Object)"B");
    }

    private void doInitValidate() {
        new InitValidatePageHandle(this.getHandleInfo()).handle();
    }

    private void doBizValidation() {
        new BizValidatePageHandle(this.getHandleInfo()).handle();
    }

    public MidTableHandleInfo getHandleInfo() {
        return new MidTableHandleInfo(this.getTaskId(), this.getMidTableNumber(), this.buildCallBackBo());
    }

    public MidTableHandleInfo getRollbackHandleInfo(List<Long> selectedIdList) {
        String midTableNumber = this.getMidTableNumber();
        QFilter qFilter = this.getNormalQFilter();
        qFilter.and(new QFilter("id", "in", selectedIdList));
        DynamicObject[] data = InitMidTableServiceHelper.queryPageCollection((String)midTableNumber, (String)"id", (QFilter[])qFilter.toArray());
        return new MidTableHandleInfo(this.getTaskId(), midTableNumber, this.buildCallBackBo(), Arrays.stream(data).map(dyn -> dyn.getLong("id")).collect(Collectors.toList()));
    }

    private QFilter getNormalQFilter() {
        QFilter qFilter = new QFilter("hrictaskid", "=", (Object)this.getTaskId());
        qFilter.and(new QFilter("initstatus", "in", (Object)OperateEnum.ROLLBACK.getHandleStatusList()));
        return qFilter;
    }

    private ExecTaskCallbackBo buildCallBackBo() {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("taskId", this.getTaskId());
        StringBuilder number = new StringBuilder();
        number.append(this.getTaskId()).append("-").append("middleOp");
        return new ExecTaskCallbackBo(number.toString(), ID.genStringId(), "middle.callback.class.operation", param);
    }

    private void downloadExcelTemplate() {
        InitTemplateServiceHelper.downloadTempExcel((String)this.getMidTableNumber(), (IFormView)this.getView());
    }

    private long getTaskId() {
        long taskId = Optional.of(this.getView()).map(IFormView::getFormShowParameter).map(it -> it.getCustomParam("hrictaskid")).map(it -> (Long)it).orElseGet(() -> 0L);
        return taskId == 0L ? this.taskId : taskId;
    }

    private String getParentPageId() {
        return Optional.of(this.getView()).map(IFormView::getFormShowParameter).map(it -> it.getCustomParam("pageId")).map(it -> (String)it).orElseGet(() -> "");
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (HRStringUtils.equals((String)event.getActionId(), (String)"refresh")) {
            this.getView().invokeOperation("refresh");
        } else if ("batch_modify_action_id".equals(event.getActionId())) {
            FormShowParameter parameters;
            Object returnData = event.getReturnData();
            if (returnData != null && StringUtils.isNotEmpty((CharSequence)returnData.toString()) && (parameters = InitOperationResultUtils.getShowOperationResultPageParameter((String)returnData.toString())) != null) {
                this.getView().showForm(parameters);
            }
            this.getView().invokeOperation("refresh");
        }
    }

    private void openImportPage() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hric_initimportstart");
        IFormView view = this.getView();
        ListShowParameter formShowParameter = (ListShowParameter)view.getFormShowParameter();
        showParameter.setCustomParam("ServiceAppId", (Object)formShowParameter.getServiceAppId());
        showParameter.setCustomParam("CheckRightAppId", (Object)formShowParameter.getCheckRightAppId());
        showParameter.setCustomParam("BillFormId", (Object)formShowParameter.getBillFormId());
        showParameter.setCustomParam("OperateKey", (Object)"initimportdata");
        showParameter.setCustomParam("ImportPlugin", (Object)"kd.hrmp.hric.formplugin.web.HRICInitImportPlugin");
        showParameter.setCustomParam("RealPermissionEntityId", (Object)formShowParameter.getBillFormId());
        showParameter.setCustomParam("ListName", formShowParameter.getCustomParam("ListName"));
        showParameter.setCustomParam("hrictaskid", (Object)this.getTaskId());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "refresh"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void beforeExportFile(BeforeExportFileEvent e) {
        e.setFileName(e.getFileName().replaceAll(e.getMainEntityType().getName(), ""));
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        String msg = rowData.getString("initerrormsg");
        if (Objects.isNull(msg) || msg.length() == 0) {
            e.getNoLinkKey().add("initerrormsg");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        this.openLargeMsgForm(args);
    }

    private void openLargeMsgForm(HyperLinkClickArgs args) {
        BillList source = (BillList)args.getHyperLinkClickEvent().getSource();
        FormService.getInstance().openLargeText(source.getEntityId(), "initerrormsg", this.getView(), source.getFocusRowPkId());
    }

    private void saveTaskOpCount(Long taskId) {
        DynamicObject taskOpCountObj = InitTaskCountServiceHelper.getByTaskId((long)taskId);
        if (HRObjectUtils.isEmpty((Object)taskOpCountObj)) {
            taskOpCountObj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_taskopcount"));
            taskOpCountObj.set("inittaskid", (Object)taskId);
            taskOpCountObj.set("introductioncount", (Object)1);
        } else {
            taskOpCountObj.set("introductioncount", (Object)(taskOpCountObj.getInt("introductioncount") + 1));
        }
        InitTaskCountServiceHelper.saveOne((DynamicObject)taskOpCountObj);
    }

    private boolean isShowDiscardDetailPage() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        return Optional.of(showParameter).map(parameter -> (Boolean)parameter.getCustomParam(IS_SHOW_DISCARDDETAILPAGE)).orElse(false);
    }

    private String getMidTableNumber() {
        return ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
    }
}

