/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.control.Label;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.formplugin.web.ChartCommonEditPlugin;

public class InitPlanDetailChartEditPlugin
extends ChartCommonEditPlugin {
    private Map<String, String> DATAVERIFY_STATUS_MAP = new HashMap<String, String>(){
        {
            this.put("A", ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d", (String)"InitPlanDetailChartEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("B", ResManager.loadKDString((String)"\u5904\u7406\u4e2d", (String)"InitPlanDetailChartEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("C", ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"InitPlanDetailChartEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
    };
    private Map<String, String> IMPLITEM_STATUS_MAP = new HashMap<String, String>(){
        {
            this.put("E", ResManager.loadKDString((String)"\u56de\u6eda\u7b49\u5f85\u4e2d", (String)"InitPlanDetailChartEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.put("F", ResManager.loadKDString((String)"\u56de\u6eda\u5904\u7406\u4e2d", (String)"InitPlanDetailChartEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
    };
    private String PLANCHART_TITLE = ResManager.loadKDString((String)"\u5b50\u8ba1\u5212\u8fdb\u5ea6\u7edf\u8ba1", (String)"InitPlanDetailChartEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String IMPLITEMCHART_TITLE = ResManager.loadKDString((String)"\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1\u8fdb\u5ea6\u7edf\u8ba1", (String)"InitPlanDetailChartEditPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String DATAVERIFYCHART_TITLE = ResManager.loadKDString((String)"\u6570\u636e\u9a8c\u8bc1\u4efb\u52a1\u8fdb\u5ea6\u7edf\u8ba1", (String)"InitPlanDetailChartEditPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long pkId = this.getView().getFormShowParameter().getCustomParam("id") instanceof String ? Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id")) : (Long)this.getView().getFormShowParameter().getCustomParam("id");
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)pkId);
        if (plan == null) {
            return;
        }
        String configMode = plan.getString("configmode");
        if (AppConstants.CONFIG_MODE_LIST.contains(configMode)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"planchartpanel"});
        } else {
            this.initPlanChart((PieChart)this.getControl("planchart"), plan);
        }
        DynamicObject[] dys = InitPlanServiceHelper.getSubInitPlansByStructNumber((String)plan.getString("structnumber"));
        List subPlanIdList = Arrays.stream(dys).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        subPlanIdList.add(pkId);
        Object[] implItemTasks = InitTaskServiceHelper.getImplItemTaskByPlanIds(subPlanIdList);
        if (ObjectUtils.isEmpty((Object[])implItemTasks)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"implitemchartpanel"});
        } else {
            this.initImplitemChart((PieChart)this.getControl("implitemchart"), (DynamicObject[])implItemTasks);
        }
        Object[] dataVerifyTasks = InitTaskServiceHelper.getDataVerifyTaskByPlanIds(subPlanIdList);
        if (ObjectUtils.isEmpty((Object[])dataVerifyTasks)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"dataverifychartpanel"});
        } else {
            this.initDataVerifyChart((PieChart)this.getControl("dataverifychart"), (DynamicObject[])dataVerifyTasks);
        }
    }

    private void initPlanChart(PieChart pieChart, DynamicObject plan) {
        DynamicObject[] dys = InitPlanServiceHelper.getSubInitPlansByParentId((Long)plan.getLong("id"));
        ItemValue[] items = this.getSeriesData(dys, this.PLAN_STATUS_MAP, "planstatus");
        this.setLabelVal(items, "planchartlabel");
        this.setCharStyle(pieChart, this.PLANCHART_TITLE, true);
        this.setChartData(pieChart, items, this.PLANCHART_TITLE);
    }

    private void initImplitemChart(PieChart pieChart, DynamicObject[] tasks) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"implitemchartpanel"});
        this.IMPLITEM_STATUS_MAP.putAll(this.DATAVERIFY_STATUS_MAP);
        ItemValue[] items = this.getSeriesData(tasks, this.IMPLITEM_STATUS_MAP, "taskstatus");
        this.setLabelVal(items, "implitemchartlabel");
        this.setCharStyle(pieChart, this.IMPLITEMCHART_TITLE, true);
        this.setChartData(pieChart, items, this.IMPLITEMCHART_TITLE);
    }

    private void initDataVerifyChart(PieChart pieChart, DynamicObject[] tasks) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"dataverifychartpanel"});
        ItemValue[] items = this.getSeriesData(tasks, this.DATAVERIFY_STATUS_MAP, "taskstatus");
        this.setLabelVal(items, "dataverifychartlabel");
        this.setCharStyle(pieChart, this.DATAVERIFYCHART_TITLE, true);
        this.setChartData(pieChart, items, this.DATAVERIFYCHART_TITLE);
    }

    private void setChartData(PieChart pieChart, ItemValue[] items, String titleChart) {
        PieSeries series = pieChart.createPieSeries(titleChart);
        series.setData(items);
        series.setRadius("40%", "70%");
        series.setPropValue("center", (Object)new Object[]{"50%", "50%"});
        series.setPropValue("labelLine", (Object)new HashMap(){
            {
                this.put("show", Boolean.TRUE);
            }
        });
        this.getView().updateView("advconchildpanelap");
    }

    private void setLabelVal(ItemValue[] items, String chartLabel) {
        int totalNum = Arrays.stream(items).mapToInt(item -> item.getValue() == null ? 0 : item.getValue().intValue()).sum();
        int finshNum = Arrays.stream(items).filter(item -> HRStringUtils.equals((String)item.getName(), (String)((String)this.PLAN_STATUS_MAP.get("C")))).mapToInt(item -> item.getValue() == null ? 0 : item.getValue().intValue()).sum();
        int percent = finshNum * 100 / totalNum;
        if (HRStringUtils.equals((String)chartLabel, (String)"planchartlabel")) {
            ((Label)this.getView().getControl(chartLabel)).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u76f4\u63a5\u5b50\u8ba1\u5212%1$s\u4e2a\uff0c\u5b8c\u6210\u7387%2$s\u3002", (String)"InitPlanDetailChartEditPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), totalNum, percent + "%"));
        } else if (HRStringUtils.equals((String)chartLabel, (String)"implitemchartlabel")) {
            ((Label)this.getView().getControl(chartLabel)).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1\u5171%1$s\u4e2a\uff0c\u5b8c\u6210\u7387%2$s", (String)"InitPlanDetailChartEditPlugin_11", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), totalNum, percent + "%"));
        } else if (HRStringUtils.equals((String)chartLabel, (String)"dataverifychartlabel")) {
            ((Label)this.getView().getControl(chartLabel)).setText(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6570\u636e\u9a8c\u8bc1\u4efb\u52a1\u5171%1$s\u4e2a\uff0c\u5b8c\u6210\u7387%2$s", (String)"InitPlanDetailChartEditPlugin_12", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), totalNum, percent + "%"));
        }
    }
}

