/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IInitPlanEntityService;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitServiceLongServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.common.ColorEnum;
import kd.hrmp.hric.common.constants.msg.PlanMsgEnum;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.util.DateUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.formplugin.web.InitPermHelper;

public class InitPlanDetailEditPlugin
extends HRDataBaseEdit {
    private IInitPlanEntityService iInitPlanEntityService = (IInitPlanEntityService)ServiceFactory.getService(IInitPlanEntityService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Label integrationLabel = (Label)this.getView().getControl("deployintegration");
        integrationLabel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (!InitPermHelper.checkDataRule(this.getPkId(), false, null)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u83dc\u5355\u65e0\u6743\u9650\u3002", (String)"InitPlanDetailEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
            IFormView formView = this.getView().getParentView();
            if (!HRStringUtils.equals((String)formView.getEntityId(), (String)"bos_list")) {
                return;
            }
            formView.invokeOperation("refresh");
            this.getView().sendFormAction(formView);
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long pkId = this.getPkId();
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)pkId);
        StringBuilder errMsg = new StringBuilder();
        boolean mutex = MutexHelper.require((IFormView)this.getView(), (String)"hric_initplandetail", (Object)pkId, (String)"refresh", (boolean)true, (StringBuilder)errMsg);
        this.setPanel(plan, mutex);
        this.setImplItemInfoPanel(plan, mutex);
        if (!mutex) {
            this.getView().showErrorNotification(errMsg.toString());
        }
        this.getView().getPageCache().put("configmode", plan.getString("configmode"));
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        long pkId = this.getPkId();
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)pkId);
        if (plan == null) {
            return;
        }
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "refresh": {
                this.setBaseInfo(plan);
                this.getView().updateView();
                break;
            }
            case "toplantemplate": {
                this.showPlanTemplate();
            }
        }
    }

    private void showPlanTemplate() {
        QFilter planStatusQFilter = new QFilter("id", "=", (Object)this.getPkId());
        planStatusQFilter.and(new QFilter("planstatus", "=", (Object)"A"));
        if (this.iInitPlanEntityService.isExistUnConfig(this.getModel().getDataEntity().getString("structnumber"))) {
            throw new KDHricException(ResManager.loadKDString((String)"\u5f53\u524d\u603b\u8ba1\u5212\u5c1a\u672a\u914d\u7f6e\u5b8c\u6210\uff0c\u65e0\u6cd5\u4fdd\u5b58\u4e3a\u6a21\u677f\u3002", (String)"InitPlanDetailEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hric_ptplbase_to");
        showParameter.setCaption(ResManager.loadKDString((String)"\u4fdd\u5b58\u4e3a\u6a21\u677f", (String)"InitPlanDetailEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setAppId("hric");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "planTemplateCallback"));
        showParameter.setCustomParam("structnumber", this.getModel().getValue("structnumber"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
    }

    private void setSubPlanInfoPanel(DynamicObject plan, boolean mutex) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("sublistinfo");
        listShowParameter.setFormId("hric_innertreelist");
        listShowParameter.setBillFormId("hric_initplan");
        listShowParameter.setCustomParam("id", (Object)plan.getLong("id"));
        listShowParameter.setCustomParam("structnumber", (Object)plan.getString("structnumber"));
        listShowParameter.setCustomParam("mutex", (Object)mutex);
        listShowParameter.setHasRight(true);
        this.getView().getPageCache().put("hric_initplan", listShowParameter.getPageId());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void setImplItemInfoPanel(DynamicObject plan, boolean mutex) {
        DynamicObjectCollection plans = this.getAllSubPlan(plan);
        DynamicObjectCollection tasks = this.getTaskByPlans(plans);
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        listShowParameter.getOpenStyle().setTargetKey("implitemlistinfo");
        listShowParameter.setFormId("hric_innerlist");
        listShowParameter.setBillFormId("hric_initpretask");
        HashMap<String, Object> customParam = new HashMap<String, Object>();
        customParam.put("configmode", plan.getString("configmode"));
        customParam.put("planstatus", plan.getString("planstatus"));
        customParam.put("id", plan.getLong("id"));
        customParam.put("hric_inittask", tasks.stream().map(it -> it.get("id")).collect(Collectors.toList()));
        customParam.put("structnumber", plan.getString("structnumber"));
        customParam.put("mutex", mutex);
        listShowParameter.setCustomParams(customParam);
        this.getView().getPageCache().put("hric_initpretask", listShowParameter.getPageId());
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void setInitServiceLogPanel(DynamicObject plan) {
        DynamicObject[] serviceLogs = InitServiceLongServiceHelper.getServiceLogByPlanId((long)plan.getLong("id"));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("operationdate", new Object[0]);
        vs.addField("operationperson", new Object[0]);
        vs.addField("operationtype", new Object[0]);
        vs.addField("operationobj", new Object[0]);
        List serviceLogList = Arrays.stream(serviceLogs).sorted(Comparator.comparing(dyn -> dyn.getDate("operationdate"), Comparator.reverseOrder())).collect(Collectors.toList());
        for (DynamicObject serviceLog : serviceLogList) {
            String type = ((ComboProp)serviceLog.getDynamicObjectType().getProperty("operationtype")).getItemByName(serviceLog.getString("operationtype"));
            vs.addRow(new Object[]{DateUtils.date2OnlyString((Date)serviceLog.getDate("operationdate")), serviceLog.getDynamicObject("operationperson").getString("name"), type, HricDynamicObjectUtils.getBigText((DynamicObject)serviceLog, (String)"operationobj")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        int a = model.getEntryRowCount("entryentity");
        for (int i = 0; i < a; ++i) {
            model.deleteEntryRow("entryentity", 0);
        }
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
    }

    public void afterCreateNewData(EventObject e) {
        long pkId = this.getPkId();
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)pkId);
        if (plan == null) {
            return;
        }
        this.setBaseInfo(plan);
    }

    private void setBaseInfo(DynamicObject plan) {
        DynamicObject parent = plan.getDynamicObject("parent");
        String planName = (String)plan.getLocaleString("name").getDefaultItem();
        if (parent == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"parentlab"});
            ((Label)this.getView().getControl("name")).setText(String.format(Locale.ROOT, PlanMsgEnum.MASTER_PLAN_PREFIX.get(), planName));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"toplantemplate"});
            ((Label)this.getView().getControl("name")).setText(String.format(Locale.ROOT, PlanMsgEnum.SON_PLAN_PREFIX.get(), planName));
            ((Label)this.getView().getControl("parent")).setText((String)Optional.ofNullable(parent.getLocaleString("name").getDefaultItem()).orElse("-"));
        }
        ((Label)this.getView().getControl("number")).setText(plan.getString("number"));
        ((Label)this.getView().getControl("group")).setText(this.getMulBasedataFieldName(plan, "group"));
        ((Label)this.getView().getControl("bizsubarea")).setText(this.getMulBasedataFieldName(plan, "bizsubarea"));
        ((Label)this.getView().getControl("industrytype")).setText(this.getBasedataFieldName(plan, "industrytype"));
        String dataRange = (String)plan.getLocaleString("datarange").getDefaultItem();
        ((Label)this.getView().getControl("datarange")).setText(HRStringUtils.isEmpty((String)dataRange) ? "-" : dataRange);
        DynamicObject sourceSystem = plan.getDynamicObject("sourcesystem");
        if (sourceSystem == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"sourcesystemlab", "deployintegration"});
        } else {
            ((Label)this.getView().getControl("sourcesystem")).setText(this.getBasedataFieldName(plan, "sourcesystem"));
        }
        ((Label)this.getView().getControl("planperson")).setText(this.getBasedataFieldName(plan, "planperson"));
        ((Label)this.getView().getControl("startdate")).setText(DateUtils.date2ShortStr((Date)plan.getDate("startdate")));
        ((Label)this.getView().getControl("enddate")).setText(DateUtils.date2ShortStr((Date)plan.getDate("enddate")));
        ((Label)this.getView().getControl("actualenddate")).setText(DateUtils.date2ShortStr((Date)plan.getDate("actualenddate")));
        ((Label)this.getView().getControl("planstatus")).setText(((ComboProp)plan.getDynamicObjectType().getProperty("planstatus")).getItemByName(plan.getString("planstatus")));
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("fc", ColorEnum.getColorByStatus((String)plan.getString("planstatus")));
        this.getView().updateControlMetadata("planstatus", (Map)paramMap);
    }

    private String getBasedataFieldName(DynamicObject plan, String lableTag) {
        ILocaleString localeString;
        String fieldName = "-";
        DynamicObject dyc = plan.getDynamicObject(lableTag);
        if (dyc != null && (localeString = dyc.getLocaleString("name")) != null) {
            fieldName = (String)localeString.getDefaultItem();
        }
        return fieldName;
    }

    private String getMulBasedataFieldName(DynamicObject plan, String lableTag) {
        String fieldName = "-";
        DynamicObjectCollection dys = plan.getDynamicObjectCollection(lableTag);
        String nameStr = dys.stream().map(dyc -> dyc.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(dyc -> (String)dyc.getLocaleString("name").getDefaultItem()).collect(Collectors.joining(","));
        if (HRStringUtils.isNotEmpty((String)nameStr)) {
            return nameStr;
        }
        return fieldName;
    }

    private void setPanel(DynamicObject plan, boolean mutex) {
        String configMode = plan.getString("configmode");
        this.getModel().setValue("structnumber", (Object)plan.getString("structnumber"));
        ((Label)this.getView().getControl("confway")).setText(((ComboProp)plan.getDynamicObjectType().getProperty("configmode")).getItemByName(configMode));
        if (HRStringUtils.equals((String)configMode, (String)"A")) {
            this.setSubPlanInfoPanel(plan, mutex);
            this.panelShow(Boolean.TRUE, Boolean.TRUE, plan);
        } else {
            this.panelShow(Boolean.FALSE, Boolean.TRUE, plan);
        }
    }

    private boolean isParentPlan(DynamicObject plan) {
        return null != plan.getDynamicObject("parent");
    }

    private void panelShow(Boolean sub, Boolean impl, DynamicObject plan) {
        this.getView().setVisible(sub, new String[]{"subplaninfopanel"});
        this.getView().setVisible(impl, new String[]{"impliteminfopanel"});
        this.getView().setVisible(Boolean.valueOf(!this.isParentPlan(plan)), new String[]{"initfinishservicelogpanel"});
        if (!this.isParentPlan(plan)) {
            this.setInitServiceLogPanel(plan);
        }
    }

    private DynamicObjectCollection getAllSubPlan(DynamicObject plan) {
        DynamicObject[] subPlanList;
        DynamicObjectCollection resultPlanList = new DynamicObjectCollection();
        resultPlanList.add((Object)plan);
        for (DynamicObject dyn : subPlanList = InitPlanServiceHelper.getInitPlansByStructNumber((String)plan.getString("structnumber"))) {
            resultPlanList.add((Object)dyn);
        }
        return resultPlanList;
    }

    private DynamicObjectCollection getTaskByPlans(DynamicObjectCollection plans) {
        DynamicObject[] result;
        DynamicObjectCollection resultTaskList = new DynamicObjectCollection();
        if (CollectionUtils.isEmpty((Collection)plans)) {
            return resultTaskList;
        }
        for (DynamicObject task : result = InitTaskServiceHelper.getInitTaskByPlanList(plans.stream().map(it -> it.getLong("id")).collect(Collectors.toList()))) {
            resultTaskList.add((Object)task);
        }
        return resultTaskList;
    }

    private long getPkId() {
        return this.getView().getFormShowParameter().getCustomParam("id") instanceof String ? Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id")) : (Long)this.getView().getFormShowParameter().getCustomParam("id");
    }

    public void click(EventObject e) {
        super.click(e);
        String controlKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            controlKey = ((Control)source).getKey();
        }
        if (HRStringUtils.equals((String)"deployintegration", (String)controlKey)) {
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)"1307812164626595840", (String)"TV3/VDJ86RC", null);
        }
    }
}

