/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.DirtyManager;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.IDataModelListener;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.ICooperativeDomainService;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.formplugin.web.InitPermHelper;
import kd.hrmp.hric.formplugin.web.plan.InitPlanFrontImplHandle;
import kd.hrmp.hric.formplugin.web.util.InitPlanFormUtils;

public class InitPlanEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
IDataModelListener {
    private static final String PAGE_CACHE_CONFIGMODE = "pageCacheConfigMode";
    private static final String STARTUP = "startup";
    private String GREATERTHAN = ResManager.loadKDString((String)"\u4e0d\u80fd\u5927\u4e8e", (String)"InitPlanEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String LESSTHAN = ResManager.loadKDString((String)"\u4e0d\u80fd\u5c0f\u4e8e", (String)"InitPlanEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private boolean isStartUpSave = false;
    private int changeRowIndex = 0;
    private Set<String> fieldSet = Sets.newHashSet();
    private static final Set<String> PERSON_SET = ImmutableSet.of((Object)"planperson", (Object)"executeperson", (Object)"verifyperson", (Object)"entryplanperson");
    private static final String[] PLAN_BTN = new String[]{"bar_save", "prestartup", "addentry", "delentry", "addimplitementry", "skip", "cancelskip", "batchassignexcute", "batchopenverify", "batchchangeperson"};
    private static final List<String> HIDE_BTN_LIST = ImmutableList.of((Object)"batchassignverify", (Object)"batchopenverify", (Object)"batchcloseverify");
    ICooperativeDomainService iSystemParamDomainService = (ICooperativeDomainService)ServiceFactory.getService(ICooperativeDomainService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.handleCollaborationMode();
        if (HRStringUtils.equals((String)status.name(), (String)OperationStatus.ADDNEW.name())) {
            Object id = this.getView().getFormShowParameter().getCustomParam("id");
            boolean iscopy = Optional.ofNullable((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")).orElse(false);
            if (null == id || iscopy) {
                return;
            }
            long pkId = this.getView().getFormShowParameter().getCustomParam("id") instanceof String ? Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id")) : (Long)this.getView().getFormShowParameter().getCustomParam("id");
            this.showPlanEdit(pkId);
        }
    }

    private void showPlanEdit(long pkId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InCurrentForm);
        showParameter.setPkId((Object)pkId);
        showParameter.setFormId("hric_initplan");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().getPageCache().put(PAGE_CACHE_CONFIGMODE, (String)this.getModel().getValue("configmode"));
        this.ctrlPanel();
        this.setLock();
        Long pkId = (Long)this.getModel().getValue("id");
        if (pkId != 0L) {
            StringBuilder errMsg = new StringBuilder();
            boolean mutex = MutexHelper.require((IFormView)this.getView(), (String)"hric_initplan", (Object)pkId, (String)"refresh", (boolean)true, (StringBuilder)errMsg);
            if (!mutex) {
                this.getView().showErrorNotification(errMsg.toString());
                this.getView().setEnable(Boolean.FALSE, new String[]{"bar_save", "prestartup"});
            }
        }
    }

    private void handleCollaborationMode() {
        boolean collaborationMode = this.iSystemParamDomainService.getParameterBoolean();
        if (!collaborationMode) {
            InitPlanFormUtils.handleCollaborationMode(this.getView(), HIDE_BTN_LIST);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().deleteEntryData("itementryentity");
        this.copyInit();
    }

    private void copyInit() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Boolean iscopy = Optional.ofNullable((Boolean)customParams.get("iscopy")).orElse(Boolean.FALSE);
        if (!iscopy.booleanValue()) {
            return;
        }
        String copyId = (String)customParams.get("id");
        if (HRStringUtils.isEmpty((String)copyId)) {
            return;
        }
        ((BillModel)this.getModel()).copy((Object)copyId, true);
        DynamicObject dyc = this.getModel().getDataEntity();
        this.billHeadSetVal(dyc);
        if (HRStringUtils.equals((String)"A", (String)dyc.getString("configmode"))) {
            this.addEntity();
            if (CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null)) {
                this.lockEntryNumberField(false);
                this.lockNumberField(false);
            } else {
                this.lockEntryNumberField(true);
                this.lockNumberField(true);
            }
        } else if (AppConstants.CONFIG_MODE_LIST.contains(dyc.getString("configmode"))) {
            this.setItemEntryEntity(dyc);
        }
    }

    private void billHeadSetVal(DynamicObject dyc) {
        this.getModel().setValue("number", (Object)this.getCodeRule());
        this.getModel().setValue("planstatus", (Object)"A");
        this.getModel().setValue("structnumber", null);
        this.getModel().setValue("parent", null);
        this.getModel().deleteEntryData("entryentity");
    }

    private void setItemEntryEntity(DynamicObject dyc) {
        DynamicObjectCollection itemEntryCol = dyc.getDynamicObjectCollection("itementryentity");
        if (!CollectionUtils.isEmpty((Collection)itemEntryCol)) {
            Iterator iter = itemEntryCol.iterator();
            while (iter.hasNext()) {
                DynamicObject implItem = ((DynamicObject)iter.next()).getDynamicObject("implitem");
                if (implItem != null && implItem.getBoolean("enable")) continue;
                iter.remove();
            }
            this.getModel().setValue("itementryentity", (Object)itemEntryCol);
        }
    }

    public void afterLoadData(EventObject e) {
        DynamicObject dyc = this.getModel().getDataEntity();
        String configMode = dyc.getString("configmode");
        if (HRStringUtils.equals((String)configMode, (String)"A")) {
            this.loadEntity(dyc, true);
            if (CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null)) {
                this.lockEntryNumberField(false);
            } else {
                this.lockEntryNumberField(true);
            }
        }
        new DirtyManager((AbstractFormDataModel)this.getModel()).clearDirty();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(PAGE_CACHE_CONFIGMODE);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void loadEntity(DynamicObject dyc, boolean isLoadId) {
        DynamicObject[] sonPlans = InitPlanServiceHelper.getInitPlansById((Long)dyc.getLong("id"));
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = this.getTableValueSetter();
        Arrays.stream(sonPlans).forEach(son -> {
            DynamicObject personObj = son.getDynamicObject("planperson");
            vs.addRow(new Object[]{isLoadId ? Long.valueOf(son.getLong("id")) : null, isLoadId ? son.getString("number") : this.getCodeRule(), son.getLocaleString("name"), son.getDynamicObjectCollection("group"), son.getDynamicObjectCollection("bizsubarea"), son.getDate("startdate"), son.getDate("enddate"), ObjectUtils.isEmpty((Object)personObj) ? null : Long.valueOf(personObj.getLong("id")), son.getLocaleString("datarange")});
        });
        model.batchCreateNewEntryRow("entryentity", vs);
    }

    private void ctrlPanel() {
        DynamicObject dyc = this.getModel().getDataEntity();
        if (ObjectUtils.isEmpty((Object)dyc)) {
            return;
        }
        if (dyc.getInt("layer") == 5) {
            this.getModel().setValue("configmode", (Object)"B");
            if (CollectionUtils.isEmpty((Collection)this.getModel().getEntryEntity("itementryentity"))) {
                InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), false, this.getIndustry());
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("configmode");
            comboEdit.setEnable("configmode", false, 0);
            this.implItemPanelShow();
            this.getModel().deleteEntryData("entryentity");
            this.getModel().setDataChanged(false);
            return;
        }
        String configMode = dyc.getString("configmode");
        if (HRStringUtils.equals((String)configMode, (String)"A")) {
            this.planPanelShow();
        } else {
            this.implItemPanelShow();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        ListShowParameter listShowParameter;
        String fieldName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (PERSON_SET.contains(fieldName)) {
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setAppId("hric");
            listShowParameter.setHasRight(true);
        }
        if (HRStringUtils.equals((String)fieldName, (String)"bizsubarea")) {
            DynamicObjectCollection dyc = (DynamicObjectCollection)this.getModel().getValue("group");
            HashSet ids = new HashSet();
            dyc.stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).forEach(gro -> ids.add((Long)gro.get("id")));
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("group", "in", ids));
        } else if (HRStringUtils.equals((String)fieldName, (String)"entrygroup")) {
            this.entityF7Filter(evt, "group");
        } else if (HRStringUtils.equals((String)fieldName, (String)"entrybizsubarea")) {
            this.entityF7Filter(evt, "entrygroup");
        } else if (HRStringUtils.equals((String)fieldName, (String)"executeperson") || HRStringUtils.equals((String)fieldName, (String)"verifyperson") || HRStringUtils.equals((String)fieldName, (String)"entryplanperson")) {
            listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            listShowParameter.setMultiSelect(false);
        } else if (HRStringUtils.equals((String)fieldName, (String)"sourcesystem")) {
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setOrderBy("index");
        }
    }

    private void entityF7Filter(BeforeF7SelectEvent evt, String field) {
        DynamicObjectCollection dyc = (DynamicObjectCollection)this.getModel().getValue(field);
        HashSet ids = new HashSet();
        HashSet<Long> subAreaIds = new HashSet<Long>();
        if (HRStringUtils.equals((String)field, (String)"group")) {
            this.showMsg(evt, field, dyc);
            dyc.stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).forEach(gro -> ids.add((Long)gro.get("id")));
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("id", "in", ids));
        } else {
            DynamicObjectCollection docs = (DynamicObjectCollection)this.getModel().getValue("bizsubarea");
            docs.stream().map(doc -> doc.get(1)).map(doc -> (DynamicObject)doc).forEach(doc -> subAreaIds.add((Long)doc.get("id")));
            dyc.stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).forEach(gro -> ids.add((Long)gro.get("id")));
            this.entrySubAreaFilter(subAreaIds);
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("group", "in", ids).and(new QFilter("id", "in", subAreaIds)));
        }
    }

    private void entrySubAreaFilter(HashSet<Long> subAreaIds) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        EntryGrid grid = (EntryGrid)this.getControl("entryentity");
        int focusRow = grid.getEntryState().getFocusRow();
        HashSet entrySelectedIds = new HashSet();
        DynamicObjectCollection entryEntityBackup = entryEntity;
        entryEntityBackup.remove(focusRow);
        for (int i = 0; i < entryEntityBackup.size(); ++i) {
            DynamicObjectCollection dys = ((DynamicObject)entryEntityBackup.get(i)).getDynamicObjectCollection("entrybizsubarea");
            dys.stream().map(doc -> doc.get(1)).map(doc -> (DynamicObject)doc).forEach(doc -> entrySelectedIds.add((Long)doc.get("id")));
        }
        entrySelectedIds.forEach(id -> {
            if (subAreaIds.contains(id)) {
                subAreaIds.remove(id);
            }
        });
    }

    private void showMsg(BeforeF7SelectEvent evt, String field, DynamicObjectCollection dyc) {
        if (CollectionUtils.isEmpty((Collection)dyc)) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u8bf7\u586b\u5199\u5355\u636e\u5934\u4fe1\u606f\uff1a%s\u3002\u201d", (String)"InitPlanEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getModel().getProperty(field).getDisplayName()));
            evt.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.changeRowIndex = e.getChangeSet()[0].getRowIndex();
        String changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElse("");
        if (this.fieldSet.contains(changeFieldName + this.changeRowIndex)) {
            return;
        }
        this.fieldSet.add(changeFieldName + this.changeRowIndex);
        switch (changeFieldName) {
            case "configmode": {
                if ((Integer)this.getModel().getValue("layer") == 5) {
                    return;
                }
                this.changePanel();
                break;
            }
            case "group": {
                this.setLock();
                this.getModel().setValue("bizsubarea", null);
                break;
            }
            case "bizsubarea": 
            case "industrytype": {
                Object configMode = this.getModel().getValue("configmode");
                if (ObjectUtils.isEmpty((Object)configMode)) {
                    return;
                }
                if (HRStringUtils.equals((String)configMode.toString(), (String)"A")) {
                    this.addEntity();
                }
                if (HRStringUtils.equals((String)configMode.toString(), (String)"B")) {
                    InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), false, this.getIndustry());
                    break;
                }
                InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), true, this.getIndustry());
                break;
            }
            case "startdate": {
                this.billHeadDataCheck("startdate");
                break;
            }
            case "enddate": {
                this.billHeadDataCheck("enddate");
                break;
            }
            case "entrystartdate": {
                this.checkDate("entrystartdate");
                break;
            }
            case "entryenddate": {
                this.checkDate("entryenddate");
                break;
            }
            case "entrygroup": {
                this.getModel().setValue("entrybizsubarea", null, this.changeRowIndex);
                break;
            }
            default: {
                return;
            }
        }
    }

    private void changePanel() {
        String configMode = (String)this.getModel().getValue("configmode");
        if (HRStringUtils.equals((String)configMode, (String)this.getView().getPageCache().get(PAGE_CACHE_CONFIGMODE))) {
            return;
        }
        if (HRStringUtils.equals((String)configMode, (String)"A") && ObjectUtils.isEmpty((Object)this.getModel().getEntryEntity("itementryentity"))) {
            this.planPanelShow();
            this.addEntity();
            this.getView().getPageCache().put(PAGE_CACHE_CONFIGMODE, configMode);
            return;
        }
        if (HRStringUtils.equals((String)configMode, (String)"B") && ObjectUtils.isEmpty((Object)this.getModel().getEntryEntity("entryentity")) && ObjectUtils.isEmpty((Object)this.getModel().getEntryEntity("itementryentity"))) {
            this.implItemPanelShow();
            InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), false, this.getIndustry());
            this.getView().getPageCache().put(PAGE_CACHE_CONFIGMODE, configMode);
            return;
        }
        if (HRStringUtils.equals((String)configMode, (String)"C") && ObjectUtils.isEmpty((Object)this.getModel().getEntryEntity("entryentity")) && ObjectUtils.isEmpty((Object)this.getModel().getEntryEntity("itementryentity"))) {
            this.implItemPanelShow();
            InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), true, this.getIndustry());
            this.getView().getPageCache().put(PAGE_CACHE_CONFIGMODE, configMode);
            return;
        }
        if (!HRStringUtils.equals((String)configMode, (String)this.getView().getPageCache().get(PAGE_CACHE_CONFIGMODE))) {
            this.openConfirmBox();
        }
    }

    private void billHeadDataCheck(String field) {
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        Date endDate = this.getModel().getDataEntity().getDate("enddate");
        String startName = this.getModel().getProperty("startdate").getDisplayName().toString();
        String endName = this.getModel().getProperty("enddate").getDisplayName().toString();
        if (this.dayAfter(startDate, endDate)) {
            this.showMsg(field, String.format(Locale.ROOT, "%s%s%s", startName, this.GREATERTHAN, endName), 0);
            return;
        }
        DynamicObjectCollection docs = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)docs)) {
            return;
        }
        if (HRStringUtils.equals((String)field, (String)"startdate")) {
            for (DynamicObject doc : docs) {
                Date sonStartDate = doc.getDate("entrystartdate");
                String sonStartDateName = ((IDataEntityProperty)doc.getDataEntityType().getProperties().get((Object)"entrystartdate")).getDisplayName().toString();
                if (sonStartDate == null || !this.dayAfter(startDate, sonStartDate)) continue;
                this.showMsg(field, String.format(Locale.ROOT, "%s%s%s", startName, this.GREATERTHAN, sonStartDateName), 0);
            }
        } else {
            for (DynamicObject doc : docs) {
                Date sonEndDate = doc.getDate("entryenddate");
                String sonEndDateName = ((IDataEntityProperty)doc.getDataEntityType().getProperties().get((Object)"entryenddate")).getDisplayName().toString();
                if (sonEndDate == null || !this.dayAfter(sonEndDate, endDate)) continue;
                this.showMsg(field, String.format(Locale.ROOT, "%s%s%s", endName, this.LESSTHAN, sonEndDateName), 0);
            }
        }
    }

    private void checkDate(String sonField) {
        Date startDate = this.getModel().getDataEntity().getDate("startdate");
        Date endDate = this.getModel().getDataEntity().getDate("enddate");
        DynamicObject currentRowEntity = this.getModel().getEntryRowEntity("entryentity", this.changeRowIndex);
        Date sonStartDate = currentRowEntity.getDate("entrystartdate");
        Date sonEndDate = currentRowEntity.getDate("entryenddate");
        String startName = this.getModel().getProperty("startdate").getDisplayName().toString();
        String endName = this.getModel().getProperty("enddate").getDisplayName().toString();
        String sonFieldName = ((IDataEntityProperty)currentRowEntity.getDataEntityType().getProperties().get((Object)sonField)).getDisplayName().toString();
        String sonStartName = ((IDataEntityProperty)currentRowEntity.getDataEntityType().getProperties().get((Object)"entrystartdate")).getDisplayName().toString();
        String sonEndName = ((IDataEntityProperty)currentRowEntity.getDataEntityType().getProperties().get((Object)"entryenddate")).getDisplayName().toString();
        if (this.dayAfter(startDate, sonStartDate)) {
            this.showMsg(sonField, String.format(Locale.ROOT, "%s%s%s", sonFieldName, this.LESSTHAN, startName), this.changeRowIndex);
        }
        if (this.dayAfter(sonStartDate, endDate)) {
            this.showMsg(sonField, String.format(Locale.ROOT, "%s%s%s", sonFieldName, this.GREATERTHAN, endName), this.changeRowIndex);
        }
        if (this.dayAfter(startDate, sonEndDate)) {
            this.showMsg(sonField, String.format(Locale.ROOT, "%s%s%s", sonFieldName, this.LESSTHAN, startName), this.changeRowIndex);
        }
        if (this.dayAfter(sonEndDate, endDate)) {
            this.showMsg(sonField, String.format(Locale.ROOT, "%s%s%s", sonFieldName, this.GREATERTHAN, endName), this.changeRowIndex);
        }
        if (this.dayAfter(sonStartDate, sonEndDate)) {
            this.showMsg(sonField, String.format(Locale.ROOT, "%s%s%s", sonStartName, this.GREATERTHAN, sonEndName), this.changeRowIndex);
        }
    }

    private boolean dayAfter(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        return startDate.after(endDate);
    }

    private void showMsg(String feild, String msg, int lineNum) {
        this.getModel().setValue(feild, null, lineNum);
        this.getView().showErrorNotification(msg);
    }

    private void addEntity() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = this.getTableValueSetter();
        DynamicObjectCollection groups = (DynamicObjectCollection)this.getModel().getValue("group");
        DynamicObjectCollection subareas = (DynamicObjectCollection)this.getModel().getValue("bizsubarea");
        String tip = ResManager.loadKDString((String)"\u521d\u59cb\u5316", (String)"InitPlanEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
        if (groups.size() > 1) {
            groups.forEach(group -> {
                DynamicObjectCollection dys = new DynamicObjectCollection();
                long groupId = (Long)group.get("fbasedataid_id");
                subareas.forEach(sub -> {
                    if (groupId == (Long)((DynamicObject)sub.get(1)).get("group.id")) {
                        dys.add(sub);
                    }
                });
                vs.addRow(new Object[]{null, this.getCodeRule(), ((DynamicObject)group.get(1)).getString("name") + tip, new DynamicObjectCollection((DynamicObject)group){
                    final /* synthetic */ DynamicObject val$group;
                    {
                        this.val$group = dynamicObject;
                        this.add(this.val$group);
                    }
                }, dys});
            });
        } else {
            subareas.forEach(sub -> vs.addRow(new Object[]{null, this.getCodeRule(), ((DynamicObject)sub.get(1)).getString("name") + tip, this.getModel().getValue("group"), new DynamicObjectCollection((DynamicObject)sub){
                final /* synthetic */ DynamicObject val$sub;
                {
                    this.val$sub = dynamicObject;
                    this.add(this.val$sub);
                }
            }}));
        }
        this.getModel().deleteEntryData("entryentity");
        model.batchCreateNewEntryRow("entryentity", vs);
        if (!CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null)) {
            this.lockEntryNumberField(true);
        } else {
            this.lockEntryNumberField(false);
        }
    }

    private String getCodeRule() {
        boolean isExist = CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null);
        boolean isAddView = CodeRuleServiceHelper.isAddView((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null);
        if (!isExist) {
            return null;
        }
        if (!isAddView) {
            return ResManager.loadKDString((String)"\u7cfb\u7edf\u81ea\u52a8\u751f\u6210", (String)"InitPlanEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
        }
        return CodeRuleServiceHelper.getNumber((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null);
    }

    private void lockEntryNumberField(boolean islock) {
        if (this.codeRuleIsEdit()) {
            EntryGrid grid = (EntryGrid)this.getControl("entryentity");
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entryEntity.size(); ++i) {
                ((FieldEdit)grid.getFieldEdits().get(0)).setEnable("entrynumber", islock, i);
            }
        }
    }

    private void lockNumberField(boolean islock) {
        if (this.codeRuleIsEdit()) {
            this.getView().setEnable(Boolean.valueOf(islock), new String[]{"number"});
        }
    }

    private boolean codeRuleIsEdit() {
        boolean isModifiable = CodeRuleServiceHelper.isModifiable((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null);
        boolean isAddView = CodeRuleServiceHelper.isAddView((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null);
        return !isModifiable || !isAddView;
    }

    private TableValueSetter getTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("id", new Object[0]);
        vs.addField("entrynumber", new Object[0]);
        vs.addField("entryname", new Object[0]);
        vs.addField("entrygroup", new Object[0]);
        vs.addField("entrybizsubarea", new Object[0]);
        vs.addField("entrystartdate", new Object[0]);
        vs.addField("entryenddate", new Object[0]);
        vs.addField("entryplanperson", new Object[0]);
        vs.addField("entrydatarange", new Object[0]);
        return vs;
    }

    private void openConfirmBox() {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u914d\u7f6e\u65b9\u5f0f\u5c06\u6e05\u7a7a\u5df2\u914d\u7f6e\u6570\u636e\uff0c\u662f\u5426\u786e\u5b9a\u5207\u6362\uff1f", (String)"InitPlanEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("configmode", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (HRStringUtils.equals((String)"configmode", (String)evt.getCallBackId())) {
            String currConfigMode = (String)this.getModel().getValue("configmode");
            TextEdit edit = (TextEdit)this.getView().getControl("number");
            edit.setFocus(true);
            if (evt.getResult() == MessageBoxResult.Yes) {
                switch (currConfigMode) {
                    case "A": {
                        this.planPanelShow();
                        this.getModel().deleteEntryData("itementryentity");
                        this.addEntity();
                        break;
                    }
                    case "B": 
                    case "C": {
                        this.implItemPanelShow();
                        if (HRStringUtils.equals((String)currConfigMode, (String)"B")) {
                            InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), false, this.getIndustry());
                        } else {
                            InitPlanFormUtils.autoGenerateItemEntry(this.getModel(), this.getView(), true, this.getIndustry());
                        }
                        this.getModel().deleteEntryData("entryentity");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                this.getView().getPageCache().put(PAGE_CACHE_CONFIGMODE, currConfigMode);
            } else {
                String cacheConfigMode = this.getView().getPageCache().get(PAGE_CACHE_CONFIGMODE);
                this.getModel().setValue("configmode", (Object)cacheConfigMode);
            }
        }
        if (HRStringUtils.equals((String)STARTUP, (String)evt.getCallBackId()) && evt.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("startup_frontimpl_confirmed", "startup_frontimpl_confirmed");
            this.getView().invokeOperation(STARTUP);
        }
    }

    private void planPanelShow() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"planpanel"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"implitempanel"});
    }

    private void implItemPanelShow() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"planpanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"implitempanel"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getControl("advcontoolbarap1");
        toolbar.addItemClickListener((ItemClickListener)this);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("entrygroup");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit_1 = (BasedataEdit)this.getControl("entrybizsubarea");
        basedataEdit_1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit basedataEdit_2 = (BasedataEdit)this.getControl("bizsubarea");
        basedataEdit_2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit execUserEdit = (BasedataEdit)this.getControl("executeperson");
        execUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit verifyUserEdit = (BasedataEdit)this.getControl("verifyperson");
        verifyUserEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit planPersonEdit = (BasedataEdit)this.getControl("planperson");
        planPersonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryPlanPersonEdit = (BasedataEdit)this.getControl("entryplanperson");
        entryPlanPersonEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Label deployLabel = (Label)this.getControl("deployintegration");
        deployLabel.addClickListener((ClickListener)this);
        BasedataEdit sourceSystemEdit = (BasedataEdit)this.getControl("sourcesystem");
        sourceSystemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"newentry", (String)formOperate.getOperateKey())) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)this.getModel().getDataEntity().getDynamicObjectCollection("bizsubarea"))) {
                this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c\u8bf7\u586b\u5199\u5355\u636e\u5934\u4fe1\u606f\uff1a%s\u3002\u201d", (String)"InitPlanEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), this.getModel().getProperty("bizsubarea").getDisplayName().toString()));
                args.setCancel(true);
                return;
            }
            if (entryEntity.size() >= 20) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b50\u8ba1\u5212\u6700\u5927\u652f\u6301\u62c6\u520620\u4e2a\u3002\u5f53\u524d\u5df2\u8fbe\u6700\u5927\u503c\uff0c\u65e0\u6cd5\u7ee7\u7eed\u62c6\u5206\u3002", (String)"InitPlanEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            } else {
                this.addEntryRow();
            }
            args.setCancel(true);
        } else if (HRStringUtils.equals((String)"prestartup", (String)formOperate.getOperateKey())) {
            if (InitPermHelper.hasNotPermission("4715a0df000000ac", this.getView(), "hric_plantreelist")) {
                args.setCancel(true);
                return;
            }
            if (this.isStartup()) {
                return;
            }
            this.isStartUpSave = true;
            if (this.invokeOperation(args, "save")) {
                return;
            }
            if (this.implItemEntityIsEmpty(args)) {
                return;
            }
            if (this.skipVaildateIsPass(args)) {
                return;
            }
            this.invokeOperation(args, STARTUP);
        } else if (HRStringUtils.equals((String)STARTUP, (String)formOperate.getOperateKey())) {
            args.setCancel(new InitPlanFrontImplHandle(this, this.getModel()).doValidate());
        } else if (HRStringUtils.equals((String)"save", (String)formOperate.getOperateKey())) {
            if (InitPermHelper.hasNotPermission("4715a0df000000ac", this.getView(), "hric_plantreelist")) {
                args.setCancel(true);
                return;
            }
            if (this.isStartup()) {
                args.setCancel(true);
            }
        }
    }

    private boolean skipVaildateIsPass(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection implItem;
        boolean allPass;
        String configMode = this.getModel().getValue("configmode").toString();
        if (AppConstants.CONFIG_MODE_LIST.contains(configMode) && !(allPass = (implItem = this.getModel().getEntryEntity("itementryentity")).stream().anyMatch(impl -> !impl.getBoolean("isskip")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u6709\u914d\u7f6e\u5b9e\u65bd\u9879\u5747\u4e3a\u8df3\u8fc7\u72b6\u6001\uff0c\u65e0\u6cd5\u542f\u52a8\u3002", (String)"InitPlanEditPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private boolean implItemEntityIsEmpty(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dys;
        String configMode = this.getModel().getValue("configmode").toString();
        if (AppConstants.CONFIG_MODE_LIST.contains(configMode) && CollectionUtils.isEmpty((Collection)(dys = this.getModel().getEntryEntity("itementryentity")))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u5b9e\u65bd\u9879\u540e\u518d\u542f\u52a8\u3002", (String)"InitPlanEditPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return true;
        }
        return false;
    }

    private boolean isStartup() {
        long pkId = this.getModel().getDataEntity().getLong("id");
        DynamicObject currPlan = InitPlanServiceHelper.getPlansById((Long)pkId);
        if (!ObjectUtils.isEmpty((Object)currPlan) && !HRStringUtils.equals((String)currPlan.getString("planstatus"), (String)"A")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u5df2\u542f\u52a8\uff0c\u65e0\u6cd5\u8fdb\u884c\u6b64\u64cd\u4f5c\u3002", (String)"InitPlanEditPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private boolean invokeOperation(BeforeDoOperationEventArgs args, String btn) {
        OperationResult result = this.getView().invokeOperation(btn);
        args.setCancel(!result.isSuccess());
        return !result.isSuccess();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"save", (String)formOperate.getOperateKey()) && this.resultIsNull(args)) {
            if (this.isStartUpSave) {
                args.getOperationResult().setShowMessage(false);
            }
            this.isStartUpSave = false;
            this.afterSaveReLoadEntity();
            this.cleanParentPageSessionCache();
        } else if (HRStringUtils.equals((String)STARTUP, (String)formOperate.getOperateKey()) && this.resultIsNull(args)) {
            this.getView().setVisible(Boolean.FALSE, PLAN_BTN);
            this.getView().setStatus(OperationStatus.VIEW);
            this.getModel().setValue("planstatus", (Object)"B");
            this.getModel().setDataChanged(false);
            this.cleanParentPageSessionCache();
        }
    }

    private void cleanParentPageSessionCache() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        SessionManager.getCurrent().put(this.getView().getParentView().getPageId() + "newAdd", "");
    }

    private void afterSaveReLoadEntity() {
        DynamicObject dyc = this.getModel().getDataEntity();
        String configMode = dyc.getString("configmode");
        if (HRStringUtils.equals((String)configMode, (String)"A")) {
            this.getModel().deleteEntryData("entryentity");
            this.loadEntity(dyc, true);
            if (CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null)) {
                this.lockEntryNumberField(false);
            } else {
                this.lockEntryNumberField(true);
            }
        }
    }

    private boolean resultIsNull(AfterDoOperationEventArgs args) {
        return args.getOperationResult() != null && args.getOperationResult().isSuccess();
    }

    private void addEntryRow() {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = this.getTableValueSetter();
        vs.addRow(new Object[]{null, this.getCodeRule()});
        this.getModel().beginInit();
        model.batchCreateNewEntryRow("entryentity", vs);
        this.getModel().endInit();
        this.getView().updateView("subplanmap");
        if (!CodeRuleServiceHelper.isExist((String)"hric_initplan", (DynamicObject)this.getModel().getDataEntity(), null)) {
            this.lockEntryNumberField(true);
        } else {
            this.lockEntryNumberField(false);
        }
    }

    private void setLock() {
        DynamicObjectCollection groupCol = (DynamicObjectCollection)this.getModel().getValue("group");
        if (CollectionUtils.isEmpty((Collection)groupCol)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizsubarea"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizsubarea"});
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String controlKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            controlKey = ((Control)source).getKey();
        }
        if (HRStringUtils.equals((String)"deployintegration", (String)controlKey)) {
            OpenPageUtils.openMenu((IFormView)this.getView(), (String)"1307812164626595840", (String)"TV3/VDJ86RC", null);
        }
    }

    private DynamicObject getIndustry() {
        return this.getModel().getDataEntity().getDynamicObject("industrytype");
    }
}

