/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.bussiness.service.RPCServiceHelper;
import kd.hrmp.hric.common.InitMessageInfoBuilder;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.formplugin.web.BosUserF7AndInitFinishPlugin;
import kd.hrmp.hric.formplugin.web.InitPermHelper;
import kd.hrmp.hric.formplugin.web.util.InitPlanFormUtils;
import org.apache.commons.lang3.StringUtils;

public class InitPlanListPlugin
extends BosUserF7AndInitFinishPlugin {
    private String PLAN_TOP_TIPS = ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u8ba1\u5212\uff0c\u6210\u529f\u5206\u914d%2$s\u6761\uff0c\u5931\u8d25\u5206\u914d%3$s\u6761\u3002", (String)"InitPlanListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String PLAN_VERIFY_TIPS = ResManager.loadKDString((String)"%s\u5df2\u5b8c\u6210\uff0c\u65e0\u6cd5\u91cd\u65b0\u5206\u914d\u8d1f\u8d23\u4eba\u3002", (String)"InitPlanListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TITLE = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f85\u529e\u4efb\u52a1\u901a\u77e5\u3002", (String)"InitPlanListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TAG = ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitPlanListPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_ONE = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u8ba1\u5212\u914d\u7f6e\u4efb\u52a1%2$s", (String)"InitPlanListPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_TWO = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u8ba1\u5212%2$s\uff0c\u8bf7\u8ddf\u8fdb\u8ba1\u5212\u8fdb\u5ea6", (String)"InitPlanListPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final List<String> BTN_LIST = Lists.newArrayList((Object[])new String[]{"reassignperson", "initfinishbtn"});
    private static final String IS_SHOWUSED = "isshowdisabled";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object planId = this.getView().getFormShowParameter().getCustomParams().get("id");
        if (!HRObjectUtils.isEmpty(planId)) {
            DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)((Long)planId));
            this.setPanel(plan);
        }
        this.getView().setVisible(Boolean.valueOf(((ListShowParameter)this.getView().getFormShowParameter()).isShowUsed()), new String[]{IS_SHOWUSED});
    }

    private void setPanel(DynamicObject plan) {
        String status = plan.getString("planstatus");
        boolean mutex = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("mutex");
        if (!mutex) {
            this.getView().setEnable(Boolean.valueOf(false), BTN_LIST.toArray(new String[0]));
        }
        this.planShow(status);
        if (null != plan.getDynamicObject("parent")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"initfinishbtn"});
            if (!HRStringUtils.equals((String)status, (String)"B")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
            }
        }
    }

    private void planShow(String status) {
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)status, (String)"B")), new String[]{"reassignperson"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (InitPermHelper.hasPermShowTipForParent("4715a0df000000ac", this.getView(), "hric_plantreelist") || !InitPermHelper.checkDataRule(this.getPkId(), true, this.getView())) {
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "reassignperson": {
                this.showBosUser();
                break;
            }
            case "initfinishbtn": {
                this.getInitTasks();
                if (!this.checkPreTaskInitFinishStatusIsCompleted() || !this.checkTaskInitFinishStatusIsCompleted() || !this.checkPlanStatus()) break;
                this.formShowParameter("plan");
                break;
            }
        }
    }

    private void recordPlanLogStr() {
        List planIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] plans = InitPlanServiceHelper.getPlanStructNumberByIdList(planIds);
        StringBuilder builder = new StringBuilder();
        Arrays.stream(plans).forEach(plan -> {
            builder.append(plan.getLocaleString("name").getLocaleValue());
            builder.append(",");
        });
        this.logStr = builder.toString();
    }

    private void showBosUser() {
        for (ListSelectedRow plan : this.getSelectedRows()) {
            if (((Long)plan.getPrimaryKeyValue()).longValue() != this.getPkId()) continue;
            this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u91cd\u65b0\u5206\u914d\u5f53\u524d\u8ba1\u5212\u7684\u8d1f\u8d23\u4eba\u5417\uff1f\u91cd\u65b0\u5206\u914d\u540e\uff0c\u4f60\u53ef\u80fd\u65e0\u6cd5\u67e5\u770b\u6b64\u8ba1\u5212\u3002", (String)"InitPlanListPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("reassignperson", (IFormPlugin)this));
            return;
        }
        ListShowParameter showParameter = this.showF7Base("reassignperson", "hric_bosuserlayout");
        showParameter.getListFilterParameter().setFilter(QFilterUtils.getEnableQFilter());
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (HRStringUtils.equals((String)evt.getCallBackId(), (String)"reassignperson") && evt.getResult() == MessageBoxResult.Yes) {
            ListShowParameter showParameter = this.showF7Base("reassignperson", "hric_bosuserlayout");
            showParameter.getListFilterParameter().setFilter(QFilterUtils.getEnableQFilter());
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"reassignperson") && closedCallBackEvent.getReturnData() != null) {
            this.updatePersonForPlan(closedCallBackEvent);
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"hric_initfinishopconf") && closedCallBackEvent.getReturnData() != null) {
            this.getInitTasks();
            this.recordPlanLogStr();
            this.opType = "plan";
            InitTaskServiceHelper.setTaskLock((DynamicObject[])this.initTaskDycs, (HRICErrorEnum)HRICErrorEnum.PLAN_OR_TASK_ERROR, () -> this.initTaskCompleteHandle());
        }
    }

    private void getInitTasks() {
        DynamicObject[] dys = InitPlanServiceHelper.getSubInitPlansByStructNumbers(this.getStructNumber());
        List subPlanIdList = Arrays.stream(dys).map(dyc -> dyc.getLong("id")).collect(Collectors.toList());
        this.initTaskDycs = InitTaskServiceHelper.getNonExecImplItemTaskByPlanIds(subPlanIdList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePersonForPlan(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        ListSelectedRow userRow = rowList.get(0);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List planIds = selectedRows.stream().map(it -> (Long)it.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] planList = InitPlanServiceHelper.getPlansByIdList(planIds);
        DynamicObjectCollection canChangePlan = new DynamicObjectCollection();
        DynamicObjectCollection errRows = new DynamicObjectCollection();
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>();
        for (DynamicObject plan : planList) {
            if (!HRStringUtils.equals((String)plan.getString("planstatus"), (String)"C")) {
                if (null != plan.getDynamicObject("planperson") && plan.getDynamicObject("planperson").getLong("id") == ((Long)userRow.getPrimaryKeyValue()).longValue()) {
                    canChangePlan.add((Object)plan);
                    continue;
                }
                plan.set("planperson", (Object)((Long)userRow.getPrimaryKeyValue()));
                canChangePlan.add((Object)plan);
                this.buildInfo(plan, infoList);
                continue;
            }
            errRows.add((Object)plan);
        }
        try (TXHandle required = TX.required();){
            if (!CollectionUtils.isEmpty((Collection)canChangePlan)) {
                InitPlanServiceHelper.updatePlanInfo((DynamicObject[])planList);
            }
            if (!CollectionUtils.isEmpty(infoList)) {
                MessageSendServiceHelper.saveMessage(infoList);
            }
        }
        AsyncTaskServiceHelper.startJob();
        this.showConfirmMessage(this.PLAN_TOP_TIPS, selectedRows, errRows, this.PLAN_VERIFY_TIPS);
    }

    private void buildInfo(DynamicObject plan, List<InitMessageInfo> infoList) {
        ArrayList<Long> receivers = new ArrayList<Long>();
        receivers.add(plan.getLong("planperson"));
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)"name");
        String entityName = "";
        Long entityId = 0L;
        String content = "";
        if (HRStringUtils.equals((String)plan.getString("planstatus"), (String)"A")) {
            entityName = "hric_initplan";
            entityId = plan.getLong("id");
            content = String.format(Locale.ROOT, this.MESSAGE_CONTENT_ONE, UserServiceHelper.getCurrentUser((String)"name").getString("name"), plan.getString("name"));
        } else {
            entityName = "hric_initplandetail";
            entityId = plan.getLong("id");
            content = String.format(Locale.ROOT, this.MESSAGE_CONTENT_TWO, UserServiceHelper.getCurrentUser((String)"name").getString("name"), plan.getString("name"));
        }
        InitMessageInfo info = new InitMessageInfoBuilder().buildReceivers(receivers).buildSenderName(currentUser.getString("name")).buildSenderId(Long.valueOf(currentUser.getLong("id"))).buildEntityName(entityName).buildEntityId(entityId).buildContent(content).buildTitle(this.MESSAGE_TITLE).buildTag(this.MESSAGE_TAG).build();
        infoList.add(info);
    }

    public void packageData(PackageDataEvent e) {
        if (HRStringUtils.equals((String)"name", (String)((AbstractColumnDesc)e.getSource()).getKey())) {
            DynamicObject rowData = e.getRowData();
            Object planId = this.getView().getFormShowParameter().getCustomParams().get("id");
            if (!HRObjectUtils.isEmpty(planId) && rowData.getLong("id") == ((Long)planId).longValue()) {
                e.getNoLinkKey().add("name");
            }
        }
    }

    public void setFilter(SetFilterEvent event) {
        super.setFilter(event);
        for (int index = event.getQFilters().size() - 1; index >= 0; --index) {
            QFilter qFilter = (QFilter)event.getQFilters().get(index);
            if (!HRStringUtils.equals((String)qFilter.getProperty(), (String)"status") && !HRStringUtils.equals((String)qFilter.getProperty(), (String)"enable")) continue;
            event.getQFilters().remove(index);
        }
        event.getQFilters().add(new QFilter("planstatus", "!=", (Object)"E"));
        if (((ListShowParameter)this.getView().getFormShowParameter()).isF7ClickByFilter()) {
            if (HRStringUtils.isNotEmpty((String)((String)this.getView().getFormShowParameter().getCustomParam("filterplanstatus")))) {
                event.getQFilters().add(new QFilter("planstatus", "!=", this.getView().getFormShowParameter().getCustomParam("filterplanstatus")));
            }
            QFilter dataRuleFilter = null;
            try {
                dataRuleFilter = RPCServiceHelper.getInitPlanDataRuleQFilter();
            }
            catch (Exception e) {
                LOG.error("[HRIC] Call RPC IHRCSDataPermissionService-getDataRule", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u89c4\u5219\u83b7\u53d6\u51fa\u9519\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitPlanListPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                dataRuleFilter = new QFilter("id", "=", (Object)0L);
            }
            if (dataRuleFilter != null) {
                event.getQFilters().add(dataRuleFilter);
            }
            event.setOrderBy("createtime desc");
        } else {
            String structNumber = (String)this.getView().getFormShowParameter().getCustomParam("structnumber");
            if (StringUtils.isNotEmpty((CharSequence)structNumber)) {
                event.getQFilters().add(new QFilter("structnumber", "like", (Object)(structNumber + "%")));
            }
            event.setOrderBy("layer asc, planstatus asc");
        }
        event.setDataPermQFilters(new ArrayList(0));
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillList source = (BillList)args.getHyperLinkClickEvent().getSource();
        FormShowParameter formShowParameter = source.getView().getFormShowParameter();
        boolean f7ClickByFilter = ((ListShowParameter)formShowParameter).isF7ClickByFilter();
        if (!f7ClickByFilter) {
            args.setCancel(true);
            long pkId = (Long)source.getFocusRowPkId();
            InitPlanFormUtils.linkInitPlan(this.getView(), pkId);
        }
    }

    private long getPkId() {
        Object planId = this.getView().getFormShowParameter().getCustomParams().get("id");
        if (HRObjectUtils.isEmpty(planId)) {
            return 0L;
        }
        return this.getView().getFormShowParameter().getCustomParam("id") instanceof String ? Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("id")) : (Long)this.getView().getFormShowParameter().getCustomParam("id");
    }
}

