/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.form.AbstractFormView;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.JSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IPromptboxDomainService;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.formplugin.web.BosUserF7AndInitFinishPlugin;
import kd.hrmp.hric.formplugin.web.InitPermHelper;

public class InitPlanTaskListPlugin
extends BosUserF7AndInitFinishPlugin {
    private static Log LOG = LogFactory.getLog(InitPlanTaskListPlugin.class);
    private String PLAN_TOP_TIPS = ResManager.loadKDString((String)"\u5171%1$s\u4e2a\u4efb\u52a1\uff0c\u6210\u529f\u5206\u914d%2$s\u6761\uff0c\u5931\u8d25\u5206\u914d%3$s\u6761\u3002", (String)"InitPlanTaskListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String PLAN_VERIFY_TIPS = ResManager.loadKDString((String)"%s\u4efb\u52a1\u4e3a\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u518d\u91cd\u65b0\u5206\u914d\u8d1f\u8d23\u4eba\u3002", (String)"InitPlanTaskListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TITLE = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5f85\u529e\u4efb\u52a1\u901a\u77e5\u3002", (String)"InitPlanTaskListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_TWO = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1%2$s", (String)"InitPlanTaskListPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_CONTENT_THREE = ResManager.loadKDString((String)"%1$s\u7ed9\u60a8\u5206\u914d\u4e86\u4e00\u4e2a\u6570\u636e\u9a8c\u8bc1\u4efb\u52a1%2$s", (String)"InitPlanTaskListPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TAG = ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitPlanTaskListPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ROLLBACK_NOTEXECTASK = ResManager.loadKDString((String)"%s\u4efb\u52a1\u4e0d\u662f\u5b9e\u65bd\u9879\u6267\u884c\u4efb\u52a1\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u6eda\u3002", (String)"InitPlanTaskListPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ROLLBACK_TASKSTATUSNOTFINISH = ResManager.loadKDString((String)"%s\u4efb\u52a1\u72b6\u6001\u4e0d\u662f\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u8fdb\u884c\u56de\u6eda\u3002", (String)"InitPlanTaskListPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ROLLBACK_TASKNOTFINISH = ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u8c03\u7528\u201c\u66f4\u65b0\u521d\u59cb\u5316\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\u201d\u670d\u52a1\uff0c\u4e0d\u80fd\u8fdb\u884c\u56de\u6eda\u201d\u3002", (String)"InitPlanTaskListPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ROLLBACK_POSTTASKMSG = ResManager.loadKDString((String)"\u9009\u4e2d\u4efb\u52a1\u6709\u5173\u8054\u540e\u7f6e\u4efb\u52a1\uff0c\u6b63\u5728\u56de\u6eda\uff0c\u65e0\u6cd5\u8fdb\u884c\u56de\u6eda\u3002", (String)"InitPlanTaskListPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final String[] BTN_ARR = new String[]{"changepeoplebtn", "taskreturnbtn", "inittaskfinish"};
    private final IPromptboxDomainService iPromptboxDomainService = (IPromptboxDomainService)ServiceFactory.getService(IPromptboxDomainService.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long id = (Long)this.getView().getFormShowParameter().getCustomParams().get("id");
        DynamicObject plan = InitPlanServiceHelper.getPlansById((Long)id);
        this.setPanel(plan);
    }

    private void setPanel(DynamicObject plan) {
        String status = plan.getString("planstatus");
        boolean mutex = (Boolean)this.getView().getFormShowParameter().getCustomParams().get("mutex");
        if (!mutex) {
            this.getView().setEnable(Boolean.valueOf(false), BTN_ARR);
        }
        this.initImplShow(status);
        DynamicObject[] subPlans = InitPlanServiceHelper.getSubInitPlansByStructNumber((String)plan.getString("structnumber"));
        boolean flag = Arrays.stream(subPlans).map(it -> it.getDynamicObjectCollection("itementryentity")).anyMatch(it -> it.stream().anyMatch(dyn -> dyn.getBoolean("isskip")));
        this.getView().setVisible(Boolean.valueOf(flag), new String[]{"skipimpl"});
        if (null != plan.getDynamicObject("parent")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"taskreturnbtn", "inittaskfinish"});
            if (!HRStringUtils.equals((String)status, (String)"B") && !flag) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"toolbarap"});
            }
        }
    }

    private void initImplShow(String status) {
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)status, (String)"B")), new String[]{"changepeoplebtn"});
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        List taskList = (List)this.getView().getFormShowParameter().getCustomParams().get("hric_inittask");
        setFilterEvent.getQFilters().add(new QFilter("id", "in", (Object)taskList).and(new QFilter("tasktype", "!=", (Object)"A")).and(new QFilter("taskstatus", "!=", (Object)"Z")));
        setFilterEvent.setDataPermQFilters(new ArrayList(0));
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject dyc = e.getRowData();
        InitTaskServiceHelper.dealPreTask((DynamicObject)dyc);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long id = (Long)this.getView().getFormShowParameter().getCustomParams().get("id");
        if (InitPermHelper.hasPermShowTipForParent("4715a0df000000ac", this.getView(), "hric_plantreelist") || !InitPermHelper.checkDataRule(id, true, this.getView())) {
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "changepeoplebtn": {
                this.showBosUser("changepeoplebtn");
                break;
            }
            case "taskreturnbtn": {
                this.taskRollback();
                break;
            }
            case "inittaskfinish": {
                this.getInitTasks();
                if (!this.checkPreTaskInitFinishStatusIsCompleted() || !this.checkTaskInitFinishStatusIsCompleted() || !this.checkTaskStatus()) break;
                this.bizTaskAgainConfirm();
                break;
            }
            case "skipimpl": {
                this.showSkipImpl();
                break;
            }
        }
    }

    private void bizTaskAgainConfirm() {
        if (ObjectUtils.isEmpty((Object[])this.initTaskDycs)) {
            this.formShowParameter("task");
            return;
        }
        if (this.initTaskDycs.length > 1) {
            this.formShowParameter("task");
            return;
        }
        DynamicObject task = this.initTaskDycs[0];
        if (HRStringUtils.equals((String)task.getDynamicObject("implitemrel").getString("initfordatasource"), (String)"C")) {
            this.formShowParameter("task");
            return;
        }
        if (task.getBoolean("haschildren")) {
            this.formShowParameter("task");
            return;
        }
        String tip = this.iPromptboxDomainService.getTipByEntityAndOp(task.getDynamicObject("implitemrel").getDynamicObject("entityobjscope").getPkValue(), "D");
        if (HRStringUtils.isEmpty((String)tip)) {
            this.formShowParameter("task");
            return;
        }
        this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("inittaskfinish", (IFormPlugin)this));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (HRStringUtils.equals((String)messageBoxClosedEvent.getCallBackId(), (String)"inittaskfinish") && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            this.initTaskFinish();
        }
    }

    private void showSkipImpl() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hric_skipimpl");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", this.getView().getFormShowParameter().getCustomParams().get("id"));
        this.getView().showForm(parameter);
    }

    private void taskRollback() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List taskIds = selectedRows.stream().map(it -> (Long)it.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] taskList = InitTaskServiceHelper.getTaskList(taskIds);
        DynamicObjectCollection errRows = new DynamicObjectCollection();
        String tipMsg = this.validateStatusAndType(taskList, errRows);
        if (errRows.size() > 0) {
            this.addAction(tipMsg, MessageTypes.Default, null, (AbstractFormView)this.getView());
            return;
        }
        List postTasks = InitTaskServiceHelper.getPostTaskListByPlan((DynamicObject[])taskList);
        if (postTasks == null) {
            return;
        }
        boolean canRollBack = true;
        for (DynamicObject dyn : postTasks) {
            if (!HRStringUtils.equals((String)dyn.getString("taskstatus"), (String)"E") && !HRStringUtils.equals((String)dyn.getString("taskstatus"), (String)"F")) continue;
            canRollBack = false;
            break;
        }
        if (!canRollBack) {
            this.addAction(this.ROLLBACK_POSTTASKMSG, MessageTypes.Default, null, (AbstractFormView)this.getView());
            return;
        }
        this.showRollBackForm(postTasks, taskList);
    }

    private String validateStatusAndType(DynamicObject[] taskList, DynamicObjectCollection errRows) {
        StringBuilder tipMsg = new StringBuilder();
        for (DynamicObject task : taskList) {
            if (!HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")) {
                tipMsg.append(String.format(Locale.ROOT, this.ROLLBACK_NOTEXECTASK, task.getString("name"))).append("\n");
                errRows.add((Object)task);
                continue;
            }
            if (!HRStringUtils.equals((String)task.getString("taskstatus"), (String)"C")) {
                tipMsg.append(String.format(Locale.ROOT, this.ROLLBACK_TASKSTATUSNOTFINISH, task.getString("name"))).append("\n");
                errRows.add((Object)task);
                continue;
            }
            if (!HRStringUtils.equals((String)task.getString("initfinish"), (String)"A")) continue;
            tipMsg.append(String.format(Locale.ROOT, this.ROLLBACK_TASKNOTFINISH, task.getString("name"))).append("\n");
            errRows.add((Object)task);
        }
        return tipMsg.toString();
    }

    private void showRollBackForm(List<DynamicObject> postTasks, DynamicObject[] taskList) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hric_taskrollback");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        try {
            parameter.setCustomParam("rollbacktaskIds", (Object)JSONUtils.toString(postTasks.stream().filter(task -> !HRStringUtils.equals((String)task.getString("taskstatus"), (String)"A")).map(dyn -> dyn.getLong("id")).collect(Collectors.toList())));
            parameter.setCustomParam("selectRollbackTask", (Object)SerializationUtils.serializeToBase64(Arrays.asList(taskList)));
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex);
        }
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnok"));
        this.getView().showForm(parameter);
    }

    private void showBosUser(String panelExecuteCallback) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u64cd\u4f5c\u7684\u884c\u3002", (String)"InitPlanTaskListPlugin_14", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter showParameter = this.showF7Base(panelExecuteCallback, "hric_bosuserlayout");
        showParameter.getListFilterParameter().setFilter(QFilterUtils.getEnableQFilter());
        showParameter.setAppId("hric");
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"changepeoplebtn") && closedCallBackEvent.getReturnData() != null) {
            this.updatePersonForTask(closedCallBackEvent);
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"btnok") && closedCallBackEvent.getReturnData() != null) {
            this.getView().invokeOperation("refresh");
            this.getView().updateView();
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"hric_initfinishopconf") && closedCallBackEvent.getReturnData() != null) {
            this.initTaskFinish();
        }
    }

    private void initTaskFinish() {
        this.getInitTasks();
        this.recordTaskLogStr();
        this.opType = "task";
        InitTaskServiceHelper.setTaskLock((DynamicObject[])this.initTaskDycs, (HRICErrorEnum)HRICErrorEnum.PLAN_OR_TASK_ERROR, () -> this.initTaskCompleteHandle());
    }

    private void getInitTasks() {
        List taskIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toList());
        this.initTaskDycs = InitTaskServiceHelper.getTaskList(taskIds);
    }

    private void recordTaskLogStr() {
        StringBuilder builder = new StringBuilder();
        Arrays.stream(this.initTaskDycs).forEach(task -> {
            builder.append(task.getLocaleString("name").getLocaleValue());
            builder.append(",");
        });
        this.logStr = builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePersonForTask(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection rowList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
        ListSelectedRow userRow = rowList.get(0);
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        List taskIds = selectedRows.stream().map(it -> (Long)it.getPrimaryKeyValue()).collect(Collectors.toList());
        DynamicObject[] taskList = InitTaskServiceHelper.getTaskListContainSonTask(taskIds);
        DynamicObjectCollection canChangeTask = new DynamicObjectCollection();
        DynamicObjectCollection errRows = new DynamicObjectCollection();
        ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>();
        for (DynamicObject task : taskList) {
            if (!HRStringUtils.equals((String)task.getString("taskstatus"), (String)"C")) {
                if (task.getDynamicObject("taskleader").getLong("id") == ((Long)userRow.getPrimaryKeyValue()).longValue()) {
                    canChangeTask.add((Object)task);
                    continue;
                }
                task.set("taskleader", (Object)((Long)userRow.getPrimaryKeyValue()));
                canChangeTask.add((Object)task);
                if (task.getDynamicObject("parent") != null) continue;
                this.buildInfo(task, infoList);
                continue;
            }
            errRows.add((Object)task);
        }
        try (TXHandle required = TX.required();){
            if (!CollectionUtils.isEmpty((Collection)canChangeTask)) {
                InitTaskServiceHelper.updateTaskInfo((DynamicObject[])taskList);
            }
            if (!CollectionUtils.isEmpty(infoList)) {
                MessageSendServiceHelper.saveMessage(infoList);
            }
        }
        AsyncTaskServiceHelper.startJob();
        this.showConfirmMessage(this.PLAN_TOP_TIPS, selectedRows, errRows, this.PLAN_VERIFY_TIPS);
    }

    private void buildInfo(DynamicObject task, List<InitMessageInfo> infoList) {
        InitMessageInfo info = MessageSendServiceHelper.buildTaskMessage((DynamicObject)task, (String)this.MESSAGE_TITLE, (String)this.MESSAGE_TAG, (String)this.buildContent(task));
        infoList.add(info);
    }

    private String buildContent(DynamicObject task) {
        if (HRStringUtils.equals((String)task.getString("tasktype"), (String)"B")) {
            return String.format(Locale.ROOT, this.MESSAGE_CONTENT_TWO, UserServiceHelper.getCurrentUser((String)"name").getString("name"), task.getString("name"));
        }
        return String.format(Locale.ROOT, this.MESSAGE_CONTENT_THREE, UserServiceHelper.getCurrentUser((String)"name").getString("name"), task.getString("name"));
    }
}

