/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.SerializationUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IExecTaskEntityService;
import kd.hrmp.hric.bussiness.service.DiExecTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.factory.ThreadPoolFactory;
import kd.hrmp.hric.bussiness.service.processing.ProcessingServiceFactory;
import kd.hrmp.hric.bussiness.service.task.exec.MidTableAutoGenerateExecTask;
import kd.hrmp.hric.common.OperateEnum;
import kd.hrmp.hric.common.bean.vo.TaskProcessingVO;
import kd.hrmp.hric.common.constants.InitMiddleTemplateConstants;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.common.util.ServiceFlowUtils;

public class InitTaksProgressEditPlugin
extends HRDataBaseEdit
implements ProgresssListener {
    private static Log LOG = LogFactory.getLog(InitTaksProgressEditPlugin.class);
    private static final String LABLE_BTN_FLAG = "lableBtnFlag";
    private String LABEL_TEXT = ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u76d1\u63a7", (String)"InitTaksProgressEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static final String CACHE_MID_TBL_OPERATE_TYPE = "midtbloperatetype";
    private static final String CACHE_TOTAL_NUM = "totalNum";
    private static final String CACHEKEY_STARTPROPGRESS = "startprogress";
    private String DI_TIPS = ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u96c6\u6210\u5931\u8d25\u3002", (String)"InitTaksProgressEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String INIT_CHECK = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6821\u9a8c", (String)"InitTaksProgressEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String BIZ_VALIDATION = ResManager.loadKDString((String)"\u4e1a\u52a1\u6821\u9a8c", (String)"InitTaksProgressEditPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String SYNC_BIZ = ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e", (String)"InitTaksProgressEditPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String ROLLBACK = ResManager.loadKDString((String)"\u6570\u636e\u56de\u6eda", (String)"InitTaksProgressEditPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String SOURCESYSDI = ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u96c6\u6210", (String)"InitTaksProgressEditPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String CURR_OPERATE_FINISH = ResManager.loadKDString((String)"\u66f4\u65b0\u521d\u59cb\u5316\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5b8c\u6210\u3002", (String)"InitTaksProgressEditPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String CURR_OPERATE_VERIFY = ResManager.loadKDString((String)"\u66f4\u65b0\u521d\u59cb\u5316\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u9a8c\u8bc1\u3002", (String)"InitTaksProgressEditPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String CURR_OPERATE_ONGOING = ResManager.loadKDString((String)"\u66f4\u65b0\u521d\u59cb\u5316\u6570\u636e\u72b6\u6001\u4e3a\u8fdb\u884c\u4e2d\u3002", (String)"InitTaksProgressEditPlugin_11", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static List<String> ENDING_STATUS = ImmutableList.of((Object)"S", (Object)"F", (Object)"X", (Object)"P", (Object)"I", (Object)"Failed", (Object)"Complete", (Object)"Terminated", (Object)"Ignored");
    private static List<String> STARTUP_SCHEME_ENDING_STATUS = ImmutableList.of((Object)"S", (Object)"X", (Object)"P", (Object)"I");
    private boolean reloadMidTable;
    private static List<String> BTN_LIST = Lists.newArrayList((Object[])new String[]{"finish", "nopass", "pass", "withdraw"});
    private IExecTaskEntityService iExecTaskEntityService = (IExecTaskEntityService)ServiceFactory.getService(IExecTaskEntityService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.comnRegisterListenet("progressbarap", "quickhandlelabel");
    }

    private void comnRegisterListenet(String panel, String btn) {
        Label quickHandleLabel;
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(panel);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        if ((quickHandleLabel = (Label)this.getView().getControl(btn)) != null) {
            quickHandleLabel.addClickListener((ClickListener)this);
        }
    }

    public void click(EventObject e) {
        super.click(e);
        String opKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            opKey = ((Control)source).getKey();
        }
        String keyType = opKey.substring(0, 5);
        if (HRStringUtils.equals((String)opKey, (String)"quickhandlelabel")) {
            this.autoGenerateTpl();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFormPage();
    }

    private void autoGenerateTpl() {
        long pkId = this.getPkId();
        DynamicObject task = InitTaskServiceHelper.getTask((long)pkId);
        DynamicObject implItemRel = task.getDynamicObject("implitemrel");
        DynamicObject importTemplate = implItemRel.getDynamicObject("initimporttemplat");
        long templateId = importTemplate.getLong("id");
        try {
            new MidTableAutoGenerateExecTask(Long.valueOf(templateId)).generate();
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u8868\u751f\u6210\u5931\u8d25\u3002\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"InitTaksProgressEditPlugin_0", (String)"hrmp-hric-business", (Object[])new Object[0]));
            return;
        }
        ThreadPoolFactory.getCommonExecutor().execute(() -> new MidTableAutoGenerateExecTask().generate());
        this.reloadMidTable = true;
        this.initFormPage();
    }

    private void initFormPage() {
        DynamicObject task = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("taskid")));
        DynamicObject implItemRel = task.getDynamicObject("implitemrel");
        DynamicObject dyc = implItemRel.getDynamicObject("middletableconf");
        if (null == dyc) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"progressbar"});
            LOG.error(ResManager.loadKDString((String)"\u4efb\u52a1{0}:\u70b9\u51fb\u5b8c\u6210\u64cd\u4f5c,\u4efb\u52a1\u5bf9\u5e94\u5b9e\u65bd\u9879\u7684\u4e2d\u95f4\u8868\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6a21\u677f\u548c\u5b9e\u65bd\u9879\u7684\u4e2d\u95f4\u8868\u5b57\u6bb5middletableconf", (String)"InitTaksProgressEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[]{task.getString("name")}));
            return;
        }
        String entityCode = dyc.getString("number");
        String entityName = Optional.ofNullable(implItemRel).map(item -> item.getDynamicObject("entityobjscope")).map(entity -> entity.getString("name")).orElse("");
        Map taskMap = (Map)this.getView().getFormShowParameter().getCustomParam("hric_inittaskform");
        this.getPageCache().put("exec_task_batch_number", String.valueOf(taskMap.get("hrictaskid")));
        this.getPageCache().put("cache_key_initformode", implItemRel.getString("initformode"));
        String initForDataSource = implItemRel.getString("initfordatasource");
        this.getPageCache().put("initForDataSource", initForDataSource);
        this.controlPanelShow(taskMap, "listcontainer", entityCode, entityName);
    }

    private void controlPanelShow(Map<String, Object> taskMap, String midTablePanel, String entityCode, String entityName) {
        if (MetadataDao.checkNumber((String)entityCode)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"progressbar", "listcontainer"});
            this.showParameter(taskMap, midTablePanel, entityCode, entityName);
            this.getView().setVisible(Boolean.FALSE, new String[]{"midtabletippanelap"});
            try {
                TaskProcessingVO processVo = ProcessingServiceFactory.getProcessingService().get(ConvertUtils.toLong((Object)taskMap.get("hrictaskid")));
                if (null != processVo.getTotalCount()) {
                    ((Label)this.getView().getControl("currbtn")).setText(this.getOperateTypeNameByRes(processVo.getOperateEnum().getBtnKey()));
                    this.start(processVo);
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"progressbar"});
            }
            catch (Exception e) {
                LOG.error(e.getMessage());
                this.getView().setVisible(Boolean.FALSE, new String[]{"progressbar"});
                return;
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"progressbar", "listcontainer"});
            this.getView().getParentView().getParentView().setEnable(Boolean.FALSE, BTN_LIST.toArray(new String[0]));
            this.getView().sendFormAction(this.getView().getParentView().getParentView());
        }
    }

    private String getOperateTypeNameByRes(String sign) {
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.INITCHECK.getBtnKey())) {
            return this.INIT_CHECK;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.VERIFY.getBtnKey())) {
            return this.CURR_OPERATE_VERIFY;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.CANCEL_VERIFY.getBtnKey())) {
            return this.CURR_OPERATE_ONGOING;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.FINISH.getBtnKey())) {
            return this.CURR_OPERATE_FINISH;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.CHECK.getBtnKey())) {
            return this.BIZ_VALIDATION;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.SYNC.getBtnKey())) {
            return this.SYNC_BIZ;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.ROLLBACK.getBtnKey())) {
            return this.ROLLBACK;
        }
        if (HRStringUtils.equals((String)sign, (String)OperateEnum.SOURCESYSDI.getBtnKey())) {
            return this.SOURCESYSDI;
        }
        LOG.warn("[HRIC]can not match operate, operate: {}", (Object)sign);
        return "";
    }

    private void showParameter(Map<String, Object> taskMap, String midTablePanel, String entityCode, String entityName) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hric_innerlist");
        showParameter.setBillFormId(entityCode);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(midTablePanel);
        showParameter.setCustomParams(taskMap);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.getListFilterParameter().setFilter(new QFilter("hrictaskid", "=", taskMap.get("hrictaskid")));
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put("mid_table_entityname", entityCode);
        this.getPageCache().put("mid_page_id", showParameter.getPageId());
    }

    public void onProgress(ProgressEvent arg0) {
        String startProgress = (String)HricCacheUtils.get((String)(this.getView().getPageId() + RequestContext.get().getCurrUserId() + CACHEKEY_STARTPROPGRESS), String.class);
        if (this.getTransactionSign()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e8b\u52a1\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u70b9\u51fb\u201c\u4e8b\u52a1\u660e\u7ec6\u201d\u67e5\u770b\u53cd\u9988\u4fe1\u606f\u3002", (String)"InitTaksProgressEditPlugin_12", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            this.getView().getPageCache().put("transaction_detail_sign", "0");
        }
        if (HRStringUtils.isEmpty((String)startProgress)) {
            this.setArgVal(arg0, "not start execution or finish", 100);
            return;
        }
        this.disable();
        this.commonOnProgress(arg0);
    }

    private void disable() {
        String childPageId = this.getPageCache().get("mid_page_id");
        if (HRStringUtils.isNotEmpty((String)childPageId)) {
            IFormView childView = this.getView().getView(childPageId);
            childView.setEnable(Boolean.valueOf(false), InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.toArray(new String[0]));
            this.getView().sendFormAction(childView);
        }
    }

    private boolean getTransactionSign() {
        if (HRStringUtils.isNotEmpty((String)this.getView().getPageCache().get("transaction_detail_sign"))) {
            return false;
        }
        Map taskMap = (Map)this.getView().getFormShowParameter().getCustomParam("hric_inittaskform");
        String key = "transaction_detail_sign" + ConvertUtils.toLong(taskMap.get("hrictaskid"));
        boolean sign = HRStringUtils.isNotEmpty((String)((String)HricCacheUtils.get((String)key, String.class)));
        return sign;
    }

    private void commonOnProgress(ProgressEvent arg0) {
        TaskProcessingVO processVo = ProcessingServiceFactory.getProcessingService().get(ConvertUtils.toLong((Object)this.getPageCache().get("exec_task_batch_number")));
        LOG.debug("process info, {}", (Object)processVo);
        String finishCount = ConvertUtils.toString((Object)processVo.getFinishCount());
        String totalNum = this.getView().getPageCache().get(CACHE_TOTAL_NUM);
        if (HRStringUtils.isNotEmpty((String)processVo.getExecResult())) {
            totalNum = ConvertUtils.toString((Object)processVo.getTotalCount());
            ((Label)this.getView().getControl("totalnum")).setText(totalNum);
        }
        int progress = processVo.isProcessing() ? processVo.getPercent() : 100;
        ((Label)this.getView().getControl("percent")).setText(progress + "%");
        ((Label)this.getView().getControl("currnum")).setText(processVo.isProcessing() ? finishCount : totalNum);
        this.setArgVal(arg0, "in execution", progress);
        progress = this.handleDiProcess(processVo, progress);
        if (progress >= 100) {
            if (HRStringUtils.isNotEmpty((String)processVo.getExecResult())) {
                ((Label)this.getView().getControl("currnum")).setText(ConvertUtils.toString((Object)processVo.getFinishCount()));
            } else {
                ((Label)this.getView().getControl("currnum")).setText(totalNum);
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"prostatus"});
            HricCacheUtils.remove((String)(this.getView().getPageId() + RequestContext.get().getCurrUserId() + CACHEKEY_STARTPROPGRESS));
            ((Label)this.getView().getControl("percent")).setText(progress + "%");
            this.setArgVal(arg0, "execution complete", progress);
            ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
            progressBar.stop();
            DiExecTaskServiceHelper.delExecTaskByInitTaskId((Object)this.getPageCache().get("exec_task_batch_number"));
            this.setBtnStatus(Boolean.TRUE);
            this.refreshChildPage(Boolean.TRUE);
            if (HRStringUtils.equals((String)this.getPageCache().get(CACHE_MID_TBL_OPERATE_TYPE), (String)OperateEnum.INITCHECK.getOperateType()) || HRStringUtils.equals((String)this.getPageCache().get(CACHE_MID_TBL_OPERATE_TYPE), (String)OperateEnum.CHECK.getOperateType()) || HRStringUtils.equals((String)this.getPageCache().get(CACHE_MID_TBL_OPERATE_TYPE), (String)OperateEnum.SYNC.getOperateType()) || HRStringUtils.equals((String)this.getPageCache().get(CACHE_MID_TBL_OPERATE_TYPE), (String)OperateEnum.ROLLBACK.getOperateType())) {
                this.showOperateResult();
            } else {
                this.refreshParentPage();
            }
        }
    }

    private void refreshParentPage() {
        IFormView parentView;
        if (this.getView().getParentView() != null && (parentView = this.getView().getParentView()).getParentView() != null) {
            parentView.getParentView().invokeOperation("refresh");
            this.getView().sendFormAction(parentView.getParentView());
        }
    }

    private void showOperateResult() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hric_middletips");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("id", (Object)this.getPkId());
        parameter.setCustomParam("mid_page_id", (Object)this.getPageCache().get("mid_page_id"));
        this.getView().showForm(parameter);
    }

    private void refreshChildPage(Boolean flag) {
        String childPageId = this.getPageCache().get("mid_page_id");
        if (HRStringUtils.isNotEmpty((String)childPageId)) {
            IFormView childView = this.getView().getView(childPageId);
            childView.setEnable(flag, InitMiddleTemplateConstants.PROCESSING_BTN_STATUS.toArray(new String[0]));
            ListView listView = (ListView)childView;
            listView.refresh();
            BillList billlist = (BillList)childView.getControl("billlistap");
            billlist.refresh();
            this.getView().sendFormAction(childView);
        }
    }

    private int handleDiProcess(TaskProcessingVO processVo, int progress) {
        String execResult = processVo.getExecResult();
        if (HRStringUtils.isNotEmpty((String)execResult) && ENDING_STATUS.contains(execResult)) {
            if (HRStringUtils.equals((String)execResult, (String)"Failed")) {
                this.getView().showMessage(this.DI_TIPS, ResManager.loadKDString((String)"\u670d\u52a1\u6d41\u7a0b\u6267\u884c\u5931\u8d25\u3002\u8bf7\u70b9\u51fb\u201c\u670d\u52a1\u6d41\u7a0b\u76d1\u63a7\u201d\u67e5\u770b\u8be6\u60c5\u3002", (String)"InitTaskFormPlugin_39", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            } else if (HRStringUtils.equals((String)execResult, (String)"F")) {
                this.getView().showMessage(this.DI_TIPS, ResManager.loadKDString((String)"\u201c\u542f\u52a8\u65b9\u6848\u201d\u6267\u884c\u5931\u8d25\u3002\u8bf7\u70b9\u51fb\u201c\u6267\u884c\u65e5\u5fd7\u201d\u67e5\u770b\u8be6\u60c5\u3002", (String)"InitTaskFormPlugin_40", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            } else if (STARTUP_SCHEME_ENDING_STATUS.contains(execResult) && processVo.getTotalCount() == 0L) {
                this.getView().showMessage(this.DI_TIPS, ResManager.loadKDString((String)"\u6570\u636e\u6e90\u65e0\u6570\u636e\u96c6\u6210\u3002\u8bf7\u70b9\u51fb\u201c\u6267\u884c\u65e5\u5fd7\u201d\u67e5\u770b\u8be6\u60c5\u3002", (String)"InitTaskFormPlugin_41", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageTypes.Default);
            }
            progress = 100;
        }
        return progress;
    }

    private void setArgVal(ProgressEvent arg0, String text, int progress) {
        arg0.setProgress(progress);
        arg0.setText(text);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (HRStringUtils.equals((String)"parentsonrel", (String)formOperate.getOperateKey())) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (CollectionUtils.isEmpty((Map)customParams)) {
                return;
            }
            this.getView().getPageCache().remove(LABLE_BTN_FLAG);
            String currOperatType = (String)customParams.get("current_operate_type");
            String btnName = (String)customParams.get("btnname");
            this.handleDiParams(customParams);
            this.startPrecess(btnName);
        } else if (HRStringUtils.equals((String)formOperate.getOperateKey(), (String)"transdetail")) {
            this.openResultPage();
        }
    }

    private void startPrecess(String btnName) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"progressbar"});
        TaskProcessingVO processVo = ProcessingServiceFactory.getProcessingService().get(this.getPkId());
        ((Label)this.getView().getControl("currbtn")).setText(btnName);
        this.start(processVo);
    }

    private void start(TaskProcessingVO processVo) {
        this.recordLog(processVo, "start");
        if (Objects.isNull(processVo.getOperateEnum())) {
            return;
        }
        this.handLlableText(processVo);
        this.getView().setVisible(Boolean.FALSE, new String[]{"prostatus"});
        String totalNum = ConvertUtils.toString((Object)processVo.getTotalCount());
        this.getView().getPageCache().put(CACHE_TOTAL_NUM, totalNum);
        ((Label)this.getView().getControl("totalnum")).setText(totalNum);
        ((Label)this.getView().getControl("currnum")).setText("0");
        ((Label)this.getView().getControl("percent")).setText("0%");
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.setPercent(progressBar.getPercent(), "start execution");
        progressBar.start();
        HricCacheUtils.put((String)(this.getView().getPageId() + RequestContext.get().getCurrUserId() + CACHEKEY_STARTPROPGRESS), (Object)"true");
        this.setBtnStatus(Boolean.FALSE);
        this.getPageCache().put(CACHE_MID_TBL_OPERATE_TYPE, processVo.getOperateEnum().getOperateType());
    }

    private void setBtnStatus(Boolean isAllow) {
        this.getView().getParentView().getParentView().setEnable(isAllow, BTN_LIST.toArray(new String[0]));
        this.getView().getParentView().getParentView().setEnable(isAllow, new String[]{"refresh"});
        this.getView().sendFormAction(this.getView().getParentView().getParentView());
    }

    private void handLlableText(TaskProcessingVO processVo) {
        String labelText = processVo.getLabelText();
        if (HRStringUtils.equals((String)labelText, (String)"isc_data_copy_trigger")) {
            ((Label)this.getView().getControl("transdetail")).setText(ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7", (String)"InitTaskFormPlugin_35", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)labelText, (String)"isc_service_flow")) {
            ((Label)this.getView().getControl("transdetail")).setText(this.LABEL_TEXT);
        } else {
            ((Label)this.getView().getControl("transdetail")).setText(ResManager.loadKDString((String)"\u4e8b\u52a1\u660e\u7ec6", (String)"InitTaskFormPlugin_37", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.equals((String)labelText, (String)"transdetail")) {
            String taskId = this.getPageCache().get("exec_task_batch_number");
            DynamicObject dyc = DiExecTaskServiceHelper.getExecTaskByInitTaskId((Long)ConvertUtils.toLong((Object)taskId));
            if (Objects.isNull(dyc)) {
                return;
            }
            String diType = dyc.getString("ditype");
            String diNumber = dyc.getString("dinumber");
            this.getView().getPageCache().put(LABLE_BTN_FLAG, diType + "|" + diNumber);
        }
    }

    private void recordLog(TaskProcessingVO processVo, String service) {
        LOG.info("[HRIC]Progress bar log,service name:{} ,percent:{},totalCount:{},finishCount:{},operateType:{}", new Object[]{service, this.null2Empty(processVo.getPercent()), this.null2Empty(processVo.getTotalCount()), this.null2Empty(processVo.getFinishCount()), this.null2Empty(processVo.getOperateEnum())});
    }

    private Object null2Empty(Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return "null";
        }
        if (obj instanceof OperateEnum) {
            return ((OperateEnum)obj).getBtnKey();
        }
        return obj;
    }

    private void handleDiParams(Map<String, Object> customParams) {
        String executionNumber = (String)customParams.get("execution_number");
        String exampleNumber = (String)customParams.get("example_number");
        if (HRStringUtils.isNotEmpty((String)executionNumber)) {
            this.saveDiExecTask(executionNumber, "isc_data_copy_trigger");
        } else if (HRStringUtils.isNotEmpty((String)exampleNumber)) {
            this.saveDiExecTask(exampleNumber, "isc_service_flow");
        }
    }

    private void saveDiExecTask(String diNumber, String diType) {
        DynamicObject execTask = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hric_diexectask"));
        execTask.set("inittask", (Object)this.getPkId());
        execTask.set("dinumber", (Object)diNumber);
        execTask.set("ditype", (Object)diType);
        DiExecTaskServiceHelper.saveDiExecTask((DynamicObject)execTask);
    }

    private void openResultPage() {
        String lableBtnFlag = this.getView().getPageCache().get(LABLE_BTN_FLAG);
        if (HRStringUtils.isEmpty((String)lableBtnFlag)) {
            this.openTransdetailPage();
            return;
        }
        List lableBtnFlagList = Splitter.on((String)"|").splitToList((CharSequence)lableBtnFlag);
        String diType = (String)lableBtnFlagList.get(0);
        String diNumber = (String)lableBtnFlagList.get(1);
        LOG.info("Hric integration record,diType:{},diNumber:{}", (Object)diType, (Object)diNumber);
        if (HRStringUtils.equals((String)diType, (String)"isc_data_copy_trigger")) {
            this.openStartupSchemeExecResultPage(diNumber);
        } else if (HRStringUtils.equals((String)diType, (String)"isc_service_flow")) {
            ServiceFlowUtils.openExecResultPage((AbstractFormPlugin)this, (long)ConvertUtils.toLong((Object)diNumber), (String)this.LABEL_TEXT);
        }
    }

    private void openTransdetailPage() {
        ListShowParameter lsp = new ListShowParameter();
        lsp.setFormId(FormMetadataCache.getListFormConfig((String)"hric_exectask").getF7ListFormId());
        lsp.setBillFormId("hric_exectask");
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(new QFilter("batchnumber", "=", (Object)ConvertUtils.toLong((Object)this.getPageCache().get("exec_task_batch_number"))).and(new QFilter("operatetype", "=", (Object)this.getPageCache().get(CACHE_MID_TBL_OPERATE_TYPE))));
        lsp.setListFilterParameter(listFilterParameter);
        lsp.setCustomParam("batchnumber", (Object)ConvertUtils.toLong((Object)this.getPageCache().get("exec_task_batch_number")));
        lsp.setCustomParam("operatetype", (Object)this.getPageCache().get(CACHE_MID_TBL_OPERATE_TYPE));
        StyleCss css = new StyleCss();
        css.setWidth("960px");
        css.setHeight("580px");
        lsp.getOpenStyle().setInlineStyleCss(css);
        lsp.getOpenStyle().setClientShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openStartupSchemeExecResultPage(String executionNumber) {
        String pageId = SessionManager.getCurrent().get(this.getView().getPageId() + executionNumber);
        BillShowParameter lsp = null;
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            lsp = new BillShowParameter();
            lsp.setFormId("isc_data_copy_execution");
            DynamicObject result = new HRBaseServiceHelper("isc_data_copy_execution").queryOne("id", new QFilter("number", "=", (Object)executionNumber));
            if (result == null || result.getLong("id") == 0L) {
                return;
            }
            lsp.setPkId((Object)result.getLong("id"));
            SessionManager.getCurrent().put(this.getView().getPageId() + executionNumber, lsp.getPageId());
        } else {
            lsp = (BillShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
        }
        lsp.setCaption(ResManager.loadKDString((String)"\u6267\u884c\u65b9\u6848\u540d\u79f0\u4e3a\uff1a\u201c\u542f\u52a8\u65b9\u6848\u6267\u884c\u65e5\u5fd7\u201d\u3002", (String)"InitTaskFormPlugin_36", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
        lsp.getOpenStyle().setClientShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private long getPkId() {
        DynamicObject task = (DynamicObject)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("taskid")));
        return task.getLong("id");
    }
}

