/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.MessageSendServiceHelper;
import kd.hrmp.hric.bussiness.service.processing.ProcessingServiceFactory;
import kd.hrmp.hric.common.bean.InitMessageInfo;
import kd.hrmp.hric.common.exception.KDHricException;
import kd.hrmp.hric.common.exception.code.HRICErrorEnum;

public class InitTaskRollbackPlugin
extends HRDataBaseEdit {
    private static Log LOG = LogFactory.getLog(InitTaskRollbackPlugin.class);
    private String WARN_MSG_ONE = ResManager.loadKDString((String)"\u56de\u6eda%s\u4efb\u52a1\u5c06\u5bfc\u81f4\u4ee5\u4e0b\u4efb\u52a1\u72b6\u6001\u53d8\u66f4\uff1a", (String)"InitTaskRollbackPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String WARN_MSG_TWO = ResManager.loadKDString((String)"\u201c\u662f\u5426\u7ee7\u7eed\u56de\u6eda\uff1f\u201d", (String)"InitTaskRollbackPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private static String LABEL_WARNTEXT = "warntext";
    private static String CACHE_ROLLBACK_TASKS = "cache_rollback_tasks";
    private String MESSAGE_CONTENT = ResManager.loadKDString((String)"%1$s\u5df2\u5c06%2$s\u4efb\u52a1\u56de\u6eda\uff0c\u60a8\u8d1f\u8d23\u7684%3$s\u72b6\u6001\u5df2\u66f4\u65b0\u4e3a%4$s\u3002", (String)"InitTaskRollbackPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TITLE = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u4efb\u52a1\u72b6\u6001\u66f4\u65b0\u63d0\u9192\uff1a\u4efb\u52a1\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b\uff01", (String)"InitTaskRollbackPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String MESSAGE_TAG = ResManager.loadKDString((String)"\u91cd\u8981,\u5fc5\u8bfb!", (String)"InitTaskRollbackPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String taskIds = (String)this.getView().getFormShowParameter().getCustomParam("rollbacktaskIds");
        if (HRStringUtils.isNotEmpty((String)taskIds)) {
            List taskIdList = (List)JSON.parseObject((String)taskIds, List.class);
            this.getPageCache().put(CACHE_ROLLBACK_TASKS, taskIds);
            this.bindControl(taskIdList);
        }
    }

    private void bindControl(List<Long> taskIdList) {
        DynamicObject[] rollBackTaskList = InitTaskServiceHelper.getTaskList(taskIdList);
        List selectTaskList = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("selectRollbackTask")));
        this.getModel().setValue(LABEL_WARNTEXT, (Object)(String.format(Locale.ROOT, this.WARN_MSG_ONE, selectTaskList.stream().map(task -> task.getString("name")).collect(Collectors.joining("\u3001"))) + "\n" + this.WARN_MSG_TWO));
        this.getView().updateView(LABEL_WARNTEXT);
        this.loadEntryData(taskIdList, rollBackTaskList);
    }

    private void loadEntryData(List<Long> taskIdList, DynamicObject[] rollBackTaskList) {
        this.getModel().deleteEntryData("taskentity");
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("taskname", new Object[0]);
        vs.addField("status", new Object[0]);
        vs.addField("afterstatus", new Object[0]);
        vs.addField("taskleader", new Object[0]);
        Map postTaskMap = InitTaskServiceHelper.getPostTaskMap((DynamicObject[])rollBackTaskList);
        for (DynamicObject task : rollBackTaskList) {
            vs.addRow(new Object[]{task.get("name"), ((ComboProp)task.getDynamicObjectType().getProperty("taskstatus")).getItemByName(task.getString("taskstatus")), ((ComboProp)task.getDynamicObjectType().getProperty("taskstatus")).getItemByName(InitTaskServiceHelper.getAfterStatus((DynamicObject)task, taskIdList, (Map)postTaskMap)), task.getDynamicObject("taskleader").getString("name")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("taskentity", vs);
        model.endInit();
        this.getView().updateView("taskentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        if (HRStringUtils.equals((String)eventArgs.getOperateKey(), (String)"btnok")) {
            String taskIds = (String)this.getView().getFormShowParameter().getCustomParam("rollbacktaskIds");
            List selectTaskList = (List)SerializationUtils.deSerializeFromBase64((String)((String)this.getView().getFormShowParameter().getCustomParam("selectRollbackTask")));
            List taskIdList = (List)JSON.parseObject((String)taskIds, List.class);
            DynamicObject[] rollBackTaskList = InitTaskServiceHelper.getTaskList((List)taskIdList);
            InitTaskServiceHelper.setTaskLock((DynamicObject[])rollBackTaskList, (HRICErrorEnum)HRICErrorEnum.TASK_ROLLBACK_ERROR, () -> this.doRollbackLogic(taskIdList, rollBackTaskList));
            ArrayList<InitMessageInfo> infoList = new ArrayList<InitMessageInfo>();
            this.buildInfo(rollBackTaskList, infoList, selectTaskList);
            if (!CollectionUtils.isEmpty(infoList)) {
                MessageSendServiceHelper.saveMessage(infoList);
                AsyncTaskServiceHelper.startJob();
            }
            this.getView().returnDataToParent((Object)true);
            this.getView().close();
        }
    }

    private void doRollbackLogic(List<Long> taskIdList, DynamicObject[] rollBackTaskList) {
        try (TXHandle tx = TX.required();){
            this.validateTaskInLock(rollBackTaskList);
            this.updateTask(taskIdList, rollBackTaskList);
            InitTaskServiceHelper.saveRollbackTasks((DynamicObject[])rollBackTaskList);
        }
        AsyncTaskServiceHelper.startJob();
    }

    private void validateTaskInLock(DynamicObject[] rollBackTaskList) {
        for (DynamicObject task : rollBackTaskList) {
            if (!ProcessingServiceFactory.getProcessingService().get(task.getLong("id")).isProcessing()) continue;
            throw new KDHricException(HRICErrorEnum.TASK_IN_PROCESSING_ERROR, new Object[]{task.getString("name")});
        }
        for (DynamicObject task : rollBackTaskList) {
            if (HRStringUtils.equals((String)task.getString("taskstatus"), (String)"C") || HRStringUtils.equals((String)task.getString("taskstatus"), (String)"B")) continue;
            throw new KDHricException(HRICErrorEnum.TASK_STATUS_NOT_COMPLETED_OR_PROCESSING_ERROR, new Object[]{task.getString("name")});
        }
    }

    private void updateTask(List<Long> rollBackTaskIdList, DynamicObject[] rollBackTaskList) {
        Map postTaskMap = InitTaskServiceHelper.getPostTaskMap((DynamicObject[])rollBackTaskList);
        Set rollBackIdSet = Arrays.stream(rollBackTaskList).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        for (DynamicObject task2 : rollBackTaskList) {
            task2.set("taskstatus", (Object)InitTaskServiceHelper.getAfterStatus((DynamicObject)task2, rollBackTaskIdList, (Map)postTaskMap));
        }
        Arrays.stream(rollBackTaskList).filter(task -> HRStringUtils.equals((String)task.getString("tasktype"), (String)"B") || HRStringUtils.equals((String)task.getString("tasktype"), (String)"C")).forEach(dyn -> {
            if (HRStringUtils.equals((String)dyn.getString("taskstatus"), (String)"B") || HRStringUtils.equals((String)dyn.getString("taskstatus"), (String)"F")) {
                dyn.set("taskbegintime", (Object)new Date());
                dyn.set("taskendtime", null);
                if (!CollectionUtils.isEmpty((Collection)dyn.getDynamicObjectCollection("pretask"))) {
                    DynamicObjectCollection preDyns = dyn.getDynamicObjectCollection("pretask");
                    ListIterator iterator = preDyns.listIterator();
                    while (iterator.hasNext()) {
                        DynamicObject task = (DynamicObject)iterator.next();
                        if (!rollBackIdSet.contains(task.getLong("fbasedataid_id"))) continue;
                        iterator.remove();
                    }
                }
            } else if (HRStringUtils.equals((String)dyn.getString("taskstatus"), (String)"E")) {
                dyn.set("taskbegintime", null);
                dyn.set("taskendtime", null);
                List postTasks = (List)postTaskMap.get(dyn.getLong("id"));
                MulBasedataDynamicObjectCollection preTasks = this.buildPreTask((DynamicObject)dyn, rollBackTaskIdList, postTasks);
                if (!CollectionUtils.isEmpty((Collection)preTasks)) {
                    dyn.set("pretask", (Object)preTasks);
                }
            } else if (HRStringUtils.equals((String)dyn.getString("tasktype"), (String)"C") && HRStringUtils.equals((String)dyn.getString("taskstatus"), (String)"A")) {
                dyn.set("taskbegintime", null);
                dyn.set("taskendtime", null);
            }
        });
    }

    private void buildInfo(DynamicObject[] rollBackTaskList, List<InitMessageInfo> infoList, List<DynamicObject> selectTaskList) {
        String totalPerson = UserServiceHelper.getCurrentUser((String)"name").getString("name");
        String selectTaskNames = selectTaskList.stream().map(it -> it.getString("name")).collect(Collectors.joining(","));
        Arrays.asList(rollBackTaskList).forEach(task -> {
            InitMessageInfo info = MessageSendServiceHelper.buildTaskMessage((DynamicObject)task, (String)this.MESSAGE_TITLE, (String)this.MESSAGE_TAG, (String)String.format(Locale.ROOT, this.MESSAGE_CONTENT, totalPerson, selectTaskNames, task.getString("name"), ((ComboProp)task.getDynamicObjectType().getProperty("taskstatus")).getItemByName(task.getString("taskstatus"))));
            infoList.add(info);
        });
    }

    private MulBasedataDynamicObjectCollection buildPreTask(DynamicObject task, List<Long> rollBackTaskIdList, List<DynamicObject> dynList) {
        if (CollectionUtils.isEmpty(dynList)) {
            return null;
        }
        MulBasedataDynamicObjectCollection mulCollection = new MulBasedataDynamicObjectCollection();
        dynList.forEach(dyn -> {
            if (HRStringUtils.equals((String)dyn.getString("tasktype"), (String)"B")) {
                DynamicObject dynamicObject = new DynamicObject(dyn.getDynamicObjectCollection("pretask").getDynamicObjectType());
                dynamicObject.set(0, null);
                dynamicObject.set(1, dyn);
                mulCollection.add(dynamicObject);
            }
        });
        DynamicObjectCollection preTasks = task.getDynamicObjectCollection("pretask");
        if (!CollectionUtils.isEmpty((Collection)preTasks)) {
            DynamicObjectCollection col = new DynamicObjectCollection();
            for (DynamicObject preTask : preTasks) {
                if (rollBackTaskIdList.contains(preTask.getLong("fbasedataid_id"))) continue;
                col.add((Object)preTask);
            }
            mulCollection.addAll(0, (Collection)col);
        }
        return mulCollection;
    }
}

