/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.isv.ISVService;
import kd.bos.list.IListView;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.service.AsyncTaskServiceHelper;
import kd.hrmp.hric.bussiness.service.BizSubAreaServiceHelper;
import kd.hrmp.hric.bussiness.service.InitPlanServiceHelper;
import kd.hrmp.hric.bussiness.service.InitTemplateServiceHelper;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.formplugin.web.InitPermHelper;
import kd.hrmp.hric.formplugin.web.util.InitFormUtils;
import org.apache.commons.lang3.ObjectUtils;

public class InitTemplateEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(InitTemplateEditPlugin.class);
    private final String RES_BILLHEAD_NAME = ResManager.loadKDString((String)"\u5355\u636e\u5934", (String)"InitTemplateEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String RES_REMOVE_ERROR = ResManager.loadKDString((String)"\u79fb\u52a8\u5c5e\u6027\u65e0\u6cd5\u66f4\u6539\u5185\u7801\u5c5e\u6027\u7684\u4f4d\u7f6e\u3002", (String)"InitTemplateEditPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String RES_SAVE_TEMP_FIRST = ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6a21\u677f", (String)"InitTemplateEditPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private final String KING_DEE = "kingdee";
    private Integer TABLE_NAME_MAX_LENGTH = 25;

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int row = e.getChangeSet()[0].getRowIndex();
        switch (propertyName) {
            case "group": {
                this.getModel().setValue("bizsubarea", null);
                break;
            }
            case "bizsubarea": {
                this.getModel().setValue("entityobjscope", null);
                break;
            }
            case "entityobjscope": {
                this.choseProperties(e, model);
                this.changeTableName(model);
                model.setValue("uniquestring", null);
                model.setValue("groupfield", null);
                this.changeUniqueAndGroupFieldItems(model);
                break;
            }
            case "intermediatetable": {
                this.getModel().setValue("importtemplateid", null);
                break;
            }
            case "isimport": {
                this.dealImportAndMustData(model, proxy, propertyName, row);
                this.changeUniqueAndGroupFieldItems(model);
                this.changeUniqueString(model, row);
                break;
            }
            case "ismustinput": {
                this.dealImportAndMustData(model, proxy, propertyName, row);
                this.changeGroupFieldItems(model);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if ("save".equals(operateKey)) {
            if (InitPermHelper.hasNotPermission("4715a0df000000ac", this.getView(), "hric_initinducttp")) {
                args.setCancel(true);
                return;
            }
            String tableName = Optional.ofNullable((String)this.getModel().getValue("intermediatetable")).orElse("");
            this.getModel().setValue("intermediatetable", (Object)tableName.toLowerCase());
        }
        if ("showlog".equals(operateKey)) {
            args.setCancel(true);
            if (InitPermHelper.hasNotPermission("47150e89000000ac", this.getView(), "hric_initinducttp")) {
                return;
            }
            this.openMidTableGenLog();
        }
        if ("btndownload".equals(operateKey)) {
            InitTemplateServiceHelper.downloadTempExcel((DynamicObject)this.getModel().getDataEntity(), (IFormView)this.getView());
            args.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String s = Optional.ofNullable(this.getView()).map(IFormView::getParentView).filter(IListView.class::isInstance).map(it -> (IListView)it).map(IListView::getTreeListView).map(ITreeListView::getTreeModel).map(ITreeModel::getCurrentNodeId).map(String::valueOf).orElse("");
        String[] ids = s.split("\\#.{1}");
        if (ids.length > 1) {
            this.getModel().setValue("group", (Object)new HRBaseServiceHelper("hbss_hrbusinessfield").queryOne((Object)ids[1]));
        }
        if (ids.length > 2) {
            this.getModel().setValue("bizsubarea", (Object)new HRBaseServiceHelper("hric_bizsubarea").queryOne((Object)ids[2]));
        }
        this.getModel().deleteEntryData("treeentryentity");
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("entityobjscope");
        if (dynamicObject != null) {
            if (this.checkViewStatus().booleanValue() && !this.checkSysPresetStatus(this.getModel().getDataEntity()).booleanValue()) {
                this.setTreeEntryEntity(dynamicObject, true);
            }
            this.changeUniqueAndGroupFieldItems(this.getModel());
        }
        if (HRStringUtils.equals((String)(status = this.getView().getFormShowParameter().getStatus()).name(), (String)OperationStatus.EDIT.name()) || HRStringUtils.equals((String)status.name(), (String)OperationStatus.VIEW.name())) {
            this.setLockField();
        }
        this.setValidateExist((List<DynamicObject>)((DynamicObjectCollection)this.getModel().getDataEntity().get("treeentryentity")));
        this.setTreeEntryEntityStatus();
    }

    private void setValidateExist(List<DynamicObject> dynamicObjectList) {
        for (int index = 0; index < dynamicObjectList.size(); ++index) {
            boolean validateExist;
            DynamicObject entryDyn = dynamicObjectList.get(index);
            boolean bl = validateExist = (!entryDyn.getBoolean("isbasedata") || !entryDyn.getBoolean("isimport")) && entryDyn.getBoolean("isvalidateexist");
            if (!validateExist) continue;
            entryDyn.set("isvalidateexist", (Object)false);
        }
        this.getModel().setDataChanged(false);
    }

    private void setLockField() {
        DynamicObject subBizArea = (DynamicObject)this.getModel().getValue("bizsubarea");
        if (!InitPlanServiceHelper.isUpdateBaseField((long)subBizArea.getLong("id"))) {
            InitFormUtils.lockField(false, this.getControl("group"));
            InitFormUtils.lockField(false, this.getControl("bizsubarea"));
            InitFormUtils.lockField(false, this.getControl("entityobjscope"));
            InitFormUtils.lockField(false, this.getControl("intermediatetable"));
        }
    }

    private Boolean checkViewStatus() {
        return !OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus());
    }

    private Boolean checkSysPresetStatus(DynamicObject dynamicObject) {
        return dynamicObject.getBoolean("issyspreset");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String sourceName = Optional.ofNullable(beforeF7SelectEvent).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"bizsubarea")) {
            InitTemplateEditPlugin.filterBizSubArea(beforeF7SelectEvent, this.getModel());
        }
        if (HRStringUtils.equals((String)sourceName, (String)"entityobjscope")) {
            this.filterAppScope(beforeF7SelectEvent);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit baseDataEdit1 = (BasedataEdit)this.getView().getControl("bizsubarea");
        baseDataEdit1.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit baseDataEdit2 = (BasedataEdit)this.getView().getControl("entityobjscope");
        baseDataEdit2.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "entryup": 
            case "entrydown": {
                this.checkMove(evt);
                break;
            }
        }
    }

    private void checkMove(BeforeItemClickEvent evt) {
        Boolean isDownIdOrPidRow = this.isDownIdOrPidRow(evt);
        if (isDownIdOrPidRow.booleanValue()) {
            this.getView().showTipNotification(this.RES_REMOVE_ERROR);
        }
        evt.setCancel(isDownIdOrPidRow.booleanValue());
    }

    private Boolean isDownIdOrPidRow(BeforeItemClickEvent evt) {
        int[] rowsIndex;
        IDataModel model = this.getModel();
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        for (int index : rowsIndex = proxy.getEntryState("treeentryentity").getSelectedRows()) {
            String entityNumber;
            if (index < 1) {
                return Boolean.FALSE;
            }
            if ("entryup".equals(evt.getItemKey())) {
                --index;
            }
            if (!"id".equals(entityNumber = (String)model.getValue("entitynumber", index)) && !entityNumber.endsWith(".id") && !entityNumber.endsWith(".pid")) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void filterBizSubArea(BeforeF7SelectEvent beforeF7SelectEvent, IDataModel model) {
        Object id = Optional.ofNullable(model).map(IDataModel::getDataEntity).map(it -> it.getDynamicObject("group")).map(it -> it.get("id")).orElse(null);
        if (ObjectUtils.isNotEmpty(id)) {
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().setFilter(new QFilter("group", "=", id));
        }
    }

    private void filterAppScope(BeforeF7SelectEvent beforeF7SelectEvent) {
        Object id = Optional.ofNullable(this.getModel()).map(IDataModel::getDataEntity).map(it -> it.getDynamicObject("bizsubarea")).map(it -> it.get("id")).orElse(null);
        HashSet appScopeSet = new HashSet();
        Object[] appScope = BizSubAreaServiceHelper.getAppScopeById(id);
        if (!HRArrayUtils.isEmpty((Object[])appScope)) {
            Arrays.stream(appScope).map(dyc -> dyc.getDynamicObjectCollection("appscope")).forEach(dyc -> dyc.forEach(dy -> appScopeSet.add(dy.getString("fbasedataid_id"))));
        }
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        showParameter.setCustomParam("bizappids", (Object)SerializationUtils.toJsonString(appScopeSet));
    }

    private void checkChildren(IDataModel model, IClientViewProxy proxy, String propertyName, boolean propertyValue, int row) {
        long entryId = (Long)model.getEntryRowEntity("treeentryentity", row).get("id");
        int count = model.getEntryRowCount("treeentryentity");
        for (int i = row + 1; i < count; ++i) {
            if (entryId != (Long)model.getEntryRowEntity("treeentryentity", i).get("pid") || propertyValue == (Boolean)model.getValue(propertyName, i)) continue;
            model.beginInit();
            model.setValue(propertyName, (Object)propertyValue, i);
            model.endInit();
            this.update(proxy, propertyName, propertyValue, i);
            if (Boolean.TRUE.equals(model.getValue("isfield", i))) continue;
            this.checkChildren(model, proxy, propertyName, propertyValue, i);
        }
    }

    private void checkParent(IDataModel model, IClientViewProxy proxy, String propertyName, boolean propertyValue, int row) {
        long parentEntryId = (Long)model.getEntryRowEntity("treeentryentity", row).get("pid");
        for (int i = row - 1; i >= 0; --i) {
            boolean addProp;
            long entryId = (Long)model.getEntryRowEntity("treeentryentity", i).get("id");
            if (parentEntryId != entryId || propertyValue == (Boolean)model.getValue(propertyName, i)) continue;
            int totalCount = 0;
            int checkCount = 0;
            int count = model.getEntryRowCount("treeentryentity");
            for (int j = i + 1; j < count; ++j) {
                if (entryId != (Long)model.getEntryRowEntity("treeentryentity", j).get("pid")) continue;
                ++totalCount;
                if (!Boolean.TRUE.equals(model.getValue(propertyName, j))) continue;
                ++checkCount;
            }
            boolean bl = addProp = totalCount > 0 && (propertyValue && checkCount == totalCount || !propertyValue && checkCount < totalCount);
            if (!addProp) break;
            model.beginInit();
            model.setValue(propertyName, (Object)propertyValue, i);
            model.endInit();
            this.update(proxy, propertyName, propertyValue, i);
            this.checkParent(model, proxy, propertyName, propertyValue, i);
        }
    }

    private void update(IClientViewProxy proxy, String propertyName, boolean propertyValue, int row) {
        if (proxy == null) {
            return;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("k", "treeentryentity");
        HashMap<String, Object> state = new HashMap<String, Object>();
        state.put("r", row);
        state.put("v", propertyValue);
        state.put("k", propertyName);
        dataMap.put("fieldstates", Collections.singletonList(state));
        proxy.addAction("u", dataMap);
    }

    private void dealImportAndMustData(IDataModel model, IClientViewProxy proxy, String propertyName, int row) {
        if (HRStringUtils.equals((String)"isimport", (String)propertyName)) {
            this.dealDataByIsImport(model, row);
        } else if (HRStringUtils.equals((String)"ismustinput", (String)propertyName)) {
            this.dealDataByMustInput(model, row);
        }
        boolean propertyValue = (Boolean)model.getValue(propertyName, row);
        if (!Boolean.TRUE.equals(model.getValue("isfield", row))) {
            this.checkChildren(model, proxy, propertyName, propertyValue, row);
        }
        this.checkParent(model, proxy, propertyName, propertyValue, row);
    }

    private void dealDataByMustInput(IDataModel model, int row) {
        if (((Boolean)model.getValue("ismustinput", row)).booleanValue() && !((Boolean)model.getValue("isimport", row)).booleanValue()) {
            model.setValue("isimport", (Object)Boolean.TRUE, row);
        }
    }

    private void dealDataByIsImport(IDataModel model, int row) {
        boolean isImport = (Boolean)model.getValue("isimport", row);
        if (((Boolean)model.getValue("isbasedata", row)).booleanValue()) {
            model.setValue("isvalidateexist", (Object)isImport, row);
        }
        if (!isImport) {
            model.setValue("ismustinput", (Object)Boolean.FALSE, row);
        }
    }

    private void choseProperties(PropertyChangedArgs e, IDataModel model) {
        DynamicObject bizObj = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (bizObj != null) {
            this.setTreeEntryEntity(bizObj);
            this.setTreeEntryEntityStatus();
        } else {
            model.deleteEntryData("treeentryentity");
        }
    }

    private void setTreeEntryEntityStatus() {
        this.getView().updateView("treeentryentity");
        TreeEntryGrid grid = (TreeEntryGrid)this.getControl("treeentryentity");
        grid.setCollapse(false);
    }

    private void setTreeEntryEntity(DynamicObject bizObj) {
        this.setTreeEntryEntity(bizObj, false);
    }

    private void setTreeEntryEntity(DynamicObject bizObj, Boolean bindFlag) {
        String entityId = bizObj.getString(((BasedataEntityType)bizObj.getDataEntityType()).getNumberProperty());
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("treeentryentity").getDynamicObjectType();
        InitTemplateServiceHelper initTemplateServiceHelper = new InitTemplateServiceHelper(new ArrayList(), dynamicObjectType, "hric_initinducttp", "t_hric_initimporttpentry");
        initTemplateServiceHelper.buildBillTreeFieldsExt(entityId, null);
        this.setValidateExist(initTemplateServiceHelper.getDynamicObjectList());
        if (bindFlag.booleanValue()) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
            if (this.checkChanged(dynamicObjectCollection, initTemplateServiceHelper.getDynamicObjectList(), dynamicObjectType).booleanValue()) {
                this.setPropertyValueByOldTemplate(dynamicObjectCollection, initTemplateServiceHelper.getDynamicObjectList());
                initTemplateServiceHelper.buildPlateFormMap(initTemplateServiceHelper.getDynamicObjectList());
                this.getModel().getDataEntity(true).set("treeentryentity", (Object)new DynamicObjectCollection(dynamicObjectType, (Object)this.getModel().getDataEntity(), initTemplateServiceHelper.resetOrder(dynamicObjectCollection)));
                this.getView().showMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5173\u8054\u5b9e\u4f53\u5bf9\u8c61\u5df2\u88ab\u4fee\u6539\u3002\u5efa\u8bae\u518d\u6b21\u4fdd\u5b58\u3002", (String)"InitTemplateEditPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getModel().getDataEntity(true).set("treeentryentity", (Object)new DynamicObjectCollection(dynamicObjectType, (Object)this.getModel().getDataEntity(), initTemplateServiceHelper.getDynamicObjectList()));
        }
    }

    private void setPropertyValueByOldTemplate(DynamicObjectCollection oldDynamicObjectCollection, List<DynamicObject> newDynamicList) {
        Map<String, DynamicObject> oldDynMap = oldDynamicObjectCollection.stream().filter(dyc -> !dyc.getBoolean("istablehead")).collect(Collectors.toMap(dyc -> dyc.getString("numberalias"), dyc -> dyc));
        newDynamicList.forEach(dyc -> {
            if (oldDynMap.containsKey(dyc.getString("numberalias"))) {
                DynamicObject oldEntryDyn = (DynamicObject)oldDynMap.get(dyc.getString("numberalias"));
                HricDynamicObjectUtils.copy((DynamicObject)oldEntryDyn, (DynamicObject)dyc, (Set)Sets.newHashSet((Object[])new String[]{"isimport", "ismustinput", "entitydescription"}));
                if (dyc.getBoolean("isbasedata") && oldEntryDyn.getBoolean("isbasedata")) {
                    dyc.set("importprop", (Object)oldEntryDyn.getString("importprop"));
                    dyc.set("isvalidateexist", (Object)oldEntryDyn.getString("isvalidateexist"));
                }
            }
        });
    }

    private Boolean checkChanged(DynamicObjectCollection dynamicObjectCollection, List<DynamicObject> newDynamicObjectCollection, DynamicObjectType dynamicObjectType) {
        if (dynamicObjectCollection.size() != newDynamicObjectCollection.size()) {
            log.error("init importtemplate data change size: old ImportTemplate Size:{}, new Importtemplate Size:{}", (Object)dynamicObjectCollection.size(), (Object)newDynamicObjectCollection.size());
        }
        return dynamicObjectCollection.size() != newDynamicObjectCollection.size() || this.checkFieldChanged(dynamicObjectCollection, newDynamicObjectCollection, dynamicObjectType) != false;
    }

    private Boolean checkFieldChanged(DynamicObjectCollection dynamicObjectCollection, List<DynamicObject> newDynamicObjectCollection, DynamicObjectType dynamicObjectType) {
        HashMap map = new HashMap();
        dynamicObjectCollection.forEach(dyc -> this.setDynamicObject(map, (DynamicObject)dyc, true));
        newDynamicObjectCollection.forEach(dyc -> this.setDynamicObject(map, (DynamicObject)dyc, false));
        if (map.entrySet().stream().anyMatch(Map.Entry::getValue)) {
            log.error("init importtemplate different field value:{}", (Object)map.entrySet().stream().filter(entry -> (Boolean)entry.getValue()).map(entry -> (String)entry.getKey()).collect(Collectors.joining(",")));
        }
        return map.entrySet().stream().anyMatch(Map.Entry::getValue);
    }

    private void setDynamicObject(Map<String, Boolean> map, DynamicObject dyc, Boolean flag) {
        String key = dyc.getString("entitynumber");
        map.put(key, flag);
    }

    private void changeUniqueAndGroupFieldItems(IDataModel model) {
        this.changeUniqueStringItems(model);
        this.changeGroupFieldItems(model);
    }

    private void changeUniqueStringItems(IDataModel model) {
        List<ComboItem> comboItems = this.getComboItems(model, "isimport");
        ComboEdit groupFieldEdit = (ComboEdit)this.getControl("uniquestring");
        groupFieldEdit.setComboItems(comboItems);
    }

    private void changeGroupFieldItems(IDataModel model) {
        ComboEdit groupFieldEdit = (ComboEdit)this.getControl("groupfield");
        List<ComboItem> groupFieldItems = this.getComboItems(model, "ismustinput");
        groupFieldEdit.setComboItems(groupFieldItems);
        String groupFieldValue = Optional.ofNullable((String)model.getValue("groupfield")).orElse("");
        Set groupFieldSet = groupFieldItems.stream().map(item -> item.getValue()).collect(Collectors.toSet());
        groupFieldValue = Arrays.stream(groupFieldValue.split(",")).filter(s -> groupFieldSet.contains(s)).collect(Collectors.joining(","));
        model.setValue("groupfield", (Object)groupFieldValue);
    }

    private List<ComboItem> getComboItems(IDataModel model, String isImportOrIsMustInput) {
        DynamicObjectCollection dyc = model.getEntryEntity("treeentryentity");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        String prefixName = "";
        for (DynamicObject ob : dyc) {
            if (this.checkIsImportOrIsMustInput(ob, isImportOrIsMustInput).booleanValue()) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(prefixName + "." + ob.get("entityname")));
                comboItem.setValue(ob.getString("numberalias"));
                comboItems.add(comboItem);
                continue;
            }
            if (!this.getScopePrefix(ob).booleanValue()) continue;
            prefixName = Optional.ofNullable((String)ob.get("entityname")).orElse("");
        }
        return comboItems;
    }

    private void changeTableName(IDataModel model) {
        if (model.getValue("entityobjscope") != null) {
            DynamicObject obj = this.getModel().getDataEntity().getDynamicObject("entityobjscope");
            String tableName = Optional.ofNullable(obj.get("number")).orElse("").toString();
            if (!HRStringUtils.isEmpty((String)tableName)) {
                if (!"kingdee".equals(ISVService.getISVInfo().getId())) {
                    tableName = tableName.substring(tableName.indexOf(95) + 1);
                }
                tableName = tableName.substring(tableName.indexOf(95) + 1);
            }
            tableName = "hric_0" + tableName;
            this.getModel().setValue("intermediatetable", (Object)(tableName.length() > this.TABLE_NAME_MAX_LENGTH ? tableName.substring(0, this.TABLE_NAME_MAX_LENGTH) : tableName));
        } else {
            this.getModel().setValue("intermediatetable", null);
        }
    }

    private Boolean checkIsImportOrIsMustInput(DynamicObject object, String isImportOrIsMustInput) {
        return (Boolean)object.get(isImportOrIsMustInput) != false && (Boolean)object.get("istablehead") == false;
    }

    private Boolean getScopePrefix(DynamicObject object) {
        return (Boolean)object.get("istablehead") != false && !this.RES_BILLHEAD_NAME.equals(object.get("entityname"));
    }

    private void changeUniqueString(IDataModel model, int row) {
        if (!((Boolean)model.getValue("isimport")).booleanValue()) {
            String uniqueString = Optional.ofNullable((String)model.getValue("uniquestring")).orElse("");
            model.setValue("uniquestring", HRStringUtils.isEmpty((String)(uniqueString = Arrays.stream(uniqueString.split(",")).filter(s -> !s.equals(model.getValue("numberalias", row))).collect(Collectors.joining(",")))) ? null : uniqueString + ",");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        IDataModel model = this.getModel();
        if (HRStringUtils.equals((String)evt.getOperateKey(), (String)"save")) {
            boolean isOpSuccess = Optional.ofNullable(evt.getOperationResult()).map(it -> it.isSuccess()).orElseGet(() -> false);
            if (isOpSuccess) {
                Save save = (Save)evt.getSource();
                Long asyncTaskId = ConvertUtils.toLong((Object)save.getOption().getVariableValue("asynctaskid"));
                AsyncTaskServiceHelper.startJob((long)asyncTaskId);
            }
            return;
        }
    }

    private void openMidTableGenLog() {
        if (Objects.equals(this.getModel().getValue("id"), 0L)) {
            this.getView().showErrorNotification(this.RES_SAVE_TEMP_FIRST);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hric_middlegeneratelog");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("templateId", this.getModel().getValue("id"));
        showParameter.setCustomParam("midTableNumber", this.getModel().getValue("intermediatetable"));
        showParameter.setCustomParam("objnumber", this.getModel().getValue("intermediatetable"));
        StyleCss css = new StyleCss();
        css.setWidth("900px");
        css.setHeight("650px");
        showParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm(showParameter);
    }

    private QFilter getCusFilter() {
        QFilter qFilter = new QFilter("objnumber", "=", this.getModel().getValue("intermediatetable"));
        return qFilter;
    }
}

