/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.LoadDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.list.ListShowParameter;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IPTplPlanDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPlanTemplateDomainService;
import kd.hrmp.hric.common.constants.PlanTemplateConstants;
import kd.hrmp.hric.common.util.HricDynamicObjectUtils;
import kd.hrmp.hric.common.util.QFilterUtils;
import kd.hrmp.hric.formplugin.web.util.ImplItemFormUtils;

public class PlanTemplateEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
TreeNodeClickListener,
TreeNodeQueryListener,
PlanTemplateConstants,
HyperLinkClickListener {
    IPlanTemplateDomainService planTemplateDomainService = (IPlanTemplateDomainService)ServiceFactory.getService(IPlanTemplateDomainService.class);
    IPTplPlanDomainService pTplPlanDomain = (IPTplPlanDomainService)ServiceFactory.getService(IPTplPlanDomainService.class);
    String implItemPanel = "advconap1";
    String CURRENT_NODE_ID = "currentNodeId";
    String ADV_CON_TOOLBAR_AP = "advcontoolbarap1";
    String FLEX_PANEL_AP_TIP = "flexpanelap3";
    String planPageCache = "hric_ptplplan";

    public void loadData(LoadDataEventArgs e) {
        super.loadData(e);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (HRStringUtils.equals((String)this.getView().getFormShowParameter().getStatus().name(), (String)OperationStatus.ADDNEW.name())) {
            this.getModel().getDataEntity().set("id", (Object)ID.genLongId());
            Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
            if (isCopy != null && isCopy.booleanValue()) {
                this.getView().getFormShowParameter().setCustomParam("issyspreset", this.getModel().getValue("issyspreset"));
                this.getModel().setValue("issyspreset", (Object)false);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)this.getModel().getValue("ptplebizarea")))), new String[]{"ptplebizsubarea"});
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject baseDataEntity = this.getView().getModel().getDataEntity();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        Boolean isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            Long pkId = (Long)((BillShowParameter)this.getView().getFormShowParameter().getShowParameter()).getPkId();
            boolean isSysPreset = (Boolean)this.getView().getFormShowParameter().getShowParameter().getCustomParam("issyspreset");
            if (isSysPreset) {
                this.createPlanCollection(pkValue);
                this.updatePlanConfigTree("");
            } else {
                List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)this.pTplPlanDomain.loadPlanInfo(pkId));
                List copyPTplPlanList = this.pTplPlanDomain.copyPTplPlanList(pTplPlanList);
                copyPTplPlanList.forEach(copyPTplPlan -> {
                    if (copyPTplPlan.getLong("parent.id") == 0L) {
                        this.getModel().getDataEntity().set("id", (Object)copyPTplPlan.getLong("id"));
                    }
                });
                TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
                this.planTemplateDomainService.setTreeForPlanTemplate(treeView, copyPTplPlanList);
                this.getView().getPageCache().put(this.planPageCache, SerializationUtils.serializeToBase64((Object)copyPTplPlanList));
            }
            this.setPlanTempInfo(String.valueOf(this.getModel().getDataEntity().getPkValue()));
        } else if (baseDataEntity.getBoolean("issyspreset")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry", "deleteentry"});
            this.showPlanFromDbOrBizArea(false, pkValue);
        } else if (HRStringUtils.equals((String)status.name(), (String)OperationStatus.EDIT.name())) {
            this.showPlanFromDbOrBizArea(true, pkValue);
        }
        DynamicObjectCollection bizSubAreaCo = this.getModel().getDataEntity().getDynamicObjectCollection("ptplebizsubarea");
        if (bizSubAreaCo.size() == 0) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.implItemPanel, this.FLEX_PANEL_AP_TIP});
        }
        this.setEnableByMutex(pkValue);
    }

    private void showPlanFromDbOrBizArea(boolean DbOrBizArea, Long pkValue) {
        if (DbOrBizArea) {
            String planTempInfoCache = this.pTplPlanDomain.loadPlanInfo(pkValue);
            this.getView().getPageCache().put(this.planPageCache, planTempInfoCache);
            List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)planTempInfoCache);
            TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
            this.planTemplateDomainService.setTreeForPlanTemplate(treeView, pTplPlanList);
        } else {
            this.createPlanCollection(pkValue);
            this.updatePlanConfigTree("");
        }
        this.setPlanTempInfo(String.valueOf(pkValue));
        this.getModel().setDataChanged(false);
    }

    private void setEnableByMutex(Long pkValue) {
        StringBuilder errMsg = new StringBuilder();
        MutexLockInfo lockInfo = new MutexLockInfo(String.valueOf(pkValue), null, null, "hric_ptplbase", "refresh", true, "default");
        boolean mutex = MutexHelper.require((IFormView)this.getView(), (MutexLockInfo)lockInfo, (StringBuilder)errMsg);
        if (!mutex) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"newentry", "deleteentry"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bizAreaEdit = (BasedataEdit)this.getView().getControl("ptplebizarea");
        bizAreaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bizSubAreaEdit = (BasedataEdit)this.getView().getControl("ptplebizsubarea");
        bizSubAreaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit industryType = (BasedataEdit)this.getView().getControl("industrytype");
        industryType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        treeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addListener();
        Toolbar toolbar = (Toolbar)this.getView().getControl(this.ADV_CON_TOOLBAR_AP);
        toolbar.addItemClickListener((ItemClickListener)this);
        EntryGrid entry = (EntryGrid)this.getView().getControl("hric_ptplitementry");
        entry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Long entityId = (Long)this.getModel().getValue("fbasedataid_id", evt.getRowIndex());
        ImplItemFormUtils.showImplItemForm(this.getView(), entityId, OperationStatus.VIEW, null);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"ptplebizsubarea")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObjectCollection dyc = (DynamicObjectCollection)this.getModel().getValue("ptplebizarea");
            HashSet ids = new HashSet();
            dyc.stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).forEach(gro -> ids.add((Long)gro.get("id")));
            showParameter.getListFilterParameter().setFilter(new QFilter("group", "in", ids));
        } else if (HRStringUtils.equals((String)sourceName, (String)"industrytype")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "industrytype"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
        formOperate.getOption().setVariableValue("hric_ptplplan", planTempInfoCache);
        String operateKey = formOperate.getOperateKey();
        if ("addentry".equals(operateKey)) {
            this.planShowImplItemF7(args);
        }
    }

    private void planShowImplItemF7(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection bizAreaCo = this.getModel().getDataEntity().getDynamicObjectCollection("ptplplbizsubarea");
        List bizAreaIdLis = bizAreaCo.stream().map(bizAreaMul -> bizAreaMul.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection itemEntryCo = this.getModel().getEntryEntity("hric_ptplitementry");
        List implItemIdList = itemEntryCo.stream().map(entry -> entry.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
        QFilter enableQFilter = QFilterUtils.getEnableQFilter();
        enableQFilter.and(new QFilter("id", "not in", implItemIdList));
        enableQFilter.and(new QFilter("bizsubarea", "in", bizAreaIdLis));
        ImplItemFormUtils.showImplItemF7(this.getView(), new CloseCallBack((IFormPlugin)this, "hric_ptplitementry"), enableQFilter);
        args.setCancel(true);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"hric_ptplitementry") && closedCallBackEvent.getReturnData() != null) {
            ListSelectedRowCollection rowList = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            List<Long> addImplItem = rowList.stream().map(ListSelectedRow::getPrimaryKeyValue).map(it -> (Long)it).collect(Collectors.toList());
            this.setEntryEntity(addImplItem, false);
            HricDynamicObjectUtils.entitySort((String)"hric_ptplitementry", (IDataModel)this.getModel(), (IFormView)this.getView());
            DynamicObjectCollection implItemCollection = this.getModel().getEntryEntity("hric_ptplitementry");
            this.updatePlanTemp("fbasedataid", implItemCollection);
        } else if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"industrytype") && null != (returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData())) {
            this.getModel().setValue("industrytype", returnData.get(0).getPrimaryKeyValue());
            this.updatePlanTemp("industrytype", this.getModel().getValue("industrytype"));
            this.updateImplItem();
        }
    }

    private void updateImplItem() {
        String id;
        List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)this.getView().getPageCache().get(this.planPageCache));
        Map pTplPlanMap = this.pTplPlanDomain.pTplPlanListToMap(pTplPlanList);
        DynamicObject pTplPlan = (DynamicObject)pTplPlanMap.get(id = this.getView().getPageCache().get(this.CURRENT_NODE_ID));
        if (!HRStringUtils.equals((String)pTplPlan.getString("configmode"), (String)"A")) {
            HricDynamicObjectUtils.updateEntry((DynamicObjectCollection)pTplPlan.getDynamicObjectCollection("hric_ptplitementry"), (IDataModel)this.getModel());
            this.getView().updateView("hric_ptplitementry");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElseGet(() -> "");
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        switch (changeFieldName) {
            case "ptplebizsubarea": {
                this.updateBizAreaAndSubBizArea();
                break;
            }
            case "ptplebizarea": {
                this.updateSubArea();
                break;
            }
            case "industrytype": {
                if (this.getModel().getValue("industrytype") != null) break;
            }
            case "ptplbizsubarea": {
                this.createPlanCollection((Long)this.getModel().getDataEntity().getPkValue());
                this.updatePlanConfigTree("");
                this.setPlanTempInfo(String.valueOf(pkValue));
                break;
            }
            case "ffillfront": {
                this.updateBizAreaAndSubBizArea();
                break;
            }
            case "planname": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                this.updatePlanTemp(changeFieldName, newValue);
                this.updatePlanConfigTree("");
                break;
            }
            case "plandescription": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                this.updatePlanTemp(changeFieldName, newValue);
                break;
            }
            case "configmode": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                if (this.getCurrentNodeInfo().getString("configmode").equals(newValue)) {
                    return;
                }
                this.updatePlanTemp(changeFieldName, newValue);
                this.updatePlanConfigTree("");
                this.setPlanTempInfo(null);
                break;
            }
            case "fbasedataid": {
                DynamicObjectCollection implItemCollection = this.getModel().getEntryEntity("hric_ptplitementry");
                this.updatePlanTemp(changeFieldName, implItemCollection);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getItemKey().equals("deleteentry")) {
            String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
            String id = this.getView().getPageCache().get(this.CURRENT_NODE_ID);
            DynamicObjectCollection implItemCollection = this.getModel().getEntryEntity("hric_ptplitementry");
            String afterCache = this.pTplPlanDomain.updatePlanTemp(planTempInfoCache, id, evt.getItemKey(), (Object)implItemCollection);
            this.getView().getPageCache().put(this.planPageCache, afterCache);
        }
    }

    private void updatePlanTemp(String changeFieldName, Object newValue) {
        String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
        if (planTempInfoCache == null) {
            String kdString = ResManager.loadKDString((String)"\u201c\u8bf7\u8f93\u5165\u4e1a\u52a1\u5b50\u9886\u57df\u6570\u636e\u3002\u201d", (String)"PlanTemplateEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
            throw new KDBizException(kdString);
        }
        String id = this.getView().getPageCache().get(this.CURRENT_NODE_ID);
        if (id == null) {
            id = String.valueOf(this.getModel().getDataEntity().getPkValue());
        }
        String pTplPlanCache = this.pTplPlanDomain.updatePlanTemp(planTempInfoCache, id, changeFieldName, newValue);
        this.getView().getPageCache().put(this.planPageCache, pTplPlanCache);
    }

    private DynamicObject getCurrentNodeInfo() {
        String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
        if (planTempInfoCache == null) {
            String kdString = ResManager.loadKDString((String)"\u201c\u8bf7\u8f93\u5165\u4e1a\u52a1\u5b50\u9886\u57df\u6570\u636e\u3002\u201d", (String)"PlanTemplateEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
            throw new KDBizException(kdString);
        }
        String id = this.getView().getPageCache().get(this.CURRENT_NODE_ID);
        if (id == null) {
            id = String.valueOf(this.getModel().getDataEntity().getPkValue());
        }
        List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)planTempInfoCache);
        Map pTplPlanMap = this.pTplPlanDomain.pTplPlanListToMap(pTplPlanList);
        return (DynamicObject)pTplPlanMap.get(id);
    }

    private void createPlanCollection(Long pkValue) {
        DynamicObjectCollection bizArea = (DynamicObjectCollection)this.getModel().getValue("ptplbizarea");
        DynamicObjectCollection bizSubArea = (DynamicObjectCollection)this.getModel().getValue("ptplbizsubarea");
        DynamicObjectCollection eBizSubArea = (DynamicObjectCollection)this.getModel().getValue("ptplebizsubarea");
        List planInfoList = this.pTplPlanDomain.createPlanInfo(pkValue, bizArea, bizSubArea, eBizSubArea);
        String planTempInfoCache = this.pTplPlanDomain.toBase64String(planInfoList);
        this.getView().getPageCache().put(this.planPageCache, planTempInfoCache);
    }

    private void updateBizAreaAndSubBizArea() {
        this.getModel().setValue("ptplbizarea", null);
        this.getModel().setValue("ptplbizsubarea", null);
        this.getModel().setValue("industrytype", null);
        this.getView().updateView("industrytype");
        List bizArea = ((DynamicObjectCollection)this.getModel().getValue("ptplebizarea")).stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).map(gro -> gro.getLong("id")).collect(Collectors.toList());
        List bizSubArea = ((DynamicObjectCollection)this.getModel().getValue("ptplebizsubarea")).stream().map(gro -> gro.get(1)).map(gro -> (DynamicObject)gro).map(gro -> gro.getLong("id")).collect(Collectors.toList());
        boolean isAddPre = (Boolean)this.getModel().getValue("ffillfront");
        if (isAddPre) {
            Map resultMap = this.planTemplateDomainService.getBizAreaAndSubBizArea(bizArea, bizSubArea);
            this.getModel().setValue("ptplbizarea", resultMap.get("ptplbizarea"));
            this.getModel().setValue("ptplbizsubarea", resultMap.get("ptplbizsubarea"));
        } else {
            this.getModel().setValue("ptplbizarea", (Object)bizArea.toArray());
            this.getModel().setValue("ptplbizsubarea", (Object)bizSubArea.toArray());
        }
    }

    private void updateSubArea() {
        this.getModel().setValue("ptplebizsubarea", null);
        this.getView().setEnable(Boolean.valueOf(!CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)this.getModel().getValue("ptplebizarea")))), new String[]{"ptplebizsubarea"});
    }

    private void updatePlanConfigTree(String name) {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
        List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)planTempInfoCache);
        if (!HRStringUtils.isEmpty((String)name)) {
            this.planTemplateDomainService.filterPTplPlanList(pTplPlanList, name);
        }
        this.planTemplateDomainService.setTreeForPlanTemplate(treeView, pTplPlanList);
    }

    public void queryTreeNodeChildren(TreeNodeEvent treeNodeEvent) {
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.setPlanTempInfo(evt.getNodeId().toString());
        if (HRStringUtils.isEmpty((String)evt.getParentNodeId().toString())) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"industrytype"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"industrytype"});
        }
    }

    public void setPlanTempInfo(String nodeId) {
        boolean isEdit;
        if (nodeId != null) {
            this.getView().getPageCache().put(this.CURRENT_NODE_ID, nodeId);
        } else {
            nodeId = this.getView().getPageCache().get(this.CURRENT_NODE_ID);
        }
        String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
        List pTplPlanList = (List)SerializationUtils.deSerializeFromBase64((String)planTempInfoCache);
        Map pTplPlanMap = this.pTplPlanDomain.pTplPlanListToMap(pTplPlanList);
        DynamicObject planInfoDyn = (DynamicObject)pTplPlanMap.get(nodeId);
        if (planInfoDyn == null) {
            return;
        }
        String configMode = planInfoDyn.getString("configmode");
        this.getModel().setValue("planname", (Object)planInfoDyn.getLocaleString("planname"));
        this.getModel().setValue("configmode", (Object)configMode);
        this.getModel().setValue("plandescription", (Object)planInfoDyn.getLocaleString("plandescription"));
        DynamicObjectCollection bizSubAreaCollection = planInfoDyn.getDynamicObjectCollection("ptplplbizsubarea");
        this.getModel().setValue("ptplplbizarea", (Object)planInfoDyn.getDynamicObjectCollection("ptplplbizarea").stream().map(s -> s.get("fbasedataid_id")).toArray());
        this.getModel().setValue("ptplplbizsubarea", (Object)bizSubAreaCollection.stream().map(s -> s.get("fbasedataid_id")).toArray());
        DynamicObjectCollection entryCo = planInfoDyn.getDynamicObjectCollection("hric_ptplitementry");
        this.setEntryEntity(entryCo.stream().map(s -> s.getLong("fbasedataid_id")).collect(Collectors.toList()), true);
        boolean bl = isEdit = bizSubAreaCollection.size() == 1 && (planInfoDyn.getString("configmode").equals("B") || planInfoDyn.getString("configmode").equals("C"));
        if (isEdit) {
            this.setComboItem(false);
        } else {
            this.setComboItem(true);
        }
        if ("A".equals(configMode)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.FLEX_PANEL_AP_TIP});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.implItemPanel});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{this.FLEX_PANEL_AP_TIP});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{this.implItemPanel});
        }
        this.getModel().setValue("industrytype", (Object)planInfoDyn.getDynamicObject("industrytype"));
        this.getModel().setDataChanged(false);
    }

    private void setComboItem(boolean isIncludePlan) {
        ComboEdit configModeEdit = (ComboEdit)this.getView().getControl("configmode");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        List data = ((ComboProp)this.getModel().getDataEntity().getDynamicObjectType().getProperty("configmode")).getComboItems();
        Map collect = data.stream().collect(Collectors.toMap(ValueMapItem::getValue, Function.identity()));
        if (isIncludePlan) {
            comboItems.add(new ComboItem(((ValueMapItem)collect.get("A")).getName(), "A"));
        }
        comboItems.add(new ComboItem(((ValueMapItem)collect.get("B")).getName(), "B"));
        comboItems.add(new ComboItem(((ValueMapItem)collect.get("C")).getName(), "C"));
        configModeEdit.setComboItems(comboItems);
    }

    private void setEntryEntity(List<Long> itemList, boolean clear) {
        if (clear) {
            this.getModel().deleteEntryData("hric_ptplitementry");
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("fbasedataid_id", new Object[0]);
        itemList.forEach(xva$0 -> vs.addRow(new Object[]{xva$0}));
        model.batchCreateNewEntryRow("hric_ptplitementry", vs);
        model.endInit();
        this.getView().updateView("hric_ptplitementry");
    }

    private void addListener() {
        Search allFuncPermSearch = (Search)this.getControl("searchap");
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        final String planTempInfoCache = this.getView().getPageCache().get(this.planPageCache);
        allFuncPermSearch.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent see) {
                if (HRStringUtils.isEmpty((String)planTempInfoCache)) {
                    return;
                }
                String searchText = see.getText();
                PlanTemplateEditPlugin.this.updatePlanConfigTree(searchText);
            }
        });
    }
}

