/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.annex;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.BackgroundTaskSubscriber;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.schedule.form.TaskClientProxy;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.annex.AnnexOpHandleFactory;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IAnnexErrorDataDomainService;
import kd.hrmp.hric.bussiness.domain.init.IContractAnnexDomainService;
import kd.hrmp.hric.bussiness.domain.init.IPersonHeadPicDomainService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.formplugin.web.annex.CommonBaseEdit;

public class AnnexProgreessEditPlugin
extends CommonBaseEdit
implements ProgresssListener {
    IPersonHeadPicDomainService iPersonHeadPicDomainService = (IPersonHeadPicDomainService)ServiceFactory.getService(IPersonHeadPicDomainService.class);
    IContractAnnexDomainService iContractAnnexDomainService = (IContractAnnexDomainService)ServiceFactory.getService(IContractAnnexDomainService.class);
    IAnnexErrorDataDomainService iAnnexErrorDataDomainService = (IAnnexErrorDataDomainService)ServiceFactory.getService(IAnnexErrorDataDomainService.class);
    private String SYNC_DATA = ResManager.loadKDString((String)"\u672c\u6b21\u6210\u529f\u540c\u6b65\u6570\u636e", (String)"AnnexProgreessEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        ProgressBar progressbar = (ProgressBar)this.getControl("progress");
        progressbar.addProgressListener((ProgresssListener)this);
        Button stop = (Button)this.getControl("stop");
        stop.addClickListener((ClickListener)this);
        Button backRun = (Button)this.getControl("btnok");
        backRun.addClickListener((ClickListener)this);
        ((Label)this.getView().getControl("faillistlabel")).addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map<String, Object> paramsMap = this.getChacheParamsMap();
        Label progresstip = (Label)this.getView().getControl("progresstip");
        if (!CollectionUtils.isEmpty(paramsMap)) {
            progresstip.setText(paramsMap.get("progresstip").toString());
        }
        String operateBtn = ConvertUtils.toString((Object)paramsMap.get("operatebtn"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"btncancel", "resultpanel"});
        this.getView().setVisible(Boolean.valueOf(ConvertUtils.toBoolean((Object)paramsMap.get("failedflexpanelap"))), new String[]{"failedflexpanelap"});
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)operateBtn, (String)"zip_in")), new String[]{"faillistlabel"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.start();
        String taskId = this.getTaskId();
        if (HRStringUtils.isNotEmpty((String)taskId)) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
            int progress = taskInfo.getProgress();
            if (progress >= 100) {
                progress = 99;
            }
            bar.setPercent(progress);
        } else {
            this.setBackrunBtnEnable(Boolean.FALSE);
        }
    }

    public void onProgress(ProgressEvent evt) {
        String taskId = this.getTaskId();
        boolean start = this.isStart();
        this.setStart(true);
        if (!start && HRStringUtils.isEmpty((String)taskId)) {
            this.dispatchTask();
            return;
        }
        Map<String, Object> paramsMap = this.getChacheParamsMap();
        String initWay = paramsMap.get("initway").toString();
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        String type = ConvertUtils.toString((Object)paramsMap.get("annexinittype"));
        if (HricCacheUtils.get((String)type, String.class) != null) {
            this.stopProgressByCache(evt);
            this.getView().close();
        }
        this.checkRepeatData(ConvertUtils.toString((Object)paramsMap.get("curoperatepage")));
        if (taskInfo.isTaskEnd()) {
            if (HRStringUtils.equals((String)initWay, (String)"part")) {
                this.stopProgressByCache(evt);
                this.setLabelForResultData(ConvertUtils.toLong((Object)paramsMap.get("migratebatchnumber")), ConvertUtils.toString((Object)paramsMap.get("curoperatepage")));
            } else {
                this.setStart(false);
                this.getPageCache().put("annextaskId", null);
                this.updateCacheParam("initway", "part");
                String curOperatePage = paramsMap.get("curoperatepage").toString();
                String name = MetadataServiceHelper.getDataEntityType((String)curOperatePage).getDisplayName().getLocaleValue();
                this.updateCacheParam("progresstip", String.format(Locale.ROOT, AnnexEnum.PREGRESS_TIP.get(), name));
                String implementName = paramsMap.get("implementname").toString();
                this.updateCacheParam("count", AnnexOpHandleFactory.getService((String)implementName).getFailAndWaitTotal());
                this.getView().updateView();
                this.stopProgressByCache(evt);
                this.setLabelForResultData(ConvertUtils.toLong((Object)paramsMap.get("batchnumber")), ConvertUtils.toString((Object)paramsMap.get("curoperatepage")));
            }
        } else {
            evt.setProgress(taskInfo.getProgress());
            if (HRStringUtils.equals((String)initWay, (String)"part")) {
                this.setBackrunBtnEnable(Boolean.TRUE);
            }
        }
    }

    private void checkRepeatData(String currPage) {
        if (HRStringUtils.equals((String)currPage, (String)"hric_perheadpicinit")) {
            if (HRStringUtils.isNotEmpty((String)((String)HricCacheUtils.get((String)"repeat_person_cache", String.class)))) {
                this.getView().getParentView().showErrorNotification(AnnexEnum.REPEAT_TIP.getMsg());
                this.getView().sendFormAction(this.getView().getParentView());
                HricCacheUtils.remove((String)"repeat_person_cache");
            }
        } else if (HRStringUtils.equals((String)currPage, (String)"hric_contractinit") && HRStringUtils.isNotEmpty((String)((String)HricCacheUtils.get((String)"repeat_contract_cache", String.class)))) {
            this.getView().getParentView().showErrorNotification(AnnexEnum.REPEAT_TIP.getMsg());
            this.getView().sendFormAction(this.getView().getParentView());
            HricCacheUtils.remove((String)"repeat_contract_cache");
        }
    }

    private void setLabelForResultData(long batchNumber, String currPage) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"resultpanel", "btncancel"});
        boolean isUpdateData = ConvertUtils.toBoolean((Object)this.getChacheParamsMap().get("failedflexpanelap"));
        if (!isUpdateData) {
            ((Label)this.getView().getControl("successlabel")).setText(this.SYNC_DATA);
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"progresspanel", "stop", "btnok"});
        DynamicObject[] persons = HRStringUtils.equals((String)currPage, (String)"hric_perheadpicinit") ? this.iPersonHeadPicDomainService.getDataByBatchNumber(Long.valueOf(batchNumber)) : this.iContractAnnexDomainService.getDataByBatchNumber(Long.valueOf(batchNumber));
        long successCount = 0L;
        successCount = isUpdateData ? Arrays.stream(persons).filter(it -> HRStringUtils.equals((String)it.getString("initstatus"), (String)"A")).count() : Arrays.stream(persons).filter(it -> HRStringUtils.equals((String)it.getString("initstatus"), (String)"C")).count();
        Map<String, Object> paramsMap = this.getChacheParamsMap();
        String operateType = ConvertUtils.toString((Object)paramsMap.get("operatebtn"));
        long failCount = 0L;
        failCount = HRStringUtils.equals((String)operateType, (String)"zip_in") ? (long)this.iAnnexErrorDataDomainService.queryErrorCountByBatchNumber(Long.valueOf(batchNumber)) : Arrays.stream(persons).filter(it -> HRStringUtils.equals((String)it.getString("initstatus"), (String)"B")).count();
        if (failCount == 0L) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"faillistlabel"});
        }
        ((Label)this.getView().getControl("successnum")).setText(String.valueOf(successCount));
        ((Label)this.getView().getControl("failnum")).setText(String.valueOf(failCount));
    }

    private void stopProgressByCache(ProgressEvent evt) {
        evt.setProgress(100);
        this.stopBar();
        this.getView().getParentView().invokeOperation("refresh");
        if (this.getView().getParentView() instanceof ListView) {
            ((ListView)this.getView().getParentView()).clearSelection();
        }
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)"stop", (CharSequence)source.getKey())) {
            HricCacheUtils.put((String)ConvertUtils.toString((Object)this.getChacheParamsMap().get("annexinittype")), (Object)true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"btnok", (CharSequence)source.getKey())) {
            this.closeForm();
            this.doTranBackground();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)"faillistlabel")) {
            this.showFailList();
        }
    }

    private void showFailList() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hric_annexerrordata");
        showParameter.setFormId(FormMetadataCache.getListFormConfig((String)"hric_annexerrordata").getF7ListFormId());
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        css.setWidth("900px");
        css.setHeight("600px");
        style.setInlineStyleCss(css);
        showParameter.setOpenStyle(style);
        showParameter.setCustomParam("batchnumber", (Object)(this.getChacheParamsMap().containsKey("migratebatchnumber") ? ConvertUtils.toLong((Object)this.getChacheParamsMap().get("migratebatchnumber")) : 0L));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Map<String, Object> paramsMap = this.getChacheParamsMap();
        if (CollectionUtils.isEmpty(paramsMap)) {
            return;
        }
        String type = ConvertUtils.toString((Object)paramsMap.get("annexinittype"));
        if (HricCacheUtils.get((String)type, String.class) != null) {
            return;
        }
        String initway = paramsMap.get("initway").toString();
        if (HRStringUtils.equals((String)initway, (String)"all")) {
            this.getView().showTipNotification(AnnexEnum.WATI_SYNC_TO_COMPLETE.get());
            e.setCancel(true);
        } else {
            TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
            this.doTranBackground();
        }
    }

    private Map<String, Object> getChacheParamsMap() {
        String cacheUniqueId = (String)this.getView().getFormShowParameter().getCustomParam("cacheUniqueId");
        String params = (String)HricCacheUtils.get((String)cacheUniqueId, String.class);
        if (HRStringUtils.isEmpty((String)params)) {
            return new HashMap<String, Object>(AppConstants.MAP_SIZE);
        }
        return (Map)SerializationUtils.fromJsonString((String)params, Map.class);
    }

    private boolean updateCacheParam(String key, Object value) {
        String cacheUniqueId = (String)this.getView().getFormShowParameter().getCustomParam("cacheUniqueId");
        String paramsStr = (String)HricCacheUtils.get((String)cacheUniqueId, String.class);
        Map paramsMap = (Map)SerializationUtils.fromJsonString((String)paramsStr, Map.class);
        paramsMap.put(key, value);
        return HricCacheUtils.put((String)cacheUniqueId, (Object)SerializationUtils.toJsonString((Object)paramsMap));
    }

    private void doTranBackground() {
        String taskId = this.getTaskId();
        if (HRStringUtils.isEmpty((String)taskId)) {
            return;
        }
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)taskId);
        if (!TaskClientProxy.isExistTask((String)taskId)) {
            TaskClientProxy.addTask((IFormView)this.getView(), (JobFormInfo)this.getJobFormInfo(), (TaskInfo)taskInfo);
            BackgroundTaskSubscriber subscriber = new BackgroundTaskSubscriber(RequestContext.get(), this.getJobFormInfo(), taskId);
            ThreadPools.executeOnce((String)"annextask-background-monitor", (Runnable)subscriber);
        }
    }

    private void setBackrunBtnEnable(Boolean isEnable) {
        this.getView().setEnable(isEnable, new String[]{"btnok"});
    }

    private void closeForm() {
        TaskClientProxy.setProgressPageId((String)this.getTaskId(), (String)"");
        this.getView().close();
    }

    private void dispatchTask() {
        JobFormInfo jobFormInfo = this.getJobFormInfo();
        if (jobFormInfo == null) {
            return;
        }
        if (HRStringUtils.isEmpty((String)jobFormInfo.getJobInfo().getAppId())) {
            jobFormInfo.getJobInfo().setAppId(this.getView().getFormShowParameter().getServiceAppId());
        }
        String taskId = ScheduleServiceHelper.dispatch((JobInfo)jobFormInfo.getJobInfo());
        this.setTaskId(taskId);
    }

    private JobFormInfo getJobFormInfo() {
        String curOperatePage;
        Map<String, Object> customParams = this.getChacheParamsMap();
        String str = customParams.get(curOperatePage = customParams.get("curoperatepage").toString()).toString();
        if (HRStringUtils.isEmpty((String)str)) {
            return null;
        }
        return (JobFormInfo)SerializationUtils.fromJsonString((String)str, JobFormInfo.class);
    }

    private void setStart(boolean start) {
        this.getPageCache().put("isstart", String.valueOf(start));
    }

    private boolean isStart() {
        String start = this.getPageCache().get("isstart");
        if (HRStringUtils.isEmpty((String)start)) {
            return false;
        }
        return Boolean.parseBoolean(start);
    }

    private void setTaskId(String taskId) {
        this.getPageCache().put("annextaskId", taskId);
    }

    private void stopBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progress");
        bar.stop();
    }

    private String getTaskId() {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("annextaskId")) {
            return (String)this.getView().getFormShowParameter().getCustomParam("annextaskId");
        }
        return this.getPageCache().get("annextaskId");
    }
}

