/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.annex;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.attachment.extend.service.FileServiceExtensionUtil;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IMigrationToolDomainService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import org.apache.commons.lang3.StringUtils;

public class AnnexUploadFormPlugin
extends HRDataBaseEdit {
    private static final List<String> SUFFIX_LIST = Lists.newArrayList((Object[])new String[]{"zip"});
    private static final List<String> PIC_List = Lists.newArrayList((Object[])new String[]{"bmp", "gif", "jpg", "png", "jpeg"});
    private static final List<String> DOC_List = Lists.newArrayList((Object[])new String[]{"txt", "doc", "xls", "xlsx", "pdf", "docx", "png", "rar", "zip", "jpg"});
    private static final Log LOG = LogFactory.getLog(AnnexUploadFormPlugin.class);
    private static final String ISUPLOADSUCCESS = "isuploadsuccess";
    private boolean isSuccess = true;
    private static final String stringFormatContract = ".*\\+.*\\+.*";
    private static final String stringFormatPerson = ".*\\+.*";
    private String TIP_1 = ResManager.loadKDString((String)"1. \u9644\u4ef6\u5bfc\u5165\u4ec5\u652f\u6301zip\u683c\u5f0f\u3002\u8bf7\u5c06\u4eba\u5458\u5934\u50cf\u56fe\u7247\u538b\u7f29\u4e3azip\u683c\u5f0f\u3002", (String)"AnnexUploadFormPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_2 = ResManager.loadKDString((String)"2.\u4eba\u5458\u5934\u50cf\u56fe\u7247\u652f\u6301\u7684\u62d3\u5c55\u540d\u4e3a\uff1ajpg\u3001png\u3001jpeg\u7b49\u683c\u5f0f\u7684\u56fe\u7247\u6587\u4ef6\u3002", (String)"AnnexUploadFormPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_3 = ResManager.loadKDString((String)"3.\u8bbe\u7f6e\u4eba\u5458\u5934\u50cf\u56fe\u7247\u547d\u540d\u89c4\u8303\uff1a", (String)"AnnexUploadFormPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_4 = ResManager.loadKDString((String)"\u552f\u4e00\u66ff\u6362\u503c\u4e3a\uff1a\u201c\u5de5\u53f7+\u59d3\u540d\u201d\uff0c\u5982\u201c1001+\u5f20\u5c0f\u660e\u201d\uff1b", (String)"AnnexUploadFormPlugin_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_5 = ResManager.loadKDString((String)"\u552f\u4e00\u66ff\u6362\u503c\u4e3a\uff1a\u201c\u5de5\u53f7\u201d\uff0c\u5982\u201c1001\u201d\uff1b", (String)"AnnexUploadFormPlugin_4", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_6 = ResManager.loadKDString((String)"1. \u9644\u4ef6\u5bfc\u5165\u4ec5\u652f\u6301zip\u683c\u5f0f\u3002\u8bf7\u5c06\u5408\u540c\u9644\u4ef6\u538b\u7f29\u4e3azip\u683c\u5f0f\u3002", (String)"AnnexUploadFormPlugin_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_7 = ResManager.loadKDString((String)"2.\u5408\u540c\u9644\u4ef6\u652f\u6301\u7684\u62d3\u5c55\u540d\u4e3a\uff1arar\u3001zip\u3001doc\u3001docx\u3001PDF\u3001jpg\u3001png\u7b49\u6587\u4ef6\u683c\u5f0f\u3002", (String)"AnnexUploadFormPlugin_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_8 = ResManager.loadKDString((String)"3.\u8bbe\u7f6e\u5408\u540c\u9644\u4ef6\u547d\u540d\u89c4\u8303\uff1a", (String)"AnnexUploadFormPlugin_7", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_9 = ResManager.loadKDString((String)"\u8bf7\u5728\u4e0b\u65b9\u8f93\u5165\u552f\u4e00\u66ff\u6362\u503c\uff0c\u683c\u5f0f\u4e3a\u201c\u5de5\u53f7+\u59d3\u540d+\u5408\u540c\u7f16\u53f7\u201d\uff0c\u4f8b\u5982\uff1a1001+\u5f20\u5c0f\u660e+LDHT-20210123-0001\u3002", (String)"AnnexUploadFormPlugin_8", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_10 = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5408\u540c\u7f16\u53f7\uff0c\u4f8b\u5982\uff1aLDHT-20210123-0001\u3002", (String)"AnnexUploadFormPlugin_9", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String TIP_11 = ResManager.loadKDString((String)"\u64cd\u4f5c\u8bf4\u660e\uff1a", (String)"AnnexUploadFormPlugin_10", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private final IMigrationToolDomainService iMigrationToolDomainService = (IMigrationToolDomainService)ServiceFactory.getService(IMigrationToolDomainService.class);

    public void afterDoOperation(AfterDoOperationEventArgs arg) {
        super.afterDoOperation(arg);
        if (HRStringUtils.equals((String)"btnok", (String)arg.getOperateKey())) {
            this.downAnnexAndImport();
            if (this.isSuccess) {
                this.getView().getPageCache().put(ISUPLOADSUCCESS, "true");
                this.getView().close();
            } else {
                this.getView().returnDataToParent(null);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (HRStringUtils.equals((String)((ListView)this.getView().getParentView()).getBillFormId(), (String)"hric_perheadpicinit")) {
            this.getModel().setValue("textareafield", (Object)StringUtils.join((Object[])new String[]{this.TIP_11, this.TIP_1, this.TIP_2}, (String)"\n"));
            ((Label)this.getView().getControl("textareafield1")).setText(StringUtils.join((Object[])new String[]{this.TIP_3}, (String)"\n"));
            this.getModel().setValue("textareafield2", (Object)StringUtils.join((Object[])new String[]{this.TIP_4, this.TIP_5}, (String)"\n"));
        } else {
            this.getModel().setValue("textareafield", (Object)StringUtils.join((Object[])new String[]{this.TIP_11, this.TIP_6, this.TIP_7}, (String)"\n"));
            ((Label)this.getView().getControl("textareafield1")).setText(StringUtils.join((Object[])new String[]{this.TIP_8}, (String)"\n"));
            this.getModel().setValue("textareafield2", (Object)StringUtils.join((Object[])new String[]{this.TIP_9, this.TIP_10}, (String)"\n"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (HRStringUtils.equals((String)key, (String)"textareafield1")) {
            this.showMigrationTools();
        }
    }

    private void showMigrationTools() {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("hric_migrationtools");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        DynamicObject migrationToolInfo = this.iMigrationToolDomainService.getAnnexInitTypeInfo(ConvertUtils.toString(this.getView().getParentView().getFormShowParameter().getCustomParams().get("annexinittype")));
        showParameter.setPkId((Object)migrationToolInfo.getLong("id"));
        showParameter.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((Label)this.getView().getControl("textareafield1")).addClickListener((ClickListener)this);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String isuploadsuccess = Optional.ofNullable(this.getView().getPageCache().get(ISUPLOADSUCCESS)).orElse("");
        if (HRStringUtils.isEmpty((String)isuploadsuccess)) {
            String entityId = this.getView().getFormShowParameter().getCustomParam("entityid").toString();
            HricCacheUtils.remove((String)entityId);
        }
    }

    private void downAnnexAndImport() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        List attachmentDataList = attachmentPanel.getAttachmentData();
        ArrayList<String> filePathList = new ArrayList<String>(AppConstants.LIST_SIZE);
        HashMap<String, String> result = new HashMap<String, String>(attachmentDataList.size());
        if (CollectionUtils.isEmpty((Collection)attachmentDataList)) {
            this.isSuccess = false;
            this.getView().showErrorNotification(AnnexEnum.ANNEX_EMPTY_CHECK.getMsg());
            return;
        }
        for (Map it : attachmentDataList) {
            String name = ConvertUtils.toString(it.get("name"));
            if (!SUFFIX_LIST.contains(name.substring(name.lastIndexOf(".") + 1))) {
                this.isSuccess = false;
                this.getView().showErrorNotification(AnnexEnum.UPLOAD_ERR_INFO.getMsg());
                return;
            }
            String url = FileServiceExtensionUtil.getDownloadUrl((String)ConvertUtils.toString(it.get("url")));
            filePathList.add(url);
            result.put(url, name);
        }
        if (!this.checkDataExist(filePathList, (Boolean)this.getView().getFormShowParameter().getCustomParam("billFormId"))) {
            return;
        }
        this.getView().returnDataToParent(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkDataExist(List<String> filePathList, boolean sign) {
        ArrayList<String> fileNameList = new ArrayList<String>(AppConstants.LIST_SIZE);
        ArrayList<String> contractNumberList = new ArrayList<String>(AppConstants.LIST_SIZE);
        String billId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        for (String it : filePathList) {
            ZipInputStream zipIn = null;
            try {
                ZipEntry zipEntry;
                zipIn = new ZipInputStream(CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(it), Charset.forName("GBK"));
                while ((zipEntry = zipIn.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) continue;
                    if (!this.checkFileNameFormat(zipEntry)) {
                        this.isSuccess = false;
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.checkFileFormat(sign, zipEntry)) {
                        this.getView().showErrorNotification(AnnexEnum.UPLOAD_ERR_INFO.getMsg());
                        this.isSuccess = false;
                        boolean bl = false;
                        return bl;
                    }
                    String fileName = zipEntry.getName().trim();
                    if (fileName.indexOf("/") > -1) {
                        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
                    }
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    if (HRStringUtils.equals((String)billId, (String)"hric_perheadpicinit")) {
                        if (fileName.indexOf("+") > -1) {
                            fileName = fileName.substring(0, fileName.indexOf("+"));
                        }
                        fileNameList.add(fileName);
                        continue;
                    }
                    if (!HRStringUtils.equals((String)billId, (String)"hric_contractinit")) continue;
                    String contractNumber = fileName.substring(fileName.lastIndexOf("+") + 1);
                    contractNumberList.add(contractNumber);
                }
            }
            catch (Exception e) {
                LOG.error("AnnexUploadFormPlugin parseUrl method has error : ", (Object)e.getMessage());
                this.getView().showErrorNotification(AnnexEnum.UPLOAD_ERR_INFO.getMsg());
                this.isSuccess = false;
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (null == zipIn) continue;
                    zipIn.close();
                }
                catch (IOException ioException) {
                    LOG.error("AnnexUploadFormPlugin checkDataExist method has error : ", (Object)ioException.getMessage());
                }
            }
        }
        return !(HRStringUtils.equals((String)billId, (String)"hric_perheadpicinit") ? this.checkNumberSole(fileNameList, AnnexEnum.CHECK_ERR_FILENAMETHREE.getMsg()) : HRStringUtils.equals((String)billId, (String)"hric_contractinit") && this.checkNumberSole(contractNumberList, AnnexEnum.CHECK_ERR_FILENAMEFIVE.getMsg()));
    }

    private boolean checkNumberSole(List<String> fileNameList, String tip) {
        if (fileNameList.stream().distinct().count() != (long)fileNameList.size()) {
            List repeatList = fileNameList.stream().collect(Collectors.toMap(e -> e, e -> 1, Integer::sum)).entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            this.getView().showErrorNotification(String.format(Locale.ROOT, tip, String.join((CharSequence)";", repeatList)));
            this.isSuccess = false;
            return true;
        }
        return false;
    }

    private boolean checkFileNameFormat(ZipEntry zipEntry) {
        String annexInitType = (String)this.getView().getFormShowParameter().getCustomParam("hric_migrationtools");
        DynamicObject annexInitTypeInfo = this.iMigrationToolDomainService.getAnnexInitTypeInfo(annexInitType);
        String uniqueType = annexInitTypeInfo.getString("uniquefield");
        String fileName = zipEntry.getName().substring(zipEntry.getName().lastIndexOf("/") + 1, zipEntry.getName().lastIndexOf("."));
        String billId = (String)this.getView().getFormShowParameter().getCustomParam("entityid");
        if (HRStringUtils.equals((String)uniqueType, (String)"B")) {
            if (fileName.contains("+")) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, HRStringUtils.equals((String)billId, (String)"hric_perheadpicinit") ? AnnexEnum.CHECK_ERR_FILENAME_SEVEN.getMsg() : AnnexEnum.CHECK_ERR_FILENAME_EIGHT.getMsg(), zipEntry.getName()));
            }
            return !fileName.contains("+");
        }
        if (HRStringUtils.equals((String)billId, (String)"hric_perheadpicinit")) {
            if (!fileName.matches(stringFormatPerson) || fileName.matches(stringFormatContract)) {
                this.getView().showErrorNotification(String.format(Locale.ROOT, AnnexEnum.CHECK_ERR_FILENAMEONE.getMsg(), zipEntry.getName()));
            }
            return fileName.matches(stringFormatPerson) && !fileName.matches(stringFormatContract);
        }
        if (!fileName.matches(stringFormatContract)) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, AnnexEnum.CHECK_ERR_FILENAMETWO.getMsg(), zipEntry.getName()));
        }
        return fileName.matches(stringFormatContract);
    }

    private boolean checkFileFormat(boolean picture, ZipEntry zipEntry) {
        String format = zipEntry.getName().substring(zipEntry.getName().lastIndexOf(".") + 1).toLowerCase(Locale.ROOT);
        if (picture) {
            return PIC_List.contains(format);
        }
        return DOC_List.contains(format);
    }
}

