/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.annex;

import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.form.JobFormInfo;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hric.bussiness.annex.AnnexOpHandleFactory;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IMigrationToolDomainService;
import kd.hrmp.hric.bussiness.service.BaseConfigServiceHelper;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.AttachmentUtils;
import kd.hrmp.hric.common.util.ConvertUtils;
import kd.hrmp.hric.common.util.HricCacheUtils;
import kd.hrmp.hric.formplugin.web.annex.CommonBaseEdit;

public class InitAnnexTplListPlugin
extends CommonBaseEdit {
    IMigrationToolDomainService migrationToolDomainService = (IMigrationToolDomainService)ServiceFactory.getService(IMigrationToolDomainService.class);
    private static Log LOG = LogFactory.getLog(InitAnnexTplListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map customParams = e.getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("annexinittype")) {
            e.setCancelMessage(AnnexEnum.MENU_ERROR_TIP.get());
            e.setCancel(true);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String annexInitType = this.getView().getFormShowParameter().getCustomParam("annexinittype").toString();
        DynamicObject dyc = this.migrationToolDomainService.getAnnexInitTypeInfo(annexInitType);
        this.getView().setVisible(Boolean.valueOf(dyc.getBoolean("isensemble")), new String[]{"exe_integration_in"});
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)((ListView)this.getView()).getBillFormId(), (String)"hric_perheadpicinit")), new String[]{"syncperson"});
        this.getView().setVisible(Boolean.valueOf(HRStringUtils.equals((String)((ListView)this.getView()).getBillFormId(), (String)"hric_contractinit")), new String[]{"synccontract"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (BTN_LIST.contains(operateKey)) {
            this.removeCache();
        }
    }

    private void removeCache() {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("annexinittype");
        HricCacheUtils.remove((String)type);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ((HRStringUtils.equals((String)operateKey, (String)"exe_integration_in") || HRStringUtils.equals((String)operateKey, (String)"zip_in") || HRStringUtils.equals((String)operateKey, (String)"synccontract") || HRStringUtils.equals((String)operateKey, (String)"syncperson")) && this.isMutex()) {
            return;
        }
        if (HRStringUtils.equals((String)operateKey, (String)"exe_integration_in")) {
            this.getView().showConfirm(AnnexEnum.ANNEX_CONFIRM.getMsg(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("exe_integration_in", (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)operateKey, (String)"zip_in")) {
            this.showAnnexPage();
        } else if (HRStringUtils.equals((String)operateKey, (String)"synccontract") || HRStringUtils.equals((String)operateKey, (String)"syncperson")) {
            this.handle("exe_integration_in", null, false);
        }
    }

    private boolean isMutex() {
        String curOpPerson;
        String entityId = ((ListView)this.getView()).getBillFormId();
        String delMutex = BaseConfigServiceHelper.get((String)"initannextpl.delmutex");
        if (HRStringUtils.equals((String)delMutex, (String)"true")) {
            HricCacheUtils.remove((String)entityId);
        }
        if (HRStringUtils.isNotEmpty((String)(curOpPerson = (String)Optional.ofNullable(HricCacheUtils.get((String)entityId, String.class)).orElse("")))) {
            this.getView().showTipNotification(String.format(Locale.ROOT, AnnexEnum.MUTEX_TIP.get(), curOpPerson));
            return true;
        }
        HricCacheUtils.put((String)entityId, (Object)RequestContext.get().getUserName());
        return false;
    }

    private void showAnnexPage() {
        String annexInitType = this.getView().getFormShowParameter().getCustomParam("annexinittype").toString();
        DynamicObject dyc = this.migrationToolDomainService.getAnnexInitTypeInfo(annexInitType);
        String transferType = dyc.getString("transfertype");
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hric_annexpanel");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btnok"));
        parameter.setCustomParam("billFormId", (Object)HRStringUtils.equals((String)transferType, (String)"A"));
        parameter.setCustomParam("entityid", (Object)((ListView)this.getView()).getBillFormId());
        parameter.setCustomParam("hric_migrationtools", (Object)annexInitType);
        this.getView().showForm(parameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (HRStringUtils.equals((String)"exe_integration_in", (String)event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.handle("exe_integration_in", null, true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        if (HRStringUtils.equals((String)"btnok", (String)event.getActionId()) && null != event.getReturnData()) {
            Map resultMap = (Map)event.getReturnData();
            this.handle("zip_in", resultMap, true);
        }
    }

    private void handle(String operateKey, Map<String, String> zipParamMap, boolean isUpdateData) {
        String annexInitType = this.getView().getFormShowParameter().getCustomParam("annexinittype").toString();
        long batchNumber = ID.genLongId();
        DynamicObject dyc = this.migrationToolDomainService.getAnnexInitTypeInfo(annexInitType);
        String string = dyc.getString("personapi");
        String[] split = string.split("_");
        if (dyc == null) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, AnnexEnum.PREGRESS_TIP.get(), annexInitType));
            return;
        }
        String implementName = dyc.getString("implementname");
        if (HRStringUtils.isEmpty((String)implementName)) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, AnnexEnum.IMPLEMENT_NAME_IS_EMPTY_TIP.get(), annexInitType));
            return;
        }
        this.buildCustomParam(operateKey, zipParamMap, isUpdateData, annexInitType, batchNumber, implementName);
        if (isUpdateData) {
            this.transferData(operateKey, zipParamMap, dyc, implementName);
        } else {
            this.syncData(zipParamMap, annexInitType, batchNumber, string, split, implementName);
        }
        this.showProgressForm(isUpdateData);
    }

    private void syncData(Map<String, String> zipParamMap, String annexInitType, long batchNumber, String string, String[] split, String implementName) {
        LOG.info("InitAnnexTplListPlugin start invoke api:{}", (Object)string);
        Map personMap = (Map)HRMServiceHelper.invokeBizService((String)split[0], (String)split[1], (String)split[2], (String)split[3], (Object[])new Object[]{1, 100});
        LOG.info("InitAnnexTplListPlugin start invoke personMap:{}", (Object)personMap);
        if (HRStringUtils.equals((String)((ListView)this.getView()).getBillFormId(), (String)"hric_contractinit")) {
            Map dataMap = (Map)personMap.get("data");
            this.customParamMap.put("count", ConvertUtils.toInteger(dataMap.get("count")));
        } else {
            this.customParamMap.put("count", ConvertUtils.toInteger(personMap.get("total")));
        }
        this.customParamMap.put("initway", "all");
        this.pageTitle = AnnexEnum.SYNC_PERSON_INFO.get();
        this.customParamMap.put("progresstip", AnnexEnum.SYNC_PERSON_TIP.get());
        AnnexOpHandleFactory.getService((String)implementName).handlePersonSync(annexInitType, Long.valueOf(batchNumber), zipParamMap);
    }

    private void transferData(String operateKey, Map<String, String> zipParamMap, DynamicObject dyc, String implementName) {
        this.setCount(implementName, operateKey, zipParamMap, dyc.getString("uniquefield"));
        this.customParamMap.put("initway", "part");
        this.pageTitle = this.getView().getFormShowParameter().getCaption();
        this.customParamMap.put("progresstip", String.format(Locale.ROOT, AnnexEnum.PREGRESS_TIP.get(), this.pageTitle));
        this.executeTask(this.customParamMap);
    }

    private void buildCustomParam(String operateKey, Map<String, String> zipParamMap, boolean isUpdateData, String annexInitType, long batchNumber, String implementName) {
        this.entityCode = ((ListView)this.getView()).getBillFormId();
        this.customParamMap.put("implementname", implementName);
        this.customParamMap.put("annexinittype", annexInitType);
        this.customParamMap.put("operatebtn", operateKey);
        this.customParamMap.put("curoperatepage", this.entityCode);
        this.customParamMap.put("failedflexpanelap", isUpdateData);
        this.customParamMap.put("zipparammap", zipParamMap);
        this.customParamMap.put("batchnumber", batchNumber);
        this.customParamMap.put("migratebatchnumber", ID.genLongId());
    }

    private void setCount(String implementName, String operateKey, Map<String, String> zipParamMap, String uniqueType) {
        if (HRStringUtils.equals((String)operateKey, (String)"zip_in")) {
            List numberList = AttachmentUtils.getIdsByZip(zipParamMap, (String)((ListView)this.getView()).getBillFormId(), (String)uniqueType);
            List idList = AnnexOpHandleFactory.getService((String)implementName).getIdsByNumbers(numberList);
            if (this.getSelectedRows().size() > 0) {
                Set pkIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
                idList.retainAll(pkIds);
                this.customParamMap.put("pkids", idList);
            }
            this.customParamMap.put("count", idList.size());
        } else if (this.getSelectedRows().size() > 0) {
            Set pkIds = this.getSelectedRows().stream().map(row -> (Long)row.getPrimaryKeyValue()).collect(Collectors.toSet());
            this.customParamMap.put("pkids", pkIds);
            this.customParamMap.put("count", pkIds.size());
        } else {
            this.customParamMap.put("count", AnnexOpHandleFactory.getService((String)implementName).getFailAndWaitTotal());
        }
    }

    private void showProgressForm(boolean isUpdateData) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hric_annexprogress");
        if (isUpdateData) {
            showParameter.setCaption(AnnexEnum.ANNEX_IN.get());
        } else {
            showParameter.setCaption(AnnexEnum.ANNEX_DATA_IN.get());
        }
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("ServiceAppId", (Object)this.getView().getFormShowParameter().getServiceAppId());
        showParameter.setCustomParam("failedflexpanelap", (Object)isUpdateData);
        String cacheUniqueId = ID.genStringId();
        this.customParamMap.put("cacheUniqueId", cacheUniqueId);
        JobFormInfo jobFormInfo = this.dispatch(this.pageTitle, this.customParamMap);
        this.customParamMap.put(this.entityCode, SerializationUtils.toJsonString((Object)jobFormInfo));
        if (!HricCacheUtils.put((String)cacheUniqueId, (Object)SerializationUtils.toJsonString((Object)this.customParamMap))) {
            this.getView().showErrorNotification(AnnexEnum.DATA_WRITE_CACHE_FAIL.get());
            return;
        }
        showParameter.setCustomParam("cacheUniqueId", (Object)cacheUniqueId);
        this.getView().showForm(showParameter);
    }
}

