/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.annex;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.DirtyManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.ItemClassEdit;
import kd.bos.form.field.ItemClassTypeEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.init.IMigrationToolDomainService;
import kd.hrmp.hric.common.constants.AppConstants;
import kd.hrmp.hric.common.constants.msg.AnnexEnum;
import kd.hrmp.hric.common.util.ConvertUtils;

public class InitMigrationToolEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener {
    IMigrationToolDomainService migrationToolDomainService = (IMigrationToolDomainService)ServiceFactory.getService(IMigrationToolDomainService.class);
    private String COMBO_1 = ResManager.loadKDString((String)"\u5de5\u53f7+\u59d3\u540d+\u5408\u540c\u7f16\u53f7", (String)"InitMigrationToolEditPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);
    private String COMBO_2 = ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7", (String)"InitMigrationToolEditPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit entityObjectEdit = (BasedataEdit)this.getView().getControl("entityobject");
        entityObjectEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isCopy = Optional.ofNullable((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")).orElse(false);
        if (!HRStringUtils.equals((String)this.getView().getFormShowParameter().getStatus().name(), (String)OperationStatus.ADDNEW.name()) || isCopy) {
            this.setModelValue();
        }
        this.analyzeComBo();
    }

    private void analyzeComBo() {
        DynamicObject entityObj = this.getModel().getDataEntity().getDynamicObject("entityobject");
        if (null != entityObj) {
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(AppConstants.LIST_SIZE);
            if (HRStringUtils.equals((String)entityObj.getString("number"), (String)"hric_contractinit")) {
                ComboItem comboItem_one = new ComboItem(new LocaleString(this.COMBO_1), "A");
                ComboItem comboItem_two = new ComboItem(new LocaleString(this.COMBO_2), "B");
                comboItems.add(comboItem_one);
                comboItems.add(comboItem_two);
                ((ComboEdit)this.getView().getControl("uniquefield")).setComboItems(comboItems);
                this.getView().updateView("uniquefield");
            }
        }
    }

    private void setModelValue() {
        ArrayList personList;
        if (HRStringUtils.isNotEmpty((String)ConvertUtils.toString((Object)this.getModel().getValue("personapi")))) {
            personList = Lists.newArrayList((Object[])new String[]{"personcloud", "personapp", "personservername", "personmethod"});
            this.decodeAPI(personList, "personapi");
        }
        if (HRStringUtils.isNotEmpty((String)ConvertUtils.toString((Object)this.getModel().getValue("bizapi")))) {
            personList = Lists.newArrayList((Object[])new String[]{"bizcloud", "bizdataapp", "bizdataname", "bizdatamethod"});
            this.decodeAPI(personList, "bizapi");
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        new DirtyManager((AbstractFormDataModel)this.getModel()).clearDirty();
    }

    private void decodeAPI(List<String> list, String api) {
        String personApi = ConvertUtils.toString((Object)this.getModel().getValue(api));
        String[] split = personApi.split("_");
        for (int i = 0; i < split.length; ++i) {
            this.getModel().setValue(list.get(i), (Object)split[i]);
            this.getView().updateView(list.get(i));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") && !ConvertUtils.toBoolean((Object)this.getModel().getValue("isensemble"))) {
            this.getModel().setValue("ensembletype", null);
            this.getModel().setValue("discheme", null);
            this.getModel().setValue("dischemenumber", null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        switch (propertyName = e.getProperty().getName()) {
            case "personservername": 
            case "personapp": 
            case "personmethod": 
            case "personcloud": {
                this.setPersonAPI("personcloud", "personapp", "personservername", "personmethod", "personapi");
                break;
            }
            case "bizdataname": 
            case "bizdataapp": 
            case "bizdatamethod": 
            case "bizcloud": {
                this.setPersonAPI("bizcloud", "bizdataapp", "bizdataname", "bizdatamethod", "bizapi");
                break;
            }
            case "isensemble": {
                this.setDiFieldIsMustInput(ConvertUtils.toBoolean((Object)this.getModel().getValue("isensemble")));
                break;
            }
            case "discheme": {
                Object diScheme = this.getModel().getValue("discheme");
                if (Objects.isNull(diScheme)) {
                    this.getModel().setValue("dischemenumber", null);
                    return;
                }
                this.getModel().setValue("dischemenumber", (Object)((DynamicObject)diScheme).getString("number"));
                break;
            }
            case "entityobject": {
                Object entityObject = this.getModel().getValue("entityobject");
                if (Objects.isNull(entityObject)) {
                    return;
                }
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)((DynamicObject)entityObject).getString("number"));
                String inheritPath = dataEntityType.getInheritPath();
                if (HRStringUtils.equals((String)inheritPath, (String)"3BLB4LHU557W")) break;
                this.getView().showErrorNotification(AnnexEnum.INHERIT_TEMPLATE_PROMPT_TIP.get());
                this.getModel().setValue("entityobject", null);
            }
        }
    }

    private void setDiFieldIsMustInput(boolean mustInput) {
        ((ItemClassTypeEdit)this.getControl("ensembletype")).setMustInput(mustInput);
        ((ItemClassEdit)this.getControl("discheme")).setMustInput(mustInput);
    }

    private void setPersonAPI(String o1, String o2, String o3, String o4, String o5) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getModel().getValue(o1)).append("_").append(this.getModel().getValue(o2)).append("_").append(this.getModel().getValue(o3)).append("_").append(this.getModel().getValue(o4));
        this.getModel().setValue(o5, (Object)stringBuilder.toString());
        this.getModel().getDataEntity().getDataEntityState().setBizChanged(((IDataEntityProperty)this.getModel().getDataEntityType().getAllFields().get(o4)).getOrdinal(), false);
        this.getView().updateView(o5);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)fieldName, (String)"entityobject")) {
            DynamicObject[] dys = this.migrationToolDomainService.getAllAnnexInitTypeInfo();
            Set idSet = Arrays.stream(dys).filter(Objects::nonNull).map(dyc -> dyc.getString("entityobject")).collect(Collectors.toSet());
            QFilter modelTypeQFilter = new QFilter("modeltype", "=", (Object)"BaseFormModel");
            ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(modelTypeQFilter.and(new QFilter("number", "not in", idSet)));
        }
    }
}

