/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hric.formplugin.web.datafix;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hric.bussiness.common.ServiceFactory;
import kd.hrmp.hric.bussiness.domain.entityservice.init.IDataFixToolEntityService;
import kd.hrmp.hric.bussiness.service.datafix.impl.DataFixServiceImpl;
import kd.hrmp.hric.bussiness.service.datafix.model.SqlGenScript;
import kd.hrmp.hric.common.util.HricRedisCacheUtil;

public class DataFixTooListPlugin
extends HRDataBaseList {
    private final IDataFixToolEntityService dataFixToolEntityService = (IDataFixToolEntityService)ServiceFactory.getService(IDataFixToolEntityService.class);
    private static final Log LOG = LogFactory.getLog(DataFixTooListPlugin.class);

    public void preOpenForm(PreOpenFormEventArgs e) {
        if (!PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            e.setCancelMessage(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataFixTooListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5de5\u5177\u3002\u7528\u4e8e\u4fee\u590d\u521d\u59cb\u5316\u5b9e\u65bd\u4e2d\u7684\u6570\u636e\u95ee\u9898\uff0c\u751f\u6210\u4fee\u590d\u811a\u672c\u3002\u6839\u636e\u9879\u76ee\u5b9e\u9645\u60c5\u51b5\u4fee\u6539\u811a\u672c\u5185\u5bb9\uff0c\u5e76\u6309\u7167\u9879\u76ee\u811a\u672c\u6d41\u7a0b\u6267\u884cSQL\u3002", (String)"DataFixTooListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (HRStringUtils.equals((String)evt.getItemKey(), (String)"log") && !PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataFixTooListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOp = (FormOperate)args.getSource();
        String operateKey = formOp.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"genfixdatasql")) {
            if ((HRStringUtils.equals((String)operateKey, (String)"genfixdatasql") || HRStringUtils.equals((String)operateKey, (String)"new") || HRStringUtils.equals((String)operateKey, (String)"delete") || HRStringUtils.equals((String)operateKey, (String)"viewonelog")) && !PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId())) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ba1\u7406\u5458\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DataFixTooListPlugin_0", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if (HRStringUtils.equals((String)operateKey, (String)"genfixdatasql")) {
                ListSelectedRowCollection listSelectedData = args.getListSelectedData();
                if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u6cd5\u5220\u9664\u5df2\u751f\u6210\u7684\u811a\u672c\u6570\u636e\u3002", (String)"DataFixTooListPlugin_1", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (listSelectedData.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u4fee\u590d\u5de5\u5177\u3002\u7528\u4e8e\u4fee\u590d\u521d\u59cb\u5316\u5b9e\u65bd\u4e2d\u7684\u6570\u636e\u95ee\u9898\uff0c\u751f\u6210\u4fee\u590d\u811a\u672c\u3002\u6839\u636e\u9879\u76ee\u5b9e\u9645\u60c5\u51b5\u4fee\u6539\u811a\u672c\u5185\u5bb9\uff0c\u5e76\u6309\u7167\u9879\u76ee\u811a\u672c\u6d41\u7a0b\u6267\u884cSQL\u3002", (String)"DataFixTooListPlugin_2", (String)"hrmp-hric-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operateKey.equals("genfixdatasql")) {
            ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows();
            ListSelectedRow listSelectedRow = selectedRows.get(0);
            Object primaryKeyValue = listSelectedRow.getPrimaryKeyValue();
            LOG.info("downloadSqlFile of fix data pkId={}", primaryKeyValue);
            DataFixServiceImpl dataFixService = new DataFixServiceImpl();
            SqlGenScript sqlGenScript = dataFixService.getExeSqlStr(Long.valueOf(Long.parseLong(primaryKeyValue.toString())));
            if (sqlGenScript == null) {
                this.getView().showErrorNotification("no sql script.");
                return;
            }
            this.getView().getPageCache().put("sqlGenScript", JSONObject.toJSONString((Object)sqlGenScript));
            this.getView().getPageCache().put("primaryKeyValue", primaryKeyValue.toString());
            boolean hasGlobalData = sqlGenScript.isHasGlobalData();
            boolean crossDb = sqlGenScript.isCrossDb();
            if (crossDb) {
                ConfirmCallBackListener confirm = new ConfirmCallBackListener("genfixdatasql", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u53d1\u73b0\u8de8\u6570\u636e\u5e93\u95ee\u9898\uff0c\u811a\u672c\u65e0\u6cd5\u81ea\u52a8\u586b\u5145\uff0c\u8bf7\u624b\u52a8\u4fee\u6539\u811a\u672c\u3002\u70b9\u51fb\u786e\u5b9a\u4e0b\u8f7d\u811a\u672c\u3002", (String)"DataFixServiceImpl_3", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
            } else if (!hasGlobalData) {
                ConfirmCallBackListener confirm = new ConfirmCallBackListener("genfixdatasql", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u6ca1\u6709\u7b26\u5408\u67e5\u8be2\u6761\u4ef6\u7684\u6570\u636e\uff0c\u811a\u672c\u65e0\u6cd5\u81ea\u52a8\u586b\u503c\uff0c\u8bf7\u624b\u52a8\u66ff\u6362\u811a\u672c\u4e2d\u7684\u5360\u4f4d\u7b26\u3002\u8bf7\u70b9\u51fb\u201c\u786e\u5b9a\u201d\u6309\u94ae\u4e0b\u8f7d\u811a\u672c\u3002", (String)"DataFixServiceImpl_5", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
            } else {
                ConfirmCallBackListener confirm = new ConfirmCallBackListener("genfixdatasql", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u751f\u6210\u51fa\u5382\u9884\u7f6e\u7684SQL\u811a\u672c\uff0c\u6839\u636e\u9879\u76ee\u5b9e\u9645\u60c5\u51b5\u4fee\u6539\u811a\u672c\u5185\u5bb9\uff0c\u5e76\u6309\u7167\u9879\u76ee\u811a\u672c\u6d41\u7a0b\u6267\u884cSQL\u3002", (String)"DataFixServiceImpl_6", (String)"hrmp-hric-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        SqlGenScript sqlGenScript = (SqlGenScript)JSONObject.parseObject((String)this.getView().getPageCache().get("sqlGenScript"), SqlGenScript.class);
        Long primaryKeyValue = Long.parseLong(this.getView().getPageCache().get("primaryKeyValue"));
        if (HRStringUtils.equals((String)callBackId, (String)"genfixdatasql") && event.getResult() == MessageBoxResult.Yes) {
            this.downloadSqlFile(sqlGenScript);
            DynamicObject dataFixTool = this.dataFixToolEntityService.query("id,number,cusstatus", (Object)primaryKeyValue);
            if (dataFixTool != null) {
                dataFixTool.set("cusstatus", (Object)"1");
                this.dataFixToolEntityService.save(dataFixTool);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void downloadSqlFile(SqlGenScript sqlGenScript) {
        if (!StringUtils.isEmpty((Object)sqlGenScript.getNoDataDesc())) {
            this.getView().showTipNotification(sqlGenScript.getNoDataDesc());
        }
        String sqlFileName = String.format("%s_%s.sql", sqlGenScript.getSceneName(), sqlGenScript.getDataVersion());
        try (ByteArrayInputStream ins = new ByteArrayInputStream(sqlGenScript.getSqlStr().getBytes(StandardCharsets.UTF_8));){
            this.exportFile(ins, sqlFileName);
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
            throw new KDException((Throwable)exception, BosErrorCode.downloadFailed, new Object[]{String.format("DataFixServiceImpl error:%s.", exception.getMessage())});
        }
    }

    private void exportFile(InputStream ins, String sqlFileName) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String url = tempFileCache.saveAsUrl(sqlFileName, ins, 1000);
        ListView listView = (ListView)this.getView();
        String formId = listView.getBillFormId();
        HashMap<String, String> refEntityMap = new HashMap<String, String>();
        refEntityMap.put("entityNum", formId);
        refEntityMap.put("appId", listView.getFormShowParameter().getServiceAppId());
        refEntityMap.put("permissionItemId", "47150e89000000ac");
        HricRedisCacheUtil.redisCacheSetPermission((String)url, (String)formId, refEntityMap);
        listView.download(url);
    }
}

